/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.DbCompareConfig;
import org.jumpmind.symmetric.io.DbCompareDiffWriter;
import org.jumpmind.symmetric.io.DbCompareReport;
import org.jumpmind.symmetric.io.DbCompareRow;
import org.jumpmind.symmetric.io.DbCompareTables;
import org.jumpmind.symmetric.io.DbValueComparator;
import org.jumpmind.symmetric.io.FirstUseFileOutputStream;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCompare {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    ISqlRowMapper<Row> defaultRowMapper = new ISqlRowMapper<Row>(){

        public Row mapRow(Row row) {
            return row;
        }
    };
    private ISymmetricEngine sourceEngine;
    private ISymmetricEngine targetEngine;
    private DbCompareConfig config;
    private DbValueComparator dbValueComparator;

    public DbCompare(ISymmetricEngine sourceEngine, ISymmetricEngine targetEngine, DbCompareConfig config) {
        this.config = config;
        this.sourceEngine = sourceEngine;
        this.targetEngine = targetEngine;
        this.dbValueComparator = new DbValueComparator(sourceEngine, targetEngine);
    }

    public DbCompareReport compare() {
        this.dbValueComparator.setNumericScale(this.config.getNumericScale());
        this.dbValueComparator.setDateTimeFormat(this.config.getDateTimeFormat());
        this.log.info("Starting DBCompare with config:\n{}", (Object)this.config.report());
        OutputStream sqlDiffOutput = this.getSqlDiffOutputStream();
        DbCompareReport report = new DbCompareReport();
        long start = System.currentTimeMillis();
        List<DbCompareTables> tablesToCompare = this.getTablesToCompare();
        report.printReportHeader(System.out);
        for (DbCompareTables tables : tablesToCompare) {
            try {
                DbCompareReport.TableReport tableReport = this.compareTables(tables, sqlDiffOutput);
                report.addTableReport(tableReport);
                long elapsed = System.currentTimeMillis() - start;
                this.log.info("Completed table {}.  Elapsed time: {}", (Object)tableReport, (Object)DurationFormatUtils.formatDurationWords((long)elapsed, (boolean)true, (boolean)true));
                report.printTableReport(tableReport, System.out);
            }
            catch (Exception e) {
                this.log.error("Exception while comparing " + tables.getSourceTable() + " to " + tables.getTargetTable(), (Throwable)e);
            }
        }
        report.printReportFooter(System.out);
        long totalTime = System.currentTimeMillis() - start;
        this.log.info("dbcompare complete.  Total Time: {}", (Object)DurationFormatUtils.formatDurationWords((long)totalTime, (boolean)true, (boolean)true));
        return report;
    }

    protected OutputStream getSqlDiffOutputStream() {
        String outputSqlDiffFileName = this.config.getOutputSql();
        if (!StringUtils.isEmpty((CharSequence)outputSqlDiffFileName) && !outputSqlDiffFileName.contains("%t")) {
            try {
                return new FirstUseFileOutputStream(outputSqlDiffFileName);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open stream to file '" + outputSqlDiffFileName + "'", e);
            }
        }
        return null;
    }

    protected OutputStream getSqlDiffOutputStream(DbCompareTables tables) {
        String outputSqlDiffFileName = this.config.getOutputSql();
        if (!StringUtils.isEmpty((CharSequence)outputSqlDiffFileName)) {
            String fileNameFormatted = outputSqlDiffFileName.replace("%t", "%s");
            fileNameFormatted = String.format(fileNameFormatted, tables.getSourceTable().getName());
            fileNameFormatted = fileNameFormatted.replaceAll("\"", "").replaceAll("\\]", "").replaceAll("\\[", "");
            try {
                return new FirstUseFileOutputStream(fileNameFormatted);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open stream to file '" + fileNameFormatted + "'", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DbCompareReport.TableReport compareTables(DbCompareTables tables, OutputStream sqlDiffOutput) {
        String sourceSelect = this.getSourceComparisonSQL(tables, this.sourceEngine.getTargetDialect().getTargetPlatform());
        String targetSelect = this.getTargetComparisonSQL(tables, this.targetEngine.getTargetDialect().getTargetPlatform());
        ISymmetricDialect sourceDialect = this.sourceEngine.getSymmetricDialect();
        ISymmetricDialect targetDialect = this.targetEngine.getSymmetricDialect();
        boolean isUsingUnitypes = targetDialect.getParameterService().is("sybase.ase.convert.unitypes.for.sync") || sourceDialect.getParameterService().is("sybase.ase.convert.unitypes.for.sync");
        boolean sourceTableContainUnitypes = false;
        boolean targetTableContainUnitypes = false;
        List sourceColumns = tables.getSourceTable().getColumnsAsList();
        for (Object column : sourceColumns) {
            if (!this.isUniType(column.getJdbcTypeName())) continue;
            sourceTableContainUnitypes = true;
        }
        List targetColumns = tables.getTargetTable().getColumnsAsList();
        for (Column column : targetColumns) {
            if (!this.isUniType(column.getJdbcTypeName())) continue;
            targetTableContainUnitypes = true;
        }
        CountingSqlReadCursor sourceCursor = new CountingSqlReadCursor((ISqlReadCursor<Row>)this.sourceEngine.getTargetDialect().getTargetPlatform().getSqlTemplateDirty().queryForCursor(sourceSelect, this.defaultRowMapper));
        CountingSqlReadCursor targetCursor = new CountingSqlReadCursor((ISqlReadCursor<Row>)this.targetEngine.getTargetDialect().getTargetPlatform().getSqlTemplateDirty().queryForCursor(targetSelect, this.defaultRowMapper));
        DbCompareReport.TableReport tableReport = new DbCompareReport.TableReport();
        tableReport.setSourceTable(tables.getSourceTable().getName());
        tableReport.setTargetTable(tables.getTargetTable().getName());
        long time = System.currentTimeMillis();
        Row sourceRow = sourceCursor.next();
        Row targetRow = targetCursor.next();
        time = System.currentTimeMillis() - time;
        this.log.debug("Took " + time + " milliseconds to get the starting source and target rows.");
        int counter = 0;
        long startTime = System.currentTimeMillis();
        DbCompareDiffWriter diffWriter = null;
        OutputStream stream = null;
        if (sqlDiffOutput != null) {
            diffWriter = new DbCompareDiffWriter(this.targetEngine, tables, sqlDiffOutput);
        } else {
            stream = this.getSqlDiffOutputStream(tables);
            diffWriter = new DbCompareDiffWriter(this.targetEngine, tables, stream);
        }
        diffWriter.setContinueAfterError(this.config.isContinueAfterError());
        try {
            while (sourceRow != null || targetRow != null) {
                if (isUsingUnitypes && (sourceTableContainUnitypes || targetTableContainUnitypes)) {
                    long keyCheck = System.currentTimeMillis();
                    HashMap<String, Object> recordToAdd = new HashMap<String, Object>();
                    HashMap<String, Object> recordToDelete = new HashMap<String, Object>();
                    if (targetTableContainUnitypes) {
                        for (String key : targetRow.keySet()) {
                            if (!key.startsWith("_uni_")) continue;
                            recordToAdd.put(key.substring(5), targetRow.get((Object)key));
                            recordToDelete.put(key, targetRow.get((Object)key));
                        }
                        this.modifyRowForUnitypes(targetRow, recordToAdd, true);
                        this.modifyRowForUnitypes(targetRow, recordToDelete, false);
                    } else if (sourceTableContainUnitypes) {
                        for (String key : sourceRow.keySet()) {
                            if (!key.startsWith("_uni_")) continue;
                            recordToAdd.put(key.substring(5), sourceRow.get((Object)key));
                            recordToDelete.put(key, sourceRow.get((Object)key));
                        }
                        this.modifyRowForUnitypes(sourceRow, recordToAdd, true);
                        this.modifyRowForUnitypes(sourceRow, recordToDelete, false);
                    }
                    keyCheck = System.currentTimeMillis() - keyCheck;
                    this.log.debug("Took " + keyCheck + " milliseconds to check for unitype keys and adjust.");
                }
                if (++counter % 50000 == 0) {
                    long elapsed = System.currentTimeMillis() - startTime;
                    this.log.info("{} rows processed for table {}. Elapsed time {}. ({} ms.) Current report status {}", new Object[]{counter, tables.getSourceTable().getName(), DurationFormatUtils.formatDurationWords((long)elapsed, (boolean)true, (boolean)true), elapsed, tableReport});
                }
                DbCompareRow sourceCompareRow = sourceRow != null ? new DbCompareRow(this.sourceEngine, this.dbValueComparator, tables.getSourceTable(), sourceRow) : null;
                DbCompareRow targetCompareRow = targetRow != null ? new DbCompareRow(this.targetEngine, this.dbValueComparator, tables.getTargetTable(), targetRow) : null;
                diffWriter.setError(false);
                diffWriter.setThrowable(null);
                DbCompareRow targetCompareRowCopy = null;
                DbCompareRow sourceCompareRowCopy = null;
                if (isUsingUnitypes) {
                    targetCompareRowCopy = targetRow != null ? new DbCompareRow(this.targetEngine, this.dbValueComparator, tables.getTargetTable().copy(), (Row)targetRow.clone()) : null;
                    sourceCompareRowCopy = sourceRow != null ? new DbCompareRow(this.sourceEngine, this.dbValueComparator, tables.getSourceTable().copy(), (Row)sourceRow.clone()) : null;
                }
                long ts1 = System.currentTimeMillis();
                int comparePk = this.comparePk(tables, sourceCompareRow, targetCompareRow);
                ts1 = System.currentTimeMillis() - ts1;
                if (ts1 > 2L) {
                    this.log.debug("Took " + ts1 + " milliseconds to run comparePKs.");
                }
                if (comparePk == 0) {
                    long ts = System.currentTimeMillis();
                    Map<Column, String> deltas = sourceCompareRow.compareTo(tables, targetCompareRow);
                    ts = System.currentTimeMillis() - ts;
                    if (ts > 2L) {
                        this.log.debug("Took " + ts + " milliseconds to run compareTo.");
                    }
                    LinkedHashMap<Column, String> deltasCopy = new LinkedHashMap<Column, String>();
                    if (isUsingUnitypes) {
                        for (Column column : deltas.keySet()) {
                            deltasCopy.put((Column)column.clone(), deltas.get(column));
                        }
                    }
                    if (targetCompareRowCopy != null || sourceCompareRowCopy != null) {
                        for (String pkColumnName : targetCompareRowCopy.getTable().getPrimaryKeyColumnNames()) {
                            if (!this.isUniType(targetCompareRowCopy.getTable().getColumnWithName(pkColumnName).getJdbcTypeName())) continue;
                            targetCompareRowCopy.getTable().getColumnWithName(pkColumnName).setMappedType("VARCHAR");
                        }
                        for (String pkColumnName : sourceCompareRowCopy.getTable().getPrimaryKeyColumnNames()) {
                            if (!this.isUniType(sourceCompareRowCopy.getTable().getColumnWithName(pkColumnName).getJdbcTypeName())) continue;
                            sourceCompareRowCopy.getTable().getColumnWithName(pkColumnName).setMappedType("VARCHAR");
                        }
                    }
                    if (deltas.isEmpty()) {
                        tableReport.countMatchedRow();
                    } else {
                        if (isUsingUnitypes) {
                            long ts2 = System.currentTimeMillis();
                            diffWriter.writeUpdate(targetCompareRowCopy, deltasCopy);
                            ts2 = System.currentTimeMillis() - ts2;
                            this.log.debug("Took " + ts2 + " milliseconds to run writeUpdate for Unitypes.");
                        } else {
                            long ts3 = System.currentTimeMillis();
                            diffWriter.writeUpdate(targetCompareRow, deltas);
                            ts3 = System.currentTimeMillis() - ts3;
                            this.log.debug("Took " + ts3 + " milliseconds to run writeUpdate.");
                        }
                        if (!diffWriter.isError()) {
                            tableReport.countDifferentRow();
                        } else {
                            tableReport.countErrorRows();
                            diffWriter.setThrowable(tableReport.getThrowable());
                        }
                    }
                    long nextRow = System.currentTimeMillis();
                    sourceRow = sourceCursor.next();
                    targetRow = targetCursor.next();
                    nextRow = System.currentTimeMillis() - nextRow;
                    if (nextRow > 2L) {
                        this.log.debug("Took " + nextRow + " milliseconds to get the next source and target rows.");
                    }
                } else if (comparePk < 0) {
                    if (isUsingUnitypes) {
                        long ts4 = System.currentTimeMillis();
                        diffWriter.writeInsert(sourceCompareRowCopy);
                        ts4 = System.currentTimeMillis() - ts4;
                        this.log.debug("Took " + ts4 + " milliseconds to run writeInsert with Unitypes.");
                    } else {
                        long ts5 = System.currentTimeMillis();
                        diffWriter.writeInsert(sourceCompareRow);
                        ts5 = System.currentTimeMillis() - ts5;
                        this.log.debug("Took " + ts5 + " milliseconds to run writeInsert.");
                    }
                    if (!diffWriter.isError()) {
                        tableReport.countMissingRow();
                    } else {
                        tableReport.countErrorRows();
                        diffWriter.setThrowable(tableReport.getThrowable());
                    }
                    sourceRow = sourceCursor.next();
                } else {
                    if (isUsingUnitypes) {
                        long ts6 = System.currentTimeMillis();
                        diffWriter.writeDelete(targetCompareRowCopy);
                        ts6 = System.currentTimeMillis() - ts6;
                        this.log.debug("Took " + ts6 + " milliseconds to run writeDelete with Unitypes.");
                    } else {
                        long ts7 = System.currentTimeMillis();
                        diffWriter.writeDelete(targetCompareRow);
                        ts7 = System.currentTimeMillis() - ts7;
                        this.log.debug("Took " + ts7 + " milliseconds to run writeDelete.");
                    }
                    if (!diffWriter.isError()) {
                        tableReport.countExtraRow();
                    } else {
                        tableReport.countErrorRows();
                        diffWriter.setThrowable(tableReport.getThrowable());
                    }
                    targetRow = targetCursor.next();
                }
                long tableReportTime = System.currentTimeMillis();
                tableReport.setSourceRows(sourceCursor.count);
                tableReport.setTargetRows(targetCursor.count);
                tableReportTime = System.currentTimeMillis() - tableReportTime;
                if (tableReportTime <= 2L) continue;
                this.log.debug("Took " + tableReportTime + " milliseconds to update the table report.");
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            if (sourceCursor != null) {
                sourceCursor.close();
            }
            if (targetCursor != null) {
                targetCursor.close();
            }
        }
        return tableReport;
    }

    protected void modifyRowForUnitypes(Row originalRow, Map<String, Object> records, Boolean isInserting) {
        for (String key : records.keySet()) {
            if (isInserting.booleanValue()) {
                originalRow.put(key, records.get(key));
                continue;
            }
            originalRow.remove((Object)key);
        }
    }

    protected int comparePk(DbCompareTables tables, DbCompareRow sourceCompareRow, DbCompareRow targetCompareRow) {
        if (sourceCompareRow != null && targetCompareRow == null) {
            return -1;
        }
        if (sourceCompareRow == null && targetCompareRow != null) {
            return 1;
        }
        if (sourceCompareRow == null) {
            return 0;
        }
        return sourceCompareRow.comparePks(tables, targetCompareRow);
    }

    protected String getSourceComparisonSQL(DbCompareTables tables, IDatabasePlatform platform) {
        String whereClause = this.config.getSourceWhereClause(tables.getSourceTable().getName());
        String sql = this.getComparisonSQL(tables.getSourceTable(), tables.getSourceTable().getPrimaryKeyColumns(), platform, whereClause, true);
        this.log.info("Source comparison SQL: {}", (Object)sql);
        return sql;
    }

    protected String getTargetComparisonSQL(DbCompareTables tables, IDatabasePlatform platform) {
        ArrayList<Column> mappedPkColumns = new ArrayList<Column>();
        for (Column sourcePkColumn : tables.getSourceTable().getPrimaryKeyColumns()) {
            Column targetColumn = tables.getColumnMapping().get(sourcePkColumn);
            if (targetColumn == null) {
                this.log.warn("No target column mapped to source PK column {}.  Dbcompare may be inaccurate for this table.", (Object)sourcePkColumn);
                continue;
            }
            mappedPkColumns.add(targetColumn);
        }
        String whereClause = this.config.getTargetWhereClause(tables.getTargetTable().getName());
        String sql = this.getComparisonSQL(tables.getTargetTable(), tables.getTargetTable().getPrimaryKeyColumns(), platform, whereClause, false);
        this.log.info("Target comparison SQL: {}", (Object)sql);
        return sql;
    }

    protected String getComparisonSQL(Table table, Column[] sortByColumns, IDatabasePlatform platform, String whereClause, boolean isSource) {
        DmlStatement statement = platform.createDmlStatement(DmlStatement.DmlType.SELECT, table.getCatalog(), table.getSchema(), table.getName(), null, table.getColumns(), null, null);
        StringBuilder sql = new StringBuilder(statement.getSql());
        String sybaseUnitypeConversions = statement.getSql();
        boolean isUsingUnitypes = false;
        if (platform.getName().equals("ase")) {
            if (isSource) {
                symmetricDialect = this.sourceEngine.getSymmetricDialect();
                isUsingUnitypes = symmetricDialect.getParameterService().is("sybase.ase.convert.unitypes.for.sync");
            } else {
                symmetricDialect = this.targetEngine.getSymmetricDialect();
                isUsingUnitypes = symmetricDialect.getParameterService().is("sybase.ase.convert.unitypes.for.sync");
            }
            if (isUsingUnitypes) {
                for (Column column : statement.getColumns()) {
                    if (!this.isUniType(column.getJdbcTypeName()) || column.getJdbcTypeName().equalsIgnoreCase("unitext")) continue;
                    sybaseUnitypeConversions = sybaseUnitypeConversions.contains(" " + column.getName() + ",") ? sybaseUnitypeConversions.replace(" " + column.getName() + ",", "case when " + column.getName() + " is null then null else '\"' +\n bintostr(convert(varbinary(16384)," + column.getName() + ")) + '\"' end as _uni_" + column.getName() + " ,") : sybaseUnitypeConversions.replace(" " + column.getName() + " from", "case when " + column.getName() + " is null then null else '\"' +\n bintostr(convert(varbinary(16384)," + column.getName() + ")) + '\"' end as _uni_" + column.getName() + " from");
                }
            }
        }
        StringBuilder finalSql = null;
        finalSql = isUsingUnitypes ? new StringBuilder(sybaseUnitypeConversions.toString()) : new StringBuilder(sql.toString());
        finalSql.setLength(finalSql.length() - "where ".length());
        finalSql.append(" t where ");
        finalSql.append(whereClause).append(" ");
        finalSql.append(this.buildOrderBy(table, sortByColumns, platform, isSource));
        return finalSql.toString();
    }

    protected String buildOrderBy(Table table, Column[] sortByColumns, IDatabasePlatform platform, boolean isSource) {
        DatabaseInfo databaseInfo = platform.getDatabaseInfo();
        String quote = databaseInfo.getDelimiterToken() == null ? "" : databaseInfo.getDelimiterToken();
        StringBuilder orderByClause = new StringBuilder("ORDER BY ");
        for (Column sortByColumn : sortByColumns) {
            String columnName = sortByColumn.getName();
            String quotedColumnName = quote + columnName + quote;
            orderByClause.append(quotedColumnName);
            String suffix = isSource ? this.config.getSourceOrderBySuffix(table.getName(), columnName) : this.config.getTargetOrderBySuffix(table.getName(), columnName);
            if (StringUtils.isNotBlank((CharSequence)suffix)) {
                orderByClause.append(" ").append(suffix);
            }
            orderByClause.append(",");
        }
        orderByClause.setLength(orderByClause.length() - 1);
        return orderByClause.toString();
    }

    protected List<DbCompareTables> getTablesToCompare() {
        List<DbCompareTables> tablesToCompare = this.config.isUseSymmetricConfig() ? this.loadTablesFromConfig() : this.loadTablesFromArguments();
        return tablesToCompare;
    }

    protected List<DbCompareTables> loadTablesFromConfig() {
        String sourceNodeGroupId = this.sourceEngine.getNodeService().findIdentity(true, true).getNodeGroupId();
        String targetNodeGroupId = this.targetEngine.getNodeService().findIdentity(true, true).getNodeGroupId();
        List<TriggerRouter> triggerRouters = this.sourceEngine.getTriggerRouterService().getTriggerRoutersForSourceAndTargetNodes(sourceNodeGroupId, targetNodeGroupId);
        Set<String> configTables = TableConstants.getTables(this.sourceEngine.getTablePrefix());
        ArrayList<String> tableNames = new ArrayList<String>();
        for (TriggerRouter triggerRouter : triggerRouters) {
            String tableName = triggerRouter.getTrigger().getFullyQualifiedSourceTableName();
            if (tableNames.contains(tableName) || configTables.contains(tableName) || (CollectionUtils.isEmpty(this.config.getSourceTableNames()) || !this.config.getSourceTableNames().contains(tableName)) && !CollectionUtils.isEmpty(this.config.getSourceTableNames())) continue;
            tableNames.add(tableName);
        }
        return this.loadTables(tableNames, this.config.getTargetTableNames());
    }

    protected List<DbCompareTables> loadTables(List<String> tableNames, List<String> targetTableNames) {
        ArrayList<DbCompareTables> compareTables = new ArrayList<DbCompareTables>(1);
        List<String> filteredTablesNames = this.filterTables(tableNames);
        if (!CollectionUtils.isEmpty(targetTableNames) && filteredTablesNames.size() != targetTableNames.size()) {
            StringBuilder sb = new StringBuilder("Source and target table lists do not match.");
            sb.append(System.lineSeparator()).append("SourceTable:TargetTable").append(System.lineSeparator());
            Iterator<String> ftn = filteredTablesNames.iterator();
            Iterator<String> ttn = targetTableNames.iterator();
            while (ftn.hasNext() || ttn.hasNext()) {
                String filteredTableName = ftn.hasNext() ? ftn.next() : "<undefined>";
                String targetTableName = ttn.hasNext() ? ttn.next() : "<undefined>";
                sb.append(filteredTableName + ":" + targetTableName).append(System.lineSeparator());
            }
            this.log.error(sb.toString());
            throw new SymmetricException("Source table names must be the same length as the list of target table names.  Check your arguments. source table names = " + filteredTablesNames + " target table names = " + targetTableNames, new Object[0]);
        }
        for (int i = 0; i < filteredTablesNames.size(); ++i) {
            Table targetTable;
            String tableName = filteredTablesNames.get(i);
            Table sourceTable = null;
            Map tableNameParts = this.sourceEngine.getTargetDialect().getTargetPlatform().parseQualifiedTableName(tableName);
            if (tableNameParts.size() == 1) {
                sourceTable = this.sourceEngine.getTargetDialect().getTargetPlatform().getTableFromCache(tableName, true);
            } else {
                sourceTable = this.sourceEngine.getTargetDialect().getTargetPlatform().getTableFromCache((String)tableNameParts.get("catalog"), (String)tableNameParts.get("schema"), (String)tableNameParts.get("table"), true);
                if (sourceTable == null) {
                    sourceTable = this.sourceEngine.getTargetDialect().getTargetPlatform().getTableFromCache((String)tableNameParts.get("schema"), (String)tableNameParts.get("catalog"), (String)tableNameParts.get("table"), true);
                }
            }
            if (sourceTable == null) {
                this.log.warn("No source table found for name {}", (Object)tableName);
                continue;
            }
            if (this.config.isUseSymmetricConfig()) {
                TriggerHistory hist;
                String catalog = null;
                String schema = null;
                if (!StringUtils.equals((CharSequence)this.sourceEngine.getTargetDialect().getTargetPlatform().getDefaultCatalog(), (CharSequence)sourceTable.getCatalog())) {
                    catalog = sourceTable.getCatalog();
                }
                if (!StringUtils.equals((CharSequence)this.sourceEngine.getTargetDialect().getTargetPlatform().getDefaultSchema(), (CharSequence)sourceTable.getSchema())) {
                    schema = sourceTable.getSchema();
                }
                if ((hist = this.sourceEngine.getTriggerRouterService().findTriggerHistory(catalog, schema, sourceTable.getName())) != null) {
                    sourceTable = sourceTable.copyAndFilterColumns(hist.getParsedColumnNames(), hist.getParsedPkColumnNames(), true, false);
                } else {
                    this.log.warn("No trigger history found for {}", (Object)sourceTable.getFullyQualifiedTableName());
                }
            }
            Table sourceTableCopy = sourceTable.copy();
            DbCompareTables tables = new DbCompareTables(sourceTableCopy, null);
            String targetTableName = tableName;
            if (!CollectionUtils.isEmpty(targetTableNames)) {
                targetTableName = targetTableNames.get(i);
            }
            if ((targetTable = this.loadTargetTable(tables, targetTableName)) == null) {
                this.log.warn("No target table found for name {}", (Object)tableName);
                continue;
            }
            tables.applyColumnMappings();
            tables.filterExcludedColumns(this.config);
            if (tables.getSourceTable().getPrimaryKeyColumnCount() == 0) {
                this.log.warn("Source table {} doesn't have any primary key columns and will not be considered in the comparison.", (Object)sourceTable);
                continue;
            }
            boolean success = this.mapPrimaryKey(tables);
            if (!success) continue;
            compareTables.add(tables);
        }
        return compareTables;
    }

    protected boolean mapPrimaryKey(DbCompareTables tables) {
        Column[] targetColumns;
        ArrayList<Column> mappedPkColumns = new ArrayList<Column>();
        for (Column sourcePkColumn : tables.getSourceTable().getPrimaryKeyColumns()) {
            Column targetColumn = tables.getColumnMapping().get(sourcePkColumn);
            if (targetColumn == null) {
                this.log.warn("No target column mapped to source PK column {}. Unable to perform dbcompare on table {}", (Object)sourcePkColumn, (Object)tables.getSourceTable());
                return false;
            }
            mappedPkColumns.add(targetColumn);
        }
        for (Column column : targetColumns = tables.getTargetTable().getColumns()) {
            column.setPrimaryKey(false);
        }
        ArrayList<Column> reorderedColumns = new ArrayList<Column>();
        for (Column mappedPkColumn : mappedPkColumns) {
            mappedPkColumn.setPrimaryKey(true);
            reorderedColumns.add(mappedPkColumn);
        }
        for (Column column : targetColumns) {
            if (reorderedColumns.contains(column)) continue;
            reorderedColumns.add(column);
        }
        tables.getTargetTable().removeAllColumns();
        tables.getTargetTable().addColumns(reorderedColumns);
        return true;
    }

    protected Table loadTargetTable(DbCompareTables tables, String targetTableName) {
        Table targetTable = null;
        if (this.config.isUseSymmetricConfig()) {
            TransformService.TransformTableNodeGroupLink transform = this.getTransformFor(tables.getSourceTable());
            if (transform != null) {
                targetTable = this.loadTargetTableUsingTransform(transform);
                tables.setTransform(transform);
            } else {
                String catalog = this.targetEngine.getTargetDialect().getTargetPlatform().getDefaultCatalog();
                String schema = this.targetEngine.getTargetDialect().getTargetPlatform().getDefaultSchema();
                String tableName = tables.getSourceTable().getName();
                TriggerRouter triggerRouter = this.getTriggerRouterFor(tables.getSourceTable());
                if (triggerRouter != null) {
                    catalog = triggerRouter.getTargetCatalog(catalog, null);
                    schema = triggerRouter.getTargetSchema(schema, null);
                    if (StringUtils.isNotEmpty((CharSequence)triggerRouter.getTargetTable(null))) {
                        tableName = triggerRouter.getTargetTable(null);
                    }
                }
                targetTable = this.targetEngine.getTargetDialect().getTargetPlatform().getTableFromCache(catalog, schema, tableName, true);
            }
        } else {
            Map tableNameParts = this.targetEngine.getTargetDialect().getTargetPlatform().parseQualifiedTableName(targetTableName);
            if (tableNameParts.size() == 1) {
                targetTable = this.targetEngine.getTargetDialect().getTargetPlatform().getTableFromCache(targetTableName, true);
            } else {
                targetTable = this.targetEngine.getTargetDialect().getTargetPlatform().getTableFromCache((String)tableNameParts.get("catalog"), (String)tableNameParts.get("schema"), (String)tableNameParts.get("table"), true);
                if (targetTable == null) {
                    targetTable = this.targetEngine.getTargetDialect().getTargetPlatform().getTableFromCache((String)tableNameParts.get("schema"), (String)tableNameParts.get("catalog"), (String)tableNameParts.get("table"), true);
                }
            }
        }
        long targetTableCopyTime = System.currentTimeMillis();
        Table targetTableCopy = targetTable.copy();
        targetTableCopyTime = System.currentTimeMillis() - targetTableCopyTime;
        this.log.debug("Took " + targetTableCopyTime + " milliseconds to copy target table.");
        tables.setTargetTable(targetTableCopy);
        return targetTableCopy;
    }

    protected TriggerRouter getTriggerRouterFor(Table sourceTable) {
        Set<TriggerRouter> triggerRouters = this.sourceEngine.getTriggerRouterService().getTriggerRouterForTableForCurrentNode(sourceTable.getCatalog(), sourceTable.getSchema(), sourceTable.getName(), false);
        for (TriggerRouter triggerRouter : triggerRouters) {
            String routerTargetNodeGroupId = triggerRouter.getRouter().getNodeGroupLink().getTargetNodeGroupId();
            String compareTargetNodeGroupId = this.targetEngine.getNodeService().getCachedIdentity().getNodeGroupId();
            if (!StringUtils.equals((CharSequence)compareTargetNodeGroupId, (CharSequence)routerTargetNodeGroupId)) continue;
            return triggerRouter;
        }
        return null;
    }

    protected TransformService.TransformTableNodeGroupLink getTransformFor(Table sourceTable) {
        TransformService.TransformTableNodeGroupLink transform;
        List<TransformService.TransformTableNodeGroupLink> transforms;
        String sourceNodeGroupId = null;
        if (this.sourceEngine.getNodeService().findIdentity() != null) {
            sourceNodeGroupId = this.sourceEngine.getNodeService().findIdentity().getNodeGroupId();
        }
        String targetNodeGroupId = null;
        if (this.targetEngine.getNodeService().findIdentity() != null) {
            targetNodeGroupId = this.targetEngine.getNodeService().findIdentity().getNodeGroupId();
        }
        if (!CollectionUtils.isEmpty(transforms = this.sourceEngine.getTransformService().findTransformsFor(sourceNodeGroupId, targetNodeGroupId, sourceTable.getName())) && !StringUtils.isEmpty((CharSequence)(transform = transforms.get(0)).getFullyQualifiedTargetTableName())) {
            return transform;
        }
        return null;
    }

    protected Table loadTargetTableUsingTransform(TransformService.TransformTableNodeGroupLink transform) {
        Table targetTable = this.targetEngine.getTargetDialect().getTargetPlatform().getTableFromCache(transform.getTargetCatalogName(), transform.getTargetSchemaName(), transform.getTargetTableName(), true);
        return targetTable;
    }

    protected Table cloneTable(Table table) {
        try {
            return (Table)table.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected List<DbCompareTables> loadTablesFromArguments() {
        if (CollectionUtils.isEmpty(this.config.getSourceTableNames())) {
            throw new RuntimeException("sourceTableNames not provided, sourceTableNames must be provided when not comparing using SymmetricDS config.");
        }
        return this.loadTables(this.config.getSourceTableNames(), this.config.getTargetTableNames());
    }

    protected List<String> filterTables(List<String> tables) {
        ArrayList<String> filteredTables = new ArrayList<String>(tables.size());
        filteredTables.addAll(tables);
        if (!CollectionUtils.isEmpty(this.config.getExcludedTableNames())) {
            ArrayList<String> excludedTables = new ArrayList<String>(filteredTables);
            for (String excludedTableName : this.config.getExcludedTableNames()) {
                for (String tableName : filteredTables) {
                    if (!this.compareTableNames(tableName, excludedTableName)) continue;
                    excludedTables.remove(tableName);
                }
            }
            return excludedTables;
        }
        return filteredTables;
    }

    protected boolean compareTableNames(String sourceTableName, String targetTableName) {
        if (StringUtils.equalsIgnoreCase((CharSequence)(sourceTableName = sourceTableName.trim()), (CharSequence)(targetTableName = targetTableName.trim()))) {
            return true;
        }
        Map sourceTableNameParts = this.sourceEngine.getTargetDialect().getTargetPlatform().parseQualifiedTableName(sourceTableName);
        Map targetTableNameParts = this.targetEngine.getTargetDialect().getTargetPlatform().parseQualifiedTableName(targetTableName);
        return StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)sourceTableNameParts.get("table")), (CharSequence)((CharSequence)targetTableNameParts.get("table")));
    }

    public boolean isUniType(String type) {
        return type.equalsIgnoreCase("UNITEXT") || type.equalsIgnoreCase("UNICHAR") || type.equalsIgnoreCase("UNIVARCHAR");
    }

    public DbCompareConfig getConfig() {
        return this.config;
    }

    static class CountingSqlReadCursor
    implements ISqlReadCursor<Row>,
    Closeable {
        ISqlReadCursor<Row> wrapped;
        int count = 0;

        CountingSqlReadCursor(ISqlReadCursor<Row> wrapped) {
            this.wrapped = wrapped;
        }

        public Row next() {
            Row row = (Row)this.wrapped.next();
            if (row != null) {
                ++this.count;
            }
            return row;
        }

        @Override
        public void close() {
            this.wrapped.close();
        }
    }
}

