/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.io.DbCompareUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCompareConfig {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String WHERE_CLAUSE = "where_clause";
    public static final String ORDER_BY_SUFFIX = "order_by_suffix";
    public static final String EXCLUDED_COLUMN = "exclude_columns";
    private List<String> sourceTableNames;
    private List<String> targetTableNames;
    private List<String> excludedTableNames;
    private boolean useSymmetricConfig = true;
    private int numericScale = 3;
    private String dateTimeFormat;
    private Map<String, String> whereClauses = new LinkedHashMap<String, String>();
    private Map<String, String> orderBySuffixes = new LinkedHashMap<String, String>();
    private Map<String, List<String>> tablesToExcludedColumns = new LinkedHashMap<String, List<String>>();
    private String outputSql;
    private boolean continueAfterError = false;
    private Map<String, String> configSources = new HashMap<String, String>();

    public DbCompareConfig() {
        this.configSources.put("sourceTableNames", "default");
        this.configSources.put("includedTableNames", "default");
        this.configSources.put("targetTableNames", "default");
        this.configSources.put("excludedTableNames", "default");
        this.configSources.put("useSymmetricConfig", "default");
        this.configSources.put("numericScale", "default");
        this.configSources.put("whereClauses", "default");
        this.configSources.put("orderBySuffixes", "default");
        this.configSources.put("tablesToExcludedColumns", "default");
        this.configSources.put("sqlDiffFileName", "default");
        this.configSources.put("outputSql", "default");
        this.configSources.put("continueAfterError", "default");
    }

    public String getSourceWhereClause(String tableName) {
        String whereClause = this.getWhereClause(tableName, "source");
        if (StringUtils.isEmpty((CharSequence)whereClause)) {
            whereClause = "1=1";
        }
        return whereClause;
    }

    public String getTargetWhereClause(String tableName) {
        String whereClause = this.getWhereClause(tableName, "target");
        if (StringUtils.isEmpty((CharSequence)whereClause)) {
            String simpleTableName = DbCompareUtil.getUnqualifiedTableName(tableName);
            whereClause = this.getWhereClause(simpleTableName, "target");
        }
        if (StringUtils.isEmpty((CharSequence)whereClause)) {
            whereClause = "1=1";
        }
        return whereClause;
    }

    protected String getWhereClause(String tableName, String sourceOrTarget) {
        String[] keys;
        String tableNameLower = tableName.toLowerCase();
        for (String key : keys = new String[]{tableNameLower + "." + sourceOrTarget + ".where_clause", tableNameLower + ".where_clause", WHERE_CLAUSE}) {
            if (!this.whereClauses.containsKey(key)) continue;
            return this.whereClauses.get(key);
        }
        return null;
    }

    public String getSourceOrderBySuffix(String tableName, String columnName) {
        return this.getOrderBySuffix(tableName, columnName, "source");
    }

    public String getTargetOrderBySuffix(String tableName, String columnName) {
        String orderBySuffix = this.getOrderBySuffix(tableName, columnName, "target");
        if (StringUtils.isEmpty((CharSequence)orderBySuffix)) {
            String simpleTableName = DbCompareUtil.getUnqualifiedTableName(tableName);
            orderBySuffix = this.getOrderBySuffix(simpleTableName, columnName, "target");
        }
        return orderBySuffix;
    }

    protected String getOrderBySuffix(String tableName, String columnName, String sourceOrTarget) {
        String[] keys;
        String tableNameLower = tableName.toLowerCase();
        String columnNameLower = columnName.toLowerCase();
        for (String key : keys = new String[]{tableNameLower + "." + columnNameLower + "." + sourceOrTarget + ".order_by_suffix", tableNameLower + "." + columnNameLower + ".order_by_suffix", tableNameLower + "." + sourceOrTarget + ".order_by_suffix", tableNameLower + ".order_by_suffix", ORDER_BY_SUFFIX}) {
            if (!this.orderBySuffixes.containsKey(key)) continue;
            return this.orderBySuffixes.get(key);
        }
        return "";
    }

    protected boolean shouldIncludeColumn(String tableName, String columnName) {
        String[] keys;
        String tableNameLower = tableName.toLowerCase();
        String columnNameLower = columnName.toLowerCase();
        for (String key : keys = new String[]{tableNameLower + ".exclude_columns", EXCLUDED_COLUMN}) {
            if (!this.tablesToExcludedColumns.containsKey(key)) continue;
            List<String> exludedColumnNames = this.tablesToExcludedColumns.get(key);
            return !exludedColumnNames.contains(columnNameLower);
        }
        return true;
    }

    public List<String> getExcludedTableNames() {
        return this.excludedTableNames;
    }

    public void setExcludedTableNames(List<String> excludedTableNames) {
        this.excludedTableNames = excludedTableNames;
    }

    public boolean isUseSymmetricConfig() {
        return this.useSymmetricConfig;
    }

    public void setUseSymmetricConfig(boolean useSymmetricConfig) {
        this.useSymmetricConfig = useSymmetricConfig;
    }

    public int getNumericScale() {
        return this.numericScale;
    }

    public void setNumericScale(int numericScale) {
        this.numericScale = numericScale;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String format) {
        this.dateTimeFormat = format;
    }

    public Map<String, String> getWhereClauses() {
        return this.whereClauses;
    }

    public void setConfigSource(String configName, String configSource) {
        this.configSources.put(configName, configSource);
    }

    public void setWhereClauses(Map<String, String> whereClauses) {
        this.whereClauses = new CaseInsensitiveMap(whereClauses);
    }

    public Map<String, String> getOrderBySuffixes() {
        return this.orderBySuffixes;
    }

    public void setOrderBySuffixes(Map<String, String> orderBySuffixes) {
        this.orderBySuffixes = new CaseInsensitiveMap(orderBySuffixes);
    }

    public List<String> getSourceTableNames() {
        return this.sourceTableNames;
    }

    public void setSourceTableNames(List<String> sourceTableNames) {
        this.sourceTableNames = sourceTableNames;
    }

    public List<String> getTargetTableNames() {
        return this.targetTableNames;
    }

    public void setTargetTableNames(List<String> targetTableNames) {
        this.targetTableNames = targetTableNames;
    }

    public Map<String, List<String>> getTablesToExcludedColumns() {
        return this.tablesToExcludedColumns;
    }

    public void setTablesToExcludedColumns(Map<String, List<String>> tablesToExcludedColumns) {
        this.tablesToExcludedColumns = tablesToExcludedColumns;
    }

    public String getOutputSql() {
        return this.outputSql;
    }

    public void setOutputSql(String outputSql) {
        this.outputSql = outputSql;
    }

    public void setContinueAfterError(boolean continueAfterError) {
        this.continueAfterError = continueAfterError;
    }

    public boolean isContinueAfterError() {
        return this.continueAfterError;
    }

    public String report() {
        StringBuilder buff = new StringBuilder(128);
        buff.append("\tsourceTableNames=").append(this.sourceTableNames).append(" @").append(this.configSources.get("sourceTableNames")).append("\n");
        buff.append("\ttargetTableNames=").append(this.targetTableNames).append(" @").append(this.configSources.get("targetTableNames")).append("\n");
        buff.append("\texcludedTableNames=").append(this.excludedTableNames).append(" @").append(this.configSources.get("excludedTableNames")).append("\n");
        buff.append("\tuseSymmetricConfig=").append(this.useSymmetricConfig).append(" @").append(this.configSources.get("useSymmetricConfig")).append("\n");
        buff.append("\tnumericScale=").append(this.numericScale).append(" @").append(this.configSources.get("numericScale")).append("\n");
        buff.append("\twhereClauses=").append(this.whereClauses).append("@").append(this.configSources.get("whereClauses")).append("\n");
        buff.append("\torderBySuffixes=").append(this.orderBySuffixes).append("@").append(this.configSources.get("orderBySuffixes")).append("\n");
        buff.append("\ttablesToExcludedColumns=").append(this.tablesToExcludedColumns).append(" @").append(this.configSources.get("tablesToExcludedColumns")).append("\n");
        buff.append("\toutputSql=").append(this.outputSql).append(" @").append(this.configSources.get("outputSql")).append("\n");
        buff.append("\tcontinueAfterError=").append(this.continueAfterError).append(" @").append(this.configSources.get("continueAfterError")).append("\n");
        return buff.toString();
    }
}

