/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbValueComparator {
    static final Logger log = LoggerFactory.getLogger(DbValueComparator.class);
    private ISymmetricEngine sourceEngine;
    private ISymmetricEngine targetEngine;
    private boolean stringIgnoreWhiteSpace = true;
    private boolean stringNullEqualsEmptyString = true;
    private List<SimpleDateFormat> dateFormats = new ArrayList<SimpleDateFormat>();
    private int numericScale = -1;
    private String dateTimeFormat;

    public DbValueComparator(ISymmetricEngine sourceEngine, ISymmetricEngine targetEngine) {
        this.sourceEngine = sourceEngine;
        this.targetEngine = targetEngine;
        this.initDateFormats();
    }

    protected void initDateFormats() {
        this.dateFormats.add(new SimpleDateFormat("MM-dd-yyyy HH:mm:ss:S"));
        this.dateFormats.add(new SimpleDateFormat("MM-dd-yyyy HH:mm:ss.S"));
    }

    public int compareValues(Column sourceColumn, Column targetColumn, String sourceValue, String targetValue) {
        if (sourceValue == null && targetValue == null) {
            return 0;
        }
        if (sourceColumn.isOfTextType()) {
            if (this.isUniType(targetColumn.getJdbcTypeName()) && !targetColumn.getJdbcTypeName().equalsIgnoreCase("unitext")) {
                long ts = System.currentTimeMillis();
                targetValue = DbValueComparator.convertString(targetValue, targetColumn, false);
                ts = System.currentTimeMillis() - ts;
                log.debug("Took " + ts + "milliseconds to convert string for comparison.");
            }
            return this.compareText(sourceColumn, targetColumn, sourceValue, targetValue);
        }
        if (this.isUniType(sourceColumn.getJdbcTypeName())) {
            if (!sourceColumn.getJdbcTypeName().equalsIgnoreCase("unitext")) {
                long ts = System.currentTimeMillis();
                sourceValue = DbValueComparator.convertString(sourceValue, sourceColumn, false);
                ts = System.currentTimeMillis() - ts;
                log.debug("Took " + ts + "milliseconds to convert string for comparison.");
            }
            return this.compareText(sourceColumn, targetColumn, sourceValue, targetValue);
        }
        if (sourceColumn.isOfNumericType()) {
            return this.compareNumeric(sourceColumn, targetColumn, sourceValue, targetValue);
        }
        if (TypeMap.isDateTimeType((int)sourceColumn.getJdbcTypeCode())) {
            return this.compareDateTime(sourceColumn, targetColumn, sourceValue, targetValue);
        }
        return this.compareDefault(sourceColumn, targetColumn, sourceValue, targetValue);
    }

    public static String convertString(String string, Column column, boolean isPrimaryKey) {
        Object stringToConvert = string;
        String utf8String = null;
        try {
            if (((String)stringToConvert).contains("\"")) {
                stringToConvert = ((String)stringToConvert).substring(1, ((String)stringToConvert).length() - 1);
            }
            if (!((String)stringToConvert).toLowerCase().matches(".*[a-z].*") && !isPrimaryKey && ((String)(stringToConvert = new String(Hex.decodeHex((String)stringToConvert)))).contains("\"")) {
                stringToConvert = ((String)stringToConvert).substring(1, ((String)stringToConvert).length() - 1);
            }
            stringToConvert = "fffe" + (String)stringToConvert;
            utf8String = new String(Hex.decodeHex((String)stringToConvert), StandardCharsets.UTF_16);
        }
        catch (DecoderException e) {
            log.warn("Failed to decode the following record " + (String)stringToConvert + " from column " + column.getName() + " of type " + column.getJdbcTypeName() + " using mapped type of " + column.getMappedType() + ". Original string was " + string, (Throwable)e);
        }
        return utf8String;
    }

    public int compareText(Column sourceColumn, Column targetColumn, String source, String target) {
        ISymmetricDialect symmetricDialect;
        boolean isUsingUnitypes;
        if (this.stringNullEqualsEmptyString) {
            if (source == null) {
                source = "";
            }
            if (target == null) {
                target = "";
            }
        }
        if (this.stringIgnoreWhiteSpace) {
            source = source != null ? source.trim() : null;
            String string = target = target != null ? target.trim() : null;
        }
        if ((isUsingUnitypes = (symmetricDialect = this.sourceEngine.getSymmetricDialect()).getParameterService().is("sybase.ase.convert.unitypes.for.sync")) && (this.isUniType(sourceColumn.getJdbcTypeName()) || this.isUniType(targetColumn.getJdbcTypeName()))) {
            String normalizedSource = Normalizer.normalize(source, Normalizer.Form.NFD);
            String normalizedTarget = Normalizer.normalize(target, Normalizer.Form.NFD);
            if (normalizedSource != null && normalizedTarget != null) {
                return normalizedSource.compareTo(normalizedTarget);
            }
            return this.compareDefault(sourceColumn, targetColumn, normalizedSource, normalizedTarget);
        }
        if (source != null && target != null) {
            return source.compareTo(target);
        }
        return this.compareDefault(sourceColumn, targetColumn, source, target);
    }

    public int compareNumeric(Column sourceColumn, Column targetColumn, String sourceValue, String targetValue) {
        if (StringUtils.isBlank((CharSequence)sourceValue) && StringUtils.isBlank((CharSequence)targetValue)) {
            return 0;
        }
        if (!StringUtils.isBlank((CharSequence)sourceValue) && StringUtils.isBlank((CharSequence)targetValue)) {
            return 1;
        }
        if (StringUtils.isBlank((CharSequence)sourceValue) && !StringUtils.isBlank((CharSequence)targetValue)) {
            return -1;
        }
        BigDecimal source = null;
        BigDecimal target = null;
        try {
            source = NumberUtils.createBigDecimal((String)sourceValue);
        }
        catch (NumberFormatException ex) {
            log.debug("Failed to parse [" + sourceValue + "]", (Throwable)ex);
        }
        try {
            target = NumberUtils.createBigDecimal((String)targetValue);
        }
        catch (NumberFormatException ex) {
            log.debug("Failed to parse [" + targetValue + "]", (Throwable)ex);
        }
        if (source != null && target != null) {
            if (this.numericScale >= 0) {
                source = source.setScale(this.numericScale, RoundingMode.HALF_UP);
                target = target.setScale(this.numericScale, RoundingMode.HALF_UP);
            }
            return source.compareTo(target);
        }
        return sourceValue.compareTo(targetValue);
    }

    public int compareDateTime(Column sourceColumn, Column targetColumn, String sourceValue, String targetValue) {
        if (sourceValue == null || targetValue == null) {
            return this.compareDefault(sourceColumn, targetColumn, sourceValue, targetValue);
        }
        Date sourceDate = this.parseDate(this.sourceEngine, sourceColumn, sourceValue);
        Date targetDate = this.parseDate(this.targetEngine, targetColumn, targetValue);
        if (sourceColumn.getJdbcTypeCode() != 91 && targetColumn.getJdbcTypeCode() != 91) {
            if (this.dateTimeFormat != null) {
                String sourceDateFormatted = this.formatDateTime(sourceDate);
                String targetDateFormatted = this.formatDateTime(targetDate);
                return this.compareDefault(sourceColumn, targetColumn, sourceDateFormatted, targetDateFormatted);
            }
        } else {
            sourceDate = DateUtils.truncate((Date)sourceDate, (int)5);
            targetDate = DateUtils.truncate((Date)targetDate, (int)5);
        }
        return this.compareDefault(sourceColumn, targetColumn, sourceDate, targetDate);
    }

    public String formatDateTime(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(this.dateTimeFormat);
        String formattedDate = formatter.format(date);
        return formattedDate;
    }

    protected int compareDefault(Column sourceColumn, Column targetColumn, Object sourceValue, Object targetValue) {
        if (sourceValue == null && targetValue == null) {
            return 0;
        }
        if (sourceValue != null && targetValue == null) {
            return 1;
        }
        if (sourceValue == null && targetValue != null) {
            return -1;
        }
        if (sourceValue instanceof Comparable) {
            return ((Comparable)sourceValue).compareTo(targetValue);
        }
        if (sourceValue instanceof String) {
            return ((String)sourceValue).compareTo((String)targetValue);
        }
        if (sourceValue != null && sourceValue.equals(targetValue)) {
            return 0;
        }
        return 1;
    }

    protected Date parseDate(ISymmetricEngine engine, Column column, String value) {
        Date date = null;
        try {
            date = engine.getDatabasePlatform().parseDate(column.getJdbcTypeCode(), value, false);
        }
        catch (Exception e) {
            for (SimpleDateFormat format : this.dateFormats) {
                try {
                    date = format.parse(value);
                    if (date == null) continue;
                    break;
                }
                catch (Exception e2) {
                }
            }
        }
        return date;
    }

    public boolean isUniType(String type) {
        return type.equalsIgnoreCase("UNITEXT") || type.equalsIgnoreCase("UNICHAR") || type.equalsIgnoreCase("UNIVARCHAR");
    }

    public int getNumericScale() {
        return this.numericScale;
    }

    public void setNumericScale(int numericScale) {
        this.numericScale = numericScale;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String format) {
        this.dateTimeFormat = format;
    }
}

