/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;

public class Channel
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String channelId;
    private int processingOrder;
    private int maxBatchSize = 10000;
    private int maxBatchToSend = 10;
    private int maxDataToRoute = 500000;
    private BigDecimal maxKBytesPerSecond = BigDecimal.ZERO;
    private boolean enabled = true;
    private boolean useOldDataToRoute = true;
    private boolean useRowDataToRoute = true;
    private boolean usePkDataToRoute = true;
    private boolean containsBigLob = false;
    private String batchAlgorithm = "default";
    private long extractPeriodMillis = 0L;
    private String dataLoaderType = "default";
    private Date createTime;
    private Date lastUpdateTime;
    private String lastUpdateBy;
    private boolean reloadFlag = false;
    private boolean fileSyncFlag = false;
    private String queue = "default";
    private NodeGroupLinkAction dataEventAction = null;
    private String description;

    public Channel() {
    }

    public Channel(String id, int processingOrder) {
        this.channelId = id;
        this.processingOrder = processingOrder;
    }

    public Channel(String id, int processingOrder, int maxBatchSize, int maxBatchToSend, boolean enabled, long extractPeriodMillis, boolean containsBigLobs, String batchAlgorithm, boolean reloadFlag, boolean filesyncFlag) {
        this(id, processingOrder, maxBatchSize, maxBatchToSend, enabled, extractPeriodMillis, containsBigLobs, reloadFlag, filesyncFlag);
        this.batchAlgorithm = batchAlgorithm;
    }

    public Channel(String id, int processingOrder, int maxBatchSize, int maxBatchToSend, boolean enabled, long extractPeriodMillis, boolean containsBigLobs, boolean reloadFlag, boolean filesyncFlag) {
        this(id, processingOrder, maxBatchSize, maxBatchToSend, enabled, extractPeriodMillis, containsBigLobs);
        this.reloadFlag = reloadFlag;
        this.fileSyncFlag = filesyncFlag;
    }

    public Channel(String id, int processingOrder, int maxBatchSize, int maxBatchToSend, boolean enabled, long extractPeriodMillis, boolean containsBigLobs) {
        this(id, processingOrder);
        this.maxBatchSize = maxBatchSize;
        this.maxBatchToSend = maxBatchToSend;
        this.enabled = enabled;
        this.extractPeriodMillis = extractPeriodMillis;
        this.containsBigLob = containsBigLobs;
        this.queue = "default";
    }

    public Channel(String id, int processingOrder, int maxBatchSize, int maxBatchToSend, boolean enabled, long extractPeriodMillis, boolean containsBigLobs, String queue) {
        this(id, processingOrder, maxBatchSize, maxBatchToSend, enabled, extractPeriodMillis, containsBigLobs);
        this.queue = queue;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String id) {
        this.channelId = id;
    }

    public int getProcessingOrder() {
        return this.processingOrder;
    }

    public void setProcessingOrder(int priority) {
        this.processingOrder = priority;
    }

    public void setMaxDataToRoute(int maxDataToRoute) {
        this.maxDataToRoute = maxDataToRoute;
    }

    public int getMaxDataToRoute() {
        return this.maxDataToRoute;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxNumberOfEvents) {
        this.maxBatchSize = maxNumberOfEvents;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getMaxBatchToSend() {
        return this.maxBatchToSend;
    }

    public void setMaxBatchToSend(int maxBatchToSend) {
        this.maxBatchToSend = maxBatchToSend;
    }

    public boolean isInList(Collection<? extends NodeChannel> channels) {
        return this.findInList(channels) != null;
    }

    public Channel findInList(Collection<? extends NodeChannel> channels) {
        if (channels != null) {
            for (NodeChannel nodeChannel : channels) {
                if (!nodeChannel.getChannelId().equals(this.channelId)) continue;
                return nodeChannel.getChannel();
            }
        }
        return null;
    }

    public void setBatchAlgorithm(String batchAlgorithm) {
        this.batchAlgorithm = batchAlgorithm;
    }

    public String getBatchAlgorithm() {
        return this.batchAlgorithm;
    }

    public long getExtractPeriodMillis() {
        return this.extractPeriodMillis;
    }

    public void setExtractPeriodMillis(long extractPeriodMillis) {
        this.extractPeriodMillis = extractPeriodMillis;
    }

    public void setUseOldDataToRoute(boolean useOldDataToRoute) {
        this.useOldDataToRoute = useOldDataToRoute;
    }

    public boolean isUseOldDataToRoute() {
        return this.useOldDataToRoute;
    }

    public void setUseRowDataToRoute(boolean useRowDataToRoute) {
        this.useRowDataToRoute = useRowDataToRoute;
    }

    public boolean isUseRowDataToRoute() {
        return this.useRowDataToRoute;
    }

    public void setUsePkDataToRoute(boolean usePkDataToRoute) {
        this.usePkDataToRoute = usePkDataToRoute;
    }

    public boolean isUsePkDataToRoute() {
        return this.usePkDataToRoute;
    }

    public void setContainsBigLob(boolean containsBigLobs) {
        this.containsBigLob = containsBigLobs;
    }

    public boolean isContainsBigLob() {
        return this.containsBigLob;
    }

    public void setDataLoaderType(String dataloader) {
        this.dataLoaderType = dataloader;
    }

    public String getDataLoaderType() {
        return this.dataLoaderType;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setFileSyncFlag(boolean filesyncFlag) {
        this.fileSyncFlag = filesyncFlag;
    }

    public boolean isFileSyncFlag() {
        return this.fileSyncFlag;
    }

    public void setReloadFlag(boolean reloadFlag) {
        this.reloadFlag = reloadFlag;
    }

    public boolean isReloadFlag() {
        return this.reloadFlag;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public BigDecimal getMaxKBytesPerSecond() {
        return this.maxKBytesPerSecond;
    }

    public void setMaxKBytesPerSecond(BigDecimal maxKBytesPerSecond) {
        this.maxKBytesPerSecond = maxKBytesPerSecond;
    }

    public NodeGroupLinkAction getDataEventAction() {
        return this.dataEventAction;
    }

    public void setDataEventAction(NodeGroupLinkAction dataEventAction) {
        this.dataEventAction = dataEventAction;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        if (this.channelId != null) {
            return this.channelId.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.channelId != null) {
            if (obj instanceof Channel) {
                return this.channelId.equals(((Channel)obj).channelId);
            }
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        if (this.channelId != null) {
            return this.channelId;
        }
        return super.toString();
    }

    public Channel copy() {
        Channel channel = null;
        try {
            channel = (Channel)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return channel;
    }
}

