/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class ChannelMap {
    public static final String CHANNELS_SUSPEND = "Suspended-Channels";
    public static final String CHANNELS_IGNORE = "Ignored-Channels";
    private String channelQueue;
    private Map<String, Set<String>> map = new HashMap<String, Set<String>>();

    public ChannelMap() {
        TreeSet suspendChannels = new TreeSet();
        this.map.put(CHANNELS_SUSPEND, suspendChannels);
        TreeSet ignoreChannels = new TreeSet();
        this.map.put(CHANNELS_IGNORE, ignoreChannels);
    }

    public void addSuspendChannels(Collection<String> suspends) {
        if (suspends != null) {
            this.map.get(CHANNELS_SUSPEND).addAll(suspends);
        }
    }

    public void addIgnoreChannels(Collection<String> ignores) {
        if (ignores != null) {
            this.map.get(CHANNELS_IGNORE).addAll(ignores);
        }
    }

    public void addSuspendChannels(String suspends) {
        if (suspends != null) {
            this.map.get(CHANNELS_SUSPEND).addAll(Arrays.asList(suspends.split(",")));
        }
    }

    public void addIgnoreChannels(String ignores) {
        if (ignores != null) {
            this.map.get(CHANNELS_IGNORE).addAll(Arrays.asList(ignores.split(",")));
        }
    }

    public String getSuspendChannelsAsString() {
        return StringUtils.join((Iterable)this.map.get(CHANNELS_SUSPEND), (char)',');
    }

    public String getIgnoreChannelsAsString() {
        return StringUtils.join((Iterable)this.map.get(CHANNELS_IGNORE), (char)',');
    }

    public Set<String> getSuspendChannels() {
        return this.map.get(CHANNELS_SUSPEND);
    }

    public Set<String> getIgnoreChannels() {
        return this.map.get(CHANNELS_IGNORE);
    }

    public String getChannelQueue() {
        return this.channelQueue;
    }

    public void setChannelQueue(String threadChannel) {
        this.channelQueue = threadChannel;
    }
}

