/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.model.FileTriggerRouter;

public class FileSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String triggerId;
    private String routerId;
    private String relativeDir;
    private String fileName;
    private LastEventType lastEventType;
    private String channelId;
    private String reloadChannelId;
    private long crc32Checksum;
    private long oldCrc32Checksum;
    private long fileSize;
    private long fileModifiedTime;
    private Date createTime = new Date();
    private String lastUpdateBy;
    private Date lastUpdateTime;

    public FileSnapshot() {
    }

    public FileSnapshot(FileSnapshot copy) {
        this.triggerId = copy.triggerId;
        this.routerId = copy.routerId;
        this.relativeDir = copy.relativeDir;
        this.fileName = copy.fileName;
        this.lastEventType = copy.lastEventType;
        this.crc32Checksum = copy.crc32Checksum;
        this.fileSize = copy.fileSize;
        this.fileModifiedTime = copy.fileModifiedTime;
        this.createTime = copy.createTime;
        this.lastUpdateBy = copy.lastUpdateBy;
        this.lastUpdateTime = copy.lastUpdateTime;
        this.channelId = copy.channelId;
        this.reloadChannelId = copy.getReloadChannelId();
    }

    public FileSnapshot(FileTriggerRouter fileTriggerRouter, File file, LastEventType lastEventType) {
        this(fileTriggerRouter, file, lastEventType, false);
    }

    public FileSnapshot(FileTriggerRouter fileTriggerRouter, File file, LastEventType lastEventType, boolean useCrc) {
        boolean isDelete = lastEventType == LastEventType.DELETE;
        this.triggerId = fileTriggerRouter.getFileTrigger().getTriggerId();
        this.channelId = fileTriggerRouter.getFileTrigger().getChannelId();
        this.reloadChannelId = fileTriggerRouter.getFileTrigger().getReloadChannelId();
        this.routerId = fileTriggerRouter.getRouter().getRouterId();
        this.lastEventType = lastEventType;
        this.lastUpdateTime = new Date();
        this.fileName = file.getName();
        this.relativeDir = file.getPath().replace('\\', '/');
        String baseDir = fileTriggerRouter.getFileTrigger().getBaseDir().replace('\\', '/');
        if (this.relativeDir.startsWith(baseDir)) {
            this.relativeDir = this.relativeDir.substring(baseDir.length());
        }
        if (this.relativeDir.endsWith(this.fileName)) {
            this.relativeDir = this.relativeDir.substring(0, this.relativeDir.lastIndexOf(this.fileName));
        }
        if (this.relativeDir.startsWith("/")) {
            this.relativeDir = this.relativeDir.substring(1);
        }
        if (this.relativeDir.endsWith("/")) {
            this.relativeDir = this.relativeDir.substring(0, this.relativeDir.length() - 1);
        }
        if (StringUtils.isBlank((CharSequence)this.relativeDir)) {
            this.relativeDir = ".";
        }
        this.fileSize = isDelete ? 0L : file.length();
        long l = this.fileModifiedTime = isDelete ? 0L : file.lastModified();
        if (useCrc && file.isFile() && !isDelete) {
            try {
                this.crc32Checksum = FileUtils.checksumCRC32((File)file);
            }
            catch (FileNotFoundException ex) {
                this.lastEventType = LastEventType.DELETE;
                this.fileSize = 0L;
                this.fileModifiedTime = 0L;
            }
            catch (IOException ex) {
                throw new IoException((Exception)ex);
            }
        } else {
            this.crc32Checksum = -1L;
        }
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public String getRouterId() {
        return this.routerId;
    }

    public void setRouterId(String routerId) {
        this.routerId = routerId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setReloadChannelId(String reloadChannelId) {
        this.reloadChannelId = reloadChannelId;
    }

    public String getReloadChannelId() {
        return this.reloadChannelId;
    }

    public String getRelativeDir() {
        return this.relativeDir;
    }

    public void setRelativeDir(String relativeDir) {
        this.relativeDir = relativeDir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public LastEventType getLastEventType() {
        return this.lastEventType;
    }

    public void setLastEventType(LastEventType lastEventType) {
        this.lastEventType = lastEventType;
        if (lastEventType == LastEventType.DELETE) {
            this.fileModifiedTime = 0L;
            this.fileSize = 0L;
        }
    }

    public long getCrc32Checksum() {
        return this.crc32Checksum;
    }

    public void setCrc32Checksum(long crc32Checksum) {
        this.crc32Checksum = crc32Checksum;
    }

    public long getOldCrc32Checksum() {
        return this.oldCrc32Checksum;
    }

    public void setOldCrc32Checksum(long oldCrc32Checksum) {
        this.oldCrc32Checksum = oldCrc32Checksum;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getFileModifiedTime() {
        return this.fileModifiedTime;
    }

    public void setFileModifiedTime(long fileModifiedTime) {
        this.fileModifiedTime = fileModifiedTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public boolean sameFile(FileSnapshot file) {
        return StringUtils.equals((CharSequence)this.fileName, (CharSequence)file.fileName) && StringUtils.equals((CharSequence)this.relativeDir, (CharSequence)file.relativeDir);
    }

    public String generateSearchKey() {
        StringBuilder b = new StringBuilder(this.fileName.length() + File.pathSeparator.length() + this.relativeDir.length());
        b.append(this.fileName);
        b.append(File.pathSeparator);
        b.append(this.relativeDir);
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.crc32Checksum ^ this.crc32Checksum >>> 32);
        result = 31 * result + (int)(this.fileModifiedTime ^ this.fileModifiedTime >>> 32);
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.relativeDir == null ? 0 : this.relativeDir.hashCode());
        result = 31 * result + (int)(this.fileSize ^ this.fileSize >>> 32);
        result = 31 * result + (this.lastEventType == null ? 0 : this.lastEventType.hashCode());
        result = 31 * result + (this.triggerId == null ? 0 : this.triggerId.hashCode());
        result = 31 * result + (this.routerId == null ? 0 : this.routerId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileSnapshot other = (FileSnapshot)obj;
        if (this.crc32Checksum != other.crc32Checksum) {
            return false;
        }
        if (this.fileModifiedTime != other.fileModifiedTime) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.relativeDir == null ? other.relativeDir != null : !this.relativeDir.equals(other.relativeDir)) {
            return false;
        }
        if (this.fileSize != other.fileSize) {
            return false;
        }
        if (this.lastEventType != other.lastEventType) {
            return false;
        }
        if (this.triggerId == null ? other.triggerId != null : !this.triggerId.equals(other.triggerId)) {
            return false;
        }
        return !(this.routerId == null ? other.routerId != null : !this.routerId.equals(other.routerId));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("fileName: ").append(this.fileName).append(", relativeDir: ").append(this.relativeDir);
        sb.append(", fileSize: ").append(this.fileSize).append(" fileModifiedTime: ").append(new Date(this.fileModifiedTime));
        return sb.toString();
    }

    public static enum LastEventType {
        CREATE("C"),
        MODIFY("M"),
        DELETE("D");

        private String code;

        private LastEventType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static LastEventType fromCode(String code) {
            if ("C".equals(code)) {
                return CREATE;
            }
            if ("M".equals(code)) {
                return MODIFY;
            }
            if ("D".equals(code)) {
                return DELETE;
            }
            return null;
        }
    }
}

