/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.ArrayList;
import java.util.Map;
import org.jumpmind.exception.InterruptedException;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.RemoteNodeStatus;

public class RemoteNodeStatuses
extends ArrayList<RemoteNodeStatus> {
    private static final long serialVersionUID = 1L;
    Map<String, Channel> channels;

    public RemoteNodeStatuses(Map<String, Channel> channels) {
        this.channels = channels;
    }

    public boolean wasDataProcessed() {
        boolean dataProcessed = false;
        for (RemoteNodeStatus status : this) {
            dataProcessed |= status.getDataProcessed() > 0L;
        }
        return dataProcessed;
    }

    public boolean wasBatchProcessed() {
        boolean batchProcessed = false;
        for (RemoteNodeStatus status : this) {
            batchProcessed |= status.getBatchesProcessed() > 0L;
        }
        return batchProcessed;
    }

    public long getDataProcessedCount() {
        long dataProcessed = this.size() > 0 ? 0L : -1L;
        for (RemoteNodeStatus status : this) {
            dataProcessed += status.getDataProcessed();
        }
        return dataProcessed;
    }

    public boolean errorOccurred() {
        boolean errorOccurred = false;
        for (RemoteNodeStatus status : this) {
            errorOccurred |= status.failed();
        }
        return errorOccurred;
    }

    public RemoteNodeStatus add(String nodeId, String queue) {
        RemoteNodeStatus status = null;
        if (nodeId != null) {
            status = new RemoteNodeStatus(nodeId, queue, this.channels);
            this.add(status);
        }
        return status;
    }

    public RemoteNodeStatus add(String nodeId) {
        RemoteNodeStatus status = null;
        if (nodeId != null) {
            status = new RemoteNodeStatus(nodeId, null, this.channels);
            this.add(status);
        }
        return status;
    }

    public boolean isComplete() {
        boolean complete = true;
        for (RemoteNodeStatus status : this) {
            complete &= status.isComplete();
        }
        return complete;
    }

    public void waitForComplete(long timeout) {
        long deadline = System.currentTimeMillis() + timeout;
        for (RemoteNodeStatus status : this) {
            long timeLeft = deadline - System.currentTimeMillis();
            try {
                if (timeLeft > 0L && status.waitCompleted(timeLeft)) continue;
                throw new InterruptedException(String.format("Timed out after %sms", timeout));
            }
            catch (java.lang.InterruptedException e) {
                throw new InterruptedException(e);
            }
        }
    }
}

