/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.ProtocolException;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.util.LinkedCaseInsensitiveMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataRouter
implements IDataRouter {
    private static final String OLD_ = "OLD_";
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void contextCommitted(SimpleRouterContext context) {
    }

    protected Map<String, String> getDataMap(DataMetaData dataMetaData, ISymmetricDialect symmetricDialect) {
        LinkedCaseInsensitiveMap data = null;
        DataEventType dml = dataMetaData.getData().getDataEventType();
        switch (dml) {
            case UPDATE: {
                data = new LinkedCaseInsensitiveMap(dataMetaData.getTable().getColumnCount() * 4);
                data.putAll(this.getNewDataAsString(null, dataMetaData, symmetricDialect));
                data.putAll(this.getOldDataAsString(OLD_, dataMetaData, symmetricDialect));
                break;
            }
            case INSERT: {
                data = new LinkedCaseInsensitiveMap(dataMetaData.getTable().getColumnCount() * 4);
                data.putAll(this.getNewDataAsString(null, dataMetaData, symmetricDialect));
                Map map = this.getNullData(OLD_, dataMetaData);
                data.putAll(map);
                break;
            }
            case DELETE: {
                data = new LinkedCaseInsensitiveMap(dataMetaData.getTable().getColumnCount() * 4);
                data.putAll(this.getOldDataAsString(null, dataMetaData, symmetricDialect));
                data.putAll(this.getOldDataAsString(OLD_, dataMetaData, symmetricDialect));
                break;
            }
            default: {
                data = new LinkedCaseInsensitiveMap(1);
            }
        }
        if (data != null) {
            if (data.size() == 0) {
                data.putAll(this.getPkDataAsString(dataMetaData, symmetricDialect));
            }
            data.put("EXTERNAL_DATA", dataMetaData.getData().getExternalData());
        }
        return data;
    }

    protected Map<String, String> getNewDataAsString(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect) {
        String[] rowData = dataMetaData.getData().toParsedRowData();
        return this.getDataAsString(prefix, dataMetaData, symmetricDialect, rowData);
    }

    protected Map<String, String> getOldDataAsString(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect) {
        String[] rowData = dataMetaData.getData().toParsedOldData();
        return this.getDataAsString(prefix, dataMetaData, symmetricDialect, rowData);
    }

    protected Map<String, String> getDataAsString(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, String[] rowData) {
        String[] columns = dataMetaData.getTriggerHistory().getParsedColumnNames();
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap(columns.length * 2);
        if (rowData != null) {
            this.testColumnNamesMatchValues(dataMetaData, columns, rowData);
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i];
                columnName = prefix != null ? prefix + columnName : columnName;
                map.put(columnName, rowData[i]);
                map.put(columnName.toUpperCase(), rowData[i]);
            }
        }
        return map;
    }

    protected Map<String, String> getPkDataAsString(DataMetaData dataMetaData, ISymmetricDialect symmetricDialect) {
        String[] columns = dataMetaData.getTriggerHistory().getParsedPkColumnNames();
        Object[] rowData = dataMetaData.getData().toParsedPkData();
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap(columns.length);
        if (rowData != null) {
            this.testColumnNamesMatchValues(dataMetaData, columns, rowData);
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i].toUpperCase();
                map.put(columnName, rowData[i]);
            }
        }
        return map;
    }

    protected Map<String, Object> getDataObjectMap(DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, boolean upperCase) {
        LinkedCaseInsensitiveMap data = null;
        DataEventType dml = dataMetaData.getData().getDataEventType();
        switch (dml) {
            case UPDATE: {
                data = new LinkedCaseInsensitiveMap(dataMetaData.getTable().getColumnCount() * 2);
                data.putAll(this.getNewDataAsObject(null, dataMetaData, symmetricDialect, upperCase));
                data.putAll(this.getOldDataAsObject(OLD_, dataMetaData, symmetricDialect, upperCase));
                break;
            }
            case INSERT: {
                data = new LinkedCaseInsensitiveMap(dataMetaData.getTable().getColumnCount() * 2);
                data.putAll(this.getNewDataAsObject(null, dataMetaData, symmetricDialect, upperCase));
                Map map = this.getNullData(OLD_, dataMetaData);
                data.putAll(map);
                break;
            }
            case DELETE: {
                data = new LinkedCaseInsensitiveMap(dataMetaData.getTable().getColumnCount() * 2);
                data.putAll(this.getOldDataAsObject(null, dataMetaData, symmetricDialect, upperCase));
                data.putAll(this.getOldDataAsObject(OLD_, dataMetaData, symmetricDialect, upperCase));
                if (data.size() != 0) break;
                data.putAll(this.getPkDataAsObject(dataMetaData, symmetricDialect));
                break;
            }
            default: {
                data = new LinkedCaseInsensitiveMap(1);
            }
        }
        if (data.size() == 0) {
            data.putAll(this.getPkDataAsString(dataMetaData, symmetricDialect));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMetaData.getData().getExternalData())) {
            data.put("EXTERNAL_DATA", dataMetaData.getData().getExternalData());
        } else {
            data.put("EXTERNAL_DATA", null);
        }
        return data;
    }

    protected Map<String, Object> getNewDataAsObject(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, boolean upperCase) {
        return this.getDataAsObject(prefix, dataMetaData, symmetricDialect, dataMetaData.getData().toParsedRowData(), upperCase);
    }

    protected Map<String, Object> getOldDataAsObject(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, boolean upperCase) {
        return this.getDataAsObject(prefix, dataMetaData, symmetricDialect, dataMetaData.getData().toParsedOldData(), upperCase);
    }

    protected <T> Map<String, T> getNullData(String prefix, DataMetaData dataMetaData) {
        String[] columnNames = dataMetaData.getTriggerHistory().getParsedColumnNames();
        LinkedCaseInsensitiveMap data = new LinkedCaseInsensitiveMap(columnNames.length * 2);
        for (String columnName : columnNames) {
            columnName = prefix != null ? prefix + columnName : columnName;
            data.put(columnName, null);
            data.put(columnName.toUpperCase(), null);
        }
        return data;
    }

    protected Map<String, Object> getDataAsObject(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, String[] rowData, boolean upperCase) {
        if (rowData != null) {
            LinkedCaseInsensitiveMap data = new LinkedCaseInsensitiveMap(rowData.length);
            String[] columnNames = dataMetaData.getTriggerHistory().getParsedColumnNames();
            Object[] objects = symmetricDialect.getPlatform().getObjectValues(symmetricDialect.getBinaryEncoding(), dataMetaData.getTable(), columnNames, rowData);
            this.testColumnNamesMatchValues(dataMetaData, columnNames, objects);
            for (int i = 0; i < columnNames.length; ++i) {
                String colName = upperCase ? columnNames[i].toUpperCase() : columnNames[i];
                data.put(prefix != null ? prefix + colName : colName, objects[i]);
            }
            return data;
        }
        return Collections.emptyMap();
    }

    protected void testColumnNamesMatchValues(DataMetaData dataMetaData, String[] columnNames, Object[] values) {
        if (columnNames.length != values.length) {
            String message = String.format("The router row for table %s had %d columns but expected %d.", dataMetaData.getData().getTableName(), values.length, columnNames.length);
            throw new ProtocolException(message, new Object[0]);
        }
    }

    protected Map<String, Object> getPkDataAsObject(DataMetaData dataMetaData, ISymmetricDialect symmetricDialect) {
        String[] rowData = dataMetaData.getData().toParsedPkData();
        if (rowData != null) {
            LinkedCaseInsensitiveMap data = new LinkedCaseInsensitiveMap(rowData.length);
            String[] columnNames = dataMetaData.getTriggerHistory().getParsedPkColumnNames();
            Object[] objects = symmetricDialect.getPlatform().getObjectValues(symmetricDialect.getBinaryEncoding(), dataMetaData.getTable(), columnNames, rowData);
            this.testColumnNamesMatchValues(dataMetaData, columnNames, objects);
            for (int i = 0; i < columnNames.length; ++i) {
                data.put(columnNames[i].toUpperCase(), objects[i]);
            }
            return data;
        }
        return Collections.emptyMap();
    }

    protected Set<String> addNodeId(String nodeId, Set<String> nodeIds, Set<Node> nodes) {
        nodeIds = nodeIds == null ? new HashSet<String>(1) : nodeIds;
        for (Node node : nodes) {
            if (!node.getNodeId().equals(nodeId)) continue;
            nodeIds.add(nodeId);
            break;
        }
        return nodeIds;
    }

    protected Set<String> toNodeIds(Set<Node> nodes, Set<String> nodeIds) {
        nodeIds = nodeIds == null ? new HashSet<String>(nodes.size()) : nodeIds;
        for (Node node : nodes) {
            nodeIds.add(node.getNodeId());
        }
        return nodeIds;
    }

    protected Set<String> toExternalIds(Set<Node> nodes) {
        HashSet<String> externalIds = new HashSet<String>();
        for (Node node : nodes) {
            externalIds.add(node.getExternalId());
        }
        return externalIds;
    }

    @Override
    public void completeBatch(SimpleRouterContext context, OutgoingBatch batch) {
        this.log.debug("Completing batch {}", (Object)batch.getBatchId());
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean isDmlOnly() {
        return true;
    }
}

