/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.route.DataGapDetector;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGapFastDetector
extends DataGapDetector
implements ISqlRowMapper<Long> {
    private static final Logger log = LoggerFactory.getLogger(DataGapFastDetector.class);
    protected IContextService contextService;
    protected IClusterService clusterService;
    protected List<DataGap> gaps;
    protected DataGap lastGap;
    protected List<Long> dataIds;
    protected boolean isAllDataRead = true;
    protected long maxDataToSelect;
    protected boolean isFullGapAnalysis = true;
    protected long lastBusyExpireRunTime;
    protected Set<DataGap> gapsAll;
    protected Set<DataGap> gapsAdded;
    protected Set<DataGap> gapsDeleted;
    protected Set<DataGap> gapsExpired;
    protected boolean detectInvalidGaps;
    protected boolean useInMemoryGaps;
    protected long routingStartTime;
    protected long earliestTransactionTime = 0L;
    protected boolean supportsTransactionViews;
    protected static Map<String, Boolean> firstTime = Collections.synchronizedMap(new HashMap());

    public DataGapFastDetector(IDataService dataService, IParameterService parameterService, IContextService contextService, ISymmetricDialect symmetricDialect, IRouterService routerService, IStatisticManager statisticManager, INodeService nodeService, IClusterService clusterService) {
        this.dataService = dataService;
        this.parameterService = parameterService;
        this.contextService = contextService;
        this.routerService = routerService;
        this.symmetricDialect = symmetricDialect;
        this.statisticManager = statisticManager;
        this.nodeService = nodeService;
        this.clusterService = clusterService;
    }

    @Override
    public void beforeRouting() {
        ProcessInfo processInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(this.nodeService.findIdentityNodeId(), null, ProcessType.GAP_DETECT));
        processInfo.setStatus(ProcessInfo.ProcessStatus.QUERYING);
        try {
            this.maxDataToSelect = this.parameterService.getLong("routing.largest.gap.size");
            this.detectInvalidGaps = this.parameterService.is("routing.detect.invalid.gaps") || firstTime.get(this.parameterService.getEngineName()) == null;
            this.reset();
            if (this.isFullGapAnalysis()) {
                log.info("Full gap analysis is running");
                long ts = System.currentTimeMillis();
                this.gaps = this.dataService.findDataGaps();
                if (this.detectInvalidGaps) {
                    this.fixOverlappingGaps(this.gaps, processInfo);
                }
                this.queryDataIdMap();
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                log.info("Querying data in gaps from database took {} ms", (Object)(System.currentTimeMillis() - ts));
                this.isAllDataRead = false;
                this.afterRouting();
                this.reset();
                log.info("Full gap analysis is done after {} ms", (Object)(System.currentTimeMillis() - ts));
            } else if (this.gaps == null || this.parameterService.is("cluster.lock.enabled")) {
                this.gaps = this.dataService.findDataGaps();
                if (this.detectInvalidGaps) {
                    this.fixOverlappingGaps(this.gaps, processInfo);
                }
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
            } else {
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
            }
        }
        catch (RuntimeException e) {
            if (processInfo.getStatus() != ProcessInfo.ProcessStatus.OK) {
                processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
            }
            throw e;
        }
        finally {
            firstTime.put(this.parameterService.getEngineName(), true);
        }
    }

    protected void reset() {
        this.isAllDataRead = true;
        this.dataIds = new ArrayList<Long>();
        this.gapsAll = new HashSet<DataGap>();
        this.gapsAdded = new HashSet<DataGap>();
        this.gapsDeleted = new HashSet<DataGap>();
        this.gapsExpired = new HashSet<DataGap>();
        this.routingStartTime = System.currentTimeMillis();
        this.supportsTransactionViews = this.symmetricDialect.supportsTransactionViews();
        this.earliestTransactionTime = 0L;
        if (this.supportsTransactionViews) {
            Date date = this.symmetricDialect.getEarliestTransactionStartTime();
            if (date != null) {
                this.earliestTransactionTime = date.getTime() - this.parameterService.getLong("oracle.transaction.view.clock.sync.threshold.ms", 60000L);
                log.debug("Earliest transaction time is {}", (Object)this.earliestTransactionTime);
            }
            this.routingStartTime = this.symmetricDialect.getDatabaseTime();
        }
    }

    protected void softReset() {
        this.gapsAll = new HashSet<DataGap>();
        this.gapsAdded = new HashSet<DataGap>();
        this.gapsDeleted = new HashSet<DataGap>();
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void afterRouting() {
        ProcessInfo processInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(this.nodeService.findIdentityNodeId(), null, ProcessType.GAP_DETECT));
        processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
        long printStats = System.currentTimeMillis();
        long gapTimoutInMs = this.parameterService.getLong("routing.stale.dataid.gap.time.ms");
        int dataIdIncrementBy = this.parameterService.getInt("data.id.increment.by");
        boolean isOracleNoOrder = this.parameterService.is("oracle.sequence.noorder", false);
        List<Long> oracleNextValues = null;
        if (isOracleNoOrder) {
            oracleNextValues = this.getOracleNextValues();
        }
        Date currentDate = new Date(this.routingStartTime);
        boolean isBusyExpire = false;
        long lastBusyExpireRunTime = this.getLastBusyExpireRunTime();
        if (!this.isAllDataRead) {
            if (lastBusyExpireRunTime == 0L) {
                this.setLastBusyExpireRunTime(System.currentTimeMillis());
            } else {
                long busyExpireMillis = this.parameterService.getLong("routing.stale.gap.busy.expire.time.ms");
                isBusyExpire = System.currentTimeMillis() - lastBusyExpireRunTime >= busyExpireMillis;
            }
        } else if (lastBusyExpireRunTime != 0L) {
            this.setLastBusyExpireRunTime(0L);
        }
        try {
            long updateTimeInMs;
            DataGap newGap;
            long ts = System.currentTimeMillis();
            long lastDataId = -1L;
            int dataIdCount = 0;
            int rangeChecked = 0;
            int expireChecked = 0;
            this.gapsAll.addAll(this.gaps);
            Map<DataGap, List<Long>> dataIdMap = this.getDataIdMap();
            if (System.currentTimeMillis() - ts > 30000L) {
                log.info("It took {}ms to map {} data IDs into {} gaps", new Object[]{System.currentTimeMillis() - ts, this.dataIds.size(), this.gaps.size()});
            }
            for (DataGap dataGap : this.gaps) {
                boolean lastGap = dataGap.equals(this.gaps.get(this.gaps.size() - 1));
                lastDataId = -1L;
                List<Long> ids = dataIdMap.get(dataGap);
                dataIdCount += ids.size();
                rangeChecked = (int)((long)rangeChecked + (dataGap.getEndId() - dataGap.getStartId()));
                if (ids.size() > 0) {
                    this.gapsDeleted.add(dataGap);
                    this.gapsAll.remove(dataGap);
                } else if (!lastGap && (this.isAllDataRead || isBusyExpire)) {
                    Date createTime = dataGap.getCreateTime();
                    boolean isExpired = false;
                    if (isOracleNoOrder && oracleNextValues != null) {
                        isExpired = createTime != null && this.routingStartTime - createTime.getTime() > gapTimoutInMs && !dataGap.containsAny(oracleNextValues);
                    } else if (this.supportsTransactionViews) {
                        isExpired = createTime != null && (createTime.getTime() < this.earliestTransactionTime || this.earliestTransactionTime == 0L);
                    } else {
                        boolean bl = isExpired = createTime != null && this.routingStartTime - createTime.getTime() > gapTimoutInMs;
                    }
                    if (isExpired) {
                        boolean isGapEmpty = false;
                        if (!this.isAllDataRead) {
                            isGapEmpty = this.dataService.countDataInRange(dataGap.getStartId() - 1L, dataGap.getEndId() + 1L) == 0;
                            ++expireChecked;
                        }
                        if (this.isAllDataRead || isGapEmpty) {
                            this.gapsExpired.add(dataGap);
                            this.gapsAll.remove(dataGap);
                        }
                    }
                }
                for (Number number : ids) {
                    long dataId = number.longValue();
                    processInfo.incrementCurrentDataCount();
                    if (lastDataId == -1L && dataGap.getStartId() + (long)dataIdIncrementBy <= dataId) {
                        this.addDataGap(new DataGap(dataGap.getStartId(), dataId - 1L, currentDate));
                    } else if (lastDataId != -1L && lastDataId + (long)dataIdIncrementBy != dataId && lastDataId != dataId) {
                        this.addDataGap(new DataGap(lastDataId + 1L, dataId - 1L, currentDate));
                    }
                    lastDataId = dataId;
                }
                if (lastDataId != -1L && !lastGap && lastDataId + (long)dataIdIncrementBy <= dataGap.getEndId()) {
                    this.addDataGap(new DataGap(lastDataId + (long)dataIdIncrementBy, dataGap.getEndId(), currentDate));
                }
                if (Thread.interrupted()) {
                    throw new SymmetricException("Thread received interrupt", new Object[0]);
                }
                if (System.currentTimeMillis() - printStats <= 30000L) continue;
                this.checkInterrupted();
                this.clusterService.refreshLock("Routing");
                log.info("The data gap detection has been running for {}ms, detected {} rows over a gap range of {}, found {} new gaps, found old {} gaps, and checked data in {} gaps", new Object[]{System.currentTimeMillis() - ts, dataIdCount, rangeChecked, this.gapsAdded.size(), this.gapsDeleted.size(), expireChecked});
                printStats = System.currentTimeMillis();
            }
            if (lastDataId != -1L && this.addDataGap(newGap = new DataGap(lastDataId + 1L, lastDataId + this.maxDataToSelect, currentDate))) {
                log.debug("Inserting new last data gap: {}", (Object)newGap);
            }
            processInfo.setStatus(ProcessInfo.ProcessStatus.CREATING);
            this.saveDataGaps();
            if (this.gaps.size() > 0) {
                this.lastGap = this.gaps.get(this.gaps.size() - 1);
            }
            this.setFullGapAnalysis(false);
            if (isBusyExpire) {
                this.setLastBusyExpireRunTime(System.currentTimeMillis());
            }
            if ((updateTimeInMs = System.currentTimeMillis() - ts) > 10000L) {
                log.info("Detecting gaps took {} ms", (Object)updateTimeInMs);
            }
            processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
        }
        catch (RuntimeException ex) {
            processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
            throw ex;
        }
        finally {
            this.logExpiredDataGaps();
            this.softReset();
        }
    }

    protected boolean addDataGap(DataGap dataGap) {
        boolean isOkay = true;
        if (this.detectInvalidGaps) {
            if (this.gapsAll.contains(dataGap)) {
                log.warn("Detected a duplicate data gap: " + dataGap);
                isOkay = false;
            } else if (dataGap.getStartId() > dataGap.getEndId()) {
                log.warn("Detected an invalid gap range: " + dataGap);
                isOkay = false;
            } else if (dataGap.gapSize() < this.maxDataToSelect - 1L && dataGap.gapSize() >= (long)((double)this.maxDataToSelect * 0.75)) {
                log.warn("Detected a very large gap range: " + dataGap);
                isOkay = false;
            }
        }
        if (isOkay) {
            this.gapsAdded.add(dataGap);
            this.gapsAll.add(dataGap);
        } else {
            this.printGapState();
        }
        return isOkay;
    }

    private void printGapState() {
        StringBuilder buff = new StringBuilder();
        buff.append("\nData IDs: " + this.dataIds).append("\n");
        buff.append("Data Gaps: " + this.gaps).append("\n");
        buff.append("Added Data Gaps: " + this.gapsAdded).append("\n");
        buff.append("Deleted Data Gaps: " + this.gapsDeleted).append("\n");
        log.info(buff.toString());
    }

    protected void saveDataGaps() {
        ISqlTemplate sqlTemplate = this.symmetricDialect.getPlatform().getSqlTemplate();
        int totalGapChanges = this.gapsDeleted.size() + this.gapsAdded.size() + this.gapsExpired.size();
        if (totalGapChanges > 0) {
            ISqlTransaction transaction = null;
            this.gaps = new ArrayList<DataGap>(this.gapsAll);
            Collections.sort(this.gaps);
            try {
                transaction = sqlTemplate.startSqlTransaction();
                int maxGapChanges = this.parameterService.getInt("routing.max.gap.changes");
                if (!this.parameterService.is("cluster.lock.enabled") && (totalGapChanges > maxGapChanges || this.useInMemoryGaps)) {
                    this.dataService.deleteAllDataGaps(transaction);
                    if (this.useInMemoryGaps && totalGapChanges <= maxGapChanges) {
                        log.info("There are {} data gap changes, which is within the max of {}, so switching to database", (Object)totalGapChanges, (Object)maxGapChanges);
                        this.useInMemoryGaps = false;
                        this.dataService.insertDataGaps(transaction, this.gaps);
                    } else {
                        if (!this.useInMemoryGaps) {
                            log.info("There are {} data gap changes, which exceeds the max of {}, so switching to in-memory", (Object)totalGapChanges, (Object)maxGapChanges);
                            this.useInMemoryGaps = true;
                        }
                        DataGap newGap = new DataGap(this.gaps.get(0).getStartId(), this.gaps.get(this.gaps.size() - 1).getEndId());
                        this.dataService.insertDataGap(transaction, newGap);
                    }
                } else {
                    this.dataService.deleteDataGaps(transaction, this.gapsDeleted);
                    this.dataService.insertDataGaps(transaction, this.gapsAdded);
                }
                this.dataService.expireDataGaps(transaction, this.gapsExpired);
                transaction.commit();
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
    }

    protected synchronized void queryDataIdMap() {
        String sql = this.routerService.getSql("selectDistinctDataIdFromDataEventUsingGapsSql");
        ISqlTemplate sqlTemplate = this.symmetricDialect.getPlatform().getSqlTemplate();
        for (DataGap dataGap : this.gaps) {
            long queryForIdsTs = System.currentTimeMillis();
            Object[] params = new Object[]{dataGap.getStartId(), dataGap.getEndId()};
            List ids = sqlTemplate.query(sql, (ISqlRowMapper)this, params);
            this.dataIds.addAll(ids);
            if (System.currentTimeMillis() - queryForIdsTs <= 30000L) continue;
            this.checkInterrupted();
            this.clusterService.refreshLock("Routing");
            log.info("It took longer than {}ms to run the following sql for gap from {} to {}.  {}", new Object[]{30000L, dataGap.getStartId(), dataGap.getEndId(), sql});
        }
    }

    protected synchronized Map<DataGap, List<Long>> getDataIdMap() {
        HashMap<DataGap, List<Long>> map = new HashMap<DataGap, List<Long>>();
        Collections.sort(this.dataIds);
        Iterator<Long> iterator = this.dataIds.iterator();
        long dataId = -1L;
        if (iterator.hasNext()) {
            dataId = iterator.next();
        }
        block0: for (DataGap gap : this.gaps) {
            List<Long> idList = map.get(gap);
            if (idList == null) {
                idList = new ArrayList<Long>();
                map.put(gap, idList);
            }
            do {
                if (dataId < gap.getStartId()) continue;
                if (dataId > gap.getEndId()) continue block0;
                idList.add(dataId);
            } while (iterator.hasNext() && (dataId = iterator.next().longValue()) != -1L);
        }
        return map;
    }

    protected void fixOverlappingGaps(List<DataGap> gapsToCheck, ProcessInfo processInfo) {
        ArrayList<DataGap> gapsCopy = new ArrayList<DataGap>(gapsToCheck);
        boolean ok = true;
        try {
            log.debug("Looking for overlapping gaps");
            try (ISqlTransaction transaction = null;){
                ISqlTemplate sqlTemplate = this.symmetricDialect.getPlatform().getSqlTemplate();
                transaction = sqlTemplate.startSqlTransaction();
                DataGap prevGap = null;
                DataGap lastGap = null;
                for (int i = 0; i < gapsCopy.size(); ++i) {
                    DataGap curGap = (DataGap)gapsCopy.get(i);
                    if (lastGap != null) {
                        ok = false;
                        log.warn("Removing gap found after last gap: " + curGap);
                        this.dataService.deleteDataGap(transaction, curGap);
                        gapsCopy.remove(i--);
                    } else {
                        if (lastGap == null && curGap.gapSize() >= this.maxDataToSelect - 1L && ((DataGap)gapsCopy.get(gapsCopy.size() - 1)).gapSize() < this.maxDataToSelect - 1L) {
                            lastGap = curGap;
                        }
                        if (prevGap != null && prevGap.overlaps(curGap)) {
                            ok = false;
                            log.warn("Removing overlapping gaps: " + prevGap + ", " + curGap);
                            this.dataService.deleteDataGap(transaction, prevGap);
                            this.dataService.deleteDataGap(transaction, curGap);
                            DataGap newGap = null;
                            newGap = curGap.equals(lastGap) ? new DataGap(prevGap.getStartId(), prevGap.getStartId() + this.maxDataToSelect - 1L) : new DataGap(prevGap.getStartId(), prevGap.getEndId() > curGap.getEndId() ? prevGap.getEndId() : curGap.getEndId());
                            log.warn("Inserting new gap to fix overlap: " + newGap);
                            this.dataService.insertDataGap(transaction, newGap);
                            gapsCopy.remove(i--);
                            gapsCopy.set(i, newGap);
                            curGap = newGap;
                        }
                    }
                    prevGap = curGap;
                }
                transaction.commit();
                if (!ok) {
                    this.printGapState();
                    log.info("Fixed gaps: " + gapsCopy);
                }
                this.gaps.clear();
                this.gaps.addAll(gapsCopy);
            }
        }
        catch (RuntimeException ex) {
            processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
            throw ex;
        }
    }

    protected void logExpiredDataGaps() {
        if (this.gapsExpired.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            for (DataGap dataGap : this.gapsExpired) {
                if (dataGap.getStartId() == dataGap.getEndId()) {
                    log.debug("Expired data gap at data_id {} create_time {}.  Skipping it because " + (this.supportsTransactionViews ? "there are no pending transactions" : "the gap expired"), (Object)dataGap.getStartId(), (Object)dataGap.getCreateTime());
                    continue;
                }
                log.debug("Expired data gap between data_id {} and {} create_time {}.  Skipping it because " + (this.supportsTransactionViews ? "there are no pending transactions" : "the gap expired"), new Object[]{dataGap.getStartId(), dataGap.getEndId(), dataGap.getCreateTime()});
            }
            return;
        }
        Date minDate = null;
        Date maxDate = null;
        long minDataId = Long.MAX_VALUE;
        long maxDataId = 0L;
        for (DataGap dataGap : this.gapsExpired) {
            if (minDate == null || dataGap.getCreateTime().before(minDate)) {
                minDate = dataGap.getCreateTime();
            }
            if (maxDate == null || dataGap.getCreateTime().after(maxDate)) {
                maxDate = dataGap.getCreateTime();
            }
            minDataId = Math.min(minDataId, dataGap.getStartId());
            maxDataId = Math.max(maxDataId, dataGap.getEndId());
        }
        log.info("Expired {} data gap(s) between data_id {} and {} and between create_time {} and {}", new Object[]{this.gapsExpired.size(), minDataId, maxDataId, minDate, maxDate});
    }

    private List<Long> getOracleNextValues() {
        if (StringUtils.isBlank((CharSequence)this.parameterService.getString("oracle.sequence.noorder.nextvalue.db.urls"))) {
            ISqlTemplate sqlTemplate = this.symmetricDialect.getPlatform().getSqlTemplate();
            try {
                return sqlTemplate.query(this.routerService.getSql("selectOracleNextValueSql"), (ISqlRowMapper)new ISqlRowMapper<Long>(){

                    public Long mapRow(Row row) {
                        return row.getLong("nextvalue");
                    }
                }, new Object[]{this.symmetricDialect.getSequenceName(SequenceIdentifier.DATA)});
            }
            catch (SqlException e) {
                log.error("Before using oracle.sequence.noorder parameter, you must 'grant select on gv$_sequences to " + this.parameterService.getString("db.user") + "' or set the oracle.sequence.noorder.nextvalue.db.urls parameter to a list of db URLs");
                throw e;
            }
        }
        return null;
    }

    protected void checkInterrupted() {
        if (Thread.interrupted()) {
            throw new RuntimeException("Thread received interrupt");
        }
    }

    public Long mapRow(Row row) {
        return row.getLong("data_id");
    }

    @Override
    public List<DataGap> getDataGaps() {
        return this.gaps;
    }

    @Override
    public DataGap getLastDataGap() {
        return this.lastGap;
    }

    @Override
    public synchronized void addDataIds(List<Long> dataIds) {
        this.dataIds.addAll(dataIds);
    }

    @Override
    public void setIsAllDataRead(boolean isAllDataRead) {
        this.isAllDataRead = isAllDataRead;
    }

    public boolean isFullGapAnalysis() {
        if (this.parameterService.is("cluster.lock.enabled")) {
            this.isFullGapAnalysis = this.contextService.is("routing.full.gap.analysis");
        }
        return this.isFullGapAnalysis;
    }

    @Override
    public void setFullGapAnalysis(boolean isFullGapAnalysis) {
        this.setFullGapAnalysis(null, isFullGapAnalysis);
    }

    @Override
    public void setFullGapAnalysis(ISqlTransaction sqlTransaction, boolean isFullGapAnalysis) {
        if (this.parameterService.is("cluster.lock.enabled")) {
            this.contextService.save(sqlTransaction, "routing.full.gap.analysis", Boolean.toString(isFullGapAnalysis));
        }
        this.isFullGapAnalysis = isFullGapAnalysis;
    }

    protected long getLastBusyExpireRunTime() {
        if (this.parameterService.is("cluster.lock.enabled")) {
            this.lastBusyExpireRunTime = this.contextService.getLong("routing.last.busy.expire.run.time");
        }
        return this.lastBusyExpireRunTime;
    }

    protected void setLastBusyExpireRunTime(long lastBusyExpireRunTime) {
        if (this.parameterService.is("cluster.lock.enabled")) {
            this.contextService.save("routing.last.busy.expire.run.time", String.valueOf(lastBusyExpireRunTime));
        }
        this.lastBusyExpireRunTime = lastBusyExpireRunTime;
    }
}

