/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.HashMap;
import java.util.Map;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.route.AbstractDataGapRouteCursor;
import org.jumpmind.symmetric.route.ChannelRouterContext;

public class DataGapRouteCursor
extends AbstractDataGapRouteCursor {
    protected static Map<String, Boolean> lastSelectUsedGreaterThanQueryByEngineName = new HashMap<String, Boolean>();
    protected String engineName;

    public DataGapRouteCursor(ChannelRouterContext context, ISymmetricEngine engine) {
        super(context, engine);
        this.engineName = this.parameterService.getEngineName();
        if (lastSelectUsedGreaterThanQueryByEngineName.get(this.engineName) == null) {
            lastSelectUsedGreaterThanQueryByEngineName.put(this.engineName, Boolean.FALSE);
        }
        this.cursor = this.prepareCursor();
    }

    protected ISqlReadCursor<Data> prepareCursor() {
        int numberOfGapsToQualify = this.parameterService.getInt("routing.max.gaps.to.qualify.in.sql", 100);
        int maxGapsBeforeGreaterThanQuery = this.parameterService.getInt("routing.data.reader.threshold.gaps.to.use.greater.than.query", 100);
        boolean useGreaterThanDataId = false;
        if (maxGapsBeforeGreaterThanQuery > 0 && this.dataGaps.size() > maxGapsBeforeGreaterThanQuery) {
            useGreaterThanDataId = true;
        }
        this.isEachGapQueried = !useGreaterThanDataId && this.dataGaps.size() <= numberOfGapsToQualify;
        String channelId = this.context.getChannel().getChannelId();
        String sql = null;
        Boolean lastSelectUsedGreaterThanQuery = lastSelectUsedGreaterThanQueryByEngineName.get(this.engineName);
        if (useGreaterThanDataId) {
            sql = this.getSql("selectDataUsingStartDataId");
            if (!lastSelectUsedGreaterThanQuery.booleanValue()) {
                this.log.info("Switching to select from the data table where data_id >= start gap because there were {} gaps found which was more than the configured threshold of {}", (Object)this.dataGaps.size(), (Object)maxGapsBeforeGreaterThanQuery);
                lastSelectUsedGreaterThanQueryByEngineName.put(this.engineName, Boolean.TRUE);
            }
        } else {
            sql = this.qualifyUsingDataGaps(this.dataGaps, numberOfGapsToQualify, this.getSql("selectDataUsingGapsSql"));
            if (lastSelectUsedGreaterThanQuery.booleanValue()) {
                this.log.info("Switching to select from the data table where data_id between gaps");
                lastSelectUsedGreaterThanQueryByEngineName.put(this.engineName, Boolean.FALSE);
            }
        }
        sql = this.qualifyForOrder(sql);
        Object[] args = null;
        int[] types = null;
        int dataIdSqlType = this.engine.getSymmetricDialect().getSqlTypeForIds();
        if (useGreaterThanDataId) {
            args = new Object[]{channelId, ((DataGap)this.dataGaps.get(0)).getStartId()};
            types = new int[]{12, dataIdSqlType};
        } else {
            int numberOfArgs = 1 + 2 * (numberOfGapsToQualify < this.dataGaps.size() ? numberOfGapsToQualify : this.dataGaps.size());
            args = new Object[numberOfArgs];
            types = new int[numberOfArgs];
            args[0] = channelId;
            types[0] = 12;
            int i = 1;
            for (int j = 0; i + 1 < numberOfArgs && j < this.dataGaps.size(); ++j) {
                DataGap gap = (DataGap)this.dataGaps.get(j);
                args[i] = gap.getStartId();
                types[i] = dataIdSqlType;
                args[i + 1] = i + 2 == numberOfArgs ? Long.valueOf(((DataGap)this.dataGaps.get(this.dataGaps.size() - 1)).getEndId()) : Long.valueOf(gap.getEndId());
                types[i + 1] = dataIdSqlType;
                i += 2;
            }
        }
        return this.executeCursor(sql, args, types);
    }
}

