/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.Map;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.service.impl.AbstractSqlMap;

public class TransformServiceSqlMap
extends AbstractSqlMap {
    public TransformServiceSqlMap(IDatabasePlatform platform, Map<String, String> replacementTokens) {
        super(platform, replacementTokens);
        this.putSql("selectTransformTable", "select                                                          transform_id, source_node_group_id, target_node_group_id,     source_catalog_name, source_schema_name,                      source_table_name,                                            target_catalog_name, target_schema_name,                      target_table_name,                                            transform_point,                                              transform_order,                                              update_first, update_action, delete_action, column_policy,    last_update_time, last_update_by, create_time                 from $(transform_table)                                     ");
        this.putSql("orderByTransformOrder", "order by transform_order asc");
        this.putSql("whereTransformIdLike", "where transform_id like ?");
        this.putSql("selectTransformColumn", "select                                              transform_id, include_on, target_column_name,     source_column_name, pk,                           transform_type, transform_expression,             transform_order,                                  last_update_time, last_update_by, create_time     from $(transform_column) order       by transform_order                                asc                                             ");
        this.putSql("selectTransformColumnForTable", "select                                              transform_id, include_on, target_column_name,     source_column_name, pk,                           transform_type, transform_expression,             transform_order,                                  last_update_time, last_update_by, create_time     from $(transform_column)             where                                             transform_id = ?                                  order by transform_order asc                    ");
        this.putSql("updateTransformTableSql", "update                         $(transform_table)     set                          source_node_group_id=?,      target_node_group_id=?,      source_catalog_name=?,       source_schema_name=?,        source_table_name=?,         target_catalog_name=?,       target_schema_name=?,        target_table_name=?,         transform_point=?,           update_first=?,              delete_action=?,             update_action=?,             transform_order=?,           column_policy=?,             last_update_time=?,          last_update_by=?             where                        transform_id=?             ");
        this.putSql("updateTransformColumnSql", "update                          $(transform_column)     set                           source_column_name=?,         pk=?,                         transform_type=?,             transform_expression=?,       transform_order=?,             last_update_time=?,          last_update_by=?             where                         transform_id=?                and include_on=?              and                           target_column_name=?        ");
        this.putSql("insertTransformTableSql", "insert into $(transform_table)                                    (source_node_group_id, target_node_group_id, source_catalog_name,     source_schema_name, source_table_name,                                target_catalog_name, target_schema_name, target_table_name,           transform_point, update_first, delete_action, update_action, transform_order,        column_policy, last_update_time, last_update_by, create_time, transform_id)                                          values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)                           ");
        this.putSql("insertTransformColumnSql", "insert into $(transform_column)                (transform_id, include_on, target_column_name,     source_column_name,                                pk, transform_type,                                transform_expression, transform_order,   last_update_time, last_update_by, create_time)             values(?,?,?,?,?,?,?,?,?,?,?)                          ");
        this.putSql("deleteTransformTableSql", "delete from $(transform_table) where     transform_id=?                             ");
        this.putSql("deleteAllTransformTablesSql", "delete from $(transform_table)");
        this.putSql("deleteTransformColumnsSql", "delete from $(transform_column) where     transform_id=?                              ");
        this.putSql("deleteAllTransformColumnsSql", "delete from $(transform_column)");
        this.putSql("deleteTransformColumnSql", "delete from $(transform_column)     where                                   transform_id=?                          and include_on=?                        and target_column_name=?              ");
        this.putSql("selectMaxTransformTableLastUpdateTime", "select max(last_update_time) from $(transform_table) where last_update_time is not null");
        this.putSql("selectMaxTransformColumnLastUpdateTime", "select max(last_update_time) from $(transform_column) where last_update_time is not null");
        this.putSql("updateTransformIdSql", "update $(transform_column) set transform_id=? where transform_id=?");
    }
}

