/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.cache.ICacheManager;
import org.jumpmind.symmetric.cache.TriggerRouterRoutersCache;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.config.ITableResolver;
import org.jumpmind.symmetric.config.ITriggerCreationListener;
import org.jumpmind.symmetric.config.TriggerFailureListener;
import org.jumpmind.symmetric.config.TriggerSelector;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerReBuildReason;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IGroupletService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ISequenceService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.TriggerRouterContext;
import org.jumpmind.symmetric.service.impl.TriggerRouterServiceSqlMap;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.util.ExceptionUtils;
import org.jumpmind.util.FormatUtils;
import org.slf4j.MDC;

public class TriggerRouterService
extends AbstractService
implements ITriggerRouterService {
    private IClusterService clusterService;
    private IConfigurationService configurationService;
    private ISequenceService sequenceService;
    private IExtensionService extensionService;
    private IParameterService parameterService;
    private TriggerFailureListener failureListener = new TriggerFailureListener();
    private IStatisticManager statisticManager;
    private IGroupletService groupletService;
    private INodeService nodeService;
    private Date lastUpdateTime;
    private ICacheManager cacheManager;
    private Map<Integer, TriggerHistory> historyMap = Collections.synchronizedMap(new HashMap());

    public TriggerRouterService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.cacheManager = engine.getCacheManager();
        this.clusterService = engine.getClusterService();
        this.configurationService = engine.getConfigurationService();
        this.statisticManager = engine.getStatisticManager();
        this.groupletService = engine.getGroupletService();
        this.nodeService = engine.getNodeService();
        this.sequenceService = engine.getSequenceService();
        this.extensionService = engine.getExtensionService();
        this.parameterService = engine.getParameterService();
        engine.getExtensionService().addExtensionPoint(this.failureListener);
        this.setSqlMap(new TriggerRouterServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    @Override
    public boolean refreshFromDatabase() {
        Date date3;
        Date date2;
        Date date1 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxTriggerLastUpdateTime"), Date.class, new Object[0]);
        Date date = this.maxDate(date1, date2 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxRouterLastUpdateTime"), Date.class, new Object[0]), date3 = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxTriggerRouterLastUpdateTime"), Date.class, new Object[0]));
        if (date != null && (this.lastUpdateTime == null || this.lastUpdateTime.before(date))) {
            if (this.lastUpdateTime != null) {
                this.log.info("Newer trigger router settings were detected");
            }
            this.lastUpdateTime = date;
            this.clearCache();
            return true;
        }
        return false;
    }

    @Override
    public List<Trigger> getTriggers() {
        return this.getTriggers(true);
    }

    @Override
    public List<Trigger> getTriggers(boolean replaceTokens) {
        List triggers = this.sqlTemplate.query(this.getSql("selectTriggersSql"), (ISqlRowMapper)new TriggerMapper(), new Object[0]);
        if (replaceTokens) {
            TypedProperties replacements = this.parameterService.getAllParameters();
            for (Trigger trigger : triggers) {
                trigger.setSourceCatalogName(FormatUtils.replaceTokens((String)trigger.getSourceCatalogName(), (Map)replacements, (boolean)true));
                trigger.setSourceSchemaName(FormatUtils.replaceTokens((String)trigger.getSourceSchemaName(), (Map)replacements, (boolean)true));
                trigger.setSourceTableName(FormatUtils.replaceTokens((String)trigger.getSourceTableName(), (Map)replacements, (boolean)true));
            }
        }
        return triggers;
    }

    @Override
    public boolean isTriggerBeingUsed(String triggerId) {
        return this.sqlTemplate.queryForInt(this.getSql("countTriggerRoutersByTriggerIdSql"), new Object[]{triggerId}) > 0;
    }

    @Override
    public boolean doesTriggerExist(String triggerId) {
        return this.sqlTemplate.queryForInt(this.getSql("countTriggerByTriggerIdSql"), new Object[]{triggerId}) > 0;
    }

    @Override
    public boolean doesTriggerExistForTable(String tableName) {
        if (tableName.toLowerCase().startsWith(this.symmetricDialect.getTablePrefix().toLowerCase())) {
            return this.doesTriggerExistForTable(tableName, true);
        }
        return this.doesTriggerExistForTable(tableName, false);
    }

    public boolean doesTriggerExistForTable(String tableName, boolean useTriggerHist) {
        if (useTriggerHist) {
            return this.sqlTemplate.queryForInt(this.getSql("countTriggerByTableNameFromTriggerHistSql"), new Object[]{tableName, tableName.toLowerCase(), tableName.toUpperCase()}) > 0;
        }
        return this.sqlTemplate.queryForInt(this.getSql("countTriggerByTableNameSql"), new Object[]{tableName, tableName.toLowerCase(), tableName.toUpperCase()}) > 0;
    }

    @Override
    public void deleteTrigger(Trigger trigger) {
        this.deleteTrigger(trigger.getTriggerId());
    }

    private void deleteTrigger(String id) {
        this.sqlTemplate.update(this.getSql("deleteTriggerSql"), new Object[]{id});
    }

    @Override
    public void deleteTriggers(Collection<Trigger> triggers) {
        List<TriggerRouter> triggerRouters = this.getTriggerRouters(true);
        ArrayList<TriggerRouter> triggerRoutersToDelete = new ArrayList<TriggerRouter>();
        for (TriggerRouter triggerRouter : triggerRouters) {
            if (!triggers.contains(triggerRouter.getTrigger())) continue;
            triggerRoutersToDelete.add(triggerRouter);
        }
        ISqlTransaction transaction = null;
        try {
            int maxRowsToFlush = this.parameterService.getInt("data.flush.jdbc.batch.size");
            transaction = this.sqlTemplate.startSqlTransaction();
            this.deleteTriggerRouters(transaction, triggerRoutersToDelete);
            transaction.prepare(this.getSql("deleteTriggerSql"));
            int[] types = new int[]{12};
            int rowCount = 0;
            for (Trigger trigger : triggers) {
                transaction.addRow(null, new Object[]{trigger.getTriggerId()}, types);
                if (++rowCount <= maxRowsToFlush) continue;
                transaction.flush();
            }
            transaction.commit();
        }
        catch (Exception e) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.close(transaction);
                throw throwable;
            }
        }
        this.close(transaction);
        this.clearCache();
    }

    @Override
    public void deleteAllTriggers() {
        this.sqlTemplate.update(this.getSql("deleteAllTriggersSql"), new Object[0]);
        this.clearCache();
    }

    @Override
    public void dropTriggers() {
        this.dropTriggers(false);
    }

    @Override
    public void dropTriggers(boolean includeSymTriggers) {
        TriggerRouterContext triggerRouterContext = new TriggerRouterContext();
        long ts = System.currentTimeMillis();
        List<TriggerHistory> activeHistories = this.getActiveTriggerHistories();
        triggerRouterContext.incrementActiveTriggerHistoriesTime(System.currentTimeMillis() - ts);
        Set<String> symTables = TableConstants.getTables(this.symmetricDialect.getTablePrefix());
        for (TriggerHistory history : activeHistories) {
            if (!includeSymTriggers && symTables.contains(history.getSourceTableName())) continue;
            this.dropTriggers(history, null, triggerRouterContext);
        }
        this.logTriggerRouterContextTimings(triggerRouterContext);
    }

    @Override
    public void dropTriggers(Set<String> tables) {
        TriggerRouterContext triggerRouterContext = new TriggerRouterContext();
        List<TriggerHistory> activeHistories = null;
        for (String table : tables) {
            if (!this.doesTriggerExistForTable(table)) continue;
            long ts = System.currentTimeMillis();
            activeHistories = this.getActiveTriggerHistories(table);
            triggerRouterContext.incrementActiveTriggerHistoriesTime(System.currentTimeMillis() - ts);
            for (TriggerHistory history : activeHistories) {
                this.dropTriggers(history, null, triggerRouterContext);
            }
        }
        this.logTriggerRouterContextTimings(triggerRouterContext);
    }

    protected void deleteTriggerHistory(TriggerHistory history) {
        this.sqlTemplate.update(this.getSql("deleteTriggerHistorySql"), new Object[]{history.getTriggerHistoryId()});
    }

    @Override
    public void createTriggersOnChannelForTables(String channelId, String catalogName, String schemaName, List<String> tables, String lastUpdateBy) {
        ArrayList<Trigger> createdTriggers = new ArrayList<Trigger>();
        List<Trigger> existingTriggers = this.getTriggers();
        for (String table : tables) {
            Trigger trigger = new Trigger();
            trigger.setChannelId(channelId);
            trigger.setSourceCatalogName(catalogName);
            trigger.setSourceSchemaName(schemaName);
            trigger.setSourceTableName(table);
            Object triggerId = table;
            if (table.length() > 50) {
                triggerId = table.substring(0, 13) + "_" + UUID.randomUUID().toString();
            }
            boolean uniqueNameCreated = false;
            int suffix = 0;
            while (!uniqueNameCreated) {
                String triggerIdPriorToCheck = triggerId;
                for (Trigger existingTrigger : existingTriggers) {
                    if (!((String)triggerId).equals(existingTrigger.getTriggerId())) continue;
                    String suffixString = "_" + suffix;
                    triggerId = suffix == 0 ? (String)triggerId + suffixString : ((String)triggerId).substring(0, ((String)triggerId).length() - ("_" + (suffix - 1)).length()) + suffixString;
                    ++suffix;
                }
                if (!((String)triggerId).equals(triggerIdPriorToCheck)) continue;
                uniqueNameCreated = true;
            }
            trigger.setTriggerId((String)triggerId);
            trigger.setLastUpdateBy(lastUpdateBy);
            trigger.setLastUpdateTime(new Date());
            trigger.setCreateTime(new Date());
            this.saveTrigger(trigger);
            createdTriggers.add(trigger);
        }
    }

    @Override
    public Collection<Trigger> findMatchingTriggers(List<Trigger> triggers, String catalog, String schema, String table) {
        HashSet<Trigger> matches = new HashSet<Trigger>();
        IDatabasePlatform targetPlatform = this.getTargetPlatform(table);
        boolean isTargetCatalog = StringUtils.isNotBlank((CharSequence)catalog) && catalog.equals(targetPlatform.getDefaultCatalog());
        boolean isTargetSchema = StringUtils.isNotBlank((CharSequence)schema) && schema.equals(targetPlatform.getDefaultSchema());
        for (Trigger trigger : triggers) {
            boolean tableMatches;
            boolean catalogMatches = trigger.isSourceCatalogNameWildCarded() || catalog == null && trigger.getSourceCatalogName() == null || StringUtils.isBlank((CharSequence)trigger.getSourceCatalogName()) && isTargetCatalog || StringUtils.isNotBlank((CharSequence)catalog) && catalog.equals(trigger.getSourceCatalogName());
            boolean schemaMatches = trigger.isSourceSchemaNameWildCarded() || schema == null && trigger.getSourceSchemaName() == null || StringUtils.isBlank((CharSequence)trigger.getSourceSchemaName()) && isTargetSchema || StringUtils.isNotBlank((CharSequence)schema) && schema.equals(trigger.getSourceSchemaName());
            boolean bl = tableMatches = trigger.isSourceTableNameWildCarded() || table.equalsIgnoreCase(trigger.getSourceTableName());
            if (!catalogMatches || !schemaMatches || !tableMatches) continue;
            matches.add(trigger);
        }
        return matches;
    }

    protected void invalidateTriggerHistory(TriggerHistory history, Exception ex) {
        if (history != null && history.getInactiveTime() == null) {
            this.log.info("Cleaning up trigger hist row of {} after failing to create trigger for {}", (Object)history.getTriggerHistoryId(), (Object)history.getFullyQualifiedSourceTableName());
            history.setErrorMessage(ex.getMessage());
            this.inactivateTriggerHistory(history);
        }
    }

    @Override
    public void inactivateTriggerHistory(TriggerHistory history) {
        history.setInactiveTime(new Date());
        this.sqlTemplate.update(this.getSql("inactivateTriggerHistorySql"), new Object[]{history.getInactiveTime(), history.getErrorMessage(), history.getTriggerHistoryId()}, new int[]{93, 12, 4});
    }

    @Override
    public Map<Long, TriggerHistory> getHistoryRecords() {
        HashMap<Long, TriggerHistory> retMap = new HashMap<Long, TriggerHistory>();
        this.sqlTemplate.query(this.getSql("allTriggerHistSql"), (ISqlRowMapper)new TriggerHistoryMapper(retMap), new Object[0]);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTriggerNameInUse(List<TriggerHistory> activeTriggerHistories, Trigger trigger, String triggerName, TriggerHistory oldhist, List<String> triggerNamesGeneratedThisSession) {
        List<TriggerHistory> list = activeTriggerHistories;
        synchronized (list) {
            for (TriggerHistory triggerHistory : activeTriggerHistories) {
                if (triggerHistory.getTriggerId().equals(trigger.getTriggerId()) && (!trigger.isSourceTableNameWildCarded() && !trigger.isSourceCatalogNameWildCarded() && !trigger.isSourceSchemaNameWildCarded() && !trigger.isSourceTableNameExpanded() || oldhist != null && triggerHistory.getTriggerHistoryId() == oldhist.getTriggerHistoryId()) || !(triggerHistory.getNameForDeleteTrigger() != null && triggerHistory.getNameForDeleteTrigger().equals(triggerName) || triggerHistory.getNameForInsertTrigger() != null && triggerHistory.getNameForInsertTrigger().equals(triggerName)) && (triggerHistory.getNameForUpdateTrigger() == null || !triggerHistory.getNameForUpdateTrigger().equals(triggerName))) continue;
                return true;
            }
        }
        return triggerNamesGeneratedThisSession.contains(triggerName);
    }

    @Override
    public TriggerHistory findTriggerHistory(String catalogName, String schemaName, String tableName) {
        List<TriggerHistory> list = this.findTriggerHistories(catalogName, schemaName, tableName);
        return list.size() > 0 ? list.get(0) : null;
    }

    @Override
    public List<TriggerHistory> findTriggerHistories(String catalogName, String schemaName, String tableName) {
        ArrayList<TriggerHistory> listToReturn = new ArrayList<TriggerHistory>();
        List<TriggerHistory> triggerHistories = this.getActiveTriggerHistories();
        if (triggerHistories != null && triggerHistories.size() > 0) {
            for (TriggerHistory triggerHistory : triggerHistories) {
                boolean matches = true;
                if (StringUtils.isNotBlank((CharSequence)catalogName)) {
                    matches = catalogName.equals(StringUtils.isNotBlank((CharSequence)triggerHistory.getSourceCatalogName()) ? triggerHistory.getSourceCatalogName() : this.platform.getDefaultCatalog());
                }
                if (matches && StringUtils.isNotBlank((CharSequence)schemaName)) {
                    matches = schemaName.equals(StringUtils.isNotBlank((CharSequence)triggerHistory.getSourceSchemaName()) ? triggerHistory.getSourceSchemaName() : this.platform.getDefaultSchema());
                }
                if (matches && StringUtils.isNotBlank((CharSequence)tableName)) {
                    boolean ignoreCase = this.parameterService.is("db.metadata.ignore.case") && !FormatUtils.isMixedCase((String)tableName);
                    boolean bl = matches = ignoreCase ? triggerHistory.getSourceTableName().equalsIgnoreCase(tableName) : triggerHistory.getSourceTableName().equals(tableName);
                }
                if (!matches) continue;
                listToReturn.add(triggerHistory);
            }
        }
        return listToReturn;
    }

    @Override
    public TriggerHistory getTriggerHistory(int histId) {
        TriggerHistory history = this.historyMap.get(histId);
        if (history == null && histId >= 0 && (history = (TriggerHistory)this.sqlTemplate.queryForObject(this.getSql("triggerHistSql"), (ISqlRowMapper)new TriggerHistoryMapper(), new Object[]{histId})) != null) {
            this.historyMap.put(histId, history);
        }
        return history;
    }

    @Override
    public List<TriggerHistory> getActiveTriggerHistories(Trigger trigger) {
        List active = this.sqlTemplate.query(this.getSql("allTriggerHistSql", "activeTriggerHistSqlByTriggerId"), (ISqlRowMapper)new TriggerHistoryMapper(), new Object[]{trigger.getTriggerId()});
        for (TriggerHistory triggerHistory : active) {
            this.historyMap.put(triggerHistory.getTriggerHistoryId(), triggerHistory);
        }
        return active;
    }

    @Override
    public TriggerHistory getNewestTriggerHistoryForTrigger(List<TriggerHistory> activeTriggerHistories, String triggerId, String catalogName, String schemaName, String tableName) {
        for (TriggerHistory triggerHistory : activeTriggerHistories) {
            if ((!StringUtils.isBlank((CharSequence)catalogName) || !StringUtils.isBlank((CharSequence)triggerHistory.getSourceCatalogName())) && (!StringUtils.isNotBlank((CharSequence)catalogName) || !catalogName.equals(triggerHistory.getSourceCatalogName())) || (!StringUtils.isBlank((CharSequence)schemaName) || !StringUtils.isBlank((CharSequence)triggerHistory.getSourceSchemaName())) && (!StringUtils.isNotBlank((CharSequence)schemaName) || !schemaName.equals(triggerHistory.getSourceSchemaName())) || (!StringUtils.isBlank((CharSequence)tableName) || !StringUtils.isBlank((CharSequence)triggerHistory.getSourceTableName())) && (!StringUtils.isNotBlank((CharSequence)tableName) || !tableName.equals(triggerHistory.getSourceTableName())) || !StringUtils.isNotBlank((CharSequence)triggerId) || !triggerId.equals(triggerHistory.getTriggerId())) continue;
            return triggerHistory;
        }
        return null;
    }

    @Override
    public TriggerHistory getNewestTriggerHistoryForTrigger(String triggerId, String catalogName, String schemaName, String tableName) {
        List triggerHistories = this.sqlTemplate.query(this.getSql("latestTriggerHistSql"), (ISqlRowMapper)new TriggerHistoryMapper(), new Object[]{triggerId, tableName});
        return this.getNewestTriggerHistoryForTrigger(triggerHistories, triggerId, catalogName, schemaName, tableName);
    }

    @Override
    public List<TriggerHistory> getActiveTriggerHistoriesFromCache() {
        return new ArrayList<TriggerHistory>(this.historyMap != null ? this.historyMap.values() : Collections.EMPTY_LIST);
    }

    @Override
    public List<TriggerHistory> getActiveTriggerHistories() {
        String sqlKey = "allTriggerHistSql";
        if (!this.parameterService.hasDatabaseBeenSetup()) {
            sqlKey = "allTriggerHistBackwardsCompatibleSql";
        }
        List histories = this.sqlTemplate.query(this.getSql(sqlKey, "activeTriggerHistSql"), (ISqlRowMapper)new TriggerHistoryMapper(), new Object[0]);
        for (TriggerHistory triggerHistory : histories) {
            this.historyMap.put(triggerHistory.getTriggerHistoryId(), triggerHistory);
        }
        return histories;
    }

    @Override
    public Map<String, TriggerHistory> getLastErrorTriggerHistories() {
        HashMap<String, TriggerHistory> map = new HashMap<String, TriggerHistory>();
        this.sqlTemplate.query(this.getSql("allTriggerHistSql", "errorTriggerHistSql"), (ISqlRowMapper)new LastTriggerHistoryMapper((Map<String, TriggerHistory>)map), new Object[0]);
        return map;
    }

    @Override
    public List<TriggerHistory> getActiveTriggerHistories(String tableName) {
        if (tableName != null) {
            String sqlKey = "allTriggerHistSql";
            if (!this.parameterService.hasDatabaseBeenSetup()) {
                sqlKey = "allTriggerHistBackwardsCompatibleSql";
            }
            return this.sqlTemplate.query(this.getSql(sqlKey, "triggerHistBySourceTableWhereSql"), (ISqlRowMapper)new TriggerHistoryMapper(), new Object[]{tableName, tableName.toLowerCase(), tableName.toUpperCase()});
        }
        return new ArrayList<TriggerHistory>();
    }

    @Override
    public List<Trigger> buildTriggersForSymmetricTables(String version, String ... tablesToExclude) {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        ArrayList<String> tables = new ArrayList<String>(TableConstants.getConfigTables(this.symmetricDialect.getTablePrefix()));
        List<Trigger> definedTriggers = this.getTriggers();
        for (Trigger trigger : definedTriggers) {
            if (!tables.remove(trigger.getSourceTableName())) continue;
            this.logOnce(String.format("Not generating virtual triggers for %s because there is a user defined trigger already defined", trigger.getSourceTableName()));
        }
        if (tablesToExclude != null) {
            for (String tableToExclude : tablesToExclude) {
                String tablename = TableConstants.getTableName(this.tablePrefix, tableToExclude);
                if (tables.remove(tablename) || tables.remove(tablename.toUpperCase())) continue;
                tables.remove(tablename.toLowerCase());
            }
        }
        Set<String> configTablesWithoutCapture = TableConstants.getConfigTablesWithoutCapture(this.symmetricDialect.getTablePrefix());
        for (String tableName : tables) {
            Trigger trigger = this.buildTriggerForSymmetricTable(tableName, configTablesWithoutCapture);
            triggers.add(trigger);
        }
        return triggers;
    }

    protected Trigger buildTriggerForSymmetricTable(String tableName, Set<String> configTablesWithoutCapture) {
        boolean syncChanges = !configTablesWithoutCapture.contains(tableName) && (this.parameterService.is("auto.sync.configuration") || TableConstants.getTableName(this.tablePrefix, "node_host").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "node").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "monitor_event").equals(tableName));
        boolean syncOnIncoming = !(this.configurationService.isMasterToMaster() && !this.nodeService.isRegistrationServer() || !this.parameterService.is("auto.sync.configuration.on.incoming", true) && !tableName.equals(TableConstants.getTableName(this.tablePrefix, "table_reload_request")));
        Trigger trigger = new Trigger();
        trigger.setUseHandleKeyUpdates(false);
        trigger.setTriggerId(tableName);
        trigger.setSyncOnDelete(syncChanges);
        trigger.setSyncOnInsert(syncChanges);
        trigger.setSyncOnUpdate(syncChanges);
        trigger.setSyncOnIncomingBatch(syncOnIncoming);
        trigger.setSourceTableName(tableName);
        trigger.setUseCaptureOldData(false);
        if (TableConstants.getTableName(this.tablePrefix, "node_host").equals(tableName)) {
            trigger.setChannelId("heartbeat");
        } else if (TableConstants.getTableName(this.tablePrefix, "monitor_event").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "table_reload_request").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "table_reload_status").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "extract_request").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "compare_request").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "compare_status").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "compare_table_status").equals(tableName)) {
            trigger.setChannelId("monitor");
            trigger.setUseCaptureOldData(true);
        } else if (TableConstants.getTableName(this.tablePrefix, "file_snapshot").equals(tableName)) {
            trigger.setChannelId("dynamic");
            trigger.setChannelExpression("$(curTriggerValue).$(curColumnPrefix)" + this.platform.alterCaseToMatchDatabaseDefaultCase("channel_id"));
            trigger.setReloadChannelId("filesync_reload");
            trigger.setUseCaptureOldData(true);
            trigger.setSyncOnIncomingBatch(false);
            boolean syncEnabled = this.parameterService.is("file.sync.enable");
            trigger.setSyncOnInsert(syncEnabled);
            trigger.setSyncOnUpdate(syncEnabled);
            trigger.setSyncOnDelete(false);
        } else if (TableConstants.getTableName(this.tablePrefix, "node").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "node_security").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "incoming_error").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "outgoing_error").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "console_user").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "console_user_hist").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "console_role").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "console_role_privilege").equals(tableName)) {
            trigger.setChannelId("system");
        } else {
            trigger.setChannelId("config");
        }
        if (TableConstants.getTableName(this.tablePrefix, "monitor_event").equals(tableName) && !this.parameterService.is("monitor.events.capture.enabled")) {
            trigger.setSyncOnInsert(false);
            trigger.setSyncOnUpdate(false);
            trigger.setSyncOnDelete(false);
        }
        if (!(TableConstants.getTableName(this.tablePrefix, "node_host").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "node").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "node_security").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "table_reload_request").equals(tableName) || TableConstants.getTableName(this.tablePrefix, "file_snapshot").equals(tableName))) {
            trigger.setUseCaptureLobs(true);
        }
        trigger.setLastUpdateTime(new Date(Version.version().hashCode()));
        return trigger;
    }

    @Override
    public List<TriggerRouter> buildTriggerRoutersForSymmetricTables(String version, NodeGroupLink nodeGroupLink, String ... tablesToExclude) {
        int initialLoadOrder = 1;
        List<Trigger> triggers = this.buildTriggersForSymmetricTables(version, tablesToExclude);
        ArrayList<TriggerRouter> triggerRouters = new ArrayList<TriggerRouter>(triggers.size());
        for (int j = 0; j < triggers.size(); ++j) {
            Trigger trigger = triggers.get(j);
            TriggerRouter triggerRouter = this.buildTriggerRoutersForSymmetricTables(version, trigger, nodeGroupLink);
            triggerRouter.setInitialLoadOrder(initialLoadOrder++);
            triggerRouters.add(triggerRouter);
        }
        return triggerRouters;
    }

    @Override
    public String buildSymmetricTableRouterId(String triggerId, String sourceNodeGroupId, String targetNodeGroupId) {
        return String.format("%s_%s_2_%s", triggerId, sourceNodeGroupId, targetNodeGroupId);
    }

    protected TriggerRouter buildTriggerRoutersForSymmetricTables(String version, Trigger trigger, NodeGroupLink nodeGroupLink) {
        TriggerRouter triggerRouter = new TriggerRouter();
        triggerRouter.setTrigger(trigger);
        Router router = triggerRouter.getRouter();
        router.setRouterId(this.buildSymmetricTableRouterId(trigger.getTriggerId(), nodeGroupLink.getSourceNodeGroupId(), nodeGroupLink.getTargetNodeGroupId()));
        if (TableConstants.getTableName(this.tablePrefix, "file_snapshot").equals(trigger.getSourceTableName())) {
            router.setRouterType("filesync");
        } else {
            router.setRouterType("configurationChanged");
        }
        router.setNodeGroupLink(nodeGroupLink);
        router.setLastUpdateTime(trigger.getLastUpdateTime());
        triggerRouter.setLastUpdateTime(trigger.getLastUpdateTime());
        return triggerRouter;
    }

    @Override
    public Set<TriggerRouter> getTriggerRouterForTableForCurrentNode(String catalogName, String schemaName, String tableName, boolean refreshCache) {
        return this.getTriggerRouterForTableForCurrentNode(null, catalogName, schemaName, tableName, refreshCache);
    }

    @Override
    public Set<TriggerRouter> getTriggerRouterForTableForCurrentNode(NodeGroupLink link, String catalogName, String schemaName, String tableName, boolean refreshCache) {
        TriggerRouterRoutersCache cache = this.getTriggerRoutersCacheForCurrentNode(refreshCache);
        Collection<List<TriggerRouter>> triggerRouters = cache.triggerRoutersByTriggerId.values();
        HashSet<TriggerRouter> returnList = new HashSet<TriggerRouter>();
        for (List<TriggerRouter> list : triggerRouters) {
            for (TriggerRouter triggerRouter : list) {
                if (!this.isMatch(link, triggerRouter) || !this.isMatch(catalogName, schemaName, tableName, triggerRouter.getTrigger())) continue;
                returnList.add(triggerRouter);
            }
        }
        return returnList;
    }

    protected boolean isMatch(NodeGroupLink link, TriggerRouter router) {
        if (link != null && router != null && router.getRouter() != null) {
            return link.getSourceNodeGroupId().equals(router.getRouter().getNodeGroupLink().getSourceNodeGroupId()) && link.getTargetNodeGroupId().equals(router.getRouter().getNodeGroupLink().getTargetNodeGroupId());
        }
        return true;
    }

    protected boolean isMatch(String catalogName, String schemaName, String tableName, Trigger trigger) {
        if (!StringUtils.isBlank((CharSequence)tableName) && !tableName.equals(trigger.getSourceTableName())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)tableName) && !StringUtils.isBlank((CharSequence)trigger.getSourceTableName())) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)catalogName) && !catalogName.equals(trigger.getSourceCatalogName())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)catalogName) && !StringUtils.isBlank((CharSequence)trigger.getSourceCatalogName())) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)schemaName) && !schemaName.equals(trigger.getSourceSchemaName())) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)schemaName) || StringUtils.isBlank((CharSequence)trigger.getSourceSchemaName());
    }

    protected List<TriggerRouter> getConfigurationTablesTriggerRoutersForCurrentNode(String sourceNodeGroupId) {
        ArrayList<TriggerRouter> triggerRouters = new ArrayList<TriggerRouter>();
        List<NodeGroupLink> links = this.configurationService.getNodeGroupLinksFor(sourceNodeGroupId, false);
        for (NodeGroupLink nodeGroupLink : links) {
            triggerRouters.addAll(this.buildTriggerRoutersForSymmetricTables(Version.version(), nodeGroupLink, new String[0]));
        }
        if (triggerRouters.size() == 0 && this.parameterService.is("sync.triggers.reg.svr.install.without.config", true) && this.parameterService.isRegistrationServer()) {
            NodeGroupLink link = new NodeGroupLink(sourceNodeGroupId, "nogroup");
            triggerRouters.addAll(this.buildTriggerRoutersForSymmetricTables(Version.version(), link, new String[0]));
        }
        return triggerRouters;
    }

    protected void mergeInConfigurationTablesTriggerRoutersForCurrentNode(String sourceNodeGroupId, List<TriggerRouter> configuredInDatabase) {
        List<TriggerRouter> virtualConfigTriggers = this.getConfigurationTablesTriggerRoutersForCurrentNode(sourceNodeGroupId);
        for (TriggerRouter trigger : virtualConfigTriggers) {
            if (!trigger.getRouter().getNodeGroupLink().getSourceNodeGroupId().equalsIgnoreCase(sourceNodeGroupId) || this.doesTriggerRouterExistInList(configuredInDatabase, trigger)) continue;
            configuredInDatabase.add(trigger);
        }
    }

    protected boolean doesTriggerRouterExistInList(List<TriggerRouter> triggerRouters, TriggerRouter triggerRouter) {
        for (TriggerRouter checkMe : triggerRouters) {
            if (!checkMe.isSame(triggerRouter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TriggerRouter getTriggerRouterForCurrentNode(String triggerId, String routerId, boolean refreshCache) {
        TriggerRouter triggerRouter = null;
        List<TriggerRouter> triggerRouters = this.getTriggerRoutersForCurrentNode(refreshCache).get(triggerId);
        if (triggerRouters != null) {
            for (TriggerRouter testTriggerRouter : triggerRouters) {
                if (!"configurationChanged".equals(testTriggerRouter.getRouter().getRouterType()) && !testTriggerRouter.getRouter().getRouterId().equals(routerId) && !routerId.equals("?")) continue;
                triggerRouter = testTriggerRouter;
                break;
            }
        }
        if (triggerRouter == null) {
            this.log.warn("Could not find trigger router [{}:{}] in list {}", new Object[]{triggerId, routerId, triggerRouters == null ? Integer.valueOf(0) : triggerRouters.toString()});
        }
        return triggerRouter;
    }

    @Override
    public Map<String, List<TriggerRouter>> getTriggerRoutersForCurrentNode(boolean refreshCache) {
        return this.getTriggerRoutersCacheForCurrentNode((boolean)refreshCache).triggerRoutersByTriggerId;
    }

    @Override
    public List<Trigger> getTriggersForCurrentNode(boolean refreshCache) {
        Map<String, List<TriggerRouter>> triggerRouters = this.getTriggerRoutersForCurrentNode(refreshCache);
        ArrayList<Trigger> triggers = new ArrayList<Trigger>(triggerRouters.size());
        for (List<TriggerRouter> list : triggerRouters.values()) {
            if (list.size() <= 0) continue;
            triggers.add(list.get(0).getTrigger());
        }
        return triggers;
    }

    @Override
    public TriggerRouter getTriggerRouterByTriggerHist(String targetNodeGroupId, int triggerHistId, boolean refreshCache) {
        TriggerRouter triggerRouter = null;
        TriggerHistory hist = this.getTriggerHistory(triggerHistId);
        if (hist != null) {
            Map<String, List<TriggerRouter>> triggerRouters = this.getTriggerRoutersForCurrentNode(refreshCache);
            block0: for (List<TriggerRouter> list : triggerRouters.values()) {
                for (TriggerRouter curTriggerRouter : list) {
                    if (!curTriggerRouter.getTriggerId().equals(hist.getTriggerId()) || !curTriggerRouter.getRouter().getNodeGroupLink().getTargetNodeGroupId().equals(targetNodeGroupId)) continue;
                    triggerRouter = curTriggerRouter;
                    continue block0;
                }
            }
        }
        return triggerRouter;
    }

    @Override
    public Map<Integer, TriggerRouter> getTriggerRoutersByTriggerHist(String targetNodeGroupId, boolean refreshCache) {
        return this.cacheManager.getTriggerRoutersByTriggerHist(refreshCache).get(targetNodeGroupId);
    }

    @Override
    public Map<String, Map<Integer, TriggerRouter>> getTriggerRoutersByTriggerHistFromDatabase() {
        HashMap<String, Map<Integer, TriggerRouter>> cache = new HashMap<String, Map<Integer, TriggerRouter>>();
        Map<String, List<TriggerRouter>> triggerRouters = this.getTriggerRoutersForCurrentNode(true);
        HashMap<String, TriggerHistory> triggerHistoryByTrigger = new HashMap<String, TriggerHistory>();
        for (TriggerHistory triggerHistory : this.getActiveTriggerHistories()) {
            triggerHistoryByTrigger.put(triggerHistory.getTriggerId(), triggerHistory);
        }
        for (List list : triggerRouters.values()) {
            for (TriggerRouter triggerRouter : list) {
                TriggerHistory hist;
                String groupId = triggerRouter.getRouter().getNodeGroupLink().getTargetNodeGroupId();
                HashMap<Integer, TriggerRouter> map = (HashMap<Integer, TriggerRouter>)cache.get(groupId);
                if (map == null) {
                    map = new HashMap<Integer, TriggerRouter>();
                    cache.put(groupId, map);
                }
                if ((hist = (TriggerHistory)triggerHistoryByTrigger.get(triggerRouter.getTriggerId())) == null) continue;
                map.put(hist.getTriggerHistoryId(), triggerRouter);
            }
        }
        return cache;
    }

    protected TriggerRouterRoutersCache getTriggerRoutersCacheForCurrentNode(boolean refreshCache) {
        String myNodeGroupId = this.parameterService.getNodeGroupId();
        return this.cacheManager.getTriggerRoutersByNodeGroupId(refreshCache).get(myNodeGroupId);
    }

    @Override
    public Map<String, TriggerRouterRoutersCache> getTriggerRoutersCacheByNodeGroupIdFromDatabase() {
        String myNodeGroupId = this.parameterService.getNodeGroupId();
        HashMap<String, TriggerRouterRoutersCache> newTriggerRouterCacheByNodeGroupId = new HashMap<String, TriggerRouterRoutersCache>();
        List<TriggerRouter> triggerRouters = this.getAllTriggerRoutersForCurrentNode(myNodeGroupId);
        HashMap<String, List<TriggerRouter>> triggerRoutersByTriggerId = new HashMap<String, List<TriggerRouter>>(triggerRouters.size());
        HashMap<String, Router> routers = new HashMap<String, Router>(triggerRouters.size());
        for (TriggerRouter triggerRouter : triggerRouters) {
            boolean sourceEnabled;
            if (!triggerRouter.isEnabled() || !(sourceEnabled = this.groupletService.isSourceEnabled(triggerRouter))) continue;
            String triggerId = triggerRouter.getTrigger().getTriggerId();
            ArrayList<TriggerRouter> list = (ArrayList<TriggerRouter>)triggerRoutersByTriggerId.get(triggerId);
            if (list == null) {
                list = new ArrayList<TriggerRouter>();
                triggerRoutersByTriggerId.put(triggerId, list);
            }
            list.add(triggerRouter);
            routers.put(triggerRouter.getRouter().getRouterId(), triggerRouter.getRouter());
        }
        newTriggerRouterCacheByNodeGroupId.put(myNodeGroupId, new TriggerRouterRoutersCache(triggerRoutersByTriggerId, routers));
        return newTriggerRouterCacheByNodeGroupId;
    }

    @Override
    public Router getActiveRouterByIdForCurrentNode(String routerId, boolean refreshCache) {
        return this.getTriggerRoutersCacheForCurrentNode((boolean)refreshCache).routersByRouterId.get(routerId);
    }

    @Override
    public List<Router> getRoutersByGroupLink(NodeGroupLink link) {
        return this.sqlTemplate.query(this.getSql("select", "selectRoutersColumnList", "selectRouterByNodeGroupLinkWhereSql"), (ISqlRowMapper)new RouterMapper(this.configurationService.getNodeGroupLinks(false)), new Object[]{link.getSourceNodeGroupId(), link.getTargetNodeGroupId()});
    }

    @Override
    public Trigger getTriggerForCurrentNodeById(String triggerId) {
        List<Trigger> triggers = this.getTriggersForCurrentNode();
        for (Trigger trigger : triggers) {
            if (!trigger.getTriggerId().equals(triggerId)) continue;
            return trigger;
        }
        return null;
    }

    @Override
    public Trigger getTriggerById(String triggerId) {
        return this.getTriggerById(triggerId, true);
    }

    @Override
    public Trigger getTriggerById(String triggerId, boolean refreshCache) {
        Trigger trigger = this.cacheManager.getTriggers(refreshCache).get(triggerId);
        if (trigger == null && !refreshCache) {
            trigger = this.getTriggerById(triggerId, true);
        }
        return trigger;
    }

    @Override
    public Router getRouterById(String routerId) {
        return this.getRouterById(routerId, true);
    }

    @Override
    public Router getRouterById(String routerId, boolean refreshCache) {
        Map<String, Router> cache = this.cacheManager.getRouters(refreshCache);
        return cache != null ? cache.get(routerId) : null;
    }

    @Override
    public List<Router> getRouters() {
        return this.getRouters(true);
    }

    @Override
    public List<Router> getRouters(boolean replaceVariables) {
        List routers = this.sqlTemplate.query(this.getSql("select ", "selectRoutersColumnList", "selectRoutersSql"), (ISqlRowMapper)new RouterMapper(this.configurationService.getNodeGroupLinks(false)), new Object[0]);
        if (replaceVariables) {
            TypedProperties replacements = this.parameterService.getAllParameters();
            for (Router router : routers) {
                router.setTargetCatalogName(FormatUtils.replaceTokens((String)router.getTargetCatalogName(), (Map)replacements, (boolean)true));
                router.setTargetSchemaName(FormatUtils.replaceTokens((String)router.getTargetSchemaName(), (Map)replacements, (boolean)true));
                router.setTargetTableName(FormatUtils.replaceTokens((String)router.getTargetTableName(), (Map)replacements, (boolean)true));
            }
        }
        return routers;
    }

    private String getTriggerRouterSql(String sql) {
        return this.getSql("select ", "selectTriggerRoutersColumnList", "selectTriggerRoutersSql", sql);
    }

    @Override
    public List<TriggerRouter> getTriggerRouters(boolean refreshCache) {
        return this.cacheManager.getTriggerRouters(refreshCache);
    }

    @Override
    public List<TriggerRouter> getTriggerRoutersFromDatabase() {
        return this.enhanceTriggerRouters(this.sqlTemplate.query(this.getTriggerRouterSql(null), (ISqlRowMapper)new TriggerRouterMapper(), new Object[0]));
    }

    @Override
    public List<TriggerRouter> getAllTriggerRoutersForCurrentNode(String sourceNodeGroupId) {
        List<TriggerRouter> triggerRouters = this.enhanceTriggerRouters(this.sqlTemplate.query(this.getTriggerRouterSql("activeTriggersForSourceNodeGroupSql"), (ISqlRowMapper)new TriggerRouterMapper(), new Object[]{sourceNodeGroupId}));
        this.mergeInConfigurationTablesTriggerRoutersForCurrentNode(sourceNodeGroupId, triggerRouters);
        return triggerRouters;
    }

    @Override
    public List<TriggerRouter> getTriggerRoutersForTargetNode(String targetNodeGroupId) {
        List<TriggerRouter> triggerRouters = this.enhanceTriggerRouters(this.sqlTemplate.query(this.getTriggerRouterSql("activeTriggersForTargetNodeGroupSql"), (ISqlRowMapper)new TriggerRouterMapper(), new Object[]{targetNodeGroupId}));
        return triggerRouters;
    }

    @Override
    public List<TriggerRouter> getTriggerRoutersForSourceAndTargetNodes(String sourceNodeGroupId, String targetNodeGroupId) {
        List<TriggerRouter> triggerRouters = this.enhanceTriggerRouters(this.sqlTemplate.query(this.getTriggerRouterSql("activeTriggersForSourceAndTargetNodeGroupsSql"), (ISqlRowMapper)new TriggerRouterMapper(), new Object[]{sourceNodeGroupId, targetNodeGroupId}));
        return triggerRouters;
    }

    @Override
    public List<TriggerRouter> getAllTriggerRoutersForReloadForCurrentNode(String sourceNodeGroupId, String targetNodeGroupId) {
        return this.enhanceTriggerRouters(this.sqlTemplate.query(this.getTriggerRouterSql("activeTriggersForReloadSql"), (ISqlRowMapper)new TriggerRouterMapper(), new Object[]{sourceNodeGroupId, targetNodeGroupId, "config", "system"}));
    }

    @Override
    public TriggerRouter findTriggerRouterById(String triggerId, String routerId) {
        return this.findTriggerRouterById(triggerId, routerId, true);
    }

    @Override
    public TriggerRouter findTriggerRouterById(String triggerId, String routerId, boolean refreshCache) {
        return this.cacheManager.getTriggerRoutersById(refreshCache).get(triggerId + routerId);
    }

    @Override
    public List<TriggerRouter> findTriggerRoutersByTriggerId(String triggerId, boolean refreshCache) {
        List configs = this.sqlTemplate.query(this.getTriggerRouterSql("selectTriggerRoutersByTriggerIdSql"), (ISqlRowMapper)new TriggerRouterMapper(), new Object[]{triggerId});
        for (TriggerRouter triggerRouter : configs) {
            triggerRouter.setRouter(this.getRouterById(triggerRouter.getRouter().getRouterId(), refreshCache));
            triggerRouter.setTrigger(this.getTriggerById(triggerRouter.getTrigger().getTriggerId(), refreshCache));
        }
        return configs;
    }

    @Override
    public List<TriggerRouter> findTriggerRoutersByRouterId(String routerId, boolean refreshCache) {
        List configs = this.sqlTemplate.query(this.getTriggerRouterSql("selectTriggerRoutersByRouterIdSql"), (ISqlRowMapper)new TriggerRouterMapper(), new Object[]{routerId});
        for (TriggerRouter triggerRouter : configs) {
            triggerRouter.setRouter(this.getRouterById(triggerRouter.getRouter().getRouterId(), refreshCache));
            triggerRouter.setTrigger(this.getTriggerById(triggerRouter.getTrigger().getTriggerId(), refreshCache));
        }
        return configs;
    }

    private List<TriggerRouter> enhanceTriggerRouters(List<TriggerRouter> triggerRouters) {
        HashMap<String, Router> routersById = new HashMap<String, Router>();
        for (Router router : this.getRouters()) {
            routersById.put(router.getRouterId().trim().toUpperCase(), router);
        }
        HashMap<String, Trigger> triggersById = new HashMap<String, Trigger>();
        for (Trigger trigger : this.getTriggers()) {
            triggersById.put(trigger.getTriggerId().trim().toUpperCase(), trigger);
        }
        for (TriggerRouter triggerRouter : triggerRouters) {
            triggerRouter.setTrigger((Trigger)triggersById.get(triggerRouter.getTrigger().getTriggerId().trim().toUpperCase()));
            triggerRouter.setRouter((Router)routersById.get(triggerRouter.getRouter().getRouterId().trim().toUpperCase()));
        }
        return triggerRouters;
    }

    @Override
    public Map<String, List<TriggerRouter>> getTriggerRoutersByChannel(String nodeGroupId) {
        return this.getTriggerRoutersByChannel(nodeGroupId, false);
    }

    public Map<String, List<TriggerRouter>> getTriggerRoutersByChannel(String nodeGroupId, boolean refreshCache) {
        return this.cacheManager.getTriggerRoutersByChannel(nodeGroupId, refreshCache);
    }

    @Override
    public Map<String, List<TriggerRouter>> getTriggerRoutersByChannelFromDatabase(String nodeGroupId) {
        HashMap<String, List<TriggerRouter>> newValue = new HashMap<String, List<TriggerRouter>>();
        List<TriggerRouter> triggerRouters = this.enhanceTriggerRouters(this.sqlTemplate.query(this.getTriggerRouterSql("selectGroupTriggersSql"), (ISqlRowMapper)new TriggerRouterMapper(), new Object[]{nodeGroupId, nodeGroupId}));
        for (TriggerRouter triggerRouter : triggerRouters) {
            ArrayList<TriggerRouter> list = (ArrayList<TriggerRouter>)newValue.get(triggerRouter.getTrigger().getChannelId());
            if (list == null) {
                list = new ArrayList<TriggerRouter>();
                newValue.put(triggerRouter.getTrigger().getChannelId(), list);
            }
            list.add(triggerRouter);
        }
        return newValue;
    }

    protected void handleTableNotFound(Trigger trigger, List<TriggerHistory> activeTriggerHistories, TriggerRouterContext context) {
        this.log.error("Table not found: {}", (Object)trigger.qualifiedSourceTableName());
        TriggerHistory hist = this.getNewestTriggerHistoryForTrigger(activeTriggerHistories, trigger.getTriggerId(), trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName());
        TriggerHistory errorHist = this.getTableNotFoundTriggerHistory(trigger);
        if (hist == null) {
            this.insert(errorHist);
        } else if (!errorHist.getErrorMessage().equals(hist.getErrorMessage())) {
            long ts = System.currentTimeMillis();
            this.inactivateTriggerHistory(hist);
            context.incrementInactivateTriggerHistTime(System.currentTimeMillis() - ts);
            this.insert(errorHist);
        }
        context.addTablesNotFound(trigger.qualifiedSourceTableName());
        context.incrementTriggersSyncedCount(1);
        for (ITriggerCreationListener l : this.extensionService.getExtensionPointList(ITriggerCreationListener.class)) {
            long ts = System.currentTimeMillis();
            l.tableDoesNotExist(context.getTriggersToSyncCount(), context.getTriggersSyncedCount(), trigger);
            context.incrementTableDoesNotExistTime(System.currentTimeMillis() - ts);
        }
    }

    protected TriggerHistory getTableNotFoundTriggerHistory(Trigger trigger) {
        String UNKNOWN = "?";
        TriggerHistory hist = new TriggerHistory(trigger);
        hist.setErrorMessage("Table not found");
        hist.setLastTriggerBuildReason(TriggerReBuildReason.TABLE_SCHEMA_CHANGED);
        hist.setColumnNames("?");
        hist.setPkColumnNames("?");
        hist.setCreateTime(new Date());
        hist.setInactiveTime(hist.getCreateTime());
        return hist;
    }

    @Override
    public void insert(TriggerHistory newHistRecord) {
        if (newHistRecord.getTriggerHistoryId() <= 0) {
            newHistRecord.setTriggerHistoryId((int)this.sequenceService.nextVal("trigger_hist"));
        }
        this.historyMap.put(newHistRecord.getTriggerHistoryId(), newHistRecord);
        this.sqlTemplate.update(this.getSql("insertTriggerHistorySql"), new Object[]{newHistRecord.getTriggerHistoryId(), newHistRecord.getTriggerId(), newHistRecord.getSourceTableName(), newHistRecord.getTableHash(), newHistRecord.getCreateTime(), newHistRecord.getColumnNames(), newHistRecord.getPkColumnNames(), newHistRecord.isMissingPk() ? 1 : 0, newHistRecord.getLastTriggerBuildReason().getCode(), newHistRecord.getNameForDeleteTrigger(), newHistRecord.getNameForInsertTrigger(), newHistRecord.getNameForUpdateTrigger(), newHistRecord.getSourceSchemaName(), newHistRecord.getSourceCatalogName(), newHistRecord.getTriggerRowHash(), newHistRecord.getTriggerTemplateHash(), newHistRecord.getErrorMessage(), newHistRecord.getInactiveTime()}, new int[]{4, 12, 12, -5, 93, 12, 12, 5, 1, 12, 12, 12, 12, 12, -5, -5, 12, 93});
    }

    @Override
    public void deleteTriggerRouter(String triggerId, String routerId) {
        this.sqlTemplate.update(this.getSql("deleteTriggerRouterSql"), new Object[]{triggerId, routerId});
        this.clearCache();
    }

    private void deleteTriggerRoutersByTriggerId(String triggerId) {
        this.sqlTemplate.update(this.getSql("deleteTriggerRoutersByTriggerIdSql"), new Object[]{triggerId});
        this.clearCache();
    }

    private void deleteTriggerRoutersByRouterId(String routerId) {
        this.sqlTemplate.update(this.getSql("deleteTriggerRoutersByRouterIdSql"), new Object[]{routerId});
        this.clearCache();
    }

    @Override
    public void deleteTriggerRouter(TriggerRouter triggerRouter) {
        this.sqlTemplate.update(this.getSql("deleteTriggerRouterSql"), new Object[]{triggerRouter.getTrigger().getTriggerId(), triggerRouter.getRouter().getRouterId()});
        this.clearCache();
    }

    @Override
    public void deleteTriggerRouters(Collection<TriggerRouter> triggerRouters) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            this.deleteTriggerRouters(transaction, triggerRouters);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            this.close(transaction);
        }
        this.clearCache();
    }

    protected void deleteTriggerRouters(ISqlTransaction transaction, Collection<TriggerRouter> triggerRouters) {
        int maxRowsToFlush = this.parameterService.getInt("data.flush.jdbc.batch.size");
        transaction.prepare(this.getSql("deleteTriggerRouterSql"));
        int[] types = new int[]{12};
        int rowCount = 0;
        for (TriggerRouter triggerRouter : triggerRouters) {
            transaction.addRow(null, new Object[]{triggerRouter.getTrigger().getTriggerId(), triggerRouter.getRouter().getRouterId()}, types);
            if (++rowCount <= maxRowsToFlush) continue;
            transaction.flush();
        }
        transaction.flush();
    }

    @Override
    public void deleteAllTriggerRouters() {
        this.sqlTemplate.update(this.getSql("deleteAllTriggerRoutersSql"), new Object[0]);
        this.clearCache();
    }

    @Override
    public void saveTriggerRouter(TriggerRouter triggerRouter) {
        this.saveTriggerRouter(triggerRouter, false);
    }

    @Override
    public void saveTriggerRouter(TriggerRouter triggerRouter, boolean updateTriggerRouterTableOnly) {
        if (!updateTriggerRouterTableOnly) {
            this.saveTrigger(triggerRouter.getTrigger());
            this.saveRouter(triggerRouter.getRouter());
        }
        triggerRouter.setLastUpdateTime(new Date());
        if (0 >= this.sqlTemplate.update(this.getSql("updateTriggerRouterSql"), this.getTriggerRouterSqlValues(triggerRouter), this.getTriggerRouterSqlTypes())) {
            triggerRouter.setCreateTime(triggerRouter.getLastUpdateTime());
            this.sqlTemplate.update(this.getSql("insertTriggerRouterSql"), this.getTriggerRouterSqlValues(triggerRouter), this.getTriggerRouterSqlTypes());
        }
        this.clearCache();
    }

    @Override
    public void renameTriggerRouter(String oldTriggerId, String oldRouterId, TriggerRouter triggerRouter) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            this.saveTriggerRouter(triggerRouter, true);
            this.sqlTemplate.update(this.getSql("updateTriggerRouterIdSql0"), new Object[]{triggerRouter.getTriggerId(), oldTriggerId});
            this.sqlTemplate.update(this.getSql("updateTriggerRouterIdSql1"), new Object[]{triggerRouter.getRouterId(), oldRouterId});
            this.deleteTriggerRouter(oldTriggerId, oldRouterId);
            transaction.commit();
        }
        catch (Exception ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    private void renameTriggerRouters(String newTriggerId, String newRouterId, List<TriggerRouter> triggerRouters) {
        if (triggerRouters != null && !triggerRouters.isEmpty()) {
            if (newTriggerId != null) {
                String oldTriggerId = triggerRouters.get(0).getTriggerId();
                for (TriggerRouter triggerRouter : triggerRouters) {
                    triggerRouter.setTriggerId(newTriggerId);
                    this.saveTriggerRouter(triggerRouter);
                }
                this.sqlTemplate.update(this.getSql("updateTriggerRouterIdSql0"), new Object[]{newTriggerId, oldTriggerId});
                this.deleteTriggerRoutersByTriggerId(oldTriggerId);
            } else if (newRouterId != null) {
                String oldRouterId = triggerRouters.get(0).getRouterId();
                for (TriggerRouter triggerRouter : triggerRouters) {
                    triggerRouter.setRouterId(newRouterId);
                    this.saveTriggerRouter(triggerRouter);
                }
                this.sqlTemplate.update(this.getSql("updateTriggerRouterIdSql1"), new Object[]{newRouterId, oldRouterId});
                this.deleteTriggerRoutersByRouterId(oldRouterId);
            }
        }
    }

    @Override
    public void insertTriggerRouters(Collection<TriggerRouter> triggerRouters) {
        this.insertUpdateTriggerRouters(triggerRouters, true, null);
    }

    @Override
    public void insertTriggersAndTriggerRouters(Collection<Trigger> triggers, Collection<TriggerRouter> triggerRouters) {
        this.insertUpdateTriggerRouters(triggerRouters, true, triggers);
    }

    @Override
    public void updateTriggerRouters(Collection<TriggerRouter> triggerRouters) {
        this.insertUpdateTriggerRouters(triggerRouters, false, null);
    }

    protected void insertUpdateTriggerRouters(Collection<TriggerRouter> triggerRouters, boolean isInsert, Collection<Trigger> triggers) {
        ISqlTransaction transaction = null;
        try {
            int maxRowsToFlush = this.parameterService.getInt("data.flush.jdbc.batch.size");
            transaction = this.sqlTemplate.startSqlTransaction();
            if (triggers != null) {
                this.insertUpdateTriggers(transaction, triggers, isInsert);
            }
            transaction.prepare(isInsert ? this.getSql("insertTriggerRouterSql") : this.getSql("updateTriggerRouterSql"));
            int[] types = this.getTriggerRouterSqlTypes();
            int rowCount = 0;
            for (TriggerRouter triggerRouter : triggerRouters) {
                triggerRouter.setLastUpdateTime(new Date());
                if (triggerRouter.getCreateTime() == null) {
                    triggerRouter.setCreateTime(triggerRouter.getLastUpdateTime());
                }
                transaction.addRow(null, this.getTriggerRouterSqlValues(triggerRouter), types);
                if (++rowCount <= maxRowsToFlush) continue;
                transaction.flush();
            }
            transaction.commit();
        }
        catch (Exception e) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.close(transaction);
                throw throwable;
            }
        }
        this.close(transaction);
        this.clearCache();
    }

    protected int[] getTriggerRouterSqlTypes() {
        return new int[]{2, 12, 12, 5, 93, 12, 93, 5, 12, 12, 12};
    }

    protected Object[] getTriggerRouterSqlValues(TriggerRouter triggerRouter) {
        return new Object[]{triggerRouter.getInitialLoadOrder(), triggerRouter.getInitialLoadSelect(), triggerRouter.getInitialLoadDeleteStmt(), triggerRouter.isPingBackEnabled() ? 1 : 0, triggerRouter.getCreateTime(), triggerRouter.getLastUpdateBy(), triggerRouter.getLastUpdateTime(), triggerRouter.isEnabled() ? 1 : 0, triggerRouter.getDataRefreshType(), triggerRouter.getTrigger().getTriggerId(), triggerRouter.getRouter().getRouterId()};
    }

    protected void resetTriggerRouterCacheByNodeGroupId() {
        this.cacheManager.flushTriggerRoutersByNodeGroupId();
    }

    @Override
    public void saveRouter(Router router) {
        router.setLastUpdateTime(new Date());
        router.nullOutBlankFields();
        if (0 >= this.sqlTemplate.update(this.getSql("updateRouterSql"), new Object[]{router.getTargetCatalogName(), router.getTargetSchemaName(), router.getTargetTableName(), router.getNodeGroupLink().getSourceNodeGroupId(), router.getNodeGroupLink().getTargetNodeGroupId(), router.getRouterType(), router.getRouterExpression(), router.isSyncOnUpdate() ? 1 : 0, router.isSyncOnInsert() ? 1 : 0, router.isSyncOnDelete() ? 1 : 0, router.isUseSourceCatalogSchema() ? 1 : 0, router.getLastUpdateBy(), router.getLastUpdateTime(), router.getRouterId()}, new int[]{12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 5, 12, 93, 12})) {
            router.setCreateTime(router.getLastUpdateTime());
            this.sqlTemplate.update(this.getSql("insertRouterSql"), new Object[]{router.getTargetCatalogName(), router.getTargetSchemaName(), router.getTargetTableName(), router.getNodeGroupLink().getSourceNodeGroupId(), router.getNodeGroupLink().getTargetNodeGroupId(), router.getRouterType(), router.getRouterExpression(), router.isSyncOnUpdate() ? 1 : 0, router.isSyncOnInsert() ? 1 : 0, router.isSyncOnDelete() ? 1 : 0, router.isUseSourceCatalogSchema() ? 1 : 0, router.getCreateTime(), router.getLastUpdateBy(), router.getLastUpdateTime(), router.getRouterId()}, new int[]{12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 5, 93, 12, 93, 12});
        }
        this.clearCache();
    }

    @Override
    public Router saveRouterAsCopy(Router router) {
        String newId = router.getRouterId();
        List routers = this.sqlTemplate.query(this.getSql("select ", "selectRoutersColumnList", "selectRoutersWhereRouterIdLikeSql"), (ISqlRowMapper)new RouterMapper(this.configurationService.getNodeGroupLinks(false)), new Object[]{newId + "%"});
        List ids = routers.stream().map(Router::getRouterId).collect(Collectors.toList());
        Object suffix = "";
        int i = 2;
        while (ids.contains(newId + (String)suffix)) {
            suffix = "_" + i;
            ++i;
        }
        router.setRouterId(newId + (String)suffix);
        this.saveRouter(router);
        return router;
    }

    @Override
    public void renameRouter(String oldId, Router router) {
        this.saveRouter(router);
        this.renameTriggerRouters(null, router.getRouterId(), this.findTriggerRoutersByRouterId(oldId, true));
        this.sqlTemplate.update(this.getSql("updateFileTriggerRouterSql"), new Object[]{router.getRouterId(), oldId});
        this.deleteRouter(oldId);
    }

    @Override
    public boolean isRouterBeingUsed(String routerId) {
        return this.sqlTemplate.queryForInt(this.getSql("countTriggerRoutersByRouterIdSql"), new Object[]{routerId}) > 0;
    }

    @Override
    public void deleteRouter(Router router) {
        if (router != null) {
            this.sqlTemplate.update(this.getSql("deleteTriggerRoutersByRouterSql"), new Object[]{router.getRouterId()});
            this.groupletService.deleteTriggerRouterGroupletsFor(router);
            this.sqlTemplate.update(this.getSql("deleteRouterSql"), new Object[]{router.getRouterId()});
        }
    }

    private void deleteRouter(String id) {
        this.sqlTemplate.update(this.getSql("deleteRouterSql"), new Object[]{id});
    }

    @Override
    public void deleteAllRouters() {
        this.sqlTemplate.update(this.getSql("deleteAllRoutersSql"), new Object[0]);
    }

    @Override
    public void saveTrigger(Trigger trigger) {
        trigger.setLastUpdateTime(new Date());
        trigger.nullOutBlankFields();
        if (0 >= this.sqlTemplate.update(this.getSql("updateTriggerSql"), this.getTriggerSqlValues(trigger), this.getTriggerSqlTypes())) {
            trigger.setCreateTime(trigger.getLastUpdateTime());
            this.sqlTemplate.update(this.getSql("insertTriggerSql"), this.getTriggerSqlValues(trigger), this.getTriggerSqlTypes());
        }
        this.clearCache();
    }

    @Override
    public void saveTriggerAsCopy(String originalId, Trigger trigger) {
        String newId = trigger.getTriggerId();
        List triggers = this.sqlTemplate.query(this.getSql("selectTriggersWhereTriggerIdLikeSql"), (ISqlRowMapper)new TriggerMapper(), new Object[]{newId + "%"});
        List ids = triggers.stream().map(Trigger::getTriggerId).collect(Collectors.toList());
        Object suffix = "";
        int i = 2;
        while (ids.contains(newId + (String)suffix)) {
            suffix = "_" + i;
            ++i;
        }
        trigger.setTriggerId(newId + (String)suffix);
        this.saveTrigger(trigger);
        for (TriggerRouter triggerRouter : this.findTriggerRoutersByTriggerId(originalId, true)) {
            triggerRouter.setTriggerId(newId + (String)suffix);
            this.saveTriggerRouter(triggerRouter, true);
        }
    }

    @Override
    public void renameTrigger(String oldId, Trigger trigger) {
        this.saveTrigger(trigger);
        this.renameTriggerRouters(trigger.getTriggerId(), null, this.findTriggerRoutersByTriggerId(oldId, true));
        this.deleteTrigger(oldId);
    }

    @Override
    public void insertTriggers(Collection<Trigger> triggers) {
        this.insertUpdateTriggers(triggers, true);
    }

    @Override
    public void updateTriggers(Collection<Trigger> triggers) {
        this.insertUpdateTriggers(triggers, false);
    }

    protected void insertUpdateTriggers(Collection<Trigger> triggers, boolean isInsert) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            this.insertUpdateTriggers(transaction, triggers, isInsert);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            this.close(transaction);
        }
        this.clearCache();
    }

    protected void insertUpdateTriggers(ISqlTransaction transaction, Collection<Trigger> triggers, boolean isInsert) {
        int maxRowsToFlush = this.parameterService.getInt("data.flush.jdbc.batch.size");
        transaction.prepare(isInsert ? this.getSql("insertTriggerSql") : this.getSql("updateTriggerSql"));
        int[] types = this.getTriggerSqlTypes();
        int rowCount = 0;
        for (Trigger trigger : triggers) {
            trigger.setLastUpdateTime(new Date());
            trigger.nullOutBlankFields();
            if (trigger.getCreateTime() == null) {
                trigger.setCreateTime(trigger.getLastUpdateTime());
            }
            transaction.addRow(null, this.getTriggerSqlValues(trigger), types);
            if (++rowCount <= maxRowsToFlush) continue;
            transaction.flush();
        }
        transaction.flush();
    }

    protected int[] getTriggerSqlTypes() {
        return new int[]{12, 12, 12, 12, 12, 5, 5, 5, 5, 5, 5, 5, 5, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 93, 12, 93, 12, 12, 5, 12, 12};
    }

    protected Object[] getTriggerSqlValues(Trigger trigger) {
        return new Object[]{trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), trigger.getChannelId(), trigger.getReloadChannelId(), trigger.isSyncOnUpdate() ? 1 : 0, trigger.isSyncOnInsert() ? 1 : 0, trigger.isSyncOnDelete() ? 1 : 0, trigger.isSyncOnIncomingBatch() ? 1 : 0, trigger.isUseStreamLobs() ? 1 : 0, trigger.isUseCaptureLobs() ? 1 : 0, trigger.isUseCaptureOldData() ? 1 : 0, trigger.isUseHandleKeyUpdates() ? 1 : 0, trigger.getNameForUpdateTrigger(), trigger.getNameForInsertTrigger(), trigger.getNameForDeleteTrigger(), trigger.getSyncOnUpdateCondition(), trigger.getSyncOnInsertCondition(), trigger.getSyncOnDeleteCondition(), trigger.getCustomBeforeUpdateText(), trigger.getCustomBeforeInsertText(), trigger.getCustomBeforeDeleteText(), trigger.getCustomOnUpdateText(), trigger.getCustomOnInsertText(), trigger.getCustomOnDeleteText(), trigger.getTxIdExpression(), trigger.getExcludedColumnNames(), trigger.getIncludedColumnNames(), trigger.getSyncKeyNames(), trigger.getCreateTime(), trigger.getLastUpdateBy(), trigger.getLastUpdateTime(), trigger.getExternalSelect(), trigger.getChannelExpression(), trigger.isStreamRow(), trigger.getTimeBasedCaptureColumn(), trigger.getTriggerId()};
    }

    @Override
    public boolean syncTriggers() {
        return this.syncTriggers(false);
    }

    @Override
    public boolean syncTriggers(boolean force) {
        return this.syncTriggers((StringBuilder)null, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean syncTriggers(StringBuilder sqlBuffer, boolean force) {
        if (this.parameterService.is("auto.sync.triggers") || this.isCalledFromSymmetricAdminTool()) {
            TriggerRouterService triggerRouterService = this;
            synchronized (triggerRouterService) {
                if (this.clusterService.lock("SyncTriggers")) {
                    TriggerRouterContext context = new TriggerRouterContext();
                    long startTime = System.currentTimeMillis();
                    try {
                        String additionalMessage = "";
                        if (this.isCalledFromSymmetricAdminTool() && !this.parameterService.is("auto.sync.triggers")) {
                            additionalMessage = " auto.sync.triggers is set to false, but the sync triggers process will run so that needed changes can be written to a file so they can be applied manually.  Once all of the triggers have been successfully applied this process should not show triggers being created";
                        }
                        this.log.info("Synchronizing triggers{}", (Object)additionalMessage);
                        long ts = System.currentTimeMillis();
                        this.fixMultipleActiveTriggerHistories(context);
                        context.incrementFixMultipleActiveTriggerHistoriesTime(System.currentTimeMillis() - ts);
                        this.platform.resetCachedTableModel();
                        this.clearCache();
                        this.configurationService.clearCache();
                        ts = System.currentTimeMillis();
                        List<Trigger> triggersForCurrentNode = this.getTriggersForCurrentNode();
                        context.incrementTriggersForCurrentNodeTime(System.currentTimeMillis() - ts);
                        context.incrementTriggersToSyncCount(triggersForCurrentNode.size());
                        ts = System.currentTimeMillis();
                        for (ITriggerCreationListener l : this.extensionService.getExtensionPointList(ITriggerCreationListener.class)) {
                            l.syncTriggersStarted();
                        }
                        context.incrementSyncTriggersStartedTime(System.currentTimeMillis() - ts);
                        boolean createTriggersForTables = false;
                        String nodeId = this.nodeService.findIdentityNodeId();
                        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
                            NodeSecurity nodeSecurity = null;
                            if (!force) {
                                nodeSecurity = this.nodeService.findNodeSecurity(nodeId);
                            }
                            if (nodeSecurity != null && (nodeSecurity.isInitialLoadEnabled() || nodeSecurity.getInitialLoadEndTime() == null)) {
                                createTriggersForTables = this.parameterService.is("trigger.create.before.initial.load.enabled");
                                if (!createTriggersForTables) {
                                    this.log.info("Trigger creation has been disabled by trigger.create.before.initial.load.enabled because an initial load is in progress or has not yet been requested");
                                }
                            } else {
                                createTriggersForTables = true;
                            }
                        }
                        if (!createTriggersForTables) {
                            triggersForCurrentNode.clear();
                        }
                        ts = System.currentTimeMillis();
                        List<TriggerHistory> activeTriggerHistories = this.getActiveTriggerHistories();
                        context.incrementActiveTriggerHistoriesTime(System.currentTimeMillis() - ts);
                        this.inactivateTriggers(triggersForCurrentNode, sqlBuffer, activeTriggerHistories, context);
                        this.updateOrCreateDatabaseTriggers(triggersForCurrentNode, sqlBuffer, force, true, activeTriggerHistories, true, context);
                        this.resetTriggerRouterCacheByNodeGroupId();
                        if (createTriggersForTables && this.symmetricDialect.supportsDdlTriggers()) {
                            ts = System.currentTimeMillis();
                            this.updateOrCreateDdlTriggers(sqlBuffer);
                            context.incrementUpdateOrCreateDdlTriggersTime(System.currentTimeMillis() - ts);
                        }
                        this.statisticManager.addJobStats("SyncTriggers", startTime, System.currentTimeMillis(), (long)context.getTriggersSyncedCount(), context.getErrorMessage());
                    }
                    catch (RuntimeException e) {
                        this.statisticManager.addJobStats("SyncTriggers", startTime, System.currentTimeMillis(), (long)context.getTriggersSyncedCount(), e);
                        throw e;
                    }
                    finally {
                        long ts = System.currentTimeMillis();
                        for (ITriggerCreationListener l : this.extensionService.getExtensionPointList(ITriggerCreationListener.class)) {
                            l.syncTriggersEnded();
                        }
                        context.incrementSyncTriggersEndedTime(System.currentTimeMillis() - ts);
                        this.logTriggerRouterContextTimings(context);
                        this.logTriggerRouterContextAnomalies(context);
                        this.clusterService.unlock("SyncTriggers");
                        this.log.info("Done synchronizing triggers");
                    }
                } else {
                    Lock lock = this.clusterService.findLocks().get("SyncTriggers");
                    if (lock != null) {
                        this.log.info("Sync triggers was locked by the cluster service.  The locking server id was: {}.  The lock time was: {}", (Object)lock.getLockingServerId(), (Object)lock.getLockTime());
                    } else {
                        this.log.info("Sync triggers was locked by the cluster service but lock details were not found. Perhaps the lock was released in the meantime.");
                    }
                    return false;
                }
            }
        } else {
            this.log.info("Not synchronizing triggers.  {} is set to false", (Object)"auto.sync.triggers");
        }
        return true;
    }

    @Override
    public void clearCache() {
        this.cacheManager.flushTriggerRoutersByNodeGroupId();
        this.cacheManager.flushTriggerRoutersByChannel();
        this.cacheManager.flushTriggerRouters();
        this.cacheManager.flushTriggerRoutersByTriggerHist();
        this.cacheManager.flushTriggerRoutersById();
        this.cacheManager.flushTriggers();
        this.cacheManager.flushRouters();
    }

    protected Set<String> getTriggerIdsFrom(List<Trigger> triggersThatShouldBeActive) {
        HashSet<String> triggerIds = new HashSet<String>(triggersThatShouldBeActive.size());
        for (Trigger trigger : triggersThatShouldBeActive) {
            triggerIds.add(trigger.getTriggerId());
        }
        return triggerIds;
    }

    protected Trigger getTriggerFromList(String triggerId, List<Trigger> triggersThatShouldBeActive) {
        for (Trigger trigger : triggersThatShouldBeActive) {
            if (!trigger.getTriggerId().equals(triggerId)) continue;
            return trigger;
        }
        return null;
    }

    private int getNumberOfThreadsToUseForSyncTriggers() {
        int numThreads = this.parameterService.getInt("sync.triggers.thread.count.per.server");
        if (this.parameterService.is("jobs.synchronized.enable", false) || !this.platform.isUseMultiThreadSyncTriggers()) {
            numThreads = 1;
        }
        return numThreads;
    }

    protected void inactivateTriggers(final List<Trigger> triggersThatShouldBeActive, final StringBuilder sqlBuffer, List<TriggerHistory> activeTriggerHistories, final TriggerRouterContext triggerRouterContext) {
        final boolean ignoreCase = this.parameterService.is("db.metadata.ignore.case");
        final HashMap tablesByTriggerId = new HashMap();
        int numThreads = this.getNumberOfThreadsToUseForSyncTriggers();
        ExecutorService executor = Executors.newFixedThreadPool(numThreads, new SyncTriggersThreadFactory());
        ArrayList futures = new ArrayList();
        for (final TriggerHistory history : activeTriggerHistories) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set<Table> tables;
                    MDC.put((String)"engineName", (String)TriggerRouterService.this.parameterService.getEngineName());
                    Map map = tablesByTriggerId;
                    synchronized (map) {
                        tables = (Set<Table>)tablesByTriggerId.get(history.getTriggerId());
                    }
                    Trigger trigger = TriggerRouterService.this.getTriggerFromList(history.getTriggerId(), triggersThatShouldBeActive);
                    if (tables == null && trigger != null) {
                        tables = TriggerRouterService.this.getTablesForTrigger(trigger, triggersThatShouldBeActive, true, triggerRouterContext);
                        Map map2 = tablesByTriggerId;
                        synchronized (map2) {
                            tablesByTriggerId.put(trigger.getTriggerId(), tables);
                        }
                    }
                    boolean foundTable = false;
                    if (tables != null && trigger != null) {
                        for (Table table : tables) {
                            boolean matchesCatalog = TriggerRouterService.this.isEqual(trigger.isSourceCatalogNameWildCarded() ? table.getCatalog() : trigger.getSourceCatalogNameUnescaped(), history.getSourceCatalogName(), ignoreCase);
                            boolean matchesSchema = TriggerRouterService.this.isEqual(trigger.isSourceSchemaNameWildCarded() ? table.getSchema() : trigger.getSourceSchemaNameUnescaped(), history.getSourceSchemaName(), ignoreCase);
                            boolean matchesTable = TriggerRouterService.this.isEqual(trigger.isSourceTableNameWildCarded() || trigger.isSourceTableNameExpanded() ? table.getName() : trigger.getSourceTableNameUnescaped(), history.getSourceTableName(), ignoreCase);
                            foundTable |= matchesCatalog && matchesSchema && matchesTable;
                        }
                    }
                    if (trigger == null) {
                        TriggerRouterService.this.log.info("About to remove triggers for inactivated table: {}", (Object)history.getFullyQualifiedSourceTableName());
                        TriggerRouterService.this.dropTriggersIfNeeded(history, sqlBuffer, triggerRouterContext, true);
                    } else if (!foundTable && history.getErrorMessage() == null) {
                        TriggerRouterService.this.log.info("About to inactivate trigger history {} because table is missing: {}", (Object)history.getTriggerHistoryId(), (Object)trigger.qualifiedSourceTableName());
                        TriggerRouterService.this.dropTriggersIfNeeded(history, sqlBuffer, triggerRouterContext, foundTable);
                    }
                }
            };
            futures.add(executor.submit(runnable));
        }
        this.awaitTermination(executor, futures);
    }

    protected boolean isEqual(String one, String two, boolean ignoreCase) {
        if (ignoreCase) {
            return StringUtils.equalsIgnoreCase((CharSequence)one, (CharSequence)two);
        }
        return StringUtils.equals((CharSequence)one, (CharSequence)two);
    }

    protected void dropTriggersIfNeeded(TriggerHistory history, StringBuilder sqlBuffer, TriggerRouterContext triggerRouterContext, boolean foundTable) {
        if (foundTable || this.platform.getDatabaseInfo().canTriggerExistWithoutTable() || this.platform != this.getTargetPlatform(history.getSourceTableName())) {
            this.dropTriggers(history, sqlBuffer, triggerRouterContext);
        } else {
            long ts = System.currentTimeMillis();
            this.inactivateTriggerHistory(history);
            triggerRouterContext.incrementInactivateTriggerHistTime(System.currentTimeMillis() - ts);
        }
    }

    @Override
    public void dropTriggers(TriggerHistory history) {
        TriggerRouterContext triggerRouterContext = new TriggerRouterContext();
        this.dropTriggers(history, null, triggerRouterContext);
        this.log.info("DropTriggers: it took {} ms to drop triggers for trigger ID {}", (Object)triggerRouterContext.getDropTriggerTime(), (Object)history.getTriggerId());
    }

    protected void dropTriggers(TriggerHistory history, StringBuilder sqlBuffer) {
        TriggerRouterContext triggerRouterContext = new TriggerRouterContext();
        this.dropTriggers(history, sqlBuffer, triggerRouterContext);
        if (sqlBuffer == null) {
            this.log.info("DropTriggers: it took {} ms to drop triggers for trigger ID {}", (Object)triggerRouterContext.getDropTriggerTime(), (Object)history.getTriggerId());
        }
    }

    protected void dropTriggers(TriggerHistory history, StringBuilder sqlBuffer, TriggerRouterContext context) {
        try {
            long ts = System.currentTimeMillis();
            this.dropTrigger(sqlBuffer, history.getSourceCatalogName(), history.getSourceSchemaName(), history.getNameForInsertTrigger(), history.getSourceTableName());
            this.dropTrigger(sqlBuffer, history.getSourceCatalogName(), history.getSourceSchemaName(), history.getNameForDeleteTrigger(), history.getSourceTableName());
            this.dropTrigger(sqlBuffer, history.getSourceCatalogName(), history.getSourceSchemaName(), history.getNameForUpdateTrigger(), history.getSourceTableName());
            context.incrementDropTriggerTime(System.currentTimeMillis() - ts);
            if (this.parameterService.is("auto.sync.triggers")) {
                context.incrementTriggersSyncedCount(1);
                for (ITriggerCreationListener l : this.extensionService.getExtensionPointList(ITriggerCreationListener.class)) {
                    ts = System.currentTimeMillis();
                    l.triggerInactivated(context.getTriggersToSyncCount(), context.getTriggersSyncedCount(), null, history);
                    context.incrementTriggerInactivatedTime(System.currentTimeMillis() - ts);
                }
            }
            ts = System.currentTimeMillis();
            boolean triggerExists = this.symmetricDialect.doesTriggerExist(sqlBuffer, history.getSourceCatalogName(), history.getSourceSchemaName(), history.getSourceTableName(), history.getNameForInsertTrigger());
            triggerExists |= this.symmetricDialect.doesTriggerExist(sqlBuffer, history.getSourceCatalogName(), history.getSourceSchemaName(), history.getSourceTableName(), history.getNameForUpdateTrigger());
            context.incrementDoesTriggerExistTime(System.currentTimeMillis() - ts);
            if (triggerExists |= this.symmetricDialect.doesTriggerExist(sqlBuffer, history.getSourceCatalogName(), history.getSourceSchemaName(), history.getSourceTableName(), history.getNameForDeleteTrigger())) {
                this.log.warn("There are triggers that have been marked as inactive.  Please remove triggers represented by trigger_id={} and trigger_hist_id={}", (Object)history.getTriggerId(), (Object)history.getTriggerHistoryId());
            } else if (history.getInactiveTime() == null) {
                ts = System.currentTimeMillis();
                this.inactivateTriggerHistory(history);
                context.incrementInactivateTriggerHistTime(System.currentTimeMillis() - ts);
            }
        }
        catch (Throwable ex) {
            this.log.error("Error while dropping triggers for table {}", (Object)history.getSourceTableName(), (Object)ex);
        }
    }

    protected void dropTrigger(StringBuilder sqlBuffer, String catalog, String schema, String triggerName, String tableName) {
        if (StringUtils.isNotBlank((CharSequence)triggerName)) {
            try {
                this.symmetricDialect.removeTrigger(sqlBuffer, catalog, schema, triggerName, tableName);
            }
            catch (SqlException e) {
                this.log.error("Error while dropping trigger {} for table {}: {}", new Object[]{triggerName, tableName, e.getMessage()});
            }
            catch (Throwable e) {
                this.log.error("Error while dropping trigger {} for table {}", new Object[]{triggerName, tableName, e});
            }
        }
    }

    protected List<TriggerRouter> toList(Collection<List<TriggerRouter>> source) {
        ArrayList<TriggerRouter> list = new ArrayList<TriggerRouter>();
        for (List<TriggerRouter> triggerRouters : source) {
            for (TriggerRouter triggerRouter : triggerRouters) {
                list.add(triggerRouter);
            }
        }
        return list;
    }

    protected List<Trigger> getTriggersForCurrentNode() {
        return new TriggerSelector(this.toList(this.getTriggerRoutersForCurrentNode(false).values())).select();
    }

    protected Set<Table> getTablesForTrigger(Trigger trigger, List<Trigger> triggers, boolean useTableCache, TriggerRouterContext triggerRouterContext) {
        try {
            return this.getTablesForTriggerWithException(trigger, triggers, useTableCache, triggerRouterContext);
        }
        catch (RuntimeException e) {
            if (this.platform.getSqlTemplate().isDeadlock((Throwable)e)) {
                this.log.warn("Deadlock occurred, so retrying");
                return this.getTablesForTriggerWithException(trigger, triggers, useTableCache, triggerRouterContext);
            }
            throw e;
        }
    }

    protected Set<Table> getTablesForTriggerWithException(Trigger trigger, List<Trigger> triggers, boolean useTableCache, TriggerRouterContext triggerRouterContext) {
        long ts = System.currentTimeMillis();
        HashSet<Table> tables = new HashSet<Table>();
        IDatabasePlatform sourcePlatform = this.getTargetPlatform(trigger.getSourceTableName());
        try {
            boolean ignoreCase = this.parameterService.is("db.metadata.ignore.case");
            ArrayList<String> catalogNames = new ArrayList<String>();
            if (trigger.isSourceCatalogNameWildCarded()) {
                List all = sourcePlatform.getDdlReader().getCatalogNames();
                for (String catalogName : all) {
                    if (!trigger.matchesCatalogName(catalogName, ignoreCase)) continue;
                    catalogNames.add(catalogName);
                }
                if (catalogNames.size() == 0) {
                    catalogNames.add(null);
                }
            } else if (StringUtils.isBlank((CharSequence)trigger.getSourceCatalogName())) {
                catalogNames.add(sourcePlatform.getDefaultCatalog());
            } else {
                catalogNames.add(trigger.getSourceCatalogNameUnescaped());
            }
            for (String catalogName : catalogNames) {
                ArrayList<String> schemaNames = new ArrayList<String>();
                if (trigger.isSourceSchemaNameWildCarded()) {
                    List all = sourcePlatform.getDdlReader().getSchemaNames(catalogName);
                    for (String schemaName : all) {
                        if (!trigger.matchesSchemaName(schemaName, ignoreCase)) continue;
                        schemaNames.add(schemaName);
                    }
                    if (schemaNames.size() == 0) {
                        schemaNames.add(null);
                    }
                } else if (StringUtils.isBlank((CharSequence)trigger.getSourceSchemaName())) {
                    schemaNames.add(sourcePlatform.getDefaultSchema());
                } else {
                    schemaNames.add(trigger.getSourceSchemaNameUnescaped());
                }
                for (String schemaName : schemaNames) {
                    if (trigger.isSourceTableNameWildCarded()) {
                        Table[] tableArray;
                        Database database = sourcePlatform.readDatabase(catalogName, schemaName, new String[]{"TABLE"});
                        for (Table table : tableArray = database.getTables()) {
                            if (!trigger.matches(table, catalogName, schemaName, ignoreCase) || this.containsExactMatchForSourceTableName(table, triggers, ignoreCase) || table.getName().toLowerCase().startsWith(this.tablePrefix)) continue;
                            tables.add(table);
                        }
                        continue;
                    }
                    if (!trigger.getSourceTableName().startsWith(this.parameterService.getTablePrefix() + "_") && CollectionUtils.isNotEmpty(this.extensionService.getExtensionPointList(ITableResolver.class))) {
                        for (ITableResolver resolver : this.extensionService.getExtensionPointList(ITableResolver.class)) {
                            resolver.resolve(catalogName, schemaName, tables, sourcePlatform, this.nodeService, trigger, useTableCache, triggerRouterContext);
                        }
                        continue;
                    }
                    Table table = sourcePlatform.getTableFromCache(catalogName, schemaName, trigger.getSourceTableNameUnescaped(), !useTableCache);
                    if (table == null) continue;
                    tables.add(table);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed to retrieve tables for trigger with id of %s", trigger.getTriggerId()), ex);
        }
        triggerRouterContext.incrementTablesForTriggerTime(System.currentTimeMillis() - ts);
        return tables;
    }

    private boolean containsExactMatchForSourceTableName(Table table, List<Trigger> triggers, boolean ignoreCase) {
        for (Trigger trigger : triggers) {
            String sourceSchemaName;
            if (trigger.isSourceWildCarded()) continue;
            String sourceCatalogName = trigger.getSourceCatalogName() != null ? trigger.getSourceCatalogName() : this.platform.getDefaultCatalog();
            String string = sourceSchemaName = trigger.getSourceSchemaName() != null ? trigger.getSourceSchemaName() : this.platform.getDefaultSchema();
            if (trigger.getSourceTableName().equals(table.getName()) && (sourceCatalogName == null || sourceCatalogName.equals(table.getCatalog())) && (sourceSchemaName == null || sourceSchemaName.equals(table.getSchema()))) {
                return true;
            }
            if (!ignoreCase || !trigger.getSourceTableName().equalsIgnoreCase(table.getName()) || sourceCatalogName != null && !sourceCatalogName.equalsIgnoreCase(table.getCatalog()) || sourceSchemaName != null && !sourceSchemaName.equalsIgnoreCase(table.getSchema())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean syncTriggers(String targetExternalId, boolean force) {
        if (this.cacheManager.isUsingTargetExternalId(false)) {
            List<Trigger> triggers = this.getTriggersForCurrentNode();
            ArrayList<Table> tables = new ArrayList<Table>();
            for (Trigger trigger : triggers) {
                Table table;
                if (!trigger.getSourceTableName().contains("targetExternalId") || (table = this.platform.readTableFromDatabase(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), FormatUtils.replace((String)"targetExternalId", (String)targetExternalId, (String)trigger.getSourceTableName()))) == null) continue;
                tables.add(table);
            }
            if (tables.size() > 0) {
                return this.syncTriggers(tables, force);
            }
        }
        return true;
    }

    @Override
    public boolean syncTriggers(Table table, boolean force) {
        return this.syncTriggers(Arrays.asList(table), force);
    }

    @Override
    public boolean syncTriggers(List<Table> tables, boolean force) {
        if (this.clusterService.lock("SyncTriggers")) {
            boolean bl;
            TriggerRouterContext context = new TriggerRouterContext();
            long startTime = System.currentTimeMillis();
            try {
                this.fixMultipleActiveTriggerHistories(context);
                boolean ignoreCase = this.parameterService.is("db.metadata.ignore.case");
                long ts = System.currentTimeMillis();
                for (ITriggerCreationListener l : this.extensionService.getExtensionPointList(ITriggerCreationListener.class)) {
                    l.syncTriggersStarted();
                }
                context.incrementSyncTriggersStartedTime(System.currentTimeMillis() - ts);
                ts = System.currentTimeMillis();
                List<Trigger> triggersForCurrentNode = this.getTriggersForCurrentNode();
                context.incrementTriggersForCurrentNodeTime(System.currentTimeMillis() - ts);
                ts = System.currentTimeMillis();
                List<TriggerHistory> activeTriggerHistories = this.getActiveTriggerHistories();
                context.incrementActiveTriggerHistoriesTime(System.currentTimeMillis() - ts);
                Map<String, List<TriggerTableSupportingInfo>> triggerToTableSupportingInfo = this.getTriggerToTableSupportingInfo(triggersForCurrentNode, activeTriggerHistories, false, context);
                HashMap<Trigger, ArrayList<Table>> triggersToProcess = new HashMap<Trigger, ArrayList<Table>>();
                for (Table table : tables) {
                    IDatabasePlatform targetPlatform = this.symmetricDialect.getTargetPlatform(table.getName());
                    for (Trigger trigger : triggersForCurrentNode) {
                        if (!trigger.matches(table, targetPlatform.getDefaultCatalog(), targetPlatform.getDefaultSchema(), ignoreCase) || trigger.isSourceTableNameWildCarded() && trigger.isSourceTableNameExpanded() && this.containsExactMatchForSourceTableName(table, triggersForCurrentNode, ignoreCase)) continue;
                        ArrayList<Table> l = (ArrayList<Table>)triggersToProcess.get(trigger);
                        if (l == null) {
                            l = new ArrayList<Table>();
                            triggersToProcess.put(trigger, l);
                        }
                        l.add(table);
                    }
                }
                if (triggersToProcess.size() > 0) {
                    context.incrementTriggersToSyncCount(triggersToProcess.size());
                    for (Map.Entry entry : triggersToProcess.entrySet()) {
                        Trigger trigger = (Trigger)entry.getKey();
                        List l = (List)entry.getValue();
                        List<TriggerTableSupportingInfo> triggerTableSupportingInfoList = triggerToTableSupportingInfo.get(trigger.getTriggerId());
                        for (Table table : l) {
                            TriggerTableSupportingInfo triggerTableSupportingInfo = null;
                            for (TriggerTableSupportingInfo t : triggerTableSupportingInfoList) {
                                if (!this.getFullyQualifiedTableName(t.getTable()).equals(this.getFullyQualifiedTableName(table))) continue;
                                triggerTableSupportingInfo = t;
                                break;
                            }
                            if (triggerTableSupportingInfo != null) {
                                this.log.info("Synchronizing triggers for {}", (Object)table.getFullyQualifiedTableName());
                                ts = System.currentTimeMillis();
                                this.updateOrCreateDatabaseTriggers(trigger, triggerTableSupportingInfo.getTable(), null, force, true, activeTriggerHistories, triggerTableSupportingInfo, context);
                                context.incrementUpdateOrCreateDatabaseTriggersTime(System.currentTimeMillis() - ts);
                                this.log.info("Done synchronizing triggers for {}", (Object)table.getFullyQualifiedTableName());
                                continue;
                            }
                            this.handleTableNotFound(trigger, activeTriggerHistories, context);
                        }
                    }
                }
                this.logTriggerRouterContextTimings(context);
                this.statisticManager.addJobStats("SyncTriggers", startTime, System.currentTimeMillis(), (long)context.getTriggersSyncedCount(), context.getErrorMessage());
                bl = true;
            }
            catch (RuntimeException e) {
                try {
                    this.statisticManager.addJobStats("SyncTriggers", startTime, System.currentTimeMillis(), (long)context.getTriggersSyncedCount(), e);
                    throw e;
                }
                catch (Throwable throwable) {
                    this.logTriggerRouterContextAnomalies(context);
                    this.clusterService.unlock("SyncTriggers");
                    long ts = System.currentTimeMillis();
                    for (ITriggerCreationListener l : this.extensionService.getExtensionPointList(ITriggerCreationListener.class)) {
                        l.syncTriggersEnded();
                    }
                    context.incrementSyncTriggersEndedTime(System.currentTimeMillis() - ts);
                    throw throwable;
                }
            }
            this.logTriggerRouterContextAnomalies(context);
            this.clusterService.unlock("SyncTriggers");
            long l = System.currentTimeMillis();
            for (ITriggerCreationListener l2 : this.extensionService.getExtensionPointList(ITriggerCreationListener.class)) {
                l2.syncTriggersEnded();
            }
            context.incrementSyncTriggersEndedTime(System.currentTimeMillis() - l);
            return bl;
        }
        return false;
    }

    protected String getFullyQualifiedTableName(Table table) {
        IDatabasePlatform targetPlatform = this.symmetricDialect.getTargetPlatform(table.getName());
        String catalog = StringUtils.isNotBlank((CharSequence)table.getCatalog()) ? table.getCatalog() : targetPlatform.getDefaultCatalog();
        String schema = StringUtils.isNotBlank((CharSequence)table.getSchema()) ? table.getSchema() : targetPlatform.getDefaultSchema();
        return Table.getFullyQualifiedTableName((String)catalog, (String)schema, (String)table.getName());
    }

    protected void updateOrCreateDdlTriggers(StringBuilder sqlBuffer) {
        String allDdlTriggerName = this.tablePrefix + "_on_all_ddl";
        String filteredDdlTriggerName = this.tablePrefix + "_on_filtered_ddl";
        boolean isCapture = this.parameterService.is("trigger.capture.ddl.changes", false);
        boolean isFiltered = this.parameterService.is("trigger.capture.ddl.check.trigger.hist", true);
        boolean allDdlTriggerExists = this.getTargetDialect().doesDdlTriggerExist(this.getTargetPlatform().getDefaultCatalog(), this.getTargetPlatform().getDefaultSchema(), allDdlTriggerName);
        boolean filteredDdlTriggerExists = this.getTargetDialect().doesDdlTriggerExist(this.getTargetPlatform().getDefaultCatalog(), this.getTargetPlatform().getDefaultSchema(), filteredDdlTriggerName);
        if (isCapture) {
            if (isFiltered) {
                if (allDdlTriggerExists) {
                    this.getTargetDialect().removeDdlTrigger(sqlBuffer, this.getTargetPlatform().getDefaultCatalog(), this.getTargetPlatform().getDefaultSchema(), allDdlTriggerName);
                }
                if (!filteredDdlTriggerExists) {
                    this.getTargetDialect().createDdlTrigger(this.tablePrefix, sqlBuffer, filteredDdlTriggerName, this.platform.getDefaultCatalog(), this.platform.getDefaultSchema());
                }
            } else {
                if (!allDdlTriggerExists) {
                    this.getTargetDialect().createDdlTrigger(this.tablePrefix, sqlBuffer, allDdlTriggerName, this.platform.getDefaultCatalog(), this.platform.getDefaultSchema());
                }
                if (filteredDdlTriggerExists) {
                    this.getTargetDialect().removeDdlTrigger(sqlBuffer, this.getTargetPlatform().getDefaultCatalog(), this.getTargetPlatform().getDefaultSchema(), filteredDdlTriggerName);
                }
            }
        } else {
            if (allDdlTriggerExists) {
                this.getTargetDialect().removeDdlTrigger(sqlBuffer, this.platform.getDefaultCatalog(), this.platform.getDefaultSchema(), allDdlTriggerName);
            }
            if (filteredDdlTriggerExists) {
                this.getTargetDialect().removeDdlTrigger(sqlBuffer, this.platform.getDefaultCatalog(), this.platform.getDefaultSchema(), filteredDdlTriggerName);
            }
        }
    }

    protected void updateOrCreateDatabaseTriggers(final List<Trigger> triggers, final StringBuilder sqlBuffer, final boolean force, final boolean verifyInDatabase, final List<TriggerHistory> activeTriggerHistories, final boolean useTableCache, final TriggerRouterContext triggerRouterContext) {
        final Map<String, List<TriggerTableSupportingInfo>> triggerToTableSupportingInfo = this.getTriggerToTableSupportingInfo(triggers, activeTriggerHistories, useTableCache, triggerRouterContext);
        int numThreads = this.getNumberOfThreadsToUseForSyncTriggers();
        ExecutorService executor = Executors.newFixedThreadPool(numThreads, new SyncTriggersThreadFactory());
        ArrayList futures = new ArrayList();
        for (final Trigger trigger : triggers) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    MDC.put((String)"engineName", (String)TriggerRouterService.this.parameterService.getEngineName());
                    TriggerRouterService.this.updateOrCreateDatabaseTrigger(trigger, triggers, sqlBuffer, force, verifyInDatabase, activeTriggerHistories, useTableCache, triggerToTableSupportingInfo, triggerRouterContext);
                }
            };
            futures.add(executor.submit(task));
        }
        this.awaitTermination(executor, futures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<TriggerTableSupportingInfo>> getTriggerToTableSupportingInfo(List<Trigger> triggers, List<TriggerHistory> activeTriggerHistories, boolean useTableCache, TriggerRouterContext triggerRouterContext) {
        HashMap<String, List<TriggerTableSupportingInfo>> triggerToTableSupportingInfo = new HashMap<String, List<TriggerTableSupportingInfo>>();
        ArrayList<String> triggerNamesGeneratedThisSession = new ArrayList<String>();
        for (Trigger trigger : triggers) {
            ArrayList<TriggerTableSupportingInfo> triggerTableSupportingInfoList = new ArrayList<TriggerTableSupportingInfo>();
            Set<Table> tables = this.getTablesForTrigger(trigger, triggers, useTableCache, triggerRouterContext);
            long ts = System.currentTimeMillis();
            Iterator<Table> iterator = tables.iterator();
            while (iterator.hasNext()) {
                TriggerHistory latestHistoryBeforeRebuild;
                Column[] columns;
                Table table;
                Table modifiedTable = table = iterator.next();
                boolean foundPk = false;
                for (Column column : columns = trigger.filterExcludedAndIncludedColumns(modifiedTable.getColumns())) {
                    if (foundPk |= column.isPrimaryKey()) break;
                }
                if (!foundPk) {
                    modifiedTable = this.platform.makeAllColumnsPrimaryKeys(modifiedTable);
                }
                List<TriggerHistory> list = activeTriggerHistories;
                synchronized (list) {
                    latestHistoryBeforeRebuild = this.getNewestTriggerHistoryForTrigger(activeTriggerHistories, trigger.getTriggerId(), trigger.isSourceCatalogNameWildCarded() ? modifiedTable.getCatalog() : trigger.getSourceCatalogNameUnescaped(), trigger.isSourceSchemaNameWildCarded() ? modifiedTable.getSchema() : trigger.getSourceSchemaNameUnescaped(), trigger.isSourceTableNameWildCarded() || trigger.isSourceTableNameExpanded() ? modifiedTable.getName() : trigger.getSourceTableNameUnescaped());
                }
                int maxTriggerNameLength = this.symmetricDialect.getMaxTriggerNameLength();
                String insertTriggerName = null;
                String updateTriggerName = null;
                String deleteTriggerName = null;
                if (trigger.isSyncOnInsert()) {
                    insertTriggerName = this.getTriggerName(DataEventType.INSERT, maxTriggerNameLength, trigger, modifiedTable, activeTriggerHistories, latestHistoryBeforeRebuild, triggerNamesGeneratedThisSession).toUpperCase();
                    triggerNamesGeneratedThisSession.add(insertTriggerName);
                }
                if (trigger.isSyncOnUpdate()) {
                    updateTriggerName = this.getTriggerName(DataEventType.UPDATE, maxTriggerNameLength, trigger, modifiedTable, activeTriggerHistories, latestHistoryBeforeRebuild, triggerNamesGeneratedThisSession).toUpperCase();
                    triggerNamesGeneratedThisSession.add(updateTriggerName);
                }
                if (trigger.isSyncOnDelete()) {
                    deleteTriggerName = this.getTriggerName(DataEventType.DELETE, maxTriggerNameLength, trigger, modifiedTable, activeTriggerHistories, latestHistoryBeforeRebuild, triggerNamesGeneratedThisSession).toUpperCase();
                    triggerNamesGeneratedThisSession.add(deleteTriggerName);
                }
                TriggerTableSupportingInfo triggerTableSupportingInfo = new TriggerTableSupportingInfo(trigger.getTriggerId(), insertTriggerName, updateTriggerName, deleteTriggerName, latestHistoryBeforeRebuild, modifiedTable);
                triggerTableSupportingInfoList.add(triggerTableSupportingInfo);
            }
            triggerToTableSupportingInfo.put(trigger.getTriggerId(), triggerTableSupportingInfoList);
            triggerRouterContext.incrementTriggerToTableSupportingInfoTime(System.currentTimeMillis() - ts);
        }
        return triggerToTableSupportingInfo;
    }

    protected void updateOrCreateDatabaseTrigger(Trigger trigger, List<Trigger> triggers, StringBuilder sqlBuffer, boolean force, boolean verifyInDatabase, List<TriggerHistory> activeTriggerHistories, boolean useTableCache, Map<String, List<TriggerTableSupportingInfo>> triggerToTableSupportingInfo, TriggerRouterContext context) {
        List<TriggerTableSupportingInfo> triggerTableSupportingInfoList = triggerToTableSupportingInfo.get(trigger.getTriggerId());
        if (triggerTableSupportingInfoList != null && triggerTableSupportingInfoList.size() > 0) {
            for (TriggerTableSupportingInfo triggerTableSupportingInfo : triggerTableSupportingInfoList) {
                long ts = System.currentTimeMillis();
                this.updateOrCreateDatabaseTriggers(trigger, triggerTableSupportingInfo.getTable(), sqlBuffer, force, verifyInDatabase, activeTriggerHistories, triggerTableSupportingInfo, context);
                context.incrementUpdateOrCreateDatabaseTriggersTime(System.currentTimeMillis() - ts);
            }
        } else {
            this.handleTableNotFound(trigger, activeTriggerHistories, context);
        }
    }

    @Override
    public void syncTrigger(Trigger trigger, ITriggerCreationListener listener, boolean force) {
        this.syncTrigger(trigger, listener, force, true);
    }

    @Override
    public void syncTrigger(Trigger trigger, ITriggerCreationListener listener, boolean force, boolean verifyInDatabase) {
        this.syncTriggers(Collections.singletonList(trigger), listener, force, verifyInDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean syncTriggers(List<Trigger> triggers, ITriggerCreationListener listener, boolean force, boolean verifyInDatabase) {
        if (this.clusterService.lock("SyncTriggers")) {
            TriggerRouterContext context = new TriggerRouterContext();
            long startTime = System.currentTimeMillis();
            try {
                long ts;
                this.fixMultipleActiveTriggerHistories(context);
                this.clearCache();
                List<Object> triggersForCurrentNode = null;
                if (verifyInDatabase) {
                    ts = System.currentTimeMillis();
                    triggersForCurrentNode = this.getTriggersForCurrentNode();
                    context.incrementTriggersForCurrentNodeTime(System.currentTimeMillis() - ts);
                } else {
                    triggersForCurrentNode = new ArrayList();
                    triggersForCurrentNode.addAll(triggers);
                }
                try {
                    if (listener != null) {
                        this.extensionService.addExtensionPoint(listener);
                    }
                    this.log.info("Synchronizing {} triggers", (Object)triggers.size());
                    context.incrementTriggersToSyncCount(triggers.size());
                    ts = System.currentTimeMillis();
                    for (ITriggerCreationListener l : this.extensionService.getExtensionPointList(ITriggerCreationListener.class)) {
                        l.syncTriggersStarted();
                    }
                    context.incrementSyncTriggersStartedTime(System.currentTimeMillis() - ts);
                    ts = System.currentTimeMillis();
                    List<TriggerHistory> allHistories = this.getActiveTriggerHistories();
                    context.incrementActiveTriggerHistoriesTime(System.currentTimeMillis() - ts);
                    HashMap<String, ArrayList<TriggerHistory>> activeHistoryByTriggerId = new HashMap<String, ArrayList<TriggerHistory>>();
                    for (TriggerHistory hist : allHistories) {
                        ArrayList<TriggerHistory> list = (ArrayList<TriggerHistory>)activeHistoryByTriggerId.get(hist.getTriggerId());
                        if (list == null) {
                            list = new ArrayList<TriggerHistory>();
                            activeHistoryByTriggerId.put(hist.getTriggerId(), list);
                        }
                        list.add(hist);
                    }
                    for (Trigger trigger : triggers) {
                        List activeHistories;
                        if (triggersForCurrentNode.contains(trigger)) {
                            if (!trigger.isSourceTableNameWildCarded() && !trigger.isSourceTableNameExpanded()) {
                                activeHistories = (List)activeHistoryByTriggerId.get(trigger.getTriggerId());
                                if (activeHistories != null) {
                                    for (Object triggerHistory : activeHistories) {
                                        if (((TriggerHistory)triggerHistory).getFullyQualifiedSourceTableName().equals(trigger.getFullyQualifiedSourceTableName())) continue;
                                        this.dropTriggers((TriggerHistory)triggerHistory, null, context);
                                    }
                                }
                            } else if (trigger.isSourceTableNameWildCarded()) {
                                Object triggerHistory;
                                Set<Table> tables = this.getTablesForTrigger(trigger, triggers, verifyInDatabase, context);
                                HashSet<String> fullyQualifiedTableNames = new HashSet<String>();
                                triggerHistory = tables.iterator();
                                while (triggerHistory.hasNext()) {
                                    Table table = (Table)triggerHistory.next();
                                    fullyQualifiedTableNames.add(table.getFullyQualifiedTableName());
                                }
                                List activeHistories2 = (List)activeHistoryByTriggerId.get(trigger.getTriggerId());
                                if (activeHistories2 != null) {
                                    for (TriggerHistory triggerHistory2 : activeHistories2) {
                                        if (fullyQualifiedTableNames.contains(triggerHistory2.getFullyQualifiedSourceTableName())) continue;
                                        this.dropTriggers(triggerHistory2, null, context);
                                    }
                                }
                            }
                            Map<String, List<TriggerTableSupportingInfo>> triggerToTableSupportingInfo = this.getTriggerToTableSupportingInfo(Collections.singletonList(trigger), allHistories, true, context);
                            this.updateOrCreateDatabaseTrigger(trigger, triggersForCurrentNode, null, force, verifyInDatabase, allHistories, false, triggerToTableSupportingInfo, context);
                            continue;
                        }
                        activeHistories = (List)activeHistoryByTriggerId.get(trigger.getTriggerId());
                        if (activeHistories == null) continue;
                        for (Object triggerHistory : activeHistories) {
                            this.dropTriggers((TriggerHistory)triggerHistory, null, context);
                        }
                    }
                    this.statisticManager.addJobStats("SyncTriggers", startTime, System.currentTimeMillis(), (long)context.getTriggersSyncedCount(), context.getErrorMessage());
                }
                finally {
                    ts = System.currentTimeMillis();
                    for (ITriggerCreationListener l : this.extensionService.getExtensionPointList(ITriggerCreationListener.class)) {
                        l.syncTriggersEnded();
                    }
                    context.incrementSyncTriggersEndedTime(System.currentTimeMillis() - ts);
                    if (listener != null) {
                        this.extensionService.removeExtensionPoint(listener);
                    }
                    this.logTriggerRouterContextTimings(context);
                    this.logTriggerRouterContextAnomalies(context);
                    this.log.info("Done synchronizing {} triggers", (Object)triggers.size());
                }
                boolean bl = true;
                return bl;
            }
            catch (RuntimeException e) {
                this.statisticManager.addJobStats("SyncTriggers", startTime, System.currentTimeMillis(), (long)context.getTriggersSyncedCount(), e);
                throw e;
            }
            finally {
                this.clusterService.unlock("SyncTriggers");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOrCreateDatabaseTriggers(Trigger trigger, Table table, StringBuilder sqlBuffer, boolean force, boolean verifyInDatabase, List<TriggerHistory> activeTriggerHistories, TriggerTableSupportingInfo triggerTableSupportingInfo, TriggerRouterContext context) {
        block22: {
            Channel channel;
            TriggerHistory latestHistoryBeforeRebuild = triggerTableSupportingInfo.getLatestHistoryBeforeRebuild();
            TriggerHistory newestHistory = null;
            TriggerReBuildReason reason = TriggerReBuildReason.NEW_TRIGGERS;
            if (verifyInDatabase && (channel = this.configurationService.getChannel(trigger.getChannelId())) == null) {
                this.log.warn("Trigger '{}' has a channel of '{}' not found in sym_channel table", (Object)trigger.getTriggerId(), (Object)trigger.getChannelId());
            }
            trigger.setSyncOnIncomingBatch(trigger.isSyncOnIncomingBatch() && !this.configurationService.isMasterToMasterOnly());
            try {
                boolean forceRebuildOfTriggers = false;
                if (latestHistoryBeforeRebuild == null) {
                    reason = TriggerReBuildReason.NEW_TRIGGERS;
                    forceRebuildOfTriggers = true;
                } else if (table.calculateTableHashcode() != latestHistoryBeforeRebuild.getTableHash()) {
                    reason = TriggerReBuildReason.TABLE_SCHEMA_CHANGED;
                    forceRebuildOfTriggers = true;
                } else if (trigger.hasChangedSinceLastTriggerBuild(latestHistoryBeforeRebuild.getCreateTime()) || trigger.toHashedValue() != latestHistoryBeforeRebuild.getTriggerRowHash()) {
                    reason = TriggerReBuildReason.TABLE_SYNC_CONFIGURATION_CHANGED;
                    forceRebuildOfTriggers = true;
                } else if ((long)this.symmetricDialect.getTriggerTemplate().toHashedValue() != latestHistoryBeforeRebuild.getTriggerTemplateHash()) {
                    reason = TriggerReBuildReason.TRIGGER_TEMPLATE_CHANGED;
                    forceRebuildOfTriggers = true;
                } else if (force) {
                    reason = TriggerReBuildReason.FORCED;
                    forceRebuildOfTriggers = true;
                }
                boolean supportsTriggers = this.symmetricDialect.getPlatform().getDatabaseInfo().isTriggersSupported();
                newestHistory = this.rebuildTriggerIfNecessary(sqlBuffer, forceRebuildOfTriggers, trigger, DataEventType.INSERT, reason, latestHistoryBeforeRebuild, null, trigger.isSyncOnInsert() && supportsTriggers, table, activeTriggerHistories, triggerTableSupportingInfo);
                newestHistory = this.rebuildTriggerIfNecessary(sqlBuffer, forceRebuildOfTriggers, trigger, DataEventType.UPDATE, reason, latestHistoryBeforeRebuild, newestHistory, trigger.isSyncOnUpdate() && supportsTriggers, table, activeTriggerHistories, triggerTableSupportingInfo);
                newestHistory = this.rebuildTriggerIfNecessary(sqlBuffer, forceRebuildOfTriggers, trigger, DataEventType.DELETE, reason, latestHistoryBeforeRebuild, newestHistory, trigger.isSyncOnDelete() && supportsTriggers, table, activeTriggerHistories, triggerTableSupportingInfo);
                if (latestHistoryBeforeRebuild != null && newestHistory != null) {
                    this.inactivateTriggerHistory(latestHistoryBeforeRebuild);
                }
                context.incrementTriggersSyncedCount(1);
                if (newestHistory != null) {
                    if (this.parameterService.is("auto.sync.triggers")) {
                        for (ITriggerCreationListener l : this.extensionService.getExtensionPointList(ITriggerCreationListener.class)) {
                            l.triggerCreated(context.getTriggersToSyncCount(), context.getTriggersSyncedCount(), trigger, newestHistory);
                        }
                    }
                    List<TriggerHistory> list = activeTriggerHistories;
                    synchronized (list) {
                        activeTriggerHistories.add(newestHistory);
                        break block22;
                    }
                }
                for (ITriggerCreationListener l : this.extensionService.getExtensionPointList(ITriggerCreationListener.class)) {
                    l.triggerChecked(context.getTriggersToSyncCount(), context.getTriggersSyncedCount());
                }
            }
            catch (Exception ex) {
                boolean usingTargetDialect;
                this.log.error(String.format("Failed to create triggers for %s", trigger.qualifiedSourceTableName()), (Throwable)ex);
                this.invalidateTriggerHistory(newestHistory, ex);
                boolean bl = usingTargetDialect = !this.getSymmetricDialect().equals(this.getTargetDialect()) && !trigger.getSourceTableName().startsWith(this.getSymmetricDialect().getTablePrefix());
                if (newestHistory != null && !usingTargetDialect) {
                    this.dropTriggers(newestHistory, sqlBuffer);
                }
                context.incrementTriggersSyncedCount(1);
                context.addTriggersFailed(trigger.qualifiedSourceTableName(), ex);
                for (ITriggerCreationListener l : this.extensionService.getExtensionPointList(ITriggerCreationListener.class)) {
                    l.triggerFailed(context.getTriggersToSyncCount(), context.getTriggersSyncedCount(), trigger, ex);
                }
            }
        }
    }

    protected TriggerHistory rebuildTriggerIfNecessary(StringBuilder sqlBuffer, boolean forceRebuild, Trigger trigger, DataEventType dmlType, TriggerReBuildReason reason, TriggerHistory oldhist, TriggerHistory hist, boolean triggerIsActive, Table table, List<TriggerHistory> activeTriggerHistories, TriggerTableSupportingInfo triggerTableSupportingInfo) {
        try {
            return this.rebuildTriggerIfNecessaryWithException(sqlBuffer, forceRebuild, trigger, dmlType, reason, oldhist, hist, triggerIsActive, table, activeTriggerHistories, triggerTableSupportingInfo);
        }
        catch (Exception e) {
            SQLException se = ExceptionUtils.unwrapSqlException((Throwable)e);
            IDatabasePlatform platform = this.symmetricDialect.getTargetPlatform(table.getName());
            if (se != null && se.getMessage() != null && platform.getName().startsWith("mssql") && se.getErrorCode() == 207) {
                this.log.error("Retrying trigger for {} after exception {} [{}]: {}", new Object[]{table.getName(), e.getClass().getName(), se.getErrorCode(), e.getMessage()});
                table = platform.readTableFromDatabase(table.getCatalog(), table.getSchema(), table.getName());
                if (table != null) {
                    return this.rebuildTriggerIfNecessaryWithException(sqlBuffer, forceRebuild, trigger, dmlType, reason, oldhist, hist, triggerIsActive, table, activeTriggerHistories, triggerTableSupportingInfo);
                }
            } else if (platform.getSqlTemplate().isDeadlock((Throwable)e)) {
                this.log.error("Retrying trigger for {} after deadlock {} [{}]: {}", new Object[]{table.getName(), e.getClass().getName(), se.getErrorCode(), e.getMessage()});
                return this.rebuildTriggerIfNecessaryWithException(sqlBuffer, forceRebuild, trigger, dmlType, reason, oldhist, hist, triggerIsActive, table, activeTriggerHistories, triggerTableSupportingInfo);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TriggerHistory rebuildTriggerIfNecessaryWithException(StringBuilder sqlBuffer, boolean forceRebuild, Trigger trigger, DataEventType dmlType, TriggerReBuildReason reason, TriggerHistory oldhist, TriggerHistory hist, boolean triggerIsActive, Table table, List<TriggerHistory> activeTriggerHistories, TriggerTableSupportingInfo triggerTableSupportingInfo) {
        boolean triggerExists = false;
        boolean triggerRemoved = false;
        boolean usingTargetDialect = false;
        if (!this.getSymmetricDialect().equals(this.getTargetDialect()) && !trigger.getSourceTableName().startsWith(this.getSymmetricDialect().getTablePrefix())) {
            usingTargetDialect = true;
        }
        TriggerHistory newTriggerHist = new TriggerHistory(table, trigger, usingTargetDialect ? this.getTargetDialect().getTriggerTemplate() : this.getSymmetricDialect().getTriggerTemplate(), reason);
        if (usingTargetDialect) {
            if (hist == null && (oldhist == null || forceRebuild)) {
                this.insert(newTriggerHist);
                List<TriggerHistory> list = activeTriggerHistories;
                synchronized (list) {
                    activeTriggerHistories.add(newTriggerHist);
                    this.historyMap.put(newTriggerHist.getTriggerHistoryId(), newTriggerHist);
                    hist = this.getNewestTriggerHistoryForTrigger(activeTriggerHistories, trigger.getTriggerId(), trigger.isSourceCatalogNameWildCarded() ? table.getCatalog() : trigger.getSourceCatalogNameUnescaped(), trigger.isSourceSchemaNameWildCarded() ? table.getSchema() : trigger.getSourceSchemaNameUnescaped(), trigger.isSourceTableNameWildCarded() || trigger.isSourceTableNameExpanded() ? table.getName() : trigger.getSourceTableNameUnescaped());
                }
            }
            if (hist == null) {
                hist = this.historyMap.get(newTriggerHist.getTriggerHistoryId());
            }
            return hist;
        }
        if (trigger.isSyncOnInsert()) {
            newTriggerHist.setNameForInsertTrigger(triggerTableSupportingInfo.getInsertTriggerName());
        }
        if (trigger.isSyncOnUpdate()) {
            newTriggerHist.setNameForUpdateTrigger(triggerTableSupportingInfo.getUpdateTriggerName());
        }
        if (trigger.isSyncOnDelete()) {
            newTriggerHist.setNameForDeleteTrigger(triggerTableSupportingInfo.getDeleteTriggerName());
        }
        String oldTriggerName = null;
        String oldSourceSchema = null;
        String oldCatalogName = null;
        if (oldhist != null) {
            oldTriggerName = oldhist.getTriggerNameForDmlType(dmlType);
            if (oldTriggerName == null) {
                oldTriggerName = this.getTriggerName(dmlType, triggerTableSupportingInfo);
            }
            oldSourceSchema = oldhist.getSourceSchemaName();
            oldCatalogName = oldhist.getSourceCatalogName();
            triggerExists = this.symmetricDialect.doesTriggerExist(sqlBuffer, oldCatalogName, oldSourceSchema, oldhist.getSourceTableName(), oldTriggerName);
        } else {
            oldTriggerName = newTriggerHist.getTriggerNameForDmlType(dmlType);
            oldSourceSchema = table.getSchema();
            oldCatalogName = table.getCatalog();
            if (StringUtils.isNotBlank((CharSequence)oldTriggerName)) {
                triggerExists = this.symmetricDialect.doesTriggerExist(sqlBuffer, oldCatalogName, oldSourceSchema, table.getName(), oldTriggerName);
            }
        }
        ISqlTransaction transaction = null;
        try {
            boolean isDeadTrigger;
            transaction = this.sqlTemplate.startSqlTransaction(this.platform.getDatabaseInfo().isRequiresAutoCommitForDdl());
            if ((forceRebuild || !triggerIsActive) && triggerExists) {
                if (!(triggerIsActive && this.platform.getDatabaseInfo().isTriggersCreateOrReplaceSupported() && oldTriggerName.equalsIgnoreCase(newTriggerHist.getTriggerNameForDmlType(dmlType)))) {
                    this.symmetricDialect.removeTrigger(sqlBuffer, oldCatalogName, oldSourceSchema, oldTriggerName, trigger.isSourceTableNameWildCarded() || trigger.isSourceTableNameExpanded() ? table.getName() : trigger.getSourceTableNameUnescaped(), transaction);
                    triggerRemoved = true;
                }
                triggerExists = false;
            }
            boolean bl = isDeadTrigger = !trigger.isSyncOnInsert() && !trigger.isSyncOnUpdate() && !trigger.isSyncOnDelete();
            if (hist == null && (oldhist == null || !triggerExists && triggerIsActive || isDeadTrigger && forceRebuild)) {
                this.insert(newTriggerHist);
                List<TriggerHistory> list = activeTriggerHistories;
                synchronized (list) {
                    Iterator<TriggerHistory> it = activeTriggerHistories.iterator();
                    while (it.hasNext()) {
                        TriggerHistory triggerHistory = it.next();
                        if (!StringUtils.equals((CharSequence)triggerHistory.getSourceCatalogName(), (CharSequence)newTriggerHist.getSourceCatalogName()) || !StringUtils.equals((CharSequence)triggerHistory.getSourceSchemaName(), (CharSequence)newTriggerHist.getSourceSchemaName()) || !StringUtils.equals((CharSequence)triggerHistory.getSourceTableName(), (CharSequence)newTriggerHist.getSourceTableName())) continue;
                        it.remove();
                    }
                    activeTriggerHistories.add(newTriggerHist);
                    this.historyMap.put(newTriggerHist.getTriggerHistoryId(), newTriggerHist);
                    hist = this.getNewestTriggerHistoryForTrigger(activeTriggerHistories, trigger.getTriggerId(), trigger.isSourceCatalogNameWildCarded() ? table.getCatalog() : trigger.getSourceCatalogNameUnescaped(), trigger.isSourceSchemaNameWildCarded() ? table.getSchema() : trigger.getSourceSchemaNameUnescaped(), trigger.isSourceTableNameWildCarded() || trigger.isSourceTableNameExpanded() ? table.getName() : trigger.getSourceTableNameUnescaped());
                }
            }
            try {
                if (!triggerExists && triggerIsActive) {
                    this.symmetricDialect.createTrigger(sqlBuffer, dmlType, trigger, hist, this.configurationService.getChannel(trigger.getChannelId()), this.tablePrefix, table, transaction);
                    if (triggerRemoved) {
                        this.statisticManager.incrementTriggersRebuiltCount(1L);
                    } else {
                        this.statisticManager.incrementTriggersCreatedCount(1L);
                    }
                } else if (triggerRemoved) {
                    this.statisticManager.incrementTriggersRemovedCount(1L);
                }
                transaction.commit();
            }
            catch (RuntimeException ex) {
                this.invalidateTriggerHistory(hist, ex);
                throw ex;
            }
        }
        catch (Throwable ex) {
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.close(transaction);
                throw throwable;
            }
        }
        this.close(transaction);
        return hist;
    }

    @Override
    public String getTriggerName(DataEventType dml, int maxTriggerNameLength, Trigger trigger, Table table, List<TriggerHistory> activeTriggerHistories, TriggerHistory oldhist, List<String> triggerNamesGeneratedThisSession) {
        Object triggerName = null;
        switch (dml) {
            case INSERT: {
                if (StringUtils.isBlank((CharSequence)trigger.getNameForInsertTrigger())) break;
                triggerName = trigger.getNameForInsertTrigger();
                break;
            }
            case UPDATE: {
                if (StringUtils.isBlank((CharSequence)trigger.getNameForUpdateTrigger())) break;
                triggerName = trigger.getNameForUpdateTrigger();
                break;
            }
            case DELETE: {
                if (StringUtils.isBlank((CharSequence)trigger.getNameForDeleteTrigger())) break;
                triggerName = trigger.getNameForDeleteTrigger();
                break;
            }
        }
        if (StringUtils.isBlank(triggerName)) {
            String triggerPrefix = this.parameterService.getString("sync.trigger.prefix", this.tablePrefix);
            String triggerPrefix1 = triggerPrefix + "_";
            String triggerSuffix1 = "on_" + dml.getCode().toLowerCase() + "_for_";
            String triggerSuffix2 = FormatUtils.replaceCharsToShortenName((String)trigger.getTriggerId());
            if (trigger.isSourceTableNameWildCarded()) {
                triggerSuffix2 = FormatUtils.replaceCharsToShortenName((String)table.getName());
            } else if (trigger.isSourceTableNameExpanded()) {
                triggerSuffix2 = FormatUtils.replaceCharsToShortenName((String)table.getName());
            }
            String triggerSuffix3 = FormatUtils.replaceCharsToShortenName((String)("_" + this.parameterService.getNodeGroupId()));
            triggerName = triggerPrefix1 + triggerSuffix1 + triggerSuffix2 + triggerSuffix3;
            if (((String)triggerName).length() > maxTriggerNameLength && maxTriggerNameLength > 0) {
                triggerName = triggerPrefix1 + triggerSuffix1 + triggerSuffix2;
            }
        }
        if (((String)(triggerName = ((String)triggerName).toUpperCase())).length() > maxTriggerNameLength && maxTriggerNameLength > 0) {
            triggerName = ((String)triggerName).substring(0, maxTriggerNameLength - 1);
            this.log.debug("We just truncated the trigger name for the {} trigger id={}.  You might want to consider manually providing a name for the trigger that is less than {} characters long", new Object[]{dml.name().toLowerCase(), trigger.getTriggerId(), maxTriggerNameLength});
        }
        int duplicateCount = 0;
        while (this.isTriggerNameInUse(activeTriggerHistories, trigger, (String)triggerName, oldhist, triggerNamesGeneratedThisSession)) {
            String duplicateSuffix = Integer.toString(++duplicateCount);
            if (((String)triggerName).length() + duplicateSuffix.length() > maxTriggerNameLength) {
                triggerName = ((String)triggerName).substring(0, ((String)triggerName).length() - duplicateSuffix.length()) + duplicateSuffix;
                continue;
            }
            triggerName = (String)triggerName + duplicateSuffix;
        }
        return triggerName;
    }

    public String getTriggerName(DataEventType dml, TriggerTableSupportingInfo triggerTableSupportingInfo) {
        String triggerName = null;
        switch (dml) {
            case INSERT: {
                triggerName = triggerTableSupportingInfo.getInsertTriggerName();
                break;
            }
            case UPDATE: {
                triggerName = triggerTableSupportingInfo.getUpdateTriggerName();
                break;
            }
            case DELETE: {
                triggerName = triggerTableSupportingInfo.getDeleteTriggerName();
                break;
            }
        }
        return triggerName;
    }

    @Override
    public Map<Trigger, Exception> getFailedTriggers() {
        return this.failureListener.getFailures();
    }

    @Override
    public TriggerHistory findTriggerHistoryForGenericSync() {
        String triggerTableName = TableConstants.getTableName(this.tablePrefix, "node");
        try {
            Collection<TriggerHistory> histories = this.historyMap.values();
            for (TriggerHistory triggerHistory : histories) {
                if (!triggerHistory.getSourceTableName().equalsIgnoreCase(triggerTableName) || triggerHistory.getInactiveTime() != null) continue;
                return triggerHistory;
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to find trigger history for generic sync", (Throwable)e);
        }
        TriggerHistory history = this.findTriggerHistory(null, null, triggerTableName.toUpperCase());
        if (history == null) {
            history = this.findTriggerHistory(null, null, triggerTableName);
        }
        return history;
    }

    @Override
    public Map<Integer, List<TriggerRouter>> fillTriggerRoutersByHistIdAndSortHist(String sourceNodeGroupId, String targetNodeGroupId, String targetExternalId, List<TriggerHistory> triggerHistories, boolean sortByFk) {
        return this.fillTriggerRoutersByHistIdAndSortHist(sourceNodeGroupId, targetNodeGroupId, targetExternalId, triggerHistories, this.getAllTriggerRoutersForReloadForCurrentNode(sourceNodeGroupId, targetNodeGroupId), sortByFk);
    }

    @Override
    public Map<Integer, List<TriggerRouter>> fillTriggerRoutersByHistIdAndSortHist(String sourceNodeGroupId, String targetNodeGroupId, String targetExternalId, List<TriggerHistory> triggerHistories, List<TriggerRouter> triggerRouters, final boolean sortByFk) {
        final Map<Integer, List<TriggerRouter>> triggerRoutersByHistoryId = this.fillTriggerRoutersByHistId(sourceNodeGroupId, targetNodeGroupId, targetExternalId, triggerHistories, triggerRouters);
        List<Table> tables = null;
        if (sortByFk) {
            tables = this.getSortedTablesFor(triggerHistories);
        }
        final List<Table> sortedTables = tables;
        Comparator<TriggerHistory> comparator = new Comparator<TriggerHistory>(){

            @Override
            public int compare(TriggerHistory o1, TriggerHistory o2) {
                List triggerRoutersForTriggerHist1 = (List)triggerRoutersByHistoryId.get(o1.getTriggerHistoryId());
                int intialLoadOrder1 = 0;
                for (TriggerRouter triggerRouter1 : triggerRoutersForTriggerHist1) {
                    if (triggerRouter1.getInitialLoadOrder() <= intialLoadOrder1) continue;
                    intialLoadOrder1 = triggerRouter1.getInitialLoadOrder();
                }
                List triggerRoutersForTriggerHist2 = (List)triggerRoutersByHistoryId.get(o2.getTriggerHistoryId());
                int intialLoadOrder2 = 0;
                for (TriggerRouter triggerRouter2 : triggerRoutersForTriggerHist2) {
                    if (triggerRouter2.getInitialLoadOrder() <= intialLoadOrder2) continue;
                    intialLoadOrder2 = triggerRouter2.getInitialLoadOrder();
                }
                if (intialLoadOrder1 < intialLoadOrder2) {
                    return -1;
                }
                if (intialLoadOrder1 > intialLoadOrder2) {
                    return 1;
                }
                if (sortByFk) {
                    Table table1 = null;
                    if (!o1.getSourceTableName().startsWith(TriggerRouterService.this.tablePrefix)) {
                        table1 = TriggerRouterService.this.getTargetPlatform().getTableFromCache(o1.getSourceCatalogName(), o1.getSourceSchemaName(), o1.getSourceTableName(), false);
                    }
                    if (table1 == null) {
                        TriggerRouterService.this.platform.getTableFromCache(o1.getSourceCatalogName(), o1.getSourceSchemaName(), o1.getSourceTableName(), false);
                    }
                    Table table2 = null;
                    if (!o2.getSourceTableName().startsWith(TriggerRouterService.this.tablePrefix)) {
                        table2 = TriggerRouterService.this.getTargetPlatform().getTableFromCache(o2.getSourceCatalogName(), o2.getSourceSchemaName(), o2.getSourceTableName(), false);
                    }
                    if (table2 == null) {
                        TriggerRouterService.this.platform.getTableFromCache(o2.getSourceCatalogName(), o2.getSourceSchemaName(), o2.getSourceTableName(), false);
                    }
                    return Integer.valueOf(sortedTables.indexOf(table1)).compareTo(sortedTables.indexOf(table2));
                }
                return o1.getSourceTableName().compareTo(o2.getSourceTableName());
            }
        };
        Collections.sort(triggerHistories, comparator);
        return triggerRoutersByHistoryId;
    }

    @Override
    public Map<Integer, List<TriggerRouter>> fillTriggerRoutersByHistId(String sourceNodeGroupId, String targetNodeGroupId, String targetExternalId, List<TriggerHistory> triggerHistories) {
        return this.fillTriggerRoutersByHistId(sourceNodeGroupId, targetNodeGroupId, targetExternalId, triggerHistories, this.getAllTriggerRoutersForReloadForCurrentNode(sourceNodeGroupId, targetNodeGroupId));
    }

    protected Map<Integer, List<TriggerRouter>> fillTriggerRoutersByHistId(String sourceNodeGroupId, String targetNodeGroupId, String targetExternalId, List<TriggerHistory> triggerHistories, List<TriggerRouter> triggerRouters) {
        triggerRouters = new ArrayList<TriggerRouter>(triggerRouters);
        HashMap<Integer, List<TriggerRouter>> triggerRoutersByHistoryId = new HashMap<Integer, List<TriggerRouter>>(triggerHistories.size());
        for (TriggerHistory triggerHistory : triggerHistories) {
            ArrayList<TriggerRouter> triggerRoutersForTriggerHistory = new ArrayList<TriggerRouter>();
            triggerRoutersByHistoryId.put(triggerHistory.getTriggerHistoryId(), triggerRoutersForTriggerHistory);
            String triggerId = triggerHistory.getTriggerId();
            for (TriggerRouter triggerRouter : triggerRouters) {
                if (!triggerRouter.getTrigger().getTriggerId().equals(triggerId) || triggerRouter.getTrigger().getSourceTableName().contains("$(targetExternalId)") && !triggerRouter.getTrigger().getSourceTableName().replace("$(targetExternalId)", targetExternalId).equalsIgnoreCase(triggerHistory.getSourceTableName())) continue;
                triggerRoutersForTriggerHistory.add(triggerRouter);
            }
        }
        return triggerRoutersByHistoryId;
    }

    @Override
    public List<Table> getSortedTablesFor(List<TriggerHistory> histories) {
        return Database.sortByForeignKeys(this.getTablesFor(histories), null, null, null);
    }

    @Override
    public List<Table> getTablesFor(List<TriggerHistory> histories) {
        ArrayList<Table> tables = new ArrayList<Table>(histories.size());
        for (TriggerHistory triggerHistory : histories) {
            Table table = null;
            if (!triggerHistory.getSourceTableName().startsWith(this.tablePrefix)) {
                table = this.getTargetPlatform().getTableFromCache(triggerHistory.getSourceCatalogName(), triggerHistory.getSourceSchemaName(), triggerHistory.getSourceTableName(), false);
            }
            if (table == null) {
                table = this.platform.getTableFromCache(triggerHistory.getSourceCatalogName(), triggerHistory.getSourceSchemaName(), triggerHistory.getSourceTableName(), false);
            }
            if (table == null) continue;
            tables.add(table);
        }
        return tables;
    }

    protected void awaitTermination(ExecutorService executor, List<Future<?>> futures) {
        long timeout = this.parameterService.getLong("sync.triggers.timeout.in.seconds", 3600L);
        executor.shutdown();
        try {
            if (executor.awaitTermination(timeout, TimeUnit.SECONDS)) {
                for (Future<?> future : futures) {
                    if (!future.isDone()) continue;
                    future.get();
                }
            } else {
                this.log.warn("Timeout of {} reached for {}", (Object)timeout, (Object)"sync.triggers.timeout.in.seconds");
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            throw new RuntimeException(e);
        }
    }

    protected void fixMultipleActiveTriggerHistories(TriggerRouterContext triggerRouterContext) {
        if (this.parameterService.is("sync.triggers.fix.duplicate.active.trigger.histories", true)) {
            List<TriggerHistory> multiples = this.getMultipleActiveTriggerHistories();
            if (multiples.size() > 0) {
                this.log.info("Fixing " + multiples.size() + " trigger histories with multiple active entries");
            }
            for (TriggerHistory triggerHistory : multiples) {
                List<TriggerHistory> th = this.getTriggerHistoryIds(triggerHistory);
                boolean first = true;
                for (TriggerHistory thLocal : th) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    triggerRouterContext.incrementMultipleActiveTriggerRouterCount(thLocal.getTriggerHistoryId());
                    this.log.info("Marking trigger history ID " + thLocal.getTriggerHistoryId() + " inactive.");
                    long ts = System.currentTimeMillis();
                    this.inactivateTriggerHistory(thLocal);
                    triggerRouterContext.incrementInactivateTriggerHistTime(System.currentTimeMillis() - ts);
                }
            }
        }
    }

    protected List<TriggerHistory> getMultipleActiveTriggerHistories() {
        if ("ase".equals(this.getTargetPlatform().getName())) {
            List<TriggerHistory> activeHistoryList = this.getActiveTriggerHistories();
            ArrayList<SimpleTriggerHistory> activeSimpleHistoryList = new ArrayList<SimpleTriggerHistory>();
            for (TriggerHistory history2 : activeHistoryList) {
                activeSimpleHistoryList.add(new SimpleTriggerHistory(history2));
            }
            HashSet activeSimpleHistorySet = new HashSet();
            return activeSimpleHistoryList.stream().filter(history -> !activeSimpleHistorySet.add(history)).distinct().collect(Collectors.toList());
        }
        return this.sqlTemplate.query(this.getSql("multipleActiveTriggerHistSql"), (ISqlRowMapper)new TriggerHistoryMapper(), new Object[0]);
    }

    protected List<TriggerHistory> getTriggerHistoryIds(TriggerHistory triggerHistory) {
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(this.getSql("selectTriggerHistIdSql")).append(" where trigger_id=? and source_table_name=?");
        values.add(triggerHistory.getTriggerId());
        values.add(triggerHistory.getSourceTableName());
        sb.append(" and source_catalog_name");
        if (StringUtils.isBlank((CharSequence)triggerHistory.getSourceCatalogName())) {
            sb.append(" is null ");
        } else {
            sb.append("=? ");
            values.add(triggerHistory.getSourceCatalogName());
        }
        sb.append(" and source_schema_name");
        if (StringUtils.isBlank((CharSequence)triggerHistory.getSourceSchemaName())) {
            sb.append(" is null ");
        } else {
            sb.append("=? ");
            values.add(triggerHistory.getSourceSchemaName());
        }
        sb.append(" and inactive_time is null");
        sb.append(" order by trigger_hist_id desc ");
        return this.sqlTemplate.query(sb.toString(), (ISqlRowMapper)new TriggerHistoryMapper(), values.toArray());
    }

    protected void logTriggerRouterContextAnomalies(TriggerRouterContext triggerRouterContext) {
        Iterator<Object> iterator = triggerRouterContext.getMultipleActiveTriggerRouterKeyset().iterator();
        while (iterator.hasNext()) {
            int triggerHistoryId = iterator.next();
            this.log.info("Marked trigger history ID {} inactive.", (Object)triggerHistoryId);
        }
        for (String triggerId : triggerRouterContext.getTriggerReadTableFromDatabaseKeyset()) {
            long databaseReadCount = triggerRouterContext.getTriggerReadTableFromDatabaseCount(triggerId);
            if (databaseReadCount <= 2L) continue;
            long copyCount = triggerRouterContext.getTriggerCopyTableCount(triggerId);
            this.log.info("The trigger {} read table {} times from the database, and made {} copies of the table.", new Object[]{triggerId, databaseReadCount, copyCount});
        }
    }

    protected void logTriggerRouterContextTimings(TriggerRouterContext triggerRouterContext) {
        this.log.info("SyncTriggers: fix multiple active trigger histories took {} ms", (Object)triggerRouterContext.getFixMultipleActiveTriggerHistoriesTime());
        this.log.info("SyncTriggers: get triggers for current node took {} ms", (Object)triggerRouterContext.getTriggersForCurrentNodeTime());
        this.log.info("SyncTriggers: sync triggers started took {} ms", (Object)triggerRouterContext.getSyncTriggersStartedTime());
        this.log.info("SyncTriggers: get active trigger histories took {} ms", (Object)triggerRouterContext.getActiveTriggerHistoriesTime());
        this.log.info("SyncTriggers: update or create ddl triggers took {} ms", (Object)triggerRouterContext.getUpdateOrCreateDdlTriggersTime());
        this.log.info("SyncTriggers: sync triggers ended took {} ms", (Object)triggerRouterContext.getSyncTriggersEndedTime());
        this.log.info("SyncTriggers: tables for trigger took {} ms", (Object)triggerRouterContext.getTablesForTriggerTime());
        this.log.info("SyncTriggers: drop trigger took {} ms", (Object)triggerRouterContext.getDropTriggerTime());
        this.log.info("SyncTriggers: trigger inactivated took {} ms", (Object)triggerRouterContext.getTriggerInactivatedTime());
        this.log.info("SyncTriggers: does trigger exist took {} ms", (Object)triggerRouterContext.getDoesTriggerExistTime());
        this.log.info("SyncTriggers: inactivate trigger hist took {} ms", (Object)triggerRouterContext.getInactivateTriggerHistTime());
        this.log.info("SyncTriggers: update or create database trigger took {} ms", (Object)triggerRouterContext.getUpdateOrCreateDatabaseTriggersTime());
        this.log.info("SyncTriggers: trigger to table supporting info took {} ms", (Object)triggerRouterContext.getTriggerToTableSupportingInfoTime());
        this.log.info("SyncTriggers: table does not exist took {} ms", (Object)triggerRouterContext.getTableDoesNotExistTime());
    }

    static class TriggerMapper
    implements ISqlRowMapper<Trigger> {
        TriggerMapper() {
        }

        public Trigger mapRow(Row rs) {
            String text;
            Trigger trigger = new Trigger();
            trigger.setTriggerId(rs.getString("trigger_id"));
            trigger.setChannelId(rs.getString("channel_id"));
            trigger.setReloadChannelId(rs.getString("reload_channel_id"));
            trigger.setSourceTableName(rs.getString("source_table_name"));
            trigger.setSyncOnInsert(rs.getBoolean("sync_on_insert"));
            trigger.setSyncOnUpdate(rs.getBoolean("sync_on_update"));
            trigger.setSyncOnDelete(rs.getBoolean("sync_on_delete"));
            trigger.setSyncOnIncomingBatch(rs.getBoolean("sync_on_incoming_batch"));
            trigger.setUseStreamLobs(rs.getBoolean("use_stream_lobs"));
            trigger.setUseCaptureLobs(rs.getBoolean("use_capture_lobs"));
            trigger.setUseCaptureOldData(rs.getBoolean("use_capture_old_data"));
            trigger.setUseHandleKeyUpdates(rs.getBoolean("use_handle_key_updates"));
            trigger.setNameForDeleteTrigger(rs.getString("name_for_delete_trigger"));
            trigger.setNameForInsertTrigger(rs.getString("name_for_insert_trigger"));
            trigger.setNameForUpdateTrigger(rs.getString("name_for_update_trigger"));
            trigger.setStreamRow(rs.getBoolean("stream_row"));
            String schema = rs.getString("source_schema_name");
            trigger.setSourceSchemaName(schema);
            String catalog = rs.getString("source_catalog_name");
            trigger.setSourceCatalogName(catalog);
            String condition = rs.getString("sync_on_insert_condition");
            if (!StringUtils.isBlank((CharSequence)condition)) {
                trigger.setSyncOnInsertCondition(condition);
            }
            if (!StringUtils.isBlank((CharSequence)(condition = rs.getString("sync_on_update_condition")))) {
                trigger.setSyncOnUpdateCondition(condition);
            }
            if (!StringUtils.isBlank((CharSequence)(condition = rs.getString("sync_on_delete_condition")))) {
                trigger.setSyncOnDeleteCondition(condition);
            }
            if (!StringUtils.isBlank((CharSequence)(text = rs.getString("custom_on_insert_text")))) {
                trigger.setCustomOnInsertText(text);
            }
            if (!StringUtils.isBlank((CharSequence)(text = rs.getString("custom_on_update_text")))) {
                trigger.setCustomOnUpdateText(text);
            }
            if (!StringUtils.isBlank((CharSequence)(text = rs.getString("custom_on_delete_text")))) {
                trigger.setCustomOnDeleteText(text);
            }
            if (!StringUtils.isBlank((CharSequence)(text = rs.getString("custom_before_insert_text")))) {
                trigger.setCustomBeforeInsertText(text);
            }
            if (!StringUtils.isBlank((CharSequence)(text = rs.getString("custom_before_update_text")))) {
                trigger.setCustomBeforeUpdateText(text);
            }
            if (!StringUtils.isBlank((CharSequence)(text = rs.getString("custom_before_delete_text")))) {
                trigger.setCustomBeforeDeleteText(text);
            }
            if (!StringUtils.isBlank((CharSequence)(condition = rs.getString("external_select")))) {
                trigger.setExternalSelect(condition);
            }
            trigger.setChannelExpression(rs.getString("channel_expression"));
            trigger.setTxIdExpression(rs.getString("tx_id_expression"));
            trigger.setCreateTime(rs.getDateTime("create_time"));
            trigger.setLastUpdateTime(rs.getDateTime("last_update_time"));
            trigger.setLastUpdateBy(rs.getString("last_update_by"));
            trigger.setExcludedColumnNames(rs.getString("excluded_column_names"));
            trigger.setIncludedColumnNames(rs.getString("included_column_names"));
            trigger.setSyncKeyNames(rs.getString("sync_key_names"));
            if (rs.containsKey((Object)"time_based_column_name")) {
                trigger.setTimeBasedCaptureColumn(rs.getString("time_based_column_name"));
            }
            return trigger;
        }
    }

    static class TriggerHistoryMapper
    implements ISqlRowMapper<TriggerHistory> {
        IParameterService parameterService;
        Map<Long, TriggerHistory> retMap = null;

        TriggerHistoryMapper() {
        }

        TriggerHistoryMapper(Map<Long, TriggerHistory> map) {
            this.retMap = map;
        }

        public TriggerHistory mapRow(Row rs) {
            TriggerHistory hist = new TriggerHistory();
            if (rs.containsKey((Object)"trigger_hist_id")) {
                hist.setTriggerHistoryId(rs.getInt("trigger_hist_id"));
            }
            if (rs.containsKey((Object)"trigger_id")) {
                hist.setTriggerId(rs.getString("trigger_id"));
            }
            if (rs.containsKey((Object)"source_table_name")) {
                hist.setSourceTableName(rs.getString("source_table_name"));
            }
            if (rs.containsKey((Object)"table_hash")) {
                hist.setTableHash(rs.getInt("table_hash"));
            }
            if (rs.containsKey((Object)"create_time")) {
                hist.setCreateTime(rs.getDateTime("create_time"));
            }
            if (rs.containsKey((Object)"pk_column_names")) {
                hist.setPkColumnNames(rs.getString("pk_column_names"));
            }
            if (rs.containsKey((Object)"column_names")) {
                hist.setColumnNames(rs.getString("column_names"));
            }
            if (rs.containsKey((Object)"is_missing_pk")) {
                hist.setIsMissingPk(rs.getBoolean("is_missing_pk"));
            }
            if (rs.containsKey((Object)"last_trigger_build_reason")) {
                hist.setLastTriggerBuildReason(TriggerReBuildReason.fromCode(rs.getString("last_trigger_build_reason")));
            }
            if (rs.containsKey((Object)"name_for_delete_trigger")) {
                hist.setNameForDeleteTrigger(rs.getString("name_for_delete_trigger"));
            }
            if (rs.containsKey((Object)"name_for_insert_trigger")) {
                hist.setNameForInsertTrigger(rs.getString("name_for_insert_trigger"));
            }
            if (rs.containsKey((Object)"name_for_update_trigger")) {
                hist.setNameForUpdateTrigger(rs.getString("name_for_update_trigger"));
            }
            if (rs.containsKey((Object)"source_schema_name")) {
                hist.setSourceSchemaName(rs.getString("source_schema_name"));
            }
            if (rs.containsKey((Object)"source_catalog_name")) {
                hist.setSourceCatalogName(rs.getString("source_catalog_name"));
            }
            if (rs.containsKey((Object)"trigger_row_hash")) {
                hist.setTriggerRowHash(rs.getLong("trigger_row_hash"));
            }
            if (rs.containsKey((Object)"trigger_template_hash")) {
                hist.setTriggerTemplateHash(rs.getLong("trigger_template_hash"));
            }
            if (rs.containsKey((Object)"error_message")) {
                hist.setErrorMessage(rs.getString("error_message"));
            }
            if (this.retMap != null) {
                this.retMap.put(Long.valueOf(hist.getTriggerHistoryId()), hist);
            }
            return hist;
        }
    }

    static class LastTriggerHistoryMapper
    extends TriggerHistoryMapper {
        Map<String, TriggerHistory> map = null;

        LastTriggerHistoryMapper(Map<String, TriggerHistory> map) {
            this.map = map;
        }

        @Override
        public TriggerHistory mapRow(Row rs) {
            TriggerHistory hist = super.mapRow(rs);
            this.map.put(hist.getTriggerId(), hist);
            return null;
        }
    }

    static class RouterMapper
    implements ISqlRowMapper<Router> {
        List<NodeGroupLink> nodeGroupLinks;

        public RouterMapper(List<NodeGroupLink> nodeGroupLinks) {
            this.nodeGroupLinks = nodeGroupLinks;
        }

        private NodeGroupLink getNodeGroupLink(String sourceNodeGroupId, String targetNodeGroupId) {
            for (NodeGroupLink nodeGroupLink : this.nodeGroupLinks) {
                if (!nodeGroupLink.getSourceNodeGroupId().equals(sourceNodeGroupId) || !nodeGroupLink.getTargetNodeGroupId().equals(targetNodeGroupId)) continue;
                return nodeGroupLink;
            }
            return null;
        }

        public Router mapRow(Row rs) {
            Router router = new Router();
            router.setSyncOnInsert(rs.getBoolean("r_sync_on_insert"));
            router.setSyncOnUpdate(rs.getBoolean("r_sync_on_update"));
            router.setSyncOnDelete(rs.getBoolean("r_sync_on_delete"));
            router.setTargetCatalogName(StringUtils.trimToNull((String)rs.getString("target_catalog_name")));
            router.setNodeGroupLink(this.getNodeGroupLink(rs.getString("source_node_group_id"), rs.getString("target_node_group_id")));
            router.setTargetSchemaName(StringUtils.trimToNull((String)rs.getString("target_schema_name")));
            router.setTargetTableName(StringUtils.trimToNull((String)rs.getString("target_table_name")));
            String condition = StringUtils.trimToNull((String)rs.getString("router_expression"));
            if (!StringUtils.isBlank((CharSequence)condition)) {
                router.setRouterExpression(condition);
            }
            router.setRouterType(rs.getString("router_type"));
            router.setRouterId(rs.getString("router_id"));
            router.setUseSourceCatalogSchema(rs.getBoolean("use_source_catalog_schema"));
            router.setCreateTime(rs.getDateTime("r_create_time"));
            router.setLastUpdateTime(rs.getDateTime("r_last_update_time"));
            router.setLastUpdateBy(rs.getString("r_last_update_by"));
            return router;
        }
    }

    static class TriggerRouterMapper
    implements ISqlRowMapper<TriggerRouter> {
        public TriggerRouter mapRow(Row rs) {
            TriggerRouter triggerRouter = new TriggerRouter();
            Trigger trigger = new Trigger();
            trigger.setTriggerId(rs.getString("trigger_id"));
            triggerRouter.setTrigger(trigger);
            Router router = new Router();
            router.setRouterId(rs.getString("router_id"));
            triggerRouter.setRouter(router);
            triggerRouter.setCreateTime(rs.getDateTime("create_time"));
            triggerRouter.setLastUpdateTime(rs.getDateTime("last_update_time"));
            triggerRouter.setLastUpdateBy(rs.getString("last_update_by"));
            triggerRouter.setInitialLoadOrder(rs.getInt("initial_load_order"));
            triggerRouter.setInitialLoadSelect(StringUtils.trimToNull((String)rs.getString("initial_load_select")));
            triggerRouter.setEnabled(rs.getBoolean("enabled"));
            triggerRouter.setInitialLoadDeleteStmt(StringUtils.trimToNull((String)rs.getString("initial_load_delete_stmt")));
            triggerRouter.setPingBackEnabled(rs.getBoolean("ping_back_enabled"));
            if (rs.containsKey((Object)"data_refresh_type")) {
                triggerRouter.setDataRefreshType(rs.getString("data_refresh_type"));
            }
            return triggerRouter;
        }
    }

    class SyncTriggersThreadFactory
    implements ThreadFactory {
        AtomicInteger threadNumber = new AtomicInteger(1);
        String namePrefix;

        SyncTriggersThreadFactory() {
            this.namePrefix = TriggerRouterService.this.parameterService.getEngineName().toLowerCase() + "-sync-triggers-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName(this.namePrefix + this.threadNumber.getAndIncrement());
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    class TriggerTableSupportingInfo {
        private String triggerId;
        private String insertTriggerName;
        private String updateTriggerName;
        private String deleteTriggerName;
        private TriggerHistory latestHistoryBeforeRebuild;
        private Table table;

        public TriggerTableSupportingInfo(String triggerId, String insertTriggerName, String updaterTriggerName, String deleteTriggerName, TriggerHistory latestHistoryBeforeRebuild, Table table) {
            this.triggerId = triggerId;
            this.insertTriggerName = insertTriggerName;
            this.updateTriggerName = updaterTriggerName;
            this.deleteTriggerName = deleteTriggerName;
            this.latestHistoryBeforeRebuild = latestHistoryBeforeRebuild;
            this.table = table;
        }

        public String getInsertTriggerName() {
            return this.insertTriggerName;
        }

        public void setInsertTriggerName(String insertTriggerName) {
            this.insertTriggerName = insertTriggerName;
        }

        public String getUpdateTriggerName() {
            return this.updateTriggerName;
        }

        public void setUpdateTriggerName(String updateTriggerName) {
            this.updateTriggerName = updateTriggerName;
        }

        public String getDeleteTriggerName() {
            return this.deleteTriggerName;
        }

        public void setDeleteTriggerName(String deleteTriggerName) {
            this.deleteTriggerName = deleteTriggerName;
        }

        public TriggerHistory getLatestHistoryBeforeRebuild() {
            return this.latestHistoryBeforeRebuild;
        }

        public void setLatestHistoryBeforeRebuild(TriggerHistory latestHistoryBeforeRebuild) {
            this.latestHistoryBeforeRebuild = latestHistoryBeforeRebuild;
        }

        public Table getTable() {
            return this.table;
        }

        public void setTable(Table table) {
            this.table = table;
        }

        public String getTriggerId() {
            return this.triggerId;
        }

        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }
    }

    class SimpleTriggerHistory
    extends TriggerHistory {
        private static final long serialVersionUID = 1L;

        public SimpleTriggerHistory(TriggerHistory history) {
            this.setTriggerId(history.getTriggerId());
            this.setSourceTableName(history.getSourceTableName());
            this.setSourceSchemaName(history.getSourceSchemaName());
            this.setSourceCatalogName(history.getSourceCatalogName());
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceCatalogName() == null ? 0 : this.getSourceCatalogName().hashCode());
            result = 31 * result + (this.getSourceSchemaName() == null ? 0 : this.getSourceSchemaName().hashCode());
            result = 31 * result + (this.getSourceTableName() == null ? 0 : this.getSourceTableName().hashCode());
            result = 31 * result + (this.getTriggerId() == null ? 0 : this.getTriggerId().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleTriggerHistory other = (SimpleTriggerHistory)obj;
            if (this.getSourceCatalogName() == null ? other.getSourceCatalogName() != null : !this.getSourceCatalogName().equals(other.getSourceCatalogName())) {
                return false;
            }
            if (this.getSourceSchemaName() == null ? other.getSourceSchemaName() != null : !this.getSourceSchemaName().equals(other.getSourceSchemaName())) {
                return false;
            }
            if (this.getSourceTableName() == null ? other.getSourceTableName() != null : !this.getSourceTableName().equals(other.getSourceTableName())) {
                return false;
            }
            return !(this.getTriggerId() == null ? other.getTriggerId() != null : !this.getTriggerId().equals(other.getTriggerId()));
        }
    }
}

