/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.statistic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IStatisticService;
import org.jumpmind.symmetric.statistic.ChannelStats;
import org.jumpmind.symmetric.statistic.HostStats;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.statistic.JobStats;
import org.jumpmind.symmetric.statistic.NodeStatsByPeriodMap;
import org.jumpmind.symmetric.statistic.RouterStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticManager
implements IStatisticManager {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String UNKNOWN = "Unknown";
    private static final int NUMBER_OF_PERMITS = 1000;
    private Map<String, ChannelStats> channelStats = new ConcurrentHashMap<String, ChannelStats>();
    private List<JobStats> jobStats = new ArrayList<JobStats>();
    private HostStats hostStats;
    private ConcurrentHashMap<Long, RouterStats> routerStatsByBatch = new ConcurrentHashMap();
    protected INodeService nodeService;
    protected IStatisticService statisticService;
    protected IParameterService parameterService;
    protected IConfigurationService configurationService;
    protected IClusterService clusterService;
    protected Semaphore channelStatsLock = new Semaphore(1000, true);
    protected Semaphore hostStatsLock = new Semaphore(1000, true);
    protected Semaphore jobStatsLock = new Semaphore(1000, true);
    protected Semaphore tableStatsLock = new Semaphore(1000, true);
    protected Map<ProcessInfoKey, ProcessInfo> processInfos = new ConcurrentHashMap<ProcessInfoKey, ProcessInfo>();
    protected Map<ProcessInfoKey, ProcessInfo> processInfosThatHaveDoneWork = new ConcurrentHashMap<ProcessInfoKey, ProcessInfo>();
    private Map<Date, Map<String, ChannelStats>> baseChannelStatsInMemory = new LinkedHashMap<Date, Map<String, ChannelStats>>();

    public StatisticManager(IParameterService parameterService, INodeService nodeService, IConfigurationService configurationService, IStatisticService statisticsService, IClusterService clusterService) {
        this.parameterService = parameterService;
        this.nodeService = nodeService;
        this.configurationService = configurationService;
        this.statisticService = statisticsService;
        this.clusterService = clusterService;
        this.init();
    }

    protected void init() {
    }

    @Override
    public ProcessInfo newProcessInfo(ProcessInfoKey key) {
        ProcessInfo process = new ProcessInfo(key);
        ProcessInfo old = this.processInfos.get(key);
        if (old != null) {
            if (old.getStatus() != ProcessInfo.ProcessStatus.OK && old.getStatus() != ProcessInfo.ProcessStatus.ERROR) {
                this.log.warn("Starting a new process even though the previous '{}' process had not finished", (Object)old.getProcessType());
                this.log.info("Details from the previous process: {}", (Object)old);
            }
            if (old.getCurrentDataCount() > 0L || old.getTotalDataCount() > 0L) {
                this.processInfosThatHaveDoneWork.put(key, old);
            }
        }
        this.processInfos.put(key, process);
        return process;
    }

    @Override
    public Set<String> getNodesWithProcessesInError() {
        String identityNodeId = this.nodeService.findIdentityNodeId();
        HashSet<String> status = new HashSet<String>();
        if (identityNodeId != null) {
            List<ProcessInfo> list = this.getProcessInfos();
            for (ProcessInfo processInfo : list) {
                String nodeIdInError = processInfo.showInError(identityNodeId);
                if (nodeIdInError == null) continue;
                status.add(nodeIdInError);
            }
        }
        return status;
    }

    @Override
    public List<ProcessInfo> getProcessInfos() {
        ArrayList<ProcessInfo> list = new ArrayList<ProcessInfo>(this.processInfos.values());
        Collections.sort(list);
        return list;
    }

    @Override
    public List<ProcessInfo> getProcessInfosThatHaveDoneWork() {
        ArrayList<ProcessInfo> toReturn = new ArrayList<ProcessInfo>();
        ArrayList<ProcessInfo> infosList = new ArrayList<ProcessInfo>(this.processInfos.values());
        for (ProcessInfo info : infosList) {
            if (info.getStatus() == ProcessInfo.ProcessStatus.OK && info.getCurrentDataCount() == 0L) {
                ProcessInfo lastThatDidWork = this.processInfosThatHaveDoneWork.get(info.getKey());
                if (lastThatDidWork == null) continue;
                toReturn.add(lastThatDidWork.copy());
                continue;
            }
            toReturn.add(info.copy());
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobStats(String jobName, long startTime, long endTime, long processedCount) {
        this.jobStatsLock.acquireUninterruptibly();
        try {
            JobStats stats = new JobStats(jobName, startTime, endTime, processedCount);
            this.jobStats.add(stats);
        }
        finally {
            this.jobStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobStats(String jobName, long startTime, long endTime, long processedCount, String errorMessage) {
        this.jobStatsLock.acquireUninterruptibly();
        try {
            JobStats stats = new JobStats(jobName, startTime, endTime, processedCount, errorMessage);
            this.jobStats.add(stats);
        }
        finally {
            this.jobStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobStats(String jobName, long startTime, long endTime, long processedCount, Exception e) {
        this.jobStatsLock.acquireUninterruptibly();
        try {
            JobStats stats = new JobStats(jobName, startTime, endTime, processedCount, e);
            this.jobStats.add(stats);
        }
        finally {
            this.jobStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobStats(String targetNodeId, int targetNodeCount, String jobName, long startTime, long endTime, long processedCount) {
        this.jobStatsLock.acquireUninterruptibly();
        try {
            JobStats stats = new JobStats(targetNodeId, targetNodeCount, startTime, endTime, jobName, processedCount);
            this.jobStats.add(stats);
        }
        finally {
            this.jobStatsLock.release();
        }
    }

    @Override
    public RouterStats getRouterStatsByBatch(Long batchId) {
        return this.routerStatsByBatch.get(batchId);
    }

    @Override
    public void addRouterStats(long startDataId, long endDataId, long dataReadCount, long peekAheadFillCount, List<DataGap> dataGaps, Set<String> transactions, Collection<OutgoingBatch> batches) {
        RouterStats routerStats = new RouterStats(startDataId, endDataId, dataReadCount, peekAheadFillCount, dataGaps, transactions);
        for (OutgoingBatch batch : batches) {
            if (batch.getNodeId().equals("-1")) continue;
            this.routerStatsByBatch.put(batch.getBatchId(), routerStats);
        }
    }

    @Override
    public void removeRouterStatsByBatch(Long batchId) {
        this.routerStatsByBatch.remove(batchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataRouted(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataRouted(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataUnRouted(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).setDataUnRouted(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataExtracted(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataExtracted(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataBytesExtracted(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataBytesExtracted(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataExtractedErrors(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataExtractedErrors(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataEventInserted(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataEventInserted(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataSent(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataSent(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataBytesSent(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataBytesSent(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataSentErrors(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataSentErrors(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataLoaded(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataLoaded(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataBytesLoaded(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataBytesLoaded(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataLoadedErrors(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataLoadedErrors(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataLoadedOutgoing(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataLoadedOutgoing(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataBytesLoadedOutgoing(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataBytesLoadedOutgoing(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementDataLoadedOutgoingErrors(String channelId, long count) {
        this.channelStatsLock.acquireUninterruptibly();
        try {
            this.getChannelStats(channelId).incrementDataLoadedOutgoingErrors(count);
        }
        finally {
            this.channelStatsLock.release();
        }
    }

    @Override
    public void incrementRestart() {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementRestarted(1L);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementNodesPulled(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementNodesPulled(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementNodesPushed(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementNodesPushed(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementTotalNodesPulledTime(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementTotalNodesPullTime(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementTotalNodesPushedTime(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementTotalNodesPushTime(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementNodesRejected(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementNodesRejected(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementNodesRegistered(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementNodesRegistered(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementNodesLoaded(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementNodesLoaded(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementNodesDisabled(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementNodesDisabled(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementPurgedBatchIncomingRows(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementPurgedBatchIncomingRows(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementPurgedBatchOutgoingRows(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementPurgedBatchOutgoingRows(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementPurgedDataRows(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementPurgedDataRows(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementPurgedDataEventRows(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementPurgedDataEventRows(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementPurgedStrandedDataRows(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementPurgedStrandedDataRows(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementPurgedStrandedDataEventRows(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementPurgedStrandedDataEventRows(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementPurgedExpiredDataRows(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementPurgedExpiredDataRows(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementTriggersRemovedCount(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementTriggersRemovedCount(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementTriggersRebuiltCount(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementTriggersRebuiltCount(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    @Override
    public void incrementTriggersCreatedCount(long count) {
        this.hostStatsLock.acquireUninterruptibly();
        try {
            this.getHostStats().incrementTriggersCreatedCount(count);
        }
        finally {
            this.hostStatsLock.release();
        }
    }

    protected void saveAdditionalStats(Date endTime, ChannelStats stats) {
        if (this.baseChannelStatsInMemory.get(endTime) == null) {
            this.baseChannelStatsInMemory.put(endTime, new HashMap());
        }
        this.baseChannelStatsInMemory.get(endTime).put(stats.getChannelId(), stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Node node;
        boolean recordStatistics = this.parameterService.is("statistic.record.enable", false);
        long recordStatisticsCountThreshold = this.parameterService.getLong("statistic.record.count.threshold", -1L);
        if (this.channelStats != null) {
            this.channelStatsLock.acquireUninterruptibly(1000);
            try {
                if (recordStatistics) {
                    Date endTime = new Date();
                    for (ChannelStats channelStats : this.channelStats.values()) {
                        if (channelStats.getNodeId().equals(UNKNOWN) && (node = this.nodeService.getCachedIdentity()) != null) {
                            channelStats.setNodeId(node.getNodeId());
                        }
                        channelStats.setEndTime(endTime);
                        this.saveAdditionalStats(endTime, channelStats);
                        if (!channelStats.isNonZero()) continue;
                        this.statisticService.save(channelStats);
                    }
                }
                this.resetChannelStats(true);
            }
            finally {
                this.channelStatsLock.release(1000);
            }
        }
        int rowsLoaded = 0;
        int rowsSent = 0;
        for (Map.Entry<Date, Map<String, ChannelStats>> entry : this.baseChannelStatsInMemory.entrySet()) {
            for (Map.Entry<String, ChannelStats> channelEntry : entry.getValue().entrySet()) {
                if (channelEntry.getKey().equals("config") || channelEntry.getKey().equals("heartbeat")) continue;
                rowsLoaded = (int)((long)rowsLoaded + channelEntry.getValue().getDataLoaded());
                rowsSent = (int)((long)rowsSent + channelEntry.getValue().getDataSent());
            }
            if (rowsLoaded <= 0 && rowsSent <= 0) continue;
            this.log.debug("===================================");
            this.log.debug("Date: " + entry.getKey());
            this.log.debug("Rows Out: " + rowsSent);
            this.log.debug("Rows In: " + rowsLoaded);
            this.log.debug("===================================");
        }
        if (this.hostStats != null) {
            this.hostStatsLock.acquireUninterruptibly(1000);
            try {
                if (recordStatistics && this.hostStats.isNonZero()) {
                    Node node2;
                    if (this.hostStats.getNodeId().equals(UNKNOWN) && (node2 = this.nodeService.getCachedIdentity()) != null) {
                        this.hostStats.setNodeId(node2.getNodeId());
                    }
                    this.hostStats.setEndTime(new Date());
                    this.statisticService.save(this.hostStats);
                }
                this.hostStats = null;
            }
            finally {
                this.hostStatsLock.release(1000);
            }
        }
        if (this.jobStats != null) {
            List<JobStats> list;
            Object var6_11 = null;
            this.jobStatsLock.acquireUninterruptibly(1000);
            try {
                list = this.jobStats;
                this.jobStats = new ArrayList<JobStats>();
            }
            finally {
                this.jobStatsLock.release(1000);
            }
            if (list != null && recordStatistics && (node = this.nodeService.getCachedIdentity()) != null) {
                String nodeId = node.getNodeId();
                String serverId = this.clusterService.getServerId();
                for (JobStats stats : list) {
                    if (recordStatisticsCountThreshold == -1L || !stats.isErrorFlag() && stats.getProcessedCount() <= recordStatisticsCountThreshold) continue;
                    stats.setNodeId(nodeId);
                    stats.setHostName(serverId);
                    this.statisticService.save(stats);
                }
            }
        }
    }

    @Override
    public TreeMap<Date, Map<String, ChannelStats>> getNodeStatsForPeriod(Date start, Date end, String nodeId, int periodSizeInMinutes) {
        Map<String, ChannelStats> currentStats = this.getWorkingChannelStats();
        NodeStatsByPeriodMap savedStatsPeriodMap = (NodeStatsByPeriodMap)this.statisticService.getNodeStatsForPeriod(start, end, nodeId, periodSizeInMinutes);
        for (String key : currentStats.keySet()) {
            ChannelStats stat = currentStats.get(key);
            Date date = stat.getStartTime();
            savedStatsPeriodMap.add(date, stat);
        }
        return savedStatsPeriodMap;
    }

    @Override
    public Map<String, ChannelStats> getWorkingChannelStats() {
        if (this.channelStats != null) {
            HashMap<String, ChannelStats> stats = new HashMap<String, ChannelStats>();
            for (ChannelStats stat : this.channelStats.values()) {
                ChannelStats newStat = new ChannelStats(stat.getNodeId(), stat.getHostName(), stat.getStartTime(), stat.getEndTime(), stat.getChannelId());
                newStat.add(stat);
                stats.put(newStat.getChannelId(), newStat);
            }
            return stats;
        }
        return new HashMap<String, ChannelStats>();
    }

    @Override
    public List<JobStats> getWorkingJobStats() {
        if (this.jobStats != null) {
            ArrayList<JobStats> stats = new ArrayList<JobStats>();
            for (JobStats stat : this.jobStats) {
                stats.add(new JobStats(stat));
            }
            return stats;
        }
        return new ArrayList<JobStats>();
    }

    @Override
    public HostStats getWorkingHostStats() {
        if (this.hostStats != null) {
            return new HostStats(this.hostStats);
        }
        return new HostStats();
    }

    protected void resetChannelStats(boolean force) {
        if (force) {
            this.channelStats = null;
        }
        if (this.channelStats == null) {
            List<NodeChannel> channels = this.configurationService.getNodeChannels(false);
            this.channelStats = new HashMap<String, ChannelStats>(channels.size());
            for (NodeChannel nodeChannel : channels) {
                this.getChannelStats(nodeChannel.getChannelId());
            }
        }
    }

    protected ChannelStats getChannelStats(String channelId) {
        this.resetChannelStats(false);
        ChannelStats stats = this.channelStats.get(channelId);
        if (stats == null) {
            Node node = this.nodeService.getCachedIdentity();
            if (node != null) {
                stats = new ChannelStats(node.getNodeId(), this.clusterService.getServerId(), new Date(), null, channelId);
                this.channelStats.put(channelId, stats);
            } else {
                stats = new ChannelStats(UNKNOWN, this.clusterService.getServerId(), new Date(), null, channelId);
            }
        }
        return stats;
    }

    protected HostStats getHostStats() {
        if (this.hostStats == null) {
            Node node = this.nodeService.getCachedIdentity();
            this.hostStats = node != null ? new HostStats(node.getNodeId(), this.clusterService.getServerId(), new Date(), null) : new HostStats(UNKNOWN, this.clusterService.getServerId(), new Date(), null);
        }
        return this.hostStats;
    }

    @Override
    public void incrementTableRows(Map<String, Map<String, Long>> tableCounts, boolean loaded) {
    }

    @Override
    public String getMostRecentActiveTableSynced() {
        return "";
    }

    @Override
    public Map<Integer, Date> getTotalLoadedRows() {
        return null;
    }
}

