/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.http;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.jumpmind.exception.HttpException;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.InitialLoadPendingException;
import org.jumpmind.symmetric.service.RegistrationNotOpenException;
import org.jumpmind.symmetric.service.RegistrationPendingException;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.AuthenticationExpiredException;
import org.jumpmind.symmetric.transport.ConnectionDuplicateException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.NoReservationException;
import org.jumpmind.symmetric.transport.ServiceNotReadyException;
import org.jumpmind.symmetric.transport.ServiceUnavailableException;
import org.jumpmind.symmetric.transport.SyncDisabledException;
import org.jumpmind.symmetric.transport.http.HttpConnection;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;

public class HttpOutgoingTransport
implements IOutgoingWithResponseTransport {
    static final String CRLF = "\r\n";
    private String boundary;
    private HttpTransportManager httpTransportManager;
    private URL url;
    private OutputStream os;
    private BufferedWriter writer;
    private BufferedReader reader;
    private HttpConnection connection;
    private int httpTimeout;
    private int httpConnectTimeout;
    private boolean useCompression;
    private int compressionStrategy;
    private int compressionLevel;
    private String nodeId;
    private String securityToken;
    private boolean streamOutputEnabled = false;
    private int streamOutputChunkSize = 30720;
    private boolean fileUpload = false;
    private Map<String, String> requestProperties;

    public HttpOutgoingTransport(HttpTransportManager httpTransportManager, URL url, int httpTimeout, int httpConnectTimeout, boolean useCompression, int compressionStrategy, int compressionLevel, String nodeId, String securityToken, boolean streamOutputEnabled, int streamOutputSize, boolean fileUpload) {
        this.httpTransportManager = httpTransportManager;
        this.url = url;
        this.httpTimeout = httpTimeout;
        this.httpConnectTimeout = httpConnectTimeout;
        this.useCompression = useCompression;
        this.compressionLevel = compressionLevel;
        this.compressionStrategy = compressionStrategy;
        this.nodeId = nodeId;
        this.securityToken = securityToken;
        this.streamOutputChunkSize = streamOutputSize;
        this.streamOutputEnabled = streamOutputEnabled;
        this.fileUpload = fileUpload;
    }

    public HttpOutgoingTransport(HttpTransportManager httpTransportManager, URL url, int httpTimeout, int httpConnectTimeout, boolean useCompression, int compressionStrategy, int compressionLevel, String nodeId, String securityToken, boolean streamOutputEnabled, int streamOutputSize, boolean fileUpload, Map<String, String> requestProperties) {
        this(httpTransportManager, url, httpTimeout, httpConnectTimeout, useCompression, compressionStrategy, compressionLevel, nodeId, securityToken, streamOutputEnabled, streamOutputSize, fileUpload);
        this.requestProperties = requestProperties;
    }

    @Override
    public void close() {
        this.closeWriter(true);
        this.closeOutputStream(true);
        this.closeReader();
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
    }

    private void closeReader() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
    }

    private void closeOutputStream(boolean closeQuietly) {
        if (this.os != null) {
            try {
                if (this.fileUpload) {
                    IOUtils.write((String)("\r\n--" + this.boundary + "--\r\n"), (OutputStream)this.os, (Charset)Charset.defaultCharset());
                }
                this.os.flush();
            }
            catch (IOException ex) {
                throw new IoException((Exception)ex);
            }
            finally {
                if (closeQuietly) {
                    try {
                        this.os.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        this.os.close();
                    }
                    catch (IOException ex) {
                        throw new IoException((Exception)ex);
                    }
                }
                this.os = null;
            }
        }
    }

    private void closeWriter(boolean closeQuietly) {
        if (this.writer != null) {
            try {
                if (this.fileUpload) {
                    IOUtils.write((String)("\r\n--" + this.boundary + "--\r\n"), (OutputStream)this.os, (Charset)Charset.defaultCharset());
                }
                this.writer.flush();
            }
            catch (IOException ex) {
                throw new IoException((Exception)ex);
            }
            finally {
                if (closeQuietly) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        this.writer.close();
                    }
                    catch (IOException ex) {
                        throw new IoException((Exception)ex);
                    }
                }
                this.writer = null;
                this.os = null;
            }
        }
    }

    private HttpConnection requestReservation(String queue) {
        try {
            this.connection = this.httpTransportManager.openConnection(this.url, this.nodeId, this.securityToken);
            this.connection.setUseCaches(false);
            this.connection.setConnectTimeout(this.httpConnectTimeout);
            this.connection.setReadTimeout(this.httpTimeout);
            this.connection.setRequestMethod("HEAD");
            this.connection.setRequestProperty("threadChannel", queue);
            this.analyzeResponseCode(this.connection.getResponseCode());
            this.httpTransportManager.updateSession(this.connection);
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
        return this.connection;
    }

    @Override
    public OutputStream openStream() {
        try {
            this.connection = this.httpTransportManager.openConnection(this.url, this.nodeId, this.securityToken);
            if (this.streamOutputEnabled) {
                this.connection.setChunkedStreamingMode(this.streamOutputChunkSize);
            }
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
            this.connection.setConnectTimeout(this.httpConnectTimeout);
            this.connection.setReadTimeout(this.httpTimeout);
            if (this.requestProperties != null) {
                for (Map.Entry<String, String> requestProperty : this.requestProperties.entrySet()) {
                    this.connection.setRequestProperty(requestProperty.getKey(), requestProperty.getValue());
                }
            }
            if (!this.fileUpload) {
                this.connection.setRequestMethod("PUT");
                this.connection.setRequestProperty("Accept-Encoding", "gzip");
                if (this.useCompression) {
                    this.connection.addRequestProperty("Content-Type", "gzip");
                }
            } else {
                this.connection.setRequestMethod("POST");
                this.boundary = Long.toHexString(System.currentTimeMillis());
                this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
            }
            this.os = this.connection.getOutputStream();
            if (!this.fileUpload && this.useCompression) {
                this.os = new GZIPOutputStream(this.os, 128, true){
                    {
                        this.def.setLevel(HttpOutgoingTransport.this.compressionLevel);
                        this.def.setStrategy(HttpOutgoingTransport.this.compressionStrategy);
                    }
                };
            }
            if (this.fileUpload) {
                String fileName = "file.zip";
                IOUtils.write((String)("--" + this.boundary + CRLF), (OutputStream)this.os, (Charset)Charset.defaultCharset());
                IOUtils.write((String)"Content-Disposition: form-data; name=\"binaryFile\"; filename=\"file.zip\"\r\n", (OutputStream)this.os, (Charset)Charset.defaultCharset());
                IOUtils.write((String)("Content-Type: " + URLConnection.guessContentTypeFromName("file.zip") + CRLF), (OutputStream)this.os, (Charset)Charset.defaultCharset());
                IOUtils.write((String)"Content-Transfer-Encoding: binary\r\n\r\n", (OutputStream)this.os, (Charset)Charset.defaultCharset());
                this.os.flush();
            }
            return this.os;
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
    }

    @Override
    public BufferedWriter openWriter() {
        OutputStreamWriter wout = new OutputStreamWriter(this.openStream(), StandardCharsets.UTF_8);
        this.writer = new BufferedWriter(wout);
        return this.writer;
    }

    @Override
    public BufferedWriter getWriter() {
        return this.writer;
    }

    private void analyzeResponseCode(int code) {
        if (670 == code) {
            throw new ConnectionRejectedException();
        }
        if (660 == code) {
            throw new ServiceUnavailableException();
        }
        if (671 == code) {
            throw new ServiceNotReadyException();
        }
        if (604 == code) {
            throw new NoReservationException();
        }
        if (605 == code) {
            throw new ConnectionDuplicateException();
        }
        if (659 == code) {
            this.httpTransportManager.clearSession(this.connection);
            throw new AuthenticationException();
        }
        if (669 == code) {
            this.httpTransportManager.clearSession(this.connection);
            throw new AuthenticationExpiredException();
        }
        if (658 == code) {
            throw new SyncDisabledException();
        }
        if (657 == code) {
            throw new RegistrationRequiredException();
        }
        if (667 == code) {
            throw new RegistrationPendingException();
        }
        if (668 == code) {
            throw new InitialLoadPendingException();
        }
        if (656 == code) {
            throw new RegistrationNotOpenException();
        }
        if (code != 200) {
            throw new HttpException(code, "Received an unexpected response code of " + code + " from the server");
        }
    }

    @Override
    public BufferedReader readResponse() throws IOException {
        this.closeWriter(false);
        this.closeOutputStream(false);
        this.analyzeResponseCode(this.connection.getResponseCode());
        this.httpTransportManager.updateSession(this.connection);
        this.reader = HttpTransportManager.getReaderFrom(this.connection);
        return this.reader;
    }

    @Override
    public boolean isOpen() {
        return this.connection != null;
    }

    @Override
    public ChannelMap getSuspendIgnoreChannelLists(IConfigurationService configurationService, String queue, Node targetNode) {
        ChannelMap suspendIgnoreChannelsList = new ChannelMap();
        try (HttpConnection connection = this.requestReservation(queue);){
            String suspends = connection.getHeaderField("Suspended-Channels");
            String ignores = connection.getHeaderField("Ignored-Channels");
            suspendIgnoreChannelsList.addSuspendChannels(suspends);
            suspendIgnoreChannelsList.addIgnoreChannels(ignores);
            ChannelMap localSuspendIgnoreChannelsList = configurationService.getSuspendIgnoreChannelLists(targetNode.getNodeId());
            suspendIgnoreChannelsList.addSuspendChannels(localSuspendIgnoreChannelsList.getSuspendChannels());
            suspendIgnoreChannelsList.addIgnoreChannels(localSuspendIgnoreChannelsList.getIgnoreChannels());
        }
        return suspendIgnoreChannelsList;
    }

    public HttpConnection getConnection() {
        return this.connection;
    }
}

