/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Transaction;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.CollectionUtils;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SymmetricUtils {
    private static final Logger log = LoggerFactory.getLogger(SymmetricUtils.class);
    protected static boolean isNoticeLogged;

    private SymmetricUtils() {
    }

    public static String quote(ISymmetricDialect symmetricDialect, String name) {
        String quote = symmetricDialect.getPlatform().getDatabaseInfo().getDelimiterToken();
        if (StringUtils.isNotBlank((CharSequence)quote)) {
            return quote + name + quote;
        }
        return name;
    }

    public static final void replaceSystemAndEnvironmentVariables(Properties properties) {
        HashSet<Object> keys = new HashSet<Object>(properties.keySet());
        Map<String, String> env = System.getenv();
        Map systemProperties = CollectionUtils.toMap((Properties)System.getProperties());
        for (Object e : keys) {
            String value = properties.getProperty((String)e);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            value = FormatUtils.replaceTokens((String)value, env, (boolean)true);
            if ((value = FormatUtils.replaceTokens((String)value, (Map)systemProperties, (boolean)true)).contains("hostName")) {
                value = FormatUtils.replace((String)"hostName", (String)AppUtils.getHostName(), (String)value);
            }
            if (value.contains("portNumber")) {
                value = FormatUtils.replace((String)"portNumber", (String)AppUtils.getPortNumber(), (String)value);
            }
            if (value.contains("protocol")) {
                value = FormatUtils.replace((String)"protocol", (String)AppUtils.getProtocol(), (String)value);
            }
            if (value.contains("ipAddress")) {
                value = FormatUtils.replace((String)"ipAddress", (String)AppUtils.getIpAddress(), (String)value);
            }
            if (value.contains("engineName")) {
                value = FormatUtils.replace((String)"engineName", (String)properties.getProperty("engine.name", ""), (String)value);
            }
            if (value.contains("nodeGroupId")) {
                value = FormatUtils.replace((String)"nodeGroupId", (String)properties.getProperty("group.id", ""), (String)value);
            }
            if (value.contains("externalId")) {
                value = FormatUtils.replace((String)"externalId", (String)properties.getProperty("external.id", ""), (String)value);
            }
            if (value.contains("syncUrl")) {
                value = FormatUtils.replace((String)"syncUrl", (String)properties.getProperty("sync.url", ""), (String)value);
            }
            if (value.contains("registrationUrl")) {
                value = FormatUtils.replace((String)"registrationUrl", (String)properties.getProperty("registration.url", ""), (String)value);
            }
            properties.put(e, value);
        }
    }

    public static String replaceNodeVariables(Node sourceNode, Node targetNode, String str) {
        if (sourceNode != null) {
            str = FormatUtils.replace((String)"sourceNodeId", (String)sourceNode.getNodeId(), (String)str);
            str = FormatUtils.replace((String)"sourceExternalId", (String)sourceNode.getExternalId(), (String)str);
            str = FormatUtils.replace((String)"sourceNodeGroupId", (String)sourceNode.getNodeGroupId(), (String)str);
        }
        if (targetNode != null) {
            str = FormatUtils.replace((String)"targetNodeId", (String)targetNode.getNodeGroupId(), (String)str);
            str = FormatUtils.replace((String)"targetExternalId", (String)targetNode.getExternalId(), (String)str);
            str = FormatUtils.replace((String)"targetNodeGroupId", (String)targetNode.getNodeGroupId(), (String)str);
        }
        return str;
    }

    public static String replaceCatalogSchemaVariables(String catalogName, String defaultCatalogName, String schemaName, String defaultSchemaName, String str) {
        if (catalogName == null) {
            catalogName = defaultCatalogName;
        }
        if (schemaName == null) {
            schemaName = defaultSchemaName;
        }
        if (catalogName != null) {
            str = FormatUtils.replace((String)"sourceCatalogName", (String)catalogName, (String)str);
        }
        if (schemaName != null) {
            str = FormatUtils.replace((String)"sourceSchemaName", (String)schemaName, (String)str);
        }
        return str;
    }

    public static String substituteScripts(String value, Map<String, String> replacementValues) {
        int endTick;
        int startTick;
        if (log.isDebugEnabled()) {
            log.debug("substituteScripts starting value is: {}", value);
        }
        if (replacementValues == null) {
            replacementValues = new HashMap<String, String>();
        }
        if ((startTick = StringUtils.indexOf((CharSequence)value, (int)96)) != -1 && (endTick = StringUtils.lastIndexOf((CharSequence)value, (int)96)) != -1 && startTick != endTick) {
            String script = StringUtils.substring((String)value, (int)(startTick + 1), (int)endTick);
            if (log.isDebugEnabled()) {
                log.debug("Script found.  Script is is: {}", (Object)script);
            }
            Interpreter interpreter = new Interpreter();
            try {
                interpreter.set("hostName", (Object)AppUtils.getHostName());
                interpreter.set("log", (Object)log);
                interpreter.set("nodeGroupId", (Object)replacementValues.get("nodeGroupId"));
                interpreter.set("syncUrl", (Object)replacementValues.get("syncUrl"));
                interpreter.set("registrationUrl", (Object)replacementValues.get("registrationUrl"));
                interpreter.set("externalId", (Object)replacementValues.get("externalId"));
                interpreter.set("engineName", (Object)replacementValues.get("engineName"));
                Object scriptResult = interpreter.eval(script);
                if (scriptResult == null) {
                    scriptResult = "";
                }
                if (log.isDebugEnabled()) {
                    log.debug("Script output is: {}", scriptResult);
                }
                value = StringUtils.substring((String)value, (int)0, (int)startTick) + scriptResult.toString() + StringUtils.substring((String)value, (int)(endTick + 1));
            }
            catch (EvalError e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (log.isDebugEnabled()) {
                log.debug("substituteScripts return value is {}", value);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logNotices() {
        Class<SymmetricUtils> clazz = SymmetricUtils.class;
        synchronized (SymmetricUtils.class) {
            if (isNoticeLogged) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            isNoticeLogged = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            Object notices = null;
            try {
                notices = String.format("%n%s%n", IOUtils.toString((URL)Thread.currentThread().getContextClassLoader().getResource("symmetricds.asciiart"), (Charset)Charset.defaultCharset()));
                notices = ((String)notices).replaceAll("\n", String.format("%n", new Object[0]));
            }
            catch (Exception ex) {
                notices = String.format("SymmetricDS Start%n", new Object[0]);
            }
            String buildTime = Long.toString(Version.getBuildTime());
            String year = null;
            year = buildTime.length() >= 4 ? buildTime.substring(0, 4) : new SimpleDateFormat("yyyy").format(new Date());
            int pad = 65;
            notices = (String)notices + String.format("+" + StringUtils.repeat((String)"-", (int)pad) + "+%n|" + StringUtils.rightPad((String)(" Copyright (C) 2007-" + year + " JumpMind, Inc."), (int)pad) + "|%n|" + StringUtils.repeat((String)" ", (int)pad) + "|%n", new Object[0]);
            InputStream in = null;
            try {
                in = AppUtils.class.getResourceAsStream("/symmetric-console-default.properties");
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            notices = in != null ? (String)notices + String.format("|" + StringUtils.rightPad((String)" Licensed under one or more agreements from JumpMind, Inc.", (int)pad) + "|%n|" + StringUtils.rightPad((String)" See doc/license.html", (int)pad) + "|%n", new Object[0]) : (String)notices + String.format("|" + StringUtils.rightPad((String)" Licensed under the GNU General Public License version 3.", (int)pad) + "|%n|" + StringUtils.rightPad((String)" This software comes with ABSOLUTELY NO WARRANTY.", (int)pad) + "|%n|" + StringUtils.rightPad((String)" See http://www.gnu.org/licenses/gpl.html", (int)pad) + "|%n", new Object[0]);
            notices = (String)notices + "+" + StringUtils.repeat((String)"-", (int)pad) + "+";
            log.info((String)notices);
            return;
        }
    }

    public static boolean filterTransactions(Transaction transaction, Map<String, Transaction> transactionMap, List<Transaction> filteredTransactions, String dbUser, boolean isBlockingUser, boolean isBlocking) {
        return SymmetricUtils.filterTransactions(transaction, transactionMap, filteredTransactions, dbUser, isBlockingUser, isBlocking, 0);
    }

    public static boolean filterTransactions(Transaction transaction, Map<String, Transaction> transactionMap, List<Transaction> filteredTransactions, String dbUser, boolean isBlockingUser, boolean isBlocking, int level) {
        if (level > 500) {
            return false;
        }
        Transaction blockingTransaction = transactionMap.get(transaction.getBlockingId());
        if (!isBlocking && blockingTransaction == null) {
            return false;
        }
        if (filteredTransactions.contains(transaction)) {
            return true;
        }
        if (isBlockingUser || dbUser != null && dbUser.equalsIgnoreCase(transaction.getUsername())) {
            filteredTransactions.add(transaction);
            if (blockingTransaction != null) {
                SymmetricUtils.filterTransactions(blockingTransaction, transactionMap, filteredTransactions, dbUser, true, true, level + 1);
            }
            return true;
        }
        if (blockingTransaction != null && SymmetricUtils.filterTransactions(blockingTransaction, transactionMap, filteredTransactions, dbUser, false, true, level + 1)) {
            filteredTransactions.add(transaction);
            return true;
        }
        return false;
    }

    public static String getDeploymentSubType(Properties properties) {
        if (properties != null) {
            boolean isLoadOnly = Boolean.valueOf(properties.getProperty("load.only", "false"));
            boolean isLogBased = Boolean.valueOf(properties.getProperty("start.log.miner.job", "false"));
            boolean isTimeBased = Boolean.valueOf(properties.getProperty("time.based.capture", "false"));
            if (isLoadOnly) {
                if (isLogBased) {
                    if (isTimeBased) {
                        return "time-based";
                    }
                    return "log-based";
                }
                String dbUrl = properties.getProperty("db.url");
                if (dbUrl != null && dbUrl.startsWith("jdbc:h2:file:") && dbUrl.contains("extract-only")) {
                    return "extract-only";
                }
                return "load-only";
            }
        }
        return "trigger-based";
    }
}

