/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.CompressionTypes;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.Function;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.IndexImpBase;
import org.jumpmind.db.model.NonUniqueIndex;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.PlatformFunction;
import org.jumpmind.db.model.PlatformIndex;
import org.jumpmind.db.model.PlatformTrigger;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.UniqueIndex;
import org.jumpmind.exception.IoException;
import org.jumpmind.util.FormatUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DatabaseXmlUtil {
    public static final String DTD_PREFIX = "http://db.apache.org/torque/dtd/database";

    private DatabaseXmlUtil() {
    }

    public static Database read(String filename) {
        return DatabaseXmlUtil.read(new File(filename));
    }

    public static Database read(File file) {
        Database database;
        FileReader reader = new FileReader(file);
        try {
            database = DatabaseXmlUtil.read(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IoException((Exception)e);
            }
        }
        reader.close();
        return database;
    }

    public static Database read(InputStream is) {
        try {
            return DatabaseXmlUtil.read(new InputStreamReader(is, StandardCharsets.UTF_8.name()));
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
    }

    public static Database read(Reader reader) {
        return DatabaseXmlUtil.read(reader, true);
    }

    public static Database read(Reader reader, boolean validate) {
        try {
            boolean done = false;
            Database database = null;
            XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setInput(reader);
            int eventType = parser.getEventType();
            while (eventType != 1 && !done) {
                switch (eventType) {
                    case 0: {
                        database = new Database();
                        break;
                    }
                    case 2: {
                        Table table;
                        String name = parser.getName();
                        if (name.equalsIgnoreCase("database")) {
                            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                                String attributeName = parser.getAttributeName(i);
                                String attributeValue = parser.getAttributeValue(i);
                                if (attributeName.equalsIgnoreCase("name")) {
                                    database.setName(attributeValue);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("catalog")) {
                                    database.setCatalog(attributeValue);
                                    continue;
                                }
                                if (!attributeName.equalsIgnoreCase("schema")) continue;
                                database.setSchema(attributeValue);
                            }
                            break;
                        }
                        if (!name.equalsIgnoreCase("table") || (table = DatabaseXmlUtil.nextTable(parser, database.getCatalog(), database.getSchema())) == null) break;
                        database.addTable(table);
                        break;
                    }
                    case 3: {
                        String name = parser.getName();
                        if (!name.equalsIgnoreCase("database")) break;
                        done = true;
                    }
                }
                eventType = parser.next();
            }
            if (validate) {
                database.initialize();
            }
            return database;
        }
        catch (XmlPullParserException e) {
            throw new IoException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
    }

    public static Table nextTable(XmlPullParser parser) {
        return DatabaseXmlUtil.nextTable(parser, null, null);
    }

    public static Table nextTable(XmlPullParser parser, String catalog, String schema) {
        try {
            Table table = null;
            ForeignKey fk = null;
            IndexImpBase index = null;
            Trigger trigger = null;
            PlatformTrigger platformTrigger = null;
            Function function = null;
            PlatformFunction platformFunction = null;
            boolean done = false;
            int eventType = parser.getEventType();
            while (eventType != 1 && !done) {
                switch (eventType) {
                    case 2: {
                        String attributeName;
                        int i;
                        String attributeValue;
                        String name = parser.getName();
                        if (name.equalsIgnoreCase("table")) {
                            table = new Table();
                            table.setCatalog(catalog);
                            table.setSchema(schema);
                            for (int i2 = 0; i2 < parser.getAttributeCount(); ++i2) {
                                String attributeName2 = parser.getAttributeName(i2);
                                attributeValue = parser.getAttributeValue(i2);
                                if (attributeName2.equalsIgnoreCase("name")) {
                                    table.setName(attributeValue);
                                } else if (attributeName2.equalsIgnoreCase("description")) {
                                    table.setDescription(attributeValue);
                                }
                                if (attributeName2.equalsIgnoreCase("logging")) {
                                    boolean logging = !"false".equalsIgnoreCase(attributeValue);
                                    table.setLogging(logging);
                                    continue;
                                }
                                if (!attributeName2.equalsIgnoreCase("compression")) continue;
                                if (CompressionTypes.PAGE.name().equalsIgnoreCase(attributeValue)) {
                                    table.setCompressionType(CompressionTypes.PAGE);
                                    continue;
                                }
                                if (CompressionTypes.ROW.name().equalsIgnoreCase(attributeValue)) {
                                    table.setCompressionType(CompressionTypes.ROW);
                                    continue;
                                }
                                if (CompressionTypes.COLUMNSTORE.name().equalsIgnoreCase(attributeValue)) {
                                    table.setCompressionType(CompressionTypes.COLUMNSTORE);
                                    continue;
                                }
                                if (CompressionTypes.COLUMNSTORE_ARCHIVE.name().equals(attributeValue)) {
                                    table.setCompressionType(CompressionTypes.COLUMNSTORE_ARCHIVE);
                                    continue;
                                }
                                table.setCompressionType(CompressionTypes.NONE);
                            }
                            break;
                        }
                        if (name.equalsIgnoreCase("column")) {
                            Column column = new Column();
                            for (i = 0; i < parser.getAttributeCount(); ++i) {
                                attributeName = parser.getAttributeName(i);
                                String attributeValue2 = parser.getAttributeValue(i);
                                if (attributeName.equalsIgnoreCase("name")) {
                                    column.setName(attributeValue2);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("primaryKey")) {
                                    column.setPrimaryKey(FormatUtils.toBoolean((String)attributeValue2));
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("primaryKeySeq")) {
                                    column.setPrimaryKeySequence(Integer.parseInt(attributeValue2));
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("required")) {
                                    column.setRequired(FormatUtils.toBoolean((String)attributeValue2));
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("type")) {
                                    column.setMappedType(attributeValue2);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("size")) {
                                    column.setSize(attributeValue2);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("default")) {
                                    column.setDefaultValue(attributeValue2);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("autoIncrement")) {
                                    column.setAutoIncrement(FormatUtils.toBoolean((String)attributeValue2));
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("autoUpdate")) {
                                    column.setAutoUpdate(FormatUtils.toBoolean((String)attributeValue2));
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("javaName")) {
                                    column.setJavaName(attributeValue2);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("description")) {
                                    column.setDescription(attributeValue2);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("unique")) {
                                    column.setUnique(FormatUtils.toBoolean((String)attributeValue2));
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("generated")) {
                                    column.setGenerated(FormatUtils.toBoolean((String)attributeValue2));
                                    continue;
                                }
                                if (!attributeName.equalsIgnoreCase("expressionAsDefault")) continue;
                                column.setExpressionAsDefaultValue(FormatUtils.toBoolean((String)attributeValue2));
                            }
                            if (table == null) break;
                            table.addColumn(column);
                            break;
                        }
                        if (name.equalsIgnoreCase("platform-column")) {
                            PlatformColumn platformColumn = new PlatformColumn();
                            for (i = 0; i < parser.getAttributeCount(); ++i) {
                                attributeName = parser.getAttributeName(i);
                                String attributeValue3 = parser.getAttributeValue(i);
                                if (attributeName.equalsIgnoreCase("name")) {
                                    platformColumn.setName(attributeValue3);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("type")) {
                                    platformColumn.setType(attributeValue3);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("default")) {
                                    platformColumn.setDefaultValue(attributeValue3);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("size")) {
                                    if (!StringUtils.isNotBlank((CharSequence)attributeValue3)) continue;
                                    platformColumn.setSize(Integer.parseInt(attributeValue3));
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("decimalDigits")) {
                                    if (!StringUtils.isNotBlank((CharSequence)attributeValue3)) continue;
                                    platformColumn.setDecimalDigits(Integer.parseInt(attributeValue3));
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("enumValues")) {
                                    if (!StringUtils.isNotBlank((CharSequence)attributeValue3)) continue;
                                    platformColumn.setEnumValues(attributeValue3.split(","));
                                    continue;
                                }
                                if (!attributeName.equalsIgnoreCase("userDefinedType")) continue;
                                platformColumn.setUserDefinedType(Boolean.parseBoolean(attributeValue3));
                            }
                            if (table == null || table.getColumnCount() <= 0) break;
                            table.getColumn(table.getColumnCount() - 1).addPlatformColumn(platformColumn);
                            break;
                        }
                        if (name.equalsIgnoreCase("foreign-key")) {
                            fk = new ForeignKey();
                            for (int i3 = 0; i3 < parser.getAttributeCount(); ++i3) {
                                String attributeName3 = parser.getAttributeName(i3);
                                attributeValue = parser.getAttributeValue(i3);
                                if (attributeName3.equalsIgnoreCase("name")) {
                                    fk.setName(attributeValue);
                                    continue;
                                }
                                if (attributeName3.equalsIgnoreCase("foreignTable")) {
                                    fk.setForeignTableName(attributeValue);
                                    continue;
                                }
                                if (attributeName3.equalsIgnoreCase("foreignTableCatalog")) {
                                    fk.setForeignTableCatalog(attributeValue);
                                    continue;
                                }
                                if (attributeName3.equalsIgnoreCase("foreignTableSchema")) {
                                    fk.setForeignTableSchema(attributeValue);
                                    continue;
                                }
                                if (attributeName3.equalsIgnoreCase("foreignOnUpdateAction")) {
                                    fk.setOnUpdateAction(ForeignKey.getForeignKeyActionByForeignKeyActionName(attributeValue));
                                    continue;
                                }
                                if (!attributeName3.equalsIgnoreCase("foreignOnDeleteAction")) continue;
                                fk.setOnDeleteAction(ForeignKey.getForeignKeyActionByForeignKeyActionName(attributeValue));
                            }
                            table.addForeignKey(fk);
                            break;
                        }
                        if (name.equalsIgnoreCase("reference")) {
                            Reference ref = new Reference();
                            for (i = 0; i < parser.getAttributeCount(); ++i) {
                                attributeName = parser.getAttributeName(i);
                                String attributeValue4 = parser.getAttributeValue(i);
                                if (attributeName.equalsIgnoreCase("local")) {
                                    ref.setLocalColumnName(attributeValue4);
                                    continue;
                                }
                                if (!attributeName.equalsIgnoreCase("foreign")) continue;
                                ref.setForeignColumnName(attributeValue4);
                            }
                            fk.addReference(ref);
                            break;
                        }
                        if (name.equalsIgnoreCase("index") || name.equalsIgnoreCase("unique")) {
                            index = name.equalsIgnoreCase("index") ? new NonUniqueIndex() : new UniqueIndex();
                            for (int i4 = 0; i4 < parser.getAttributeCount(); ++i4) {
                                String attributeName4 = parser.getAttributeName(i4);
                                attributeValue = parser.getAttributeValue(i4);
                                if (!attributeName4.equalsIgnoreCase("name")) continue;
                                index.setName(attributeValue);
                            }
                            table.addIndex(index);
                            break;
                        }
                        if (name.equalsIgnoreCase("index-column") || name.equalsIgnoreCase("unique-column")) {
                            IndexColumn indexColumn = new IndexColumn();
                            for (i = 0; i < parser.getAttributeCount(); ++i) {
                                attributeName = parser.getAttributeName(i);
                                String attributeValue5 = parser.getAttributeValue(i);
                                if (attributeName.equalsIgnoreCase("name")) {
                                    indexColumn.setName(attributeValue5);
                                    continue;
                                }
                                if (!attributeName.equalsIgnoreCase("size")) continue;
                                indexColumn.setSize(attributeValue5);
                            }
                            indexColumn.setColumn(table.getColumnWithName(indexColumn.getName()));
                            if (index == null) break;
                            index.addColumn(indexColumn);
                            break;
                        }
                        if (name.equalsIgnoreCase("include-column")) {
                            IndexColumn indexColumn = new IndexColumn();
                            for (i = 0; i < parser.getAttributeCount(); ++i) {
                                attributeName = parser.getAttributeName(i);
                                String attributeValue6 = parser.getAttributeValue(i);
                                if (!attributeName.equalsIgnoreCase("name")) continue;
                                indexColumn.setName(attributeValue6);
                            }
                            indexColumn.setColumn(table.getColumnWithName(indexColumn.getName()));
                            if (index == null) break;
                            index.addIncludedColumn(indexColumn);
                            break;
                        }
                        if (name.equalsIgnoreCase("platform-index")) {
                            PlatformIndex platformIndex = new PlatformIndex();
                            for (i = 0; i < parser.getAttributeCount(); ++i) {
                                attributeName = parser.getAttributeName(i);
                                String attributeValue7 = parser.getAttributeValue(i);
                                if (attributeName.equalsIgnoreCase("name")) {
                                    platformIndex.setName(attributeValue7);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("filter-condition")) {
                                    platformIndex.setFilterCondition(attributeValue7);
                                    continue;
                                }
                                if (!attributeName.equalsIgnoreCase("compression")) continue;
                                if (CompressionTypes.ROW.name().equalsIgnoreCase(attributeValue7)) {
                                    platformIndex.setCompressionType(CompressionTypes.ROW);
                                    continue;
                                }
                                if (CompressionTypes.PAGE.name().equalsIgnoreCase(attributeValue7)) {
                                    platformIndex.setCompressionType(CompressionTypes.PAGE);
                                    continue;
                                }
                                if (CompressionTypes.COLUMNSTORE.name().equalsIgnoreCase(attributeValue7)) {
                                    platformIndex.setCompressionType(CompressionTypes.COLUMNSTORE);
                                    continue;
                                }
                                if (CompressionTypes.COLUMNSTORE_ARCHIVE.name().equals(attributeValue7)) {
                                    platformIndex.setCompressionType(CompressionTypes.COLUMNSTORE_ARCHIVE);
                                    continue;
                                }
                                platformIndex.setCompressionType(CompressionTypes.NONE);
                            }
                            if (index == null) break;
                            index.addPlatformIndex(platformIndex);
                            break;
                        }
                        if (name.equalsIgnoreCase("trigger")) {
                            trigger = new Trigger();
                            trigger.setCatalogName(catalog);
                            trigger.setSchemaName(schema);
                            for (int i5 = 0; i5 < parser.getAttributeCount(); ++i5) {
                                String attributeName5 = parser.getAttributeName(i5);
                                attributeValue = parser.getAttributeValue(i5);
                                if (!attributeName5.equalsIgnoreCase("name")) continue;
                                trigger.setName(attributeValue);
                            }
                            if (table == null) break;
                            table.addTrigger(trigger);
                            break;
                        }
                        if (name.equalsIgnoreCase("platform-trigger")) {
                            platformTrigger = new PlatformTrigger();
                            for (int i6 = 0; i6 < parser.getAttributeCount(); ++i6) {
                                String attributeName6 = parser.getAttributeName(i6);
                                attributeValue = parser.getAttributeValue(i6);
                                if (!attributeName6.equalsIgnoreCase("name")) continue;
                                platformTrigger.setName(attributeValue);
                            }
                            if (trigger == null) break;
                            trigger.addPlatformTrigger(platformTrigger);
                            break;
                        }
                        if (name.equalsIgnoreCase("trigger-text")) {
                            String triggerText = parser.nextText();
                            platformTrigger.setTriggerText(triggerText);
                            break;
                        }
                        if (name.equalsIgnoreCase("function")) {
                            function = new Function();
                            function.setCatalogName(catalog);
                            function.setSchemaName(schema);
                            for (int i7 = 0; i7 < parser.getAttributeCount(); ++i7) {
                                String attributeName7 = parser.getAttributeName(i7);
                                attributeValue = parser.getAttributeValue(i7);
                                if (!attributeName7.equalsIgnoreCase("name")) continue;
                                function.setFunctionName(attributeValue);
                            }
                            if (platformTrigger == null) break;
                            platformTrigger.setFunction(function);
                            break;
                        }
                        if (name.equalsIgnoreCase("platform-function")) {
                            platformFunction = new PlatformFunction();
                            for (int i8 = 0; i8 < parser.getAttributeCount(); ++i8) {
                                String attributeName8 = parser.getAttributeName(i8);
                                attributeValue = parser.getAttributeValue(i8);
                                if (!attributeName8.equalsIgnoreCase("name")) continue;
                                platformFunction.setName(attributeValue);
                            }
                            if (function == null) break;
                            function.addPlatformFunction(platformFunction);
                            break;
                        }
                        if (!name.equalsIgnoreCase("function-text")) break;
                        String functionText = parser.nextText();
                        platformFunction.setFunctionText(functionText);
                        break;
                    }
                    case 3: {
                        String name = parser.getName();
                        if (name.equalsIgnoreCase("table")) {
                            done = true;
                            break;
                        }
                        if (name.equalsIgnoreCase("index") || name.equalsIgnoreCase("unique")) {
                            index = null;
                            break;
                        }
                        if (name.equalsIgnoreCase("foreign-key")) {
                            fk = null;
                            break;
                        }
                        if (name.equalsIgnoreCase("trigger")) {
                            trigger = null;
                            break;
                        }
                        if (name.equalsIgnoreCase("platform-trigger")) {
                            platformTrigger = null;
                            break;
                        }
                        if (name.equalsIgnoreCase("function")) {
                            function = null;
                            break;
                        }
                        if (!name.equalsIgnoreCase("platform-function")) break;
                        platformFunction = null;
                    }
                }
                if (done) continue;
                eventType = parser.next();
            }
            return table;
        }
        catch (XmlPullParserException e) {
            throw new IoException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
    }

    public static void write(Database model, String filename) {
        try (BufferedWriter writer = null;){
            writer = new BufferedWriter(new FileWriter(filename));
            DatabaseXmlUtil.write(model, (Writer)writer);
            writer.flush();
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
    }

    public static void write(Database model, OutputStream output) {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        DatabaseXmlUtil.write(model, (Writer)writer);
        try {
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
    }

    public static void write(Database model, Writer output) {
        try {
            output.write("<?xml version=\"1.0\"?>\n<!DOCTYPE database SYSTEM \"http://db.apache.org/torque/dtd/database\">\n");
            output.write("<database name=\"" + model.getName() + "\"");
            if (model.getCatalog() != null) {
                output.write(" catalog=\"" + model.getCatalog() + "\"");
            }
            if (model.getSchema() != null) {
                output.write(" schema=\"" + model.getSchema() + "\"");
            }
            if (model.getIdMethod() != null) {
                output.write(" defaultIdMethod=\"" + model.getIdMethod() + "\"");
            }
            output.write(">\n");
            for (Table table : model.getTables()) {
                DatabaseXmlUtil.write(table, output);
            }
            output.write("</database>\n");
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
    }

    public static String toXml(Table table) {
        StringWriter writer = new StringWriter();
        DatabaseXmlUtil.write(table, (Writer)writer);
        return writer.toString();
    }

    public static String toXml(Database db) {
        StringWriter writer = new StringWriter();
        DatabaseXmlUtil.write(db, (Writer)writer);
        return writer.toString();
    }

    public static boolean isOracle(Column column) {
        if (column.getPlatformColumns() != null) {
            Collection<PlatformColumn> platformColumns = column.getPlatformColumns().values();
            for (PlatformColumn col : platformColumns) {
                if (!col.getName().equals("oracle") && !col.getName().equals("oracle122") && !col.getName().equals("oracle23")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMySql(Column column) {
        if (column.getPlatformColumns() != null) {
            Collection<PlatformColumn> platformColumns = column.getPlatformColumns().values();
            for (PlatformColumn col : platformColumns) {
                if (!col.getName().equals("mysql")) continue;
                return true;
            }
        }
        return false;
    }

    public static void write(Table table, Writer output) {
        try {
            output.write("\t<table name=\"" + StringEscapeUtils.escapeXml10((String)table.getName()) + "\"");
            if (table.getCompressionType() != CompressionTypes.NONE) {
                output.write(" compression=\"" + table.getCompressionType().name() + "\"");
            }
            if (!table.getLogging()) {
                output.write(" logging=\"false\"");
            }
            output.write(">\n");
            for (Column column : table.getColumns()) {
                output.write("\t\t<column name=\"" + StringEscapeUtils.escapeXml10((String)column.getName()) + "\"");
                if (column.isPrimaryKey()) {
                    output.write(" primaryKey=\"" + column.isPrimaryKey() + "\"");
                    output.write(" primaryKeySeq=\"" + column.getPrimaryKeySequence() + "\"");
                }
                if (column.isRequired()) {
                    output.write(" required=\"" + column.isRequired() + "\"");
                }
                if (column.getMappedType() != null) {
                    if (DatabaseXmlUtil.isOracle(column) && column.getMappedType().equalsIgnoreCase("date")) {
                        output.write(" type=\"TIMESTAMP\"");
                    } else {
                        output.write(" type=\"" + column.getMappedType() + "\"");
                    }
                }
                if (column.getSize() != null) {
                    output.write(" size=\"" + column.getSize() + "\"");
                }
                if (column.getDefaultValue() != null) {
                    output.write(" default=\"" + StringEscapeUtils.escapeXml10((String)column.getDefaultValue()) + "\"");
                }
                if (column.isAutoIncrement()) {
                    output.write(" autoIncrement=\"" + column.isAutoIncrement() + "\"");
                }
                if (column.isAutoUpdate()) {
                    output.write(" autoUpdate=\"" + column.isAutoUpdate() + "\"");
                }
                if (column.getJavaName() != null) {
                    output.write(" javaName=\"" + column.getJavaName() + "\"");
                }
                if (column.isUnique()) {
                    output.write(" unique=\"" + column.isUnique() + "\"");
                }
                if (column.isGenerated()) {
                    output.write(" generated=\"" + column.isGenerated() + "\"");
                }
                if (column.isExpressionAsDefaultValue()) {
                    output.write(" expressionAsDefault=\"" + column.isExpressionAsDefaultValue() + "\"");
                }
                if (column.getPlatformColumns() != null && column.getPlatformColumns().size() > 0) {
                    Collection<PlatformColumn> platformColumns = column.getPlatformColumns().values();
                    output.write(">\n");
                    for (PlatformColumn platformColumn : platformColumns) {
                        output.write("\t\t\t<platform-column name=\"" + platformColumn.getName() + "\"");
                        output.write(" type=\"" + StringEscapeUtils.escapeXml10((String)platformColumn.getType()) + "\"");
                        if (platformColumn.getSize() > 0 || platformColumn.getSize() == 0 && DatabaseXmlUtil.isMySql(column) && column.getMappedType().equalsIgnoreCase("varchar")) {
                            output.write(" size=\"" + platformColumn.getSize() + "\"");
                        }
                        if (platformColumn.getDecimalDigits() > 0) {
                            output.write(" decimalDigits=\"" + platformColumn.getDecimalDigits() + "\"");
                        }
                        if (platformColumn.getDefaultValue() != null) {
                            output.write(" default=\"" + StringEscapeUtils.escapeXml10((String)platformColumn.getDefaultValue()) + "\"");
                        }
                        if (platformColumn.getEnumValues() != null && platformColumn.getEnumValues().length > 0) {
                            output.write(" enumValues=\"");
                            int writeComma = 0;
                            for (String enumValue : platformColumn.getEnumValues()) {
                                if (writeComma != 0) {
                                    output.write(",");
                                }
                                output.write(enumValue);
                                writeComma = 1;
                            }
                            output.write("\"");
                        }
                        if (platformColumn.isUserDefinedType()) {
                            output.write(" userDefinedType=\"" + platformColumn.isUserDefinedType() + "\"");
                        }
                        output.write("/>\n");
                    }
                    output.write("\t\t</column>\n");
                    continue;
                }
                output.write("/>\n");
            }
            for (Cloneable cloneable : table.getForeignKeys()) {
                IndexColumn[] name = ((ForeignKey)cloneable).getName() == null ? "" : ((ForeignKey)cloneable).getName();
                output.write("\t\t<foreign-key name=\"" + StringEscapeUtils.escapeXml10((String)name) + "\" foreignTable=\"" + StringEscapeUtils.escapeXml10((String)((ForeignKey)cloneable).getForeignTableName()) + "\" foreignTableCatalog=\"" + StringEscapeUtils.escapeXml10((String)(((ForeignKey)cloneable).getForeignTableCatalog() == null || ((ForeignKey)cloneable).getForeignTableCatalog().equals(table.getCatalog()) ? "" : ((ForeignKey)cloneable).getForeignTableCatalog())) + "\" foreignTableSchema=\"" + StringEscapeUtils.escapeXml10((String)(((ForeignKey)cloneable).getForeignTableSchema() == null || ((ForeignKey)cloneable).getForeignTableSchema().equals(table.getSchema()) ? "" : ((ForeignKey)cloneable).getForeignTableSchema())) + "\"" + DatabaseXmlUtil.writeForeignKeyOnUpdateClause((ForeignKey)cloneable) + DatabaseXmlUtil.writeForeignKeyOnDeleteClause((ForeignKey)cloneable) + ">\n");
                for (Reference ref : ((ForeignKey)cloneable).getReferences()) {
                    output.write("\t\t\t<reference local=\"" + StringEscapeUtils.escapeXml10((String)ref.getLocalColumnName()) + "\" foreign=\"" + StringEscapeUtils.escapeXml10((String)ref.getForeignColumnName()) + "\"/>\n");
                }
                output.write("\t\t</foreign-key>\n");
            }
            for (Cloneable cloneable : table.getIndices()) {
                if (cloneable.isUnique()) {
                    output.write("\t\t<unique name=\"" + StringEscapeUtils.escapeXml10((String)cloneable.getName()) + "\">\n");
                    for (IndexColumn column : cloneable.getColumns()) {
                        output.write("\t\t\t<unique-column name=\"" + StringEscapeUtils.escapeXml10((String)column.getName()) + "\"/>\n");
                    }
                    DatabaseXmlUtil.handleIncludeColumns(output, (IIndex)cloneable);
                } else {
                    output.write("\t\t<index name=\"" + StringEscapeUtils.escapeXml10((String)cloneable.getName()) + "\">\n");
                    for (IndexColumn column : cloneable.getColumns()) {
                        output.write("\t\t\t<index-column name=\"" + StringEscapeUtils.escapeXml10((String)column.getName()) + "\"");
                        if (column.getSize() != null) {
                            output.write(" size=\"" + column.getSize() + "\"");
                        }
                        output.write("/>\n");
                    }
                    DatabaseXmlUtil.handleIncludeColumns(output, (IIndex)cloneable);
                }
                if (cloneable.getPlatformIndexes() != null && cloneable.getPlatformIndexes().size() > 0) {
                    Map<String, PlatformIndex> platformIndexes = cloneable.getPlatformIndexes();
                    for (String key : platformIndexes.keySet()) {
                        PlatformIndex platformIndex = platformIndexes.get(key);
                        if ((platformIndex.getFilterCondition() == null || platformIndex.getFilterCondition().length() <= 0) && platformIndex.getCompressionType() == CompressionTypes.NONE) continue;
                        output.write("\t\t\t<platform-index name=\"" + StringEscapeUtils.escapeXml10((String)platformIndex.getName()) + "\"");
                        if (platformIndex.getFilterCondition() != null && platformIndex.getFilterCondition().length() > 0) {
                            output.write(" filter-condition=\"" + platformIndex.getFilterCondition() + "\"");
                        }
                        if (platformIndex.getCompressionType() != CompressionTypes.NONE) {
                            output.write(" compression=\"" + platformIndex.getCompressionType().name() + "\"");
                        }
                        output.write("/>\n");
                    }
                }
                if (cloneable.isUnique()) {
                    output.write("\t\t</unique>\n");
                    continue;
                }
                output.write("\t\t</index>\n");
            }
            for (Cloneable cloneable : table.getTriggers()) {
                output.write("\t\t<trigger name=\"" + StringEscapeUtils.escapeXml10((String)((Trigger)cloneable).getName()) + "\">\n");
                if (((Trigger)cloneable).getPlatformTriggers() != null) {
                    Map<String, PlatformTrigger> platformTriggers = ((Trigger)cloneable).getPlatformTriggers();
                    for (String key : platformTriggers.keySet()) {
                        PlatformTrigger platformTrigger = platformTriggers.get(key);
                        String triggerText = platformTrigger.getTriggerText();
                        output.write("\t\t\t<platform-trigger name=\"" + StringEscapeUtils.escapeXml10((String)platformTrigger.getName()) + "\">\n");
                        output.write("\t\t\t\t<trigger-text>");
                        output.write("<![CDATA[");
                        output.write(triggerText);
                        output.write("]]>");
                        output.write("</trigger-text>\n");
                        Function function = platformTrigger.getFunction();
                        if (function != null) {
                            output.write("\t\t\t\t<function name=\"" + StringEscapeUtils.escapeXml10((String)function.getFunctionName()) + "\">\n");
                            Map<String, PlatformFunction> platformFunctions = function.getPlatformFunctions();
                            for (String functionKey : platformFunctions.keySet()) {
                                PlatformFunction platformFunction = platformFunctions.get(functionKey);
                                String functionText = platformFunction.getFunctionText();
                                output.write("\t\t\t\t\t<platform-function name=\"" + StringEscapeUtils.escapeXml10((String)platformFunction.getName()) + "\">\n");
                                output.write("\t\t\t\t\t\t<function-text>");
                                output.write("<![CDATA[");
                                output.write(functionText);
                                output.write("]]>");
                                output.write("</function-text>\n");
                                output.write("\t\t\t\t\t</platform-function>\n");
                            }
                            output.write("\t\t\t\t</function>\n");
                        }
                        output.write("\t\t\t</platform-trigger>\n");
                    }
                }
                output.write("\t\t</trigger>\n");
            }
            output.write("\t</table>\n");
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
    }

    public static String writeForeignKeyOnUpdateClause(ForeignKey fk) {
        StringBuilder sb = new StringBuilder();
        if (fk.getOnUpdateAction() != ForeignKey.ForeignKeyAction.RESTRICT && fk.getOnUpdateAction() != ForeignKey.ForeignKeyAction.NOACTION) {
            sb.append(" foreignOnUpdateAction=\"" + StringEscapeUtils.escapeXml10((String)fk.getOnUpdateAction().getForeignKeyActionName()) + "\"");
        }
        return sb.toString();
    }

    public static String writeForeignKeyOnDeleteClause(ForeignKey fk) {
        StringBuilder sb = new StringBuilder();
        if (fk.getOnDeleteAction() != ForeignKey.ForeignKeyAction.RESTRICT && fk.getOnDeleteAction() != ForeignKey.ForeignKeyAction.NOACTION) {
            sb.append(" foreignOnDeleteAction=\"" + StringEscapeUtils.escapeXml10((String)fk.getOnDeleteAction().getForeignKeyActionName()) + "\"");
        }
        return sb.toString();
    }

    private static void handleIncludeColumns(Writer output, IIndex index) throws IOException {
        for (IndexColumn column : index.getIncludedColumns()) {
            output.write("\t\t\t<include-column name=\"" + StringEscapeUtils.escapeXml10((String)column.getName()) + "\"/>\n");
        }
    }
}

