/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.CompressionTypes;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table
implements Serializable,
Cloneable,
Comparable<Table> {
    private static final Logger log = LoggerFactory.getLogger(Table.class);
    private static final long serialVersionUID = 1L;
    private static final ColumnPkSequenceComparator columnPkSequenceComparator = new ColumnPkSequenceComparator();
    private String oldCatalog = null;
    private String oldSchema = null;
    private String catalog = null;
    private String schema = null;
    private String name = null;
    private String description = null;
    private String type = null;
    private boolean isAccessControlled;
    private ArrayList<Column> columns = new ArrayList();
    private ArrayList<ForeignKey> foreignKeys = new ArrayList();
    private ArrayList<IIndex> indices = new ArrayList();
    private String primaryKeyConstraintName;
    private String fullyQualifiedTableName;
    private String fullyQualifiedTableNameLowerCase;
    private String tableNameLowerCase;
    private ArrayList<Column> lobColumns;
    private CompressionTypes compressionType = CompressionTypes.NONE;
    private boolean madeAllColumnsPrimaryKey;
    private boolean logging = true;
    private ArrayList<Trigger> triggers = new ArrayList();

    public Table() {
    }

    public Table(String tableName) {
        this(null, null, tableName);
    }

    public Table(String tableName, Column ... columns) {
        this(null, null, tableName);
        if (columns != null) {
            for (Column column : columns) {
                this.addColumn(column);
            }
        }
    }

    public Table(String catalog, String schema, String tableName) {
        this.catalog = catalog;
        this.schema = schema;
        this.name = tableName;
    }

    public Table(String catalog, String schema, String tableName, String[] columnNames, String[] keyNames) {
        this(catalog, schema, tableName);
        for (String name : columnNames) {
            this.addColumn(new Column(name));
        }
        for (String name : keyNames) {
            Column column = this.getColumnWithName(name);
            if (column == null) continue;
            column.setPrimaryKey(true);
        }
    }

    public void removeAllColumns() {
        this.columns.clear();
        this.lobColumns = null;
    }

    public void removeAllColumnDefaults() {
        for (Column column : this.columns) {
            column.setDefaultValue(null);
            Map<String, PlatformColumn> platformColumns = column.getPlatformColumns();
            if (platformColumns == null) continue;
            Collection<PlatformColumn> cols = platformColumns.values();
            for (PlatformColumn platformColumn : cols) {
                platformColumn.setDefaultValue(null);
            }
        }
    }

    public void removeAllIndices() {
        this.indices.clear();
    }

    public void removeAllForeignKeys() {
        this.foreignKeys.clear();
    }

    public void removeAllIndexes() {
        this.indices.clear();
    }

    public void removeAllTriggers() {
        this.triggers.clear();
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        for (ForeignKey fk : this.getForeignKeys()) {
            if (fk.getForeignTableCatalog() == null || !fk.getForeignTableCatalog().equals(this.catalog)) continue;
            fk.setForeignTableCatalog(catalog);
        }
        this.oldCatalog = this.catalog != null ? this.catalog : catalog;
        this.catalog = catalog;
        this.fullyQualifiedTableNameLowerCase = null;
        this.fullyQualifiedTableName = null;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        for (ForeignKey fk : this.getForeignKeys()) {
            if (fk.getForeignTableSchema() == null || !fk.getForeignTableSchema().equals(this.schema)) continue;
            fk.setForeignTableSchema(schema);
        }
        this.oldSchema = this.schema != null ? this.schema : schema;
        this.schema = schema;
        this.fullyQualifiedTableNameLowerCase = null;
        this.fullyQualifiedTableName = null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fullyQualifiedTableNameLowerCase = null;
        this.fullyQualifiedTableName = null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getPrimaryKeyColumnCount() {
        return this.getPrimaryKeyColumns().length;
    }

    public Column getColumn(int idx) {
        return this.columns.get(idx);
    }

    public Column[] getColumns() {
        return this.columns.toArray(new Column[this.columns.size()]);
    }

    public List<Column> getColumnsAsList() {
        return new ArrayList<Column>(this.columns);
    }

    public final void addColumn(Column column) {
        if (column != null) {
            this.columns.add(column);
            this.lobColumns = null;
        }
    }

    public void addColumn(int idx, Column column) {
        if (column != null) {
            this.columns.add(idx, column);
            this.lobColumns = null;
        }
    }

    public void addColumn(Column previousColumn, Column column) {
        if (column != null) {
            if (previousColumn == null) {
                this.columns.add(0, column);
            } else {
                this.columns.add(this.columns.indexOf(previousColumn), column);
            }
            this.lobColumns = null;
        }
    }

    public void addColumns(Collection<Column> columns) {
        Iterator<Column> it = columns.iterator();
        while (it.hasNext()) {
            this.addColumn(it.next());
        }
    }

    public void setPrimaryKeys(String[] primaryKeys) {
        if (primaryKeys != null) {
            for (Column column : this.columns) {
                boolean foundMatch = false;
                for (String primaryKey : primaryKeys) {
                    if (!column.getName().equalsIgnoreCase(primaryKey)) continue;
                    column.setPrimaryKey(true);
                    foundMatch = true;
                }
                if (foundMatch) continue;
                column.setPrimaryKey(false);
            }
        }
    }

    public void addColumns(String[] columnNames) {
        if (columnNames != null) {
            for (String columnName : columnNames) {
                this.addColumn(new Column(columnName));
            }
        }
    }

    public void removeColumn(Column column) {
        if (column != null) {
            this.columns.remove(column);
            this.lobColumns = null;
        }
    }

    public void removeColumn(int idx) {
        this.columns.remove(idx);
        this.lobColumns = null;
    }

    public int getForeignKeyCount() {
        return this.foreignKeys.size();
    }

    public ForeignKey getForeignKey(int idx) {
        return this.foreignKeys.get(idx);
    }

    public ForeignKey[] getForeignKeys() {
        return this.foreignKeys.toArray(new ForeignKey[this.foreignKeys.size()]);
    }

    public void addForeignKey(ForeignKey foreignKey) {
        if (foreignKey != null) {
            this.foreignKeys.add(foreignKey);
        }
    }

    public void addForeignKey(int idx, ForeignKey foreignKey) {
        if (foreignKey != null) {
            this.foreignKeys.add(idx, foreignKey);
        }
    }

    public void addForeignKeys(Collection<ForeignKey> foreignKeys) {
        Iterator<ForeignKey> it = foreignKeys.iterator();
        while (it.hasNext()) {
            this.addForeignKey(it.next());
        }
    }

    public void removeForeignKey(ForeignKey foreignKey) {
        if (foreignKey != null) {
            this.foreignKeys.remove(foreignKey);
        }
    }

    public void removeForeignKey(int idx) {
        this.foreignKeys.remove(idx);
    }

    public int getIndexCount() {
        return this.indices.size();
    }

    public IIndex getIndex(int idx) {
        return this.indices.get(idx);
    }

    public void addIndex(IIndex index) {
        if (index != null) {
            this.indices.add(index);
        }
    }

    public void addIndex(int idx, IIndex index) {
        if (index != null) {
            this.indices.add(idx, index);
        }
    }

    public void addIndices(Collection<IIndex> indices) {
        Iterator<IIndex> it = indices.iterator();
        while (it.hasNext()) {
            this.addIndex(it.next());
        }
    }

    public IIndex[] getIndices() {
        return this.indices.toArray(new IIndex[this.indices.size()]);
    }

    public IIndex[] getNonUniqueIndices() {
        if (this.indices != null) {
            ArrayList<IIndex> nonunique = new ArrayList<IIndex>();
            for (IIndex index : this.indices) {
                if (index.isUnique()) continue;
                nonunique.add(index);
            }
            return nonunique.toArray(new IIndex[nonunique.size()]);
        }
        return new IIndex[0];
    }

    public IIndex[] getUniqueIndices() {
        if (this.indices != null) {
            ArrayList<IIndex> unique = new ArrayList<IIndex>();
            for (IIndex index : this.indices) {
                if (!index.isUnique()) continue;
                unique.add(index);
            }
            return unique.toArray(new IIndex[unique.size()]);
        }
        return new IIndex[0];
    }

    public void removeIndex(IIndex index) {
        if (index != null) {
            this.indices.remove(index);
        }
    }

    public void removeIndex(int idx) {
        this.indices.remove(idx);
    }

    public boolean hasPrimaryKey() {
        for (Column column : this.columns) {
            if (!column.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNTypeColumns() {
        for (Column column : this.columns) {
            if (column.getJdbcTypeCode() != -15 && column.getJdbcTypeCode() != -9 && column.getJdbcTypeCode() != -16 && column.getJdbcTypeCode() != 2011 && (column.getJdbcTypeName() == null || !column.getJdbcTypeName().startsWith("NVARCHAR") && !column.getJdbcTypeName().startsWith("NCHAR"))) continue;
            return true;
        }
        return false;
    }

    public boolean hasGeneratedColumns() {
        for (Column column : this.columns) {
            if (!column.isGenerated()) continue;
            return true;
        }
        return false;
    }

    public Column findColumn(String name) {
        return this.findColumn(name, false);
    }

    public Column findColumn(String name, boolean caseSensitive) {
        for (Column column : this.columns) {
            if (!(caseSensitive ? column.getName().equals(name) : column.getName().equalsIgnoreCase(name))) continue;
            return column;
        }
        return null;
    }

    public int getColumnIndex(Column column) {
        return this.getColumnIndex(column.getName());
    }

    public int getColumnIndex(String columnName) {
        int idx = 0;
        Iterator<Column> it = this.columns.iterator();
        while (it.hasNext()) {
            if (columnName != null && columnName.equalsIgnoreCase(it.next().getName())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public int getPrimaryKeyColumnIndex(String columnName) {
        int idx = 0;
        List<Column> primaryKeyColumns = this.getPrimaryKeyColumnsAsList();
        Iterator<Column> it = primaryKeyColumns.iterator();
        while (it.hasNext()) {
            if (columnName != null && columnName.equalsIgnoreCase(it.next().getName())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public IIndex findIndex(String name) {
        return this.findIndex(name, false);
    }

    public IIndex findIndex(String name, boolean caseSensitive) {
        for (int idx = 0; idx < this.getIndexCount(); ++idx) {
            IIndex index = this.getIndex(idx);
            if (!(caseSensitive ? index.getName().equals(name) : index.getName().equalsIgnoreCase(name))) continue;
            return index;
        }
        return null;
    }

    public ForeignKey findForeignKey(ForeignKey key) {
        for (int idx = 0; idx < this.getForeignKeyCount(); ++idx) {
            ForeignKey fk = this.getForeignKey(idx);
            if (!fk.equals(key)) continue;
            return fk;
        }
        return null;
    }

    public ForeignKey findForeignKey(ForeignKey key, boolean caseSensitive) {
        for (int idx = 0; idx < this.getForeignKeyCount(); ++idx) {
            ForeignKey fk = this.getForeignKey(idx);
            if ((!caseSensitive || !fk.equals(key)) && (caseSensitive || !fk.equalsIgnoreCase(key))) continue;
            return fk;
        }
        return null;
    }

    public ForeignKey getSelfReferencingForeignKey() {
        for (int idx = 0; idx < this.getForeignKeyCount(); ++idx) {
            ForeignKey fk = this.getForeignKey(idx);
            if (!this.getName().equalsIgnoreCase(fk.getForeignTableName())) continue;
            return fk;
        }
        return null;
    }

    public List<Column> getPrimaryKeyColumnsAsList() {
        if (this.columns != null) {
            ArrayList<Column> selectedColumns = new ArrayList<Column>();
            for (Column column : this.columns) {
                if (column == null || !column.isPrimaryKey()) continue;
                selectedColumns.add(column);
            }
            return selectedColumns;
        }
        return new ArrayList<Column>(0);
    }

    public Column[] getPrimaryKeyColumns() {
        List<Column> pkColumns = this.getPrimaryKeyColumnsAsList();
        return pkColumns.toArray(new Column[pkColumns.size()]);
    }

    public Column[] getPrimaryKeyColumnsInIndexOrder() {
        List<Column> pkColumns = this.getPrimaryKeyColumnsAsList();
        Collections.sort(pkColumns, columnPkSequenceComparator);
        return pkColumns.toArray(new Column[pkColumns.size()]);
    }

    public Column[] getNonPrimaryKeyColumns() {
        ArrayList<Column> nonPkColumns = new ArrayList<Column>();
        List<Column> pkColumns = this.getPrimaryKeyColumnsAsList();
        for (Column c : this.columns) {
            if (pkColumns.contains(c)) continue;
            nonPkColumns.add(c);
        }
        return nonPkColumns.toArray(new Column[nonPkColumns.size()]);
    }

    public Column[] getAutoIncrementColumns() {
        if (this.columns != null) {
            ArrayList<Column> selectedColumns = new ArrayList<Column>();
            for (Column column : this.columns) {
                if (!column.isAutoIncrement()) continue;
                selectedColumns.add(column);
            }
            return selectedColumns.toArray(new Column[selectedColumns.size()]);
        }
        return new Column[0];
    }

    public void sortForeignKeys(final boolean caseSensitive) {
        if (!this.foreignKeys.isEmpty()) {
            final Collator collator = Collator.getInstance();
            Collections.sort(this.foreignKeys, new Comparator<ForeignKey>(){

                @Override
                public int compare(ForeignKey obj1, ForeignKey obj2) {
                    String fk1Name = obj1.getName();
                    String fk2Name = obj2.getName();
                    if (!caseSensitive) {
                        fk1Name = fk1Name != null ? fk1Name.toLowerCase() : null;
                        fk2Name = fk2Name != null ? fk2Name.toLowerCase() : null;
                    }
                    return collator.compare(fk1Name, fk2Name);
                }
            });
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Table result = (Table)super.clone();
        result.catalog = this.catalog;
        result.schema = this.schema;
        result.name = this.name;
        result.type = this.type;
        result.columns = new ArrayList(this.columns.size());
        for (Column col : this.columns) {
            if (col == null) continue;
            result.columns.add((Column)col.clone());
        }
        result.foreignKeys = new ArrayList(this.foreignKeys.size());
        for (ForeignKey fk : this.foreignKeys) {
            if (fk == null) continue;
            result.foreignKeys.add((ForeignKey)fk.clone());
        }
        result.indices = new ArrayList(this.indices.size());
        for (IIndex i : this.indices) {
            if (i == null) continue;
            result.indices.add((IIndex)i.clone());
        }
        result.triggers = new ArrayList(this.triggers.size());
        for (Trigger t : this.triggers) {
            if (t == null) continue;
            result.triggers.add((Trigger)t.clone());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Table) {
            Table other = (Table)obj;
            return new EqualsBuilder().append((Object)this.catalog, (Object)other.catalog).append((Object)this.schema, (Object)other.schema).append((Object)this.name, (Object)other.name).append(this.columns, other.columns).append(new HashSet<ForeignKey>(this.foreignKeys), new HashSet<ForeignKey>(other.foreignKeys)).append(new HashSet<IIndex>(this.indices), new HashSet<IIndex>(other.indices)).isEquals();
        }
        return false;
    }

    public boolean equalsByName(Table other) {
        if (this == other) {
            return true;
        }
        if (other != null && StringUtils.equalsIgnoreCase((CharSequence)this.catalog, (CharSequence)other.catalog) && StringUtils.equalsIgnoreCase((CharSequence)this.schema, (CharSequence)other.schema) && StringUtils.equalsIgnoreCase((CharSequence)this.name, (CharSequence)other.name)) {
            if (this.columns == other.columns) {
                return true;
            }
            ListIterator<Column> iter1 = this.columns.listIterator();
            ListIterator<Column> iter2 = other.columns.listIterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                Column c1 = iter1.next();
                Column c2 = iter2.next();
                if (c1 != null ? c1.equalsByName(c2) : c2 == null) continue;
                return false;
            }
            return !iter1.hasNext() && !iter2.hasNext();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.catalog).append((Object)this.schema).append(this.columns).append(new HashSet<ForeignKey>(this.foreignKeys)).append(new HashSet<IIndex>(this.indices)).toHashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Table [name=");
        result.append(this.getName());
        result.append("; ");
        result.append(this.getColumnCount());
        result.append(" columns]");
        return result.toString();
    }

    public String toVerboseString() {
        int idx;
        StringBuilder result = new StringBuilder();
        result.append("Table [name=");
        result.append(this.getName());
        result.append("; catalog=");
        result.append(this.getCatalog());
        result.append("; schema=");
        result.append(this.getSchema());
        result.append("; type=");
        result.append(this.getType());
        result.append("; logging=");
        result.append(this.getLogging());
        result.append("] columns:");
        for (idx = 0; idx < this.getColumnCount(); ++idx) {
            result.append(" ");
            result.append(this.getColumn(idx).toVerboseString());
        }
        result.append("; indices:");
        for (idx = 0; idx < this.getIndexCount(); ++idx) {
            result.append(" ");
            result.append(this.getIndex(idx).toVerboseString());
        }
        result.append("; foreign keys:");
        for (idx = 0; idx < this.getForeignKeyCount(); ++idx) {
            result.append(" ");
            result.append(this.getForeignKey(idx).toVerboseString());
        }
        return result.toString();
    }

    public String getTableKey() {
        return this.getFullyQualifiedTableName() + "-" + this.calculateTableLiteHashcode();
    }

    public boolean containsLobColumns(IDatabasePlatform platform) {
        if (this.lobColumns == null) {
            this.lobColumns = this.populateLobColumns(platform);
        }
        return this.lobColumns.size() > 0;
    }

    public List<Column> getLobColumns(IDatabasePlatform platform) {
        if (this.lobColumns == null) {
            this.lobColumns = this.populateLobColumns(platform);
        }
        return this.lobColumns;
    }

    private ArrayList<Column> populateLobColumns(IDatabasePlatform platform) {
        ArrayList<Column> lobColumns = new ArrayList<Column>();
        for (Column c : this.columns) {
            if (!platform.isLob(c)) continue;
            lobColumns.add(c);
        }
        return lobColumns;
    }

    public String getFullyQualifiedTableName() {
        if (this.fullyQualifiedTableName == null) {
            this.fullyQualifiedTableName = Table.getFullyQualifiedTableName(this.catalog, this.schema, this.name, null, ".", ".");
        }
        return this.fullyQualifiedTableName;
    }

    public String getFullyQualifiedTableNameLowerCase() {
        if (this.fullyQualifiedTableNameLowerCase == null) {
            this.fullyQualifiedTableNameLowerCase = this.getFullyQualifiedTableName().toLowerCase();
        }
        return this.fullyQualifiedTableNameLowerCase;
    }

    public String getFullyQualifiedTableName(String quote) {
        return Table.getFullyQualifiedTableName(this.catalog, this.schema, this.name, quote, ".", ".");
    }

    public String getNameLowerCase() {
        if (this.tableNameLowerCase == null) {
            this.tableNameLowerCase = this.getName().toLowerCase();
        }
        return this.tableNameLowerCase;
    }

    public static String getFullyQualifiedTableName(String catalogName, String schemaName, String tableName) {
        return Table.getFullyQualifiedTableName(catalogName, schemaName, tableName, null, ".", ".");
    }

    public String getQualifiedColumnName(Column column) {
        return this.getFullyQualifiedTableName() + "." + column.getName();
    }

    public static String getFullyQualifiedTablePrefix(String catalogName, String schemaName) {
        return Table.getFullyQualifiedTablePrefix(new StringBuilder(), catalogName, schemaName, null, ".", ".");
    }

    public String getQualifiedTableName(String quoteString, String catalogSeparator, String schemaSeparator) {
        return Table.getFullyQualifiedTableName(this.catalog, this.schema, this.name, quoteString, catalogSeparator, schemaSeparator);
    }

    public String getQualifiedTableName() {
        return this.getQualifiedTableName("", ".", ".");
    }

    public static String getFullyQualifiedTableName(String catalogName, String schemaName, String tableName, String quoteString, String catalogSeparator, String schemaSeparator) {
        if (quoteString == null) {
            quoteString = "";
        }
        StringBuilder sb = new StringBuilder();
        Table.getFullyQualifiedTablePrefix(sb, catalogName, schemaName, quoteString, catalogSeparator, schemaSeparator);
        sb.append(quoteString).append(tableName).append(quoteString);
        return sb.toString();
    }

    public static String getFullyQualifiedTablePrefix(String catalogName, String schemaName, String quoteString, String catalogSeparator, String schemaSeparator) {
        return Table.getFullyQualifiedTablePrefix(new StringBuilder(), catalogName, schemaName, quoteString, catalogSeparator, schemaSeparator);
    }

    public static String getFullyQualifiedTablePrefix(StringBuilder sb, String catalogName, String schemaName, String quoteString, String catalogSeparator, String schemaSeparator) {
        if (quoteString == null) {
            quoteString = "";
        }
        if (!StringUtils.isBlank((CharSequence)catalogName)) {
            sb.append(quoteString).append(catalogName).append(quoteString).append(catalogSeparator);
        }
        if (!StringUtils.isBlank((CharSequence)schemaName)) {
            sb.append(quoteString).append(schemaName).append(quoteString).append(schemaSeparator);
        }
        return sb.toString();
    }

    public String getQualifiedTablePrefix(String quoteString, String catalogSeparator, String schemaSeparator) {
        return Table.getFullyQualifiedTablePrefix(new StringBuilder(), this.catalog, this.schema, quoteString, catalogSeparator, schemaSeparator);
    }

    public final Column getColumnWithName(String name) {
        Column[] columns = this.getColumns();
        if (columns != null) {
            for (Column column : columns) {
                if (!column.getName().equalsIgnoreCase(name)) continue;
                return column;
            }
        }
        return null;
    }

    public Column[] getColumnsWithName(String[] columnNames) {
        Column[] columns = new Column[columnNames.length];
        int index = 0;
        for (String columnName : columnNames) {
            columns[index++] = this.getColumnWithName(columnName);
        }
        return columns;
    }

    public boolean doesIndexContainOnlyPrimaryKeyColumns(IIndex index) {
        IndexColumn[] columns = index.getColumns();
        if (columns != null) {
            for (IndexColumn indexColumn : columns) {
                Column column = this.getColumnWithName(indexColumn.getName());
                if (column != null && column.isPrimaryKey()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasAutoIncrementColumn() {
        if (this.columns != null) {
            for (Column column : this.getColumns()) {
                if (!column.isAutoIncrement()) continue;
                return true;
            }
        }
        return false;
    }

    public Column[] getDistributionKeyColumns() {
        if (this.columns != null) {
            ArrayList<Column> selectedColumns = new ArrayList<Column>();
            for (Column column : this.columns) {
                if (!column.isDistributionKey()) continue;
                selectedColumns.add(column);
            }
            return selectedColumns.toArray(new Column[selectedColumns.size()]);
        }
        return new Column[0];
    }

    public void orderColumns(String[] columnNames) {
        this.orderColumns(columnNames, false);
    }

    public void orderColumns(String[] columnNames, boolean addMissingColumns) {
        Column[] orderedColumns = Table.orderColumns(columnNames, this, addMissingColumns);
        this.columns.clear();
        for (Column column : orderedColumns) {
            if (column == null) continue;
            this.columns.add(column);
        }
    }

    public static Column[] orderColumns(String[] columnNames, Table table, boolean addMissingColumns) {
        Column[] unorderedColumns = table.getColumns();
        Column[] orderedColumns = new Column[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            Column newColumn;
            String name = columnNames[i];
            for (Column column : unorderedColumns) {
                if (column == null || !column.getName().equals(name)) continue;
                orderedColumns[i] = column;
                break;
            }
            if (orderedColumns[i] == null) {
                for (Column column : unorderedColumns) {
                    if (column == null || !column.getName().equalsIgnoreCase(name)) continue;
                    orderedColumns[i] = column;
                    break;
                }
            }
            if (orderedColumns[i] != null) continue;
            if (!addMissingColumns) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Could not find column with the name of {} on table {}.", (Object)name, (Object)table.toVerboseString());
                continue;
            }
            orderedColumns[i] = newColumn = new Column(name);
            if (!log.isDebugEnabled()) continue;
            log.debug("Could not find column with the name of {} on table {}. Added this column to the list of columns.", (Object)name, (Object)table.toVerboseString());
        }
        return orderedColumns;
    }

    public String getOldCatalog() {
        return this.oldCatalog;
    }

    public void setOldCatalog(String oldCatalog) {
        this.oldCatalog = oldCatalog;
    }

    public String getOldSchema() {
        return this.oldSchema;
    }

    public void setOldSchema(String oldSchema) {
        this.oldSchema = oldSchema;
    }

    public boolean isAccessControlled() {
        return this.isAccessControlled;
    }

    public void setAccessControlled(boolean isAccessControlled) {
        this.isAccessControlled = isAccessControlled;
    }

    public Table copy() {
        try {
            return (Table)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Table copyAndFilterColumns(String[] orderedColumnNames, String[] pkColumnNames, boolean setPrimaryKeys, boolean addMissingColumns) {
        Table table = this.copy();
        table.orderColumns(orderedColumnNames, addMissingColumns);
        TreeSet<String> columnNameSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        columnNameSet.addAll(Arrays.asList(orderedColumnNames));
        ArrayList<IIndex> indices = new ArrayList<IIndex>();
        for (IIndex index : table.getIndices()) {
            boolean keepIndex = true;
            block1: for (IndexColumn columnInIndex : index.getColumns()) {
                if (columnInIndex == null || columnInIndex.getName() == null) {
                    keepIndex = false;
                    break;
                }
                if (columnNameSet.contains(columnInIndex.getName())) continue;
                Set<String> functionalIndexColumnNameSet = this.parseFunctionalIndexColumnName(columnInIndex.getName());
                if (functionalIndexColumnNameSet.isEmpty()) {
                    keepIndex = false;
                    break;
                }
                for (String functionalIndexColumnName : functionalIndexColumnNameSet) {
                    if (columnNameSet.contains(functionalIndexColumnName)) continue;
                    keepIndex = false;
                    continue block1;
                }
            }
            if (!keepIndex) continue;
            indices.add(index);
        }
        table.removeAllIndices();
        table.addIndices(indices);
        if (setPrimaryKeys && this.columns != null) {
            for (Column column : table.columns) {
                if (column == null) continue;
                column.setPrimaryKey(false);
            }
            if (pkColumnNames != null) {
                for (Column column : table.columns) {
                    if (column == null) continue;
                    String[] stringArray = pkColumnNames;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String pkColumnName = stringArray[i];
                        if (!column.getName().equalsIgnoreCase(pkColumnName)) continue;
                        boolean required = column.isRequired();
                        column.setPrimaryKey(true);
                        column.setRequired(required);
                    }
                }
            }
            if (table.getForeignKeys() != null && table.getForeignKeys().length > 0) {
                ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
                HashSet<String> columnsSet = new HashSet<String>(Arrays.asList(orderedColumnNames));
                for (ForeignKey fk : table.getForeignKeys()) {
                    boolean addFk = true;
                    for (Reference ref : fk.getReferences()) {
                        if (ref == null || ref.getLocalColumnName() == null || columnsSet.contains(ref.getLocalColumnName())) continue;
                        addFk = false;
                    }
                    if (!addFk) continue;
                    foreignKeys.add(fk);
                }
                table.removeAllForeignKeys();
                table.addForeignKeys(foreignKeys);
            }
        }
        return table;
    }

    private Set<String> parseFunctionalIndexColumnName(String name) {
        HashSet<String> nameSet;
        block3: {
            block2: {
                nameSet = new HashSet<String>();
                if (!name.contains(")::")) break block2;
                String[] splitName = StringUtils.split((String)name, (String)")::");
                for (int i = 0; i < splitName.length - 1; ++i) {
                    String s = splitName[i];
                    int lastParen = s.lastIndexOf("(");
                    if (lastParen == -1) continue;
                    nameSet.add(s.substring(lastParen + 1));
                }
                break block3;
            }
            if (StringUtils.countMatches((CharSequence)name, (CharSequence)"\"") < 2) break block3;
            for (String columnName : StringUtils.substringsBetween((String)name, (String)"\"", (String)"\"")) {
                nameSet.add(columnName);
            }
        }
        return nameSet;
    }

    public String[] getColumnNames() {
        String[] columnNames = new String[this.columns.size()];
        int i = 0;
        for (Column col : this.columns) {
            columnNames[i++] = col.getName();
        }
        return columnNames;
    }

    public String[] getPrimaryKeyColumnNames() {
        Column[] columns = this.getPrimaryKeyColumns();
        String[] columnNames = new String[columns.length];
        int i = 0;
        for (Column col : columns) {
            columnNames[i++] = col.getName();
        }
        return columnNames;
    }

    public int calculateTableHashcode() {
        return this.calculateTableHashcode(true);
    }

    public int calculateTableLiteHashcode() {
        return this.calculateTableHashcode(false);
    }

    protected int calculateTableHashcode(boolean includeTypes) {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Table.calculateHashcodeForColumns(31, this.getColumns(), includeTypes);
        result = 31 * result + Table.calculateHashcodeForColumns(31, this.getPrimaryKeyColumns(), includeTypes);
        return result;
    }

    private static int calculateHashcodeForColumns(int PRIME, Column[] cols, boolean includeTypes) {
        int result = 1;
        if (cols != null && cols.length > 0) {
            for (Column column : cols) {
                result = PRIME * result + column.getName().hashCode();
                if (includeTypes && column.getMappedType() != null) {
                    result = PRIME * result + column.getMappedType().hashCode();
                }
                result = PRIME * result + column.getSizeAsInt();
            }
        }
        return result;
    }

    public static boolean areAllColumnsPrimaryKeys(Column[] columns) {
        boolean allPks = true;
        if (columns != null) {
            for (Column column : columns) {
                allPks &= column.isPrimaryKey();
            }
        }
        return allPks;
    }

    public static Table buildTable(String tableName, String[] keyNames, String[] columnNames) {
        int i;
        Table table = new Table();
        table.setName(tableName);
        for (i = 0; i < columnNames.length; ++i) {
            table.addColumn(new Column(columnNames[i]));
        }
        for (i = 0; i < keyNames.length; ++i) {
            table.getColumnWithName(keyNames[i]).setPrimaryKey(true);
        }
        return table;
    }

    public static String getCommaDeliminatedColumns(Column[] cols) {
        StringBuilder columns = new StringBuilder();
        if (cols != null && cols.length > 0) {
            for (Column column : cols) {
                columns.append(Table.escapeColumnNameForCsv(column.getName()));
                columns.append(",");
            }
            columns.replace(columns.length() - 1, columns.length(), "");
            return columns.toString();
        }
        return " ";
    }

    public static String[] getArrayColumns(Column[] cols) {
        if (cols != null) {
            String[] columns = new String[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                columns[i] = cols[i].getName();
            }
            return columns;
        }
        return null;
    }

    public void setPrimaryKeyConstraintName(String primaryKeyConstraintName) {
        this.primaryKeyConstraintName = primaryKeyConstraintName;
    }

    public String getPrimaryKeyConstraintName() {
        return this.primaryKeyConstraintName;
    }

    public boolean containsJdbcTypes() {
        Column[] columns = this.getColumns();
        if (columns != null && columns.length > 0) {
            for (Column column : columns) {
                if (column.containsJdbcTypes()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void copyColumnTypesFrom(Table table) {
        if (table != null && this.columns != null) {
            for (Column column : this.columns) {
                Column sourceColumn = table.getColumnWithName(column.getName());
                if (sourceColumn == null) continue;
                column.setJdbcTypeCode(sourceColumn.getJdbcTypeCode());
                column.setJdbcTypeName(sourceColumn.getJdbcTypeName());
                column.setMappedTypeCode(sourceColumn.getMappedTypeCode());
                column.setMappedType(sourceColumn.getMappedType());
            }
        }
    }

    @Override
    public int compareTo(Table o) {
        return this.getFullyQualifiedTableName().compareTo(o.getFullyQualifiedTableName());
    }

    public static String escapeColumnNameForCsv(String columnName) {
        if (columnName != null && (columnName.indexOf(92) != -1 || columnName.indexOf(44) != -1 || columnName.indexOf(34) != -1)) {
            columnName = columnName.replace("\\", "\\\\");
            columnName = columnName.replace("\"", "\\\"");
            return "\"" + columnName + "\"";
        }
        return columnName;
    }

    public CompressionTypes getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(CompressionTypes compressionType) {
        this.compressionType = compressionType;
    }

    public boolean isMadeAllColumnsPrimaryKey() {
        return this.madeAllColumnsPrimaryKey;
    }

    public void setMadeAllColumnsPrimaryKey(boolean madeAllColumnsPrimaryKey) {
        this.madeAllColumnsPrimaryKey = madeAllColumnsPrimaryKey;
    }

    public int getTriggerCount() {
        return this.triggers.size();
    }

    public Trigger getTrigger(int i) {
        return this.triggers.get(i);
    }

    public Trigger[] getTriggers() {
        return this.triggers.toArray(new Trigger[this.triggers.size()]);
    }

    public List<Trigger> getTriggersAsList() {
        return new ArrayList<Trigger>(this.triggers);
    }

    public final void addTrigger(Trigger trigger) {
        if (trigger != null) {
            this.triggers.add(trigger);
        }
    }

    public void addTrigger(int idx, Trigger trigger) {
        if (trigger != null) {
            this.triggers.add(idx, trigger);
        }
    }

    public void addTrigger(Trigger previousTrigger, Trigger trigger) {
        if (trigger != null) {
            if (previousTrigger == null) {
                this.triggers.add(0, trigger);
            } else {
                this.triggers.add(this.triggers.indexOf(previousTrigger), trigger);
            }
        }
    }

    public void addTriggers(Collection<Trigger> triggers) {
        Iterator<Trigger> it = triggers.iterator();
        while (it.hasNext()) {
            this.addTrigger(it.next());
        }
    }

    public Trigger findTrigger(String name, boolean caseSensitive) {
        for (Trigger trigger : this.triggers) {
            if (!(caseSensitive ? trigger.getName().equals(name) : trigger.getName().equalsIgnoreCase(name))) continue;
            return trigger;
        }
        return null;
    }

    public void removeTrigger(Trigger trigger) {
        if (trigger != null) {
            this.triggers.remove(trigger);
        }
    }

    public boolean getLogging() {
        return this.logging;
    }

    public void setLogging(boolean value) {
        this.logging = value;
    }

    static class ColumnPkSequenceComparator
    implements Comparator<Column> {
        ColumnPkSequenceComparator() {
        }

        @Override
        public int compare(Column o1, Column o2) {
            if (o1 != null && o2 != null) {
                return Integer.compare(o1.getPrimaryKeySequence(), o2.getPrimaryKeySequence());
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            return 0;
        }
    }
}

