/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.util.ArrayList;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexImpBase;

public class UniqueIndex
extends IndexImpBase {
    private static final long serialVersionUID = 1L;

    public UniqueIndex() {
    }

    public UniqueIndex(String name) {
        this.setName(name);
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        UniqueIndex result = new UniqueIndex();
        result.name = this.name;
        result.columns = (ArrayList)this.columns.clone();
        result.includedColumns = (ArrayList)this.includedColumns.clone();
        this.clonePlatformIndexes(result);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UniqueIndex) {
            UniqueIndex other = (UniqueIndex)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.columns, (Object)other.columns).append((Object)this.platformIndexes, (Object)other.platformIndexes).append((Object)this.includedColumns, (Object)other.includedColumns).isEquals();
        }
        return false;
    }

    @Override
    public boolean equalsIgnoreCase(IIndex other) {
        if (other instanceof UniqueIndex) {
            boolean checkName;
            UniqueIndex otherIndex = (UniqueIndex)other;
            boolean bl = checkName = this.name != null && this.name.length() > 0 && otherIndex.name != null && otherIndex.name.length() > 0;
            if ((!checkName || this.name.equalsIgnoreCase(otherIndex.name)) && this.getColumnCount() == otherIndex.getColumnCount()) {
                for (int idx = 0; idx < this.getColumnCount(); ++idx) {
                    if (this.getColumn(idx).equalsIgnoreCase(otherIndex.getColumn(idx))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.columns.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Unique index [name=");
        result.append(this.getName());
        result.append("; ");
        result.append(this.getColumnCount());
        result.append(" columns]");
        return result.toString();
    }

    @Override
    public String toVerboseString() {
        StringBuilder result = new StringBuilder();
        result.append("Unique index [");
        result.append(this.getName());
        result.append("] columns:");
        for (int idx = 0; idx < this.getColumnCount(); ++idx) {
            result.append(" ");
            result.append(this.getColumn(idx));
        }
        return result.toString();
    }
}

