/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.hsqldb2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.ColumnSizeChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;

public class HsqlDb2DdlBuilder
extends AbstractDdlBuilder {
    public HsqlDb2DdlBuilder() {
        super("hsqldb2");
        this.databaseInfo.setNonPKIdentityColumnsSupported(false);
        this.databaseInfo.setIdentityOverrideAllowed(false);
        this.databaseInfo.setSystemForeignKeyIndicesAlwaysNonUnique(true);
        this.databaseInfo.addNativeTypeMapping(2003, "LONGVARBINARY", -4);
        this.databaseInfo.addNativeTypeMapping(2005, "LONGVARCHAR", -1);
        this.databaseInfo.addNativeTypeMapping(-1, "LONGVARCHAR", -1);
        this.databaseInfo.addNativeTypeMapping(2001, "LONGVARBINARY", -4);
        this.databaseInfo.addNativeTypeMapping(6, "DOUBLE", 8);
        this.databaseInfo.addNativeTypeMapping(2000, "OTHER");
        this.databaseInfo.addNativeTypeMapping(0, "LONGVARBINARY", -4);
        this.databaseInfo.addNativeTypeMapping(2006, "LONGVARBINARY", -4);
        this.databaseInfo.addNativeTypeMapping(2002, "LONGVARBINARY", -4);
        this.databaseInfo.addNativeTypeMapping(-6, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping("BIT", "BOOLEAN", "BOOLEAN");
        this.databaseInfo.addNativeTypeMapping("DATALINK", "LONGVARBINARY", "LONGVARBINARY");
        this.databaseInfo.setDefaultSize(1, Integer.MAX_VALUE);
        this.databaseInfo.setDefaultSize(12, Integer.MAX_VALUE);
        this.databaseInfo.setDefaultSize(-2, Integer.MAX_VALUE);
        this.databaseInfo.setDefaultSize(-3, Integer.MAX_VALUE);
        this.databaseInfo.setDefaultSize(93, 3);
        this.databaseInfo.setDefaultSize(92, 0);
        this.databaseInfo.setHasSize(93, true);
        this.databaseInfo.setHasSize(-101, true);
        this.databaseInfo.setHasSize(-102, true);
        this.databaseInfo.setHasSize(92, true);
        this.databaseInfo.setHasSize(-103, true);
        this.databaseInfo.setMaxSize("TIMESTAMP", 3);
        this.databaseInfo.setMaxSize("TIME", 3);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(true);
        this.databaseInfo.setBlankCharColumnSpacePadded(true);
        this.databaseInfo.setCharColumnSpaceTrimmed(false);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setGeneratedColumnsSupported(true);
    }

    @Override
    protected void dropTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        ddl.append("DROP TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        ddl.append(" IF EXISTS");
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void writeGeneratedColumn(Table table, Column column, StringBuilder ddl) {
        this.writeColumnTypeDefaultRequired(table, column, ddl);
        String definition = this.getDefinitionForGeneratedColumn(table, column);
        if (!StringUtils.isBlank((CharSequence)definition)) {
            if (!definition.startsWith("(") || !definition.endsWith(")")) {
                ddl.append(" GENERATED ALWAYS AS ").append("(").append(definition).append(")");
            } else {
                ddl.append(" GENERATED ALWAYS AS ").append(definition);
            }
        }
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        return "CALL IDENTITY()";
    }

    @Override
    protected boolean shouldGeneratePrimaryKeys(Column[] primaryKeyColumns) {
        if (primaryKeyColumns != null && primaryKeyColumns.length == 1) {
            return !primaryKeyColumns[0].isAutoIncrement();
        }
        return true;
    }

    @Override
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        TableChange change;
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            ColumnSizeChange sizeChange;
            TableChange change2 = changeIt.next();
            if (change2 instanceof RemoveColumnChange && ((RemoveColumnChange)change2).getColumn().isPrimaryKey()) {
                changeIt.remove();
            }
            if (change2 instanceof ColumnSizeChange && (sizeChange = (ColumnSizeChange)change2).getChangedColumn().getMappedTypeCode() == 12 && sizeChange.getNewSize() == 0) {
                changeIt.remove();
            }
            if (!(change2 instanceof ColumnDataTypeChange)) continue;
            ColumnDataTypeChange dataTypeChange = (ColumnDataTypeChange)change2;
            if (dataTypeChange.getChangedColumn().getMappedTypeCode() == 12 && dataTypeChange.getNewTypeCode() == -1) {
                changeIt.remove();
                continue;
            }
            if (dataTypeChange.getNewTypeCode() != -5 || !this.writeAlterColumnDataTypeToBigInt(dataTypeChange, ddl)) continue;
            changeIt.remove();
        }
        ArrayList<AddColumnChange> addColumnChanges = new ArrayList<AddColumnChange>();
        Iterator<TableChange> changeIt2 = changes.iterator();
        while (changeIt2.hasNext()) {
            change = changeIt2.next();
            if (!(change instanceof AddColumnChange)) continue;
            addColumnChanges.add((AddColumnChange)change);
            changeIt2.remove();
        }
        changeIt2 = addColumnChanges.listIterator(addColumnChanges.size());
        while (changeIt2.hasPrevious()) {
            AddColumnChange addColumnChange = (AddColumnChange)changeIt2.previous();
            this.processChange(currentModel, desiredModel, addColumnChange, ddl);
            changeIt2.remove();
        }
        changeIt2 = changes.iterator();
        while (changeIt2.hasNext()) {
            change = changeIt2.next();
            if (change instanceof RemoveColumnChange) {
                RemoveColumnChange removeColumnChange = (RemoveColumnChange)change;
                this.processChange(currentModel, desiredModel, removeColumnChange, ddl);
                changeIt2.remove();
                continue;
            }
            if (!(change instanceof CopyColumnValueChange)) continue;
            CopyColumnValueChange copyColumnChange = (CopyColumnValueChange)change;
            this.processChange(currentModel, desiredModel, copyColumnChange, ddl);
            changeIt2.remove();
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("ADD COLUMN ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn(), ddl);
        if (change.getNextColumn() != null) {
            ddl.append(" BEFORE ");
            this.printIdentifier(this.getColumnName(change.getNextColumn()), ddl);
        }
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    @Override
    public void writeExternalIndexDropStmt(Table table, IIndex index, StringBuilder ddl) {
        ddl.append("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index), ddl);
        this.printEndOfStatement(ddl);
    }
}

