/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mssql;

import java.rmi.server.UID;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddForeignKeyChange;
import org.jumpmind.db.alter.AddIndexChange;
import org.jumpmind.db.alter.AddPrimaryKeyChange;
import org.jumpmind.db.alter.ColumnAutoIncrementChange;
import org.jumpmind.db.alter.ColumnChange;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.ColumnSizeChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.IModelChange;
import org.jumpmind.db.alter.PrimaryKeyChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.RemoveForeignKeyChange;
import org.jumpmind.db.alter.RemoveIndexChange;
import org.jumpmind.db.alter.RemovePrimaryKeyChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.alter.TableChangeImplBase;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;
import org.jumpmind.db.platform.PlatformUtils;

public class MsSql2000DdlBuilder
extends AbstractDdlBuilder {
    private DateFormat _genericDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat _genericTimeFormat = new SimpleDateFormat("HH:mm:ss");

    public MsSql2000DdlBuilder() {
        super("mssql2000");
        this.databaseInfo.setMaxIdentifierLength(128);
        this.databaseInfo.addNativeTypeMapping(2003, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(-5, "BIGINT", -5);
        this.databaseInfo.addNativeTypeMapping(91, "DATETIME", 93);
        this.databaseInfo.addNativeTypeMapping(2001, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(8, "FLOAT", 6);
        this.databaseInfo.addNativeTypeMapping(4, "INT");
        this.databaseInfo.addNativeTypeMapping(2000, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(-4, "IMAGE");
        this.databaseInfo.addNativeTypeMapping(-1, "TEXT", -1);
        this.databaseInfo.addNativeTypeMapping(-16, "NTEXT", -16);
        this.databaseInfo.addNativeTypeMapping(0, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(1111, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(2006, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(2002, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(92, "DATETIME", 93);
        this.databaseInfo.addNativeTypeMapping(93, "DATETIME");
        this.databaseInfo.addNativeTypeMapping(-101, "DATETIME");
        this.databaseInfo.addNativeTypeMapping(-102, "DATETIME");
        this.databaseInfo.addNativeTypeMapping(-6, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping("BOOLEAN", "BIT", "BIT");
        this.databaseInfo.addNativeTypeMapping("DATALINK", "IMAGE", "LONGVARBINARY");
        this.databaseInfo.setDefaultSize(1, 254);
        this.databaseInfo.setDefaultSize(12, 254);
        this.databaseInfo.setDefaultSize(-2, 254);
        this.databaseInfo.setDefaultSize(-3, 254);
        this.databaseInfo.setDefaultSize(93, 3);
        this.databaseInfo.setMaxSize("DATETIME", 3);
        this.databaseInfo.setDateOverridesToTimestamp(true);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(true);
        this.databaseInfo.setBlankCharColumnSpacePadded(true);
        this.databaseInfo.setCharColumnSpaceTrimmed(false);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setAutoIncrementUpdateAllowed(false);
        this.databaseInfo.setGeneratedColumnsSupported(true);
        this.databaseInfo.setBinaryQuoteStart("0x");
        this.databaseInfo.setBinaryQuoteEnd("");
        this.addLobMapping();
    }

    protected void addLobMapping() {
        this.databaseInfo.addNativeTypeMapping(2004, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(2005, "TEXT", -1);
    }

    @Override
    public String mapDefaultValue(Object defaultValue, Column column) {
        String newValue = super.mapDefaultValue(defaultValue, column);
        if (this.databaseInfo.getDefaultValuesToTranslate().containsKey(defaultValue.toString())) {
            return newValue;
        }
        int typeCode = column.getMappedTypeCode();
        if (!(typeCode != 93 && typeCode != -101 && typeCode != -102 || column.allPlatformColumnNamesContain("mssql"))) {
            String uppercaseValue = newValue.trim().toUpperCase();
            if (uppercaseValue.startsWith("SYSDATE") || uppercaseValue.startsWith("SYSTIMESTAMP") || uppercaseValue.startsWith("CURRENT_DATE") || uppercaseValue.startsWith("CURRENT_TIMESTAMP") || uppercaseValue.startsWith("CURRENT DATE") || uppercaseValue.startsWith("CURRENT TIMESTAMP") || uppercaseValue.startsWith("LOCALTIME") || uppercaseValue.startsWith("NOW(") || uppercaseValue.startsWith("TRANSACTION_TIMESTAMP(") || uppercaseValue.startsWith("STATEMENT_TIMESTAMP(") || uppercaseValue.startsWith("CLOCK_TIMESTAMP(")) {
                newValue = "GETDATE()";
            } else if (uppercaseValue.startsWith("UTC_TIMESTAMP")) {
                newValue = "GETUTCDATE()";
            }
        }
        return newValue;
    }

    @Override
    protected void createTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        this.writeQuotationOnStatement(ddl);
        super.createTable(table, ddl, temporary, recreate);
    }

    @Override
    protected void dropTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        String tableName = this.getTableName(table.getName());
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        String tableNameVar = "tn" + this.createUniqueIdentifier();
        String constraintNameVar = "cn" + this.createUniqueIdentifier();
        this.writeQuotationOnStatement(ddl);
        ddl.append("IF EXISTS (SELECT 1 FROM ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        ddl.append("dbo.sysobjects WHERE type = 'U' AND name = ");
        this.printAlwaysSingleQuotedIdentifier(tableName, ddl);
        this.println(")", ddl);
        this.println("BEGIN", ddl);
        this.println("  DECLARE @" + tableNameVar + " nvarchar(256), @" + constraintNameVar + " nvarchar(256)", ddl);
        this.println("  DECLARE refcursor CURSOR FOR", ddl);
        this.println("  SELECT object_name(objs.parent_obj) tablename, objs.name constraintname", ddl);
        ddl.append("    FROM ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        ddl.append("dbo.sysobjects objs");
        ddl.append("    WHERE objs.xtype in ('C','D','F','UQ') AND object_name(objs.parent_obj) = ");
        this.printAlwaysSingleQuotedIdentifier(tableName, ddl);
        this.println("", ddl);
        this.println("  OPEN refcursor", ddl);
        this.println("  FETCH NEXT FROM refcursor INTO @" + tableNameVar + ", @" + constraintNameVar, ddl);
        this.println("  WHILE @@FETCH_STATUS = 0", ddl);
        this.println("    BEGIN", ddl);
        ddl.append("      EXEC ('ALTER TABLE ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            this.printIdentifier(schema, ddl);
            ddl.append(".");
        }
        ddl.append("'+@" + tableNameVar + "+' DROP CONSTRAINT '+@" + constraintNameVar + ")");
        this.println("", ddl);
        this.println("      FETCH NEXT FROM refcursor INTO @" + tableNameVar + ", @" + constraintNameVar, ddl);
        this.println("    END", ddl);
        this.println("  CLOSE refcursor", ddl);
        this.println("  DEALLOCATE refcursor", ddl);
        ddl.append("  DROP TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        this.println("", ddl);
        this.println("END", ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    public void dropExternalForeignKeys(Table table, StringBuilder ddl) {
        this.writeQuotationOnStatement(ddl);
        super.dropExternalForeignKeys(table, ddl);
    }

    @Override
    protected DateFormat getValueDateFormat() {
        return this._genericDateFormat;
    }

    @Override
    protected DateFormat getValueTimeFormat() {
        return this._genericTimeFormat;
    }

    @Override
    protected String getValueAsString(Column column, Object value) {
        if (value == null) {
            return "NULL";
        }
        StringBuilder result = new StringBuilder();
        switch (column.getMappedTypeCode()) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                if (!(value instanceof String) && this.getValueNumberFormat() != null) {
                    result.append(this.getValueNumberFormat().format(value));
                    break;
                }
                result.append(value);
                break;
            }
            case 91: {
                result.append("CAST(");
                result.append(this.databaseInfo.getValueQuoteToken());
                result.append(value instanceof String ? (String)value : this.getValueDateFormat().format(value));
                result.append(this.databaseInfo.getValueQuoteToken());
                result.append(" AS datetime)");
                break;
            }
            case 92: {
                result.append("CAST(");
                result.append(this.databaseInfo.getValueQuoteToken());
                result.append(value instanceof String ? (String)value : this.getValueTimeFormat().format(value));
                result.append(this.databaseInfo.getValueQuoteToken());
                result.append(" AS datetime)");
                break;
            }
            case 93: {
                result.append("CAST(");
                result.append(this.databaseInfo.getValueQuoteToken());
                result.append(value);
                result.append(this.databaseInfo.getValueQuoteToken());
                result.append(" AS datetime)");
            }
        }
        return super.getValueAsString(column, value);
    }

    @Override
    protected String getNativeDefaultValue(Column column) {
        String defaultValue;
        if (column.getMappedTypeCode() == -7 || PlatformUtils.supportsJava14JdbcTypes() && column.getMappedTypeCode() == PlatformUtils.determineBooleanTypeCode()) {
            String defaultValue2 = column.getDefaultValue();
            if ("NULL".equalsIgnoreCase(defaultValue2)) {
                return defaultValue2;
            }
            if ("'True'".equalsIgnoreCase(defaultValue2)) {
                return "1";
            }
            return this.getDefaultValueHelper().convert(defaultValue2, column.getMappedTypeCode(), 5);
        }
        if ((column.getMappedTypeCode() == 93 || column.getMappedTypeCode() == 92 || column.getMappedTypeCode() == 91) && (defaultValue = super.getNativeDefaultValue(column)) != null && (defaultValue.equalsIgnoreCase("CURRENT_DATE") || defaultValue.equalsIgnoreCase("CURRENT DATE"))) {
            return "CURRENT_TIMESTAMP";
        }
        return super.getNativeDefaultValue(column);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
        ddl.append("IDENTITY (1,1) ");
    }

    @Override
    protected void writeExternalForeignKeyDropStmt(Table table, ForeignKey foreignKey, StringBuilder ddl) {
        String constraintName = this.getForeignKeyName(table, foreignKey);
        String catalog = table.getCatalog();
        ddl.append("IF EXISTS (SELECT 1 FROM ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        ddl.append("sys.sysobjects WHERE type = 'F' AND name = ");
        this.printAlwaysSingleQuotedIdentifier(constraintName, ddl);
        this.println(")", ddl);
        this.printIndent(ddl);
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        ddl.append(" DROP CONSTRAINT ");
        this.printIdentifier(constraintName, ddl);
        this.printEndOfStatement(ddl);
    }

    private String getQuotationOnStatement() {
        if (this.delimitedIdentifierModeOn) {
            return "SET quoted_identifier on" + this.databaseInfo.getSqlCommandDelimiter() + "\n";
        }
        return "";
    }

    private void writeQuotationOnStatement(StringBuilder ddl) {
        ddl.append(this.getQuotationOnStatement());
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        return "SELECT @@IDENTITY";
    }

    @Override
    public String getDeleteSql(Table table, Map<String, Object> pkValues, boolean genPlaceholders) {
        return this.getQuotationOnStatement() + super.getDeleteSql(table, pkValues, genPlaceholders);
    }

    @Override
    public String getInsertSql(Table table, Map<String, Object> columnValues, boolean genPlaceholders) {
        return this.getQuotationOnStatement() + super.getInsertSql(table, columnValues, genPlaceholders);
    }

    @Override
    public String getUpdateSql(Table table, Map<String, Object> columnValues, boolean genPlaceholders) {
        return this.getQuotationOnStatement() + super.getUpdateSql(table, columnValues, genPlaceholders);
    }

    protected void printAlwaysSingleQuotedIdentifier(String identifier, StringBuilder ddl) {
        ddl.append("'");
        ddl.append(identifier);
        ddl.append("'");
    }

    @Override
    public void writeCopyDataStatement(Table sourceTable, Table targetTable, StringBuilder ddl) {
        boolean hasIdentityColumns;
        boolean bl = hasIdentityColumns = targetTable.getAutoIncrementColumns().length > 0;
        if (hasIdentityColumns) {
            ddl.append("SET IDENTITY_INSERT ");
            ddl.append(this.getFullyQualifiedTableNameShorten(targetTable));
            ddl.append(" ON");
            this.printEndOfStatement(ddl);
        }
        super.writeCopyDataStatement(sourceTable, targetTable, ddl);
        if (hasIdentityColumns) {
            ddl.append("SET IDENTITY_INSERT ");
            ddl.append(this.getFullyQualifiedTableNameShorten(targetTable));
            ddl.append(" OFF");
            this.printEndOfStatement(ddl);
        }
    }

    @Override
    protected void processChanges(Database currentModel, Database desiredModel, List<IModelChange> changes, StringBuilder ddl) {
        if (!changes.isEmpty()) {
            this.writeQuotationOnStatement(ddl);
        }
        HashSet<IIndex> removedIndexes = new HashSet<IIndex>();
        HashSet<ForeignKey> removedForeignKeys = new HashSet<ForeignKey>();
        HashSet<Table> removedPKs = new HashSet<Table>();
        for (IModelChange change : changes) {
            if (change instanceof RemoveIndexChange) {
                removedIndexes.add(((RemoveIndexChange)change).getIndex());
                continue;
            }
            if (change instanceof RemoveForeignKeyChange) {
                removedForeignKeys.add(((RemoveForeignKeyChange)change).getForeignKey());
                continue;
            }
            if (!(change instanceof RemovePrimaryKeyChange)) continue;
            removedPKs.add(((RemovePrimaryKeyChange)change).getChangedTable());
        }
        ArrayList<TableChangeImplBase> additionalChanges = new ArrayList<TableChangeImplBase>();
        for (IModelChange change : changes) {
            if (!(change instanceof ColumnDataTypeChange) && !(change instanceof ColumnSizeChange)) continue;
            Column column = ((ColumnChange)change).getChangedColumn();
            Table table = ((ColumnChange)change).getChangedTable();
            if (column.isPrimaryKey() && !removedPKs.contains(table)) {
                Column[] pk = table.getPrimaryKeyColumnsInIndexOrder();
                additionalChanges.add(new RemovePrimaryKeyChange(table, pk));
                additionalChanges.add(new AddPrimaryKeyChange(table, pk));
                removedPKs.add(table);
            }
            for (int idx = 0; idx < table.getIndexCount(); ++idx) {
                IIndex index = table.getIndex(idx);
                if (!index.hasColumn(column) || removedIndexes.contains(index)) continue;
                additionalChanges.add(new RemoveIndexChange(table, index));
                additionalChanges.add(new AddIndexChange(table, index));
                removedIndexes.add(index);
            }
            for (int tableIdx = 0; tableIdx < currentModel.getTableCount(); ++tableIdx) {
                Table curTable = currentModel.getTable(tableIdx);
                for (int fkIdx = 0; fkIdx < curTable.getForeignKeyCount(); ++fkIdx) {
                    ForeignKey curFk = curTable.getForeignKey(fkIdx);
                    if (!curFk.hasLocalColumn(column) && !curFk.hasForeignColumn(column) || removedForeignKeys.contains(curFk)) continue;
                    additionalChanges.add(new RemoveForeignKeyChange(curTable, curFk));
                    additionalChanges.add(new AddForeignKeyChange(curTable, curFk));
                    removedForeignKeys.add(curFk);
                }
            }
        }
        changes.addAll(additionalChanges);
        super.processChanges(currentModel, desiredModel, changes, ddl);
    }

    @Override
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        TableChange change;
        for (TableChange change2 : changes) {
            if (!(change2 instanceof ColumnAutoIncrementChange)) continue;
            return;
        }
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            TableChange change2;
            change2 = changeIt.next();
            if (change2 instanceof RemovePrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (RemovePrimaryKeyChange)change2, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change2 instanceof PrimaryKeyChange)) continue;
            PrimaryKeyChange pkChange = (PrimaryKeyChange)change2;
            RemovePrimaryKeyChange removePkChange = new RemovePrimaryKeyChange(pkChange.getChangedTable(), pkChange.getOldPrimaryKeyColumns());
            this.processChange(currentModel, desiredModel, removePkChange, ddl);
        }
        ArrayList<ColumnChange> columnChanges = new ArrayList<ColumnChange>();
        Iterator<TableChange> changeIt2 = changes.iterator();
        while (changeIt2.hasNext()) {
            change = changeIt2.next();
            if (change instanceof AddColumnChange) {
                AddColumnChange addColumnChange = (AddColumnChange)change;
                this.processChange(currentModel, desiredModel, addColumnChange, ddl);
                changeIt2.remove();
                continue;
            }
            if (change instanceof RemoveColumnChange) {
                this.processChange(currentModel, desiredModel, (RemoveColumnChange)change, ddl);
                changeIt2.remove();
                continue;
            }
            if (change instanceof CopyColumnValueChange) {
                CopyColumnValueChange copyColumnChange = (CopyColumnValueChange)change;
                this.processChange(currentModel, desiredModel, copyColumnChange, ddl);
                changeIt2.remove();
                continue;
            }
            if (!(change instanceof ColumnChange) || columnChanges == null) continue;
            columnChanges.add((ColumnChange)change);
        }
        if (columnChanges != null) {
            HashSet<Column> processedColumns = new HashSet<Column>();
            for (ColumnChange change3 : columnChanges) {
                Column sourceColumn = change3.getChangedColumn();
                if (!sourceColumn.isPrimaryKey()) {
                    Column targetColumn = targetTable.findColumn(sourceColumn.getName(), this.delimitedIdentifierModeOn);
                    if (!processedColumns.contains(targetColumn)) {
                        this.processColumnChange(sourceTable, targetTable, sourceColumn, targetColumn, change3 instanceof ColumnDataTypeChange || change3 instanceof ColumnSizeChange, ddl);
                        processedColumns.add(targetColumn);
                    }
                    changes.remove(change3);
                    change3.apply(currentModel, this.delimitedIdentifierModeOn);
                    continue;
                }
                this.log.debug("Cannot alter a primay key column on sql server (azure).  Just let the table rebuild.");
            }
        }
        changeIt2 = changes.iterator();
        while (changeIt2.hasNext()) {
            change = changeIt2.next();
            if (change instanceof AddPrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (AddPrimaryKeyChange)change, ddl);
                changeIt2.remove();
                continue;
            }
            if (!(change instanceof PrimaryKeyChange)) continue;
            PrimaryKeyChange pkChange = (PrimaryKeyChange)change;
            AddPrimaryKeyChange addPkChange = new AddPrimaryKeyChange(pkChange.getChangedTable(), pkChange.getNewPrimaryKeyColumns());
            this.processChange(currentModel, desiredModel, addPkChange, ddl);
            changeIt2.remove();
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("ADD ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn(), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change, StringBuilder ddl) {
        boolean hasDefault;
        boolean bl = hasDefault = change.getColumn().getParsedDefaultValue() != null;
        if (hasDefault) {
            this.dropDefaultConstraint(change.getChangedTable(), change.getColumn().getName(), ddl);
        }
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemovePrimaryKeyChange change, StringBuilder ddl) {
        String catalog = change.getChangedTable().getCatalog();
        String schema = change.getChangedTable().getSchema();
        String tableName = this.getTableName(change.getChangedTable().getName());
        String tableNameVar = "tn" + this.createUniqueIdentifier();
        String constraintNameVar = "cn" + this.createUniqueIdentifier();
        this.println("BEGIN", ddl);
        this.println("  DECLARE @" + tableNameVar + " nvarchar(256), @" + constraintNameVar + " nvarchar(256)", ddl);
        this.println("  DECLARE refcursor CURSOR FOR", ddl);
        this.println("  SELECT parentobjs.name tablename, objs.name constraintname", ddl);
        ddl.append("    FROM ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        this.println("dbo.sysobjects objs", ddl);
        ddl.append("    JOIN ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        this.println("dbo.sysobjects parentobjs on objs.parent_obj=parentobjs.id", ddl);
        ddl.append("    WHERE objs.xtype = 'PK' AND parentobjs.name = ");
        this.printAlwaysSingleQuotedIdentifier(tableName, ddl);
        this.println("", ddl);
        this.println("  OPEN refcursor", ddl);
        this.println("  FETCH NEXT FROM refcursor INTO @" + tableNameVar + ", @" + constraintNameVar, ddl);
        this.println("  WHILE @@FETCH_STATUS = 0", ddl);
        this.println("    BEGIN", ddl);
        ddl.append("      EXEC ('ALTER TABLE ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            this.printIdentifier(schema, ddl);
            ddl.append(".");
        }
        ddl.append("'+@" + tableNameVar + "+' DROP CONSTRAINT '+@" + constraintNameVar + ")");
        this.println("", ddl);
        this.println("      FETCH NEXT FROM refcursor INTO @" + tableNameVar + ", @" + constraintNameVar, ddl);
        this.println("    END", ddl);
        this.println("  CLOSE refcursor", ddl);
        this.println("  DEALLOCATE refcursor", ddl);
        ddl.append("END");
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void dropDefaultConstraint(Table table, String columnName, StringBuilder ddl) {
        this.println("BEGIN                                                                                        ", ddl);
        this.println("DECLARE @sql NVARCHAR(2000)                                                                  ", ddl);
        this.println(String.format("SELECT TOP 1 @sql = N'alter table \"%s\" drop constraint ['+objs.NAME+N']'                     ", table.getName()), ddl);
        this.println("FROM dbo.sysconstraints dc                                                              ", ddl);
        this.println("JOIN dbo.sysobjects objs                                                                          ", ddl);
        this.println("    ON objs.id = dc.constid                                                     ", ddl);
        this.println("JOIN sys.columns c                                                                           ", ddl);
        this.println("    ON c.default_object_id = dc.colid                                                    ", ddl);
        this.println("WHERE                                                                                        ", ddl);
        this.println(String.format("    dc.id = OBJECT_ID('%s')                                                    ", table.getName()), ddl);
        this.println(String.format("AND c.name = N'%s'                                                                           ", columnName), ddl);
        this.println("IF @@ROWCOUNT > 0                                                                            ", ddl);
        this.println("  EXEC (@sql)                                                                                ", ddl);
        this.println("END                                                                                          ", ddl);
        this.printEndOfStatement(ddl);
    }

    protected void processColumnChange(Table sourceTable, Table targetTable, Column sourceColumn, Column targetColumn, boolean typeChange, StringBuilder ddl) {
        boolean hasDefault = sourceColumn.getParsedDefaultValue() != null;
        boolean shallHaveDefault = targetColumn.getParsedDefaultValue() != null;
        String newDefault = targetColumn.getDefaultValue();
        if (newDefault != null) {
            targetColumn.setDefaultValue(null);
        }
        if (hasDefault) {
            this.dropColumnChangeDefaults(sourceTable, sourceColumn, ddl);
        }
        if (targetColumn.getMappedType().equalsIgnoreCase("LONGNVARCHAR") && sourceColumn.getJdbcTypeName().equalsIgnoreCase("text") || targetColumn.getMappedType().equalsIgnoreCase("LONGVARCHAR") && sourceColumn.getJdbcTypeName().equalsIgnoreCase("ntext")) {
            ddl.append("ALTER TABLE ");
            ddl.append(this.getFullyQualifiedTableNameShorten(sourceTable));
            this.printIndent(ddl);
            ddl.append("ALTER COLUMN ");
            this.printIdentifier(this.getColumnName(targetColumn), ddl);
            ddl.append(" varchar(max)");
            this.printEndOfStatement(ddl);
        }
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(sourceTable));
        this.printIndent(ddl);
        ddl.append("ALTER COLUMN ");
        this.writeColumnTypeDefaultRequired(sourceTable, targetColumn, ddl);
        this.printEndOfStatement(ddl);
        if (shallHaveDefault) {
            targetColumn.setDefaultValue(newDefault);
            ddl.append("ALTER TABLE ");
            ddl.append(this.getFullyQualifiedTableNameShorten(sourceTable));
            this.printIndent(ddl);
            ddl.append("ADD CONSTRAINT ");
            this.printIdentifier(this.getConstraintName("DF", sourceTable, sourceColumn.getName(), null), ddl);
            this.writeColumnDefaultValueStmt(sourceTable, targetColumn, ddl);
            ddl.append(" FOR ");
            this.printIdentifier(this.getColumnName(sourceColumn), ddl);
            this.printEndOfStatement(ddl);
        }
    }

    protected void dropColumnChangeDefaults(Table sourceTable, Column sourceColumn, StringBuilder ddl) {
        String tableName = this.getTableName(sourceTable.getName());
        String columnName = this.getColumnName(sourceColumn);
        String tableNameVar = "tn" + this.createUniqueIdentifier();
        String constraintNameVar = "cn" + this.createUniqueIdentifier();
        this.println("BEGIN", ddl);
        this.println("  DECLARE @" + tableNameVar + " nvarchar(256), @" + constraintNameVar + " nvarchar(256)", ddl);
        this.println("  DECLARE refcursor CURSOR FOR", ddl);
        this.println("  SELECT object_name(cons.id) tablename, object_name(cons.constid) constraintname FROM dbo.sysconstraints cons ", ddl);
        this.println("    WHERE  cons.colid = (SELECT colid FROM syscolumns WHERE id = object_id(", ddl);
        this.printAlwaysSingleQuotedIdentifier(tableName, ddl);
        ddl.append(") AND name = ");
        this.printAlwaysSingleQuotedIdentifier(columnName, ddl);
        this.println(") AND", ddl);
        ddl.append("          object_name(cons.id) = ");
        this.printAlwaysSingleQuotedIdentifier(tableName, ddl);
        this.println("  OPEN refcursor", ddl);
        this.println("  FETCH NEXT FROM refcursor INTO @" + tableNameVar + ", @" + constraintNameVar, ddl);
        this.println("  WHILE @@FETCH_STATUS = 0", ddl);
        this.println("    BEGIN", ddl);
        this.println("      EXEC ('ALTER TABLE '+@" + tableNameVar + "+' DROP CONSTRAINT '+@" + constraintNameVar + ")", ddl);
        this.println("      FETCH NEXT FROM refcursor INTO @" + tableNameVar + ", @" + constraintNameVar, ddl);
        this.println("    END", ddl);
        this.println("  CLOSE refcursor", ddl);
        this.println("  DEALLOCATE refcursor", ddl);
        ddl.append("END");
        this.printEndOfStatement(ddl);
    }

    protected String createUniqueIdentifier() {
        return new UID().toString().replace(':', '_').replace('-', '_');
    }

    @Override
    protected void filterColumnSqlType(StringBuilder sqlType) {
        int identityIndex = sqlType.indexOf("identity");
        if (identityIndex > 0) {
            sqlType.replace(identityIndex, sqlType.length(), "");
            int parensIndex = sqlType.indexOf("()");
            if (parensIndex > 0) {
                sqlType.replace(parensIndex, sqlType.length(), "");
            }
        }
        if (sqlType.toString().equalsIgnoreCase("varchar")) {
            sqlType.setLength(0);
            sqlType.append("varchar(max)");
        } else if (sqlType.toString().equalsIgnoreCase("varbinary")) {
            sqlType.setLength(0);
            sqlType.append("varbinary(max)");
        } else if (sqlType.toString().equalsIgnoreCase("nvarchar")) {
            sqlType.setLength(0);
            sqlType.append("nvarchar(max)");
        } else if (sqlType.toString().equalsIgnoreCase("nvarbinary")) {
            sqlType.setLength(0);
            sqlType.append("nvarbinary(max)");
        } else if (StringUtils.containsIgnoreCase((CharSequence)sqlType, (CharSequence)"uniqueidentifier(")) {
            sqlType.setLength(0);
            sqlType.append("uniqueidentifier");
        } else if (StringUtils.containsIgnoreCase((CharSequence)sqlType, (CharSequence)"sysname(")) {
            sqlType.setLength(0);
            sqlType.append("sysname");
        }
    }

    @Override
    protected void writeColumnDefaultValue(Table table, Column column, StringBuilder ddl) {
        String defaultValueStr;
        String defaultValue = this.getNativeDefaultValue(column);
        PlatformColumn platformColumn = column.findPlatformColumn(this.databaseName);
        if (platformColumn != null && StringUtils.containsIgnoreCase((CharSequence)platformColumn.getType(), (CharSequence)"uniqueidentifier") && (StringUtils.containsIgnoreCase((CharSequence)(defaultValueStr = this.mapDefaultValue(defaultValue, column)), (CharSequence)"NEWID()") || StringUtils.containsIgnoreCase((CharSequence)defaultValueStr, (CharSequence)"NEWSEQUENTIALID()"))) {
            ddl.append(defaultValueStr);
            return;
        }
        this.printDefaultValue(defaultValue, column, ddl);
    }

    @Override
    protected boolean shouldUseQuotes(String defaultValue, Column column) {
        String defaultValueStr;
        for (defaultValueStr = this.mapDefaultValue(defaultValue, column); defaultValueStr != null && defaultValueStr.startsWith("(") && defaultValueStr.endsWith(")"); defaultValueStr = defaultValueStr.substring(1, defaultValueStr.length() - 1)) {
        }
        return super.shouldUseQuotes(defaultValue, column) && !defaultValueStr.trim().toUpperCase().startsWith("GETDATE(") && !defaultValueStr.trim().toUpperCase().startsWith("GETUTCDATE(");
    }

    @Override
    protected void writeGeneratedColumn(Table table, Column column, StringBuilder ddl) {
        String definition = this.getDefinitionForGeneratedColumn(table, column);
        if (!StringUtils.isBlank((CharSequence)definition)) {
            this.printIdentifier(this.getColumnName(column), ddl);
            ddl.append(" AS ").append(definition);
        } else {
            this.writeColumnTypeDefaultRequired(table, column, ddl);
        }
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyUpdate(ForeignKey key, StringBuilder ddl) {
        ForeignKey.ForeignKeyAction original = key.getOnUpdateAction();
        if (key.getOnUpdateAction() == ForeignKey.ForeignKeyAction.RESTRICT) {
            key.setOnUpdateAction(ForeignKey.ForeignKeyAction.NOACTION);
        }
        super.writeCascadeAttributesForForeignKeyUpdate(key, ddl);
        key.setOnUpdateAction(original);
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyDelete(ForeignKey key, StringBuilder ddl) {
        ForeignKey.ForeignKeyAction original = key.getOnDeleteAction();
        if (key.getOnDeleteAction() == ForeignKey.ForeignKeyAction.RESTRICT) {
            key.setOnDeleteAction(ForeignKey.ForeignKeyAction.NOACTION);
        }
        super.writeCascadeAttributesForForeignKeyDelete(key, ddl);
        key.setOnDeleteAction(original);
    }
}

