/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mssql;

import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.mssql.MsSql2000DdlBuilder;

public class MsSql2005DdlBuilder
extends MsSql2000DdlBuilder {
    public static final int NVARCHARMAX_LIMIT = 4000;
    public static final int VARCHARMAX_LIMIT = 8000;

    public MsSql2005DdlBuilder() {
        this.databaseName = "mssql2005";
        this.databaseInfo.addNativeTypeMapping(2009, "XML", 2009);
    }

    @Override
    protected void addLobMapping() {
        this.databaseInfo.addNativeTypeMapping(-4, "VARBINARY(MAX)", -4);
        this.databaseInfo.addNativeTypeMapping(2004, "VARBINARY(MAX)", 2004);
        this.databaseInfo.addNativeTypeMapping(2011, "NVARCHAR(MAX)", 2011);
        this.databaseInfo.addNativeTypeMapping(2005, "VARCHAR(MAX)", 2005);
        this.databaseInfo.addNativeTypeMapping(-1, "VARCHAR(MAX)", -1);
    }

    @Override
    protected void dropDefaultConstraint(Table table, String columnName, StringBuilder ddl) {
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        this.println("BEGIN", ddl);
        this.println("DECLARE @sql NVARCHAR(2000)", ddl);
        ddl.append("SELECT @sql = N'alter table ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            this.printIdentifier(schema, ddl);
            ddl.append(".");
        }
        this.printIdentifier(table.getName(), ddl);
        this.println(" drop constraint ['+cons.NAME+N']'", ddl);
        ddl.append("from ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        this.println("sys.default_constraints cons", ddl);
        ddl.append("join ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        this.println("sys.syscolumns cols on cons.parent_object_id = cols.id and cons.parent_column_id = cols.colid", ddl);
        ddl.append("join ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        this.println("sys.sysobjects objs on objs.id=cons.parent_object_id", ddl);
        ddl.append("join ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        this.println("sys.schemas sch on sch.schema_id = objs.uid", ddl);
        this.println("WHERE cols.name='" + columnName + "' and objs.name='" + table.getName() + "' and sch.name='" + schema + "'", ddl);
        this.println("IF @@ROWCOUNT > 0", ddl);
        this.println("  EXEC (@sql)", ddl);
        this.println("END", ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void dropColumnChangeDefaults(Table sourceTable, Column sourceColumn, StringBuilder ddl) {
        String tableName = this.getTableName(sourceTable.getName());
        String columnName = this.getColumnName(sourceColumn);
        String tableNameVar = "tn" + this.createUniqueIdentifier();
        String constraintNameVar = "cn" + this.createUniqueIdentifier();
        String catalog = sourceTable.getCatalog();
        String schema = sourceTable.getSchema();
        this.println("BEGIN", ddl);
        this.println("  DECLARE @" + tableNameVar + " nvarchar(256), @" + constraintNameVar + " nvarchar(256)", ddl);
        this.println("  DECLARE refcursor CURSOR FOR", ddl);
        this.println("  select objs.name tablename, cons.name constraintname ", ddl);
        ddl.append("   from ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        this.println("sys.default_constraints cons", ddl);
        ddl.append("join ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        this.println("sys.sysobjects objs on cons.parent_object_id=objs.id", ddl);
        ddl.append("join ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        this.println("sys.schemas sch on objs.uid=sch.schema_id", ddl);
        this.println("    where cons.parent_column_id=(", ddl);
        this.println("    SELECT colid", ddl);
        ddl.append("    FROM ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        this.println("sys.syscolumns cols", ddl);
        ddl.append(" JOIN ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        this.println("sys.sysobjects objs on objs.id=cols.id", ddl);
        ddl.append(" JOIN ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        this.println("sys.schemas sch on sch.schema_id=objs.uid", ddl);
        ddl.append("WHERE objs.name = ");
        this.printAlwaysSingleQuotedIdentifier(tableName, ddl);
        ddl.append(" and cols.name = ");
        this.printAlwaysSingleQuotedIdentifier(columnName, ddl);
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            ddl.append(" AND sch.name=");
            this.printAlwaysSingleQuotedIdentifier(schema, ddl);
        }
        this.println(")", ddl);
        ddl.append(" AND objs.name=");
        this.printAlwaysSingleQuotedIdentifier(tableName, ddl);
        ddl.append(" AND sch.name=");
        this.printAlwaysSingleQuotedIdentifier(schema, ddl);
        this.println("", ddl);
        this.println("  OPEN refcursor", ddl);
        this.println("  FETCH NEXT FROM refcursor INTO @" + tableNameVar + ", @" + constraintNameVar, ddl);
        this.println("  WHILE @@FETCH_STATUS = 0", ddl);
        this.println("    BEGIN", ddl);
        ddl.append("      EXEC ('ALTER TABLE ");
        if (StringUtils.isNotBlank((CharSequence)catalog)) {
            this.printIdentifier(catalog, ddl);
            ddl.append(".");
        }
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            this.printIdentifier(schema, ddl);
            ddl.append(".");
        }
        ddl.append("'+@" + tableNameVar + "+' DROP CONSTRAINT '+@" + constraintNameVar + ")");
        this.println("", ddl);
        this.println("      FETCH NEXT FROM refcursor INTO @" + tableNameVar + ", @" + constraintNameVar, ddl);
        this.println("    END", ddl);
        this.println("  CLOSE refcursor", ddl);
        this.println("  DEALLOCATE refcursor", ddl);
        ddl.append("END");
        this.printEndOfStatement(ddl);
    }

    @Override
    public String getSqlType(Column column) {
        Object sqlType = super.getSqlType(column);
        boolean useVarcharForText = System.getProperty("mssql.use.varchar.for.lob", "false").equalsIgnoreCase("true");
        boolean useNvarChar = System.getProperty("mssql.use.ntypes.for.chars", "false").equalsIgnoreCase("true");
        if (column.getMappedTypeCode() == -3 && column.anyPlatformColumnTypeContains("hierarchyid")) {
            sqlType = "HIERARCHYID";
        } else if (column.getMappedTypeCode() == -3 && column.getSizeAsInt() > 8000) {
            sqlType = "VARBINARY(MAX)";
        } else if (column.getMappedTypeCode() == 12 && column.getSizeAsInt() > 8000) {
            sqlType = "VARCHAR(MAX)";
        } else if (column.getMappedTypeCode() == -9 && column.getSizeAsInt() > 4000) {
            sqlType = "NVARCHAR(MAX)";
        } else if (column.getMappedTypeCode() == 3 && column.getSizeAsInt() > 38) {
            sqlType = String.format("DECIMAL(38,%d)", column.getScale());
        } else if (useVarcharForText && (column.getMappedTypeCode() == -1 || column.getMappedTypeCode() == -16 || column.getMappedTypeCode() == 2005)) {
            column.setMappedType("VARCHAR");
            column.setSize("10000");
            sqlType = column.getMappedTypeCode() == -16 ? "N" : "";
            sqlType = (String)sqlType + "VARCHAR(MAX)";
        }
        if (useNvarChar && column.getMappedTypeCode() == 12) {
            int intColumnSize = 2 * column.getSizeAsInt();
            String strColumnSize = String.valueOf(intColumnSize);
            if (intColumnSize > 4000) {
                strColumnSize = "MAX";
            }
            sqlType = String.format("NVARCHAR(%s)", strColumnSize);
        }
        return sqlType;
    }

    @Override
    protected void writeColumnType(Table table, Column column, StringBuilder ddl) {
        super.writeColumnType(table, column, ddl);
        PlatformColumn platformColumn = column.findPlatformColumn(this.databaseName);
        if (!(column.isRequired() || platformColumn == null || !platformColumn.isUserDefinedType() || this.databaseInfo.isNullAsDefaultValueRequired() && this.databaseInfo.hasNullDefault(column.getMappedTypeCode()))) {
            ddl.append(" ");
            this.writeColumnNullableStmt(ddl);
        }
    }

    @Override
    protected void writeExternalIndexCreate(Table table, IIndex index, StringBuilder ddl) {
        super.writeExternalIndexCreate(table, index, ddl);
        if (index.getIncludedColumns() != null && index.getIncludedColumns().length > 0) {
            ddl.append(" INCLUDE (");
            IndexColumn[] includedColumns = index.getIncludedColumns();
            for (int i = 0; i < includedColumns.length; ++i) {
                IndexColumn includedColumn = includedColumns[i];
                if (i > 0) {
                    ddl.append(", ");
                }
                ddl.append(includedColumn.getName());
            }
            ddl.append(")");
        }
    }
}

