/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.sql.InvalidSqlException;
import org.jumpmind.db.sql.ParsedSql;

public abstract class NamedParameterUtils {
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};
    private static final String[] START_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] STOP_SKIP = new String[]{"'", "\"", "\n", "*/"};

    public static ParsedSql parseSqlStatement(String sql) {
        HashSet<String> namedParameters = new HashSet<String>();
        ParsedSql parsedSql = new ParsedSql(sql);
        char[] statement = sql.toCharArray();
        int namedParameterCount = 0;
        int unnamedParameterCount = 0;
        int totalParameterCount = 0;
        int i = 0;
        while (i < statement.length) {
            char c;
            int skipToPosition = NamedParameterUtils.skipCommentsAndQuotes(statement, i);
            if (i != skipToPosition) {
                if (skipToPosition >= statement.length) break;
                i = skipToPosition;
            }
            if ((c = statement[i]) == ':' || c == '&') {
                int j = i + 1;
                if (j < statement.length && statement[j] == ':' && c == ':') {
                    i += 2;
                    continue;
                }
                while (j < statement.length && !NamedParameterUtils.isParameterSeparator(statement[j])) {
                    ++j;
                }
                if (j - i > 1) {
                    String parameter = sql.substring(i + 1, j);
                    if (namedParameters.add(parameter)) {
                        ++namedParameterCount;
                    }
                    parsedSql.addNamedParameter(parameter, i, j);
                    ++totalParameterCount;
                }
                i = j - 1;
            } else if (c == '?') {
                ++unnamedParameterCount;
                ++totalParameterCount;
            }
            ++i;
        }
        parsedSql.setNamedParameterCount(namedParameterCount);
        parsedSql.setUnnamedParameterCount(unnamedParameterCount);
        parsedSql.setTotalParameterCount(totalParameterCount);
        return parsedSql;
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        for (int i = 0; i < START_SKIP.length; ++i) {
            if (statement[position] != START_SKIP[i].charAt(0)) continue;
            boolean match = true;
            for (int j = 1; j < START_SKIP[i].length(); ++j) {
                if (statement[position + j] == START_SKIP[i].charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            int offset = START_SKIP[i].length();
            for (int m = position + offset; m < statement.length; ++m) {
                if (statement[m] != STOP_SKIP[i].charAt(0)) continue;
                boolean endMatch = true;
                int endPos = m;
                for (int n = 1; n < STOP_SKIP[i].length(); ++n) {
                    if (m + n >= statement.length) {
                        return statement.length;
                    }
                    if (statement[m + n] != STOP_SKIP[i].charAt(n)) {
                        endMatch = false;
                        break;
                    }
                    endPos = m + n;
                }
                if (!endMatch) continue;
                return endPos + 1;
            }
            return statement.length;
        }
        return position;
    }

    public static String substituteNamedParameters(ParsedSql parsedSql, Map<String, ?> paramSource) {
        String originalSql = parsedSql.getOriginalSql();
        StringBuilder actualSql = new StringBuilder();
        List<String> paramNames = parsedSql.getParameterNames();
        int lastIndex = 0;
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = paramNames.get(i);
            int[] indexes = parsedSql.getParameterIndexes(i);
            int startIndex = indexes[0];
            int endIndex = indexes[1];
            actualSql.append(originalSql.substring(lastIndex, startIndex));
            if (paramSource != null && paramSource.containsKey(paramName)) {
                Object value = paramSource.get(paramName);
                if (value instanceof Collection) {
                    Iterator entryIter = ((Collection)value).iterator();
                    int k = 0;
                    while (entryIter.hasNext()) {
                        if (k > 0) {
                            actualSql.append(", ");
                        }
                        ++k;
                        Object entryItem = entryIter.next();
                        if (entryItem instanceof Object[]) {
                            Object[] expressionList = (Object[])entryItem;
                            actualSql.append("(");
                            for (int m = 0; m < expressionList.length; ++m) {
                                if (m > 0) {
                                    actualSql.append(", ");
                                }
                                actualSql.append("?");
                            }
                            actualSql.append(")");
                            continue;
                        }
                        actualSql.append("?");
                    }
                } else {
                    actualSql.append("?");
                }
            } else {
                throw new InvalidSqlException("The parameter map passed in did not contain a key for the named parameter %s. \nKeys: %s \nSQL: %s", paramName, paramSource != null ? paramSource.keySet() : "null", originalSql);
            }
            lastIndex = endIndex;
        }
        actualSql.append(originalSql.substring(lastIndex, originalSql.length()));
        return actualSql.toString();
    }

    public static Object[] buildValueArray(ParsedSql parsedSql, Map<String, ?> paramSource) {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        if (parsedSql.getNamedParameterCount() > 0 && parsedSql.getUnnamedParameterCount() > 0) {
            throw new IllegalStateException("You can't mix named and traditional ? placeholders. You have " + parsedSql.getNamedParameterCount() + " named parameter(s) and " + parsedSql.getUnnamedParameterCount() + " traditonal placeholder(s) in [" + parsedSql.getOriginalSql() + "]");
        }
        List<String> paramNames = parsedSql.getParameterNames();
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = paramNames.get(i);
            Object value = paramSource.get(paramName);
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object object : collection) {
                    paramArray.add(object);
                }
                continue;
            }
            paramArray.add(value);
        }
        return paramArray.toArray(new Object[paramArray.size()]);
    }

    private static boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (char separator : PARAMETER_SEPARATORS) {
            if (c != separator) continue;
            return true;
        }
        return false;
    }
}

