/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jumpmind.db.sql.ISqlResultsListener;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.SqlScriptReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlScript {
    private static final Logger log = LoggerFactory.getLogger(SqlScript.class);
    private ISqlTemplate sqlTemplate;
    private int commitRate = 10000;
    private boolean failOnError = true;
    private boolean failOnDrop = true;
    private boolean failOnSequenceCreate = true;
    private ISqlResultsListener resultsListener;
    private SqlScriptReader scriptReader;

    public SqlScript(URL url, ISqlTemplate sqlTemplate) {
        this(url, sqlTemplate, true, ";", null);
    }

    public SqlScript(URL url, ISqlTemplate sqlTemplate, boolean failOnError) {
        this(url, sqlTemplate, failOnError, ";", null);
    }

    public SqlScript(URL url, ISqlTemplate sqlTemplate, String delimiter) {
        this(url, sqlTemplate, true, delimiter, null);
    }

    public SqlScript(URL url, ISqlTemplate sqlTemplate, boolean failOnError, String delimiter, Map<String, String> replacementTokens) {
        try {
            String fileName = url.getFile();
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            this.init(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8.name()), sqlTemplate, failOnError, true, true, false, delimiter, replacementTokens);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public SqlScript(String sqlScript, ISqlTemplate sqlTemplate, boolean failOnError, Map<String, String> replacementTokens) {
        this(sqlScript, sqlTemplate, failOnError, true, true, ";", replacementTokens);
    }

    public SqlScript(String sqlScript, ISqlTemplate sqlTemplate, boolean failOnError, boolean failOnDrop, boolean failOnSequenceCreate, String delimiter, Map<String, String> replacementTokens) {
        this.init(new StringReader(sqlScript), sqlTemplate, failOnError, failOnDrop, failOnSequenceCreate, false, delimiter, replacementTokens);
    }

    public SqlScript(String sqlScript, ISqlTemplate sqlTemplate, boolean failOnError, boolean failOnDrop, boolean failOnSequenceCreate, boolean triggersContainJava, String delimiter, Map<String, String> replacementTokens) {
        this.init(new StringReader(sqlScript), sqlTemplate, failOnError, failOnDrop, failOnSequenceCreate, triggersContainJava, delimiter, replacementTokens);
    }

    public SqlScript(Reader reader, ISqlTemplate sqlTemplate, boolean failOnError, String delimiter, Map<String, String> replacementTokens) {
        this.init(reader, sqlTemplate, failOnError, true, true, false, delimiter, replacementTokens);
    }

    private void init(Reader reader, ISqlTemplate sqlTemplate, boolean failOnError, boolean failOnDrop, boolean failOnSequenceCreate, boolean triggersContainJava, String delimiter, Map<String, String> replacementTokens) {
        this.scriptReader = new SqlScriptReader(reader, triggersContainJava);
        this.scriptReader.setDelimiter(delimiter);
        this.scriptReader.setReplacementTokens(replacementTokens);
        this.sqlTemplate = sqlTemplate;
        this.failOnError = failOnError;
        this.failOnSequenceCreate = failOnSequenceCreate;
        this.failOnDrop = failOnDrop;
    }

    public long execute() {
        return this.execute(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execute(boolean autoCommit) {
        try {
            long count;
            if (!(autoCommit || this.failOnDrop && this.failOnError && this.failOnSequenceCreate)) {
                log.debug("Autocommit was set to false, however either failOnDrop({}) or failOnError({}) or failOnSequenceCreate({}) were set to false which means that autoCommit needs to be enabled.  We are setting it to true", new Object[]{this.failOnDrop, this.failOnError, this.failOnSequenceCreate});
                autoCommit = true;
            }
            long l = count = (long)this.sqlTemplate.update(autoCommit, this.failOnError, this.failOnDrop, this.failOnSequenceCreate, this.commitRate, this.resultsListener, this.scriptReader);
            return l;
        }
        finally {
            try {
                if (this.scriptReader != null) {
                    this.scriptReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static int calculateTotalStatements(String sqlScript, String delimiter, boolean triggersContainJava) {
        int count = 0;
        try (SqlScriptReader scriptReader = new SqlScriptReader((Reader)new StringReader(sqlScript), triggersContainJava);){
            scriptReader.setDelimiter(delimiter);
            while (scriptReader.readSqlStatement() != null) {
                ++count;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return count;
    }

    public int getCommitRate() {
        return this.commitRate;
    }

    public void setCommitRate(int commitRate) {
        this.commitRate = commitRate;
    }

    public void setLineDeliminator(String lineDeliminator) {
        this.scriptReader.setDelimiter(lineDeliminator);
    }

    public void setListener(ISqlResultsListener listener) {
        this.resultsListener = listener;
    }

    public void setFailOnDrop(boolean failOnDrop) {
        this.failOnDrop = failOnDrop;
    }

    public void setFailOnSequenceCreate(boolean failOnSequenceCreate) {
        this.failOnSequenceCreate = failOnSequenceCreate;
    }

    public boolean isFailOnDrop() {
        return this.failOnDrop;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean isFailOnSequenceCreate() {
        return this.failOnSequenceCreate;
    }
}

