/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.util;

import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.Row;

public class TableRow {
    Table table;
    Row row;
    String whereSql;
    String referenceColumnName;
    String fkName;
    String fkColumnValues = null;

    public TableRow(Table table, Row row, String whereSql, String referenceColumnName, String fkName) {
        this.table = table;
        this.row = row;
        this.whereSql = whereSql;
        this.referenceColumnName = referenceColumnName;
        this.fkName = fkName;
    }

    protected String getFkColumnValues() {
        if (this.fkColumnValues == null) {
            ForeignKey[] keys;
            StringBuilder builder = new StringBuilder();
            for (ForeignKey foreignKey : keys = this.table.getForeignKeys()) {
                Reference[] refs;
                if (!foreignKey.getName().equals(this.fkName)) continue;
                for (Reference ref : refs = foreignKey.getReferences()) {
                    Object value = this.row.get(ref.getLocalColumnName());
                    if (value != null) {
                        builder.append("\"").append(value).append("\",");
                        continue;
                    }
                    builder.append("null,");
                }
            }
            this.fkColumnValues = builder.toString();
        }
        return this.fkColumnValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        result = 31 * result + (this.whereSql == null ? 0 : this.whereSql.hashCode());
        result = 31 * result + (this.getFkColumnValues() == null ? 0 : this.getFkColumnValues().hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof TableRow) {
            TableRow tr = (TableRow)o;
            return tr.table.equals(this.table) && tr.whereSql.equals(this.whereSql) && tr.getFkColumnValues().equals(this.getFkColumnValues());
        }
        return false;
    }

    public String toString() {
        return this.table.getFullyQualifiedTableName() + ":" + this.whereSql + ":" + this.getFkColumnValues();
    }

    public Table getTable() {
        return this.table;
    }

    public Row getRow() {
        return this.row;
    }

    public String getWhereSql() {
        return this.whereSql;
    }

    public String getReferenceColumnName() {
        return this.referenceColumnName;
    }

    public String getFkName() {
        return this.fkName;
    }
}

