/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.IDataReader;
import org.jumpmind.symmetric.io.data.reader.AbstractDataReader;
import org.jumpmind.util.Statistics;

public abstract class AbstractTableDataReader
extends AbstractDataReader
implements IDataReader {
    public static final String CTX_LINE_NUMBER = AbstractTableDataReader.class.getSimpleName() + ".lineNumber";
    protected Reader reader;
    protected Statistics statistics = new Statistics();
    protected DataContext context;
    protected Batch batch;
    protected Table table;
    protected int lineNumber = 0;
    protected boolean readDataBeforeTable = false;
    protected boolean readingBatch = false;
    protected boolean readingTable = false;

    public AbstractTableDataReader(Batch batch, String catalogName, String schemaName, String tableName, StringBuilder input) {
        this(batch, catalogName, schemaName, tableName, (Reader)new BufferedReader(new StringReader(input.toString())));
    }

    public AbstractTableDataReader(Batch batch, String catalogName, String schemaName, String tableName, InputStream is) {
        this(batch, catalogName, schemaName, tableName, AbstractTableDataReader.toReader(is));
    }

    public AbstractTableDataReader(Batch batch, String catalogName, String schemaName, String tableName, String input) {
        this(batch, catalogName, schemaName, tableName, (Reader)new BufferedReader(new StringReader(input)));
    }

    public AbstractTableDataReader(Batch batch, String catalogName, String schemaName, String tableName, File file) {
        this(batch, catalogName, schemaName, AbstractTableDataReader.toTableName(tableName, file), AbstractTableDataReader.toReader(file));
    }

    public AbstractTableDataReader(Batch batch, String catalogName, String schemaName, String tableName, Reader reader) {
        this.reader = reader;
        this.batch = batch;
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            this.table = new Table(catalogName, schemaName, tableName);
        }
    }

    public AbstractTableDataReader(BinaryEncoding binaryEncoding, String catalogName, String schemaName, String tableName, Reader reader) {
        this(AbstractTableDataReader.toBatch(binaryEncoding), catalogName, schemaName, tableName, reader);
    }

    public AbstractTableDataReader(BinaryEncoding binaryEncoding, String catalogName, String schemaName, String tableName, InputStream is) {
        this(AbstractTableDataReader.toBatch(binaryEncoding), catalogName, schemaName, tableName, is);
    }

    protected static String toTableName(String tableName, File file) {
        if (StringUtils.isBlank((CharSequence)tableName) && (tableName = file.getName()).lastIndexOf(".") > 0) {
            tableName = tableName.substring(0, tableName.lastIndexOf("."));
        }
        return tableName;
    }

    @Override
    public void open(DataContext context) {
        this.lineNumber = 0;
        this.context = context;
        this.init();
    }

    protected abstract void init();

    protected abstract CsvData readNext();

    protected abstract void finish();

    protected CsvData buildCsvData(String[] tokens, DataEventType dml) {
        this.statistics.increment("READ_BYTE_COUNT", this.logDebugAndCountBytes(tokens));
        return new CsvData(dml, tokens);
    }

    @Override
    public CsvData nextData() {
        if (this.readDataBeforeTable || this.readingTable) {
            CsvData data = this.readNext();
            if (data != null) {
                ++this.lineNumber;
                this.context.put(CTX_LINE_NUMBER, this.lineNumber);
                return data;
            }
            this.batch.setComplete(true);
        }
        return null;
    }

    @Override
    public Batch nextBatch() {
        if (!this.readingBatch) {
            this.readingBatch = true;
            return this.batch;
        }
        return null;
    }

    @Override
    public Table nextTable() {
        if (!this.readingTable) {
            this.readingTable = true;
            return this.table;
        }
        return null;
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.finish();
    }

    @Override
    public Map<Batch, Statistics> getStatistics() {
        HashMap<Batch, Statistics> map = new HashMap<Batch, Statistics>(1);
        map.put(this.batch, this.statistics);
        return map;
    }
}

