/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.IDataReader;
import org.jumpmind.symmetric.io.data.reader.AbstractDataReader;
import org.jumpmind.util.Statistics;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SymXmlDataReader
extends AbstractDataReader
implements IDataReader {
    protected Reader reader;
    protected DataContext context;
    protected Batch batch;
    protected Table table;
    protected CsvData data;
    protected String sourceNodeId;
    protected int lineNumber = 0;
    protected XmlPullParser parser;
    protected Statistics statistics = new Statistics();
    protected Object next = null;

    public SymXmlDataReader(InputStream is) {
        this(SymXmlDataReader.toReader(is));
    }

    public SymXmlDataReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public void open(DataContext context) {
        try {
            this.lineNumber = 0;
            this.context = context;
            this.parser = XmlPullParserFactory.newInstance().newPullParser();
            this.parser.setInput(this.reader);
            this.next = this.readNext();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    protected Object readNext() {
        try {
            LinkedHashMap<String, String> rowData = new LinkedHashMap<String, String>();
            String columnName = null;
            Table lastTable = this.table;
            int eventType = this.parser.next();
            while (eventType != 1) {
                switch (eventType) {
                    case 4: {
                        if (columnName == null) break;
                        rowData.put(columnName, this.parser.getText());
                        columnName = null;
                        break;
                    }
                    case 2: {
                        String attributeValue;
                        int i;
                        String name = this.parser.getName();
                        if ("row".equalsIgnoreCase(name)) {
                            this.table = new Table();
                            this.data = new CsvData();
                            for (i = 0; i < this.parser.getAttributeCount(); ++i) {
                                String attributeName = this.parser.getAttributeName(i);
                                attributeValue = this.parser.getAttributeValue(i);
                                if (attributeName.equalsIgnoreCase("entity")) {
                                    this.table.setName(attributeValue);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("catalog")) {
                                    this.table.setCatalog(attributeValue);
                                    continue;
                                }
                                if (attributeName.equalsIgnoreCase("schema")) {
                                    this.table.setSchema(attributeValue);
                                    continue;
                                }
                                if (!attributeName.equalsIgnoreCase("dml")) continue;
                                if (attributeValue.equals("I")) {
                                    this.data.setDataEventType(DataEventType.INSERT);
                                    continue;
                                }
                                if (attributeValue.equals("U")) {
                                    this.data.setDataEventType(DataEventType.UPDATE);
                                    continue;
                                }
                                if (attributeValue.equals("D")) {
                                    this.data.setDataEventType(DataEventType.DELETE);
                                    continue;
                                }
                                if (attributeValue.equals("C")) {
                                    this.data.setDataEventType(DataEventType.CREATE);
                                    continue;
                                }
                                if (attributeValue.equals("S")) {
                                    this.data.setDataEventType(DataEventType.SQL);
                                    continue;
                                }
                                if (attributeValue.equals("B")) {
                                    this.data.setDataEventType(DataEventType.BSH);
                                    continue;
                                }
                                if (!attributeValue.equals("R")) continue;
                                this.data.setDataEventType(DataEventType.RELOAD);
                            }
                            break;
                        }
                        if ("data".equalsIgnoreCase(name)) {
                            boolean nullValue = false;
                            for (int i2 = 0; i2 < this.parser.getAttributeCount(); ++i2) {
                                String attributeName = this.parser.getAttributeName(i2);
                                String attributeValue2 = this.parser.getAttributeValue(i2);
                                if ("key".equalsIgnoreCase(attributeName)) {
                                    columnName = attributeValue2;
                                    continue;
                                }
                                if (!"xsi:nil".equalsIgnoreCase(attributeName)) continue;
                                nullValue = true;
                            }
                            if (!nullValue) break;
                            rowData.put(columnName, null);
                            columnName = null;
                            break;
                        }
                        if (!"batch".equalsIgnoreCase(name)) break;
                        this.batch = new Batch();
                        for (i = 0; i < this.parser.getAttributeCount(); ++i) {
                            String attributeName = this.parser.getAttributeName(i);
                            attributeValue = this.parser.getAttributeValue(i);
                            if ("binary".equalsIgnoreCase(attributeName)) {
                                this.batch.setBinaryEncoding(BinaryEncoding.valueOf((String)attributeValue));
                                continue;
                            }
                            if (!"nodeid".equalsIgnoreCase(attributeName)) continue;
                            this.batch.setSourceNodeId(attributeValue);
                        }
                        return this.batch;
                    }
                    case 3: {
                        String name = this.parser.getName();
                        if ("row".equalsIgnoreCase(name)) {
                            String[] columnNames;
                            for (String colName : columnNames = rowData.keySet().toArray(new String[rowData.size()])) {
                                this.table.addColumn(new Column(colName));
                            }
                            String[] columnValues = rowData.values().toArray(new String[rowData.size()]);
                            this.data.putParsedData("rowData", columnValues);
                            rowData.clear();
                            if (lastTable == null || !lastTable.equals((Object)this.table)) {
                                return this.table;
                            }
                            return this.data;
                        }
                        if (!"data".equalsIgnoreCase(name)) break;
                        columnName = null;
                    }
                }
                eventType = this.parser.next();
            }
            return null;
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
        catch (XmlPullParserException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Batch nextBatch() {
        if (this.next instanceof Batch) {
            this.batch = (Batch)this.next;
            this.next = null;
            return this.batch;
        }
        this.next = this.readNext();
        if (this.next instanceof Batch) {
            this.batch = (Batch)this.next;
            this.next = null;
            return this.batch;
        }
        return null;
    }

    @Override
    public Table nextTable() {
        if (this.next instanceof Table) {
            this.table = (Table)this.next;
            this.next = this.data;
        } else {
            this.next = this.readNext();
            if (this.next instanceof Table) {
                this.table = (Table)this.next;
                this.next = this.data;
            } else {
                this.table = null;
            }
        }
        if (this.table == null) {
            this.batch.setComplete(true);
        }
        return this.table;
    }

    @Override
    public CsvData nextData() {
        if (this.next instanceof CsvData) {
            CsvData data = (CsvData)this.next;
            this.next = null;
            return data;
        }
        this.next = this.readNext();
        if (this.next instanceof CsvData) {
            CsvData data = (CsvData)this.next;
            this.next = null;
            return data;
        }
        return null;
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Map<Batch, Statistics> getStatistics() {
        HashMap<Batch, Statistics> map = new HashMap<Batch, Statistics>(1);
        map.put(this.batch, this.statistics);
        return map;
    }
}

