/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.transform.ISingleNewAndOldValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;

public class ClarionDateTimeColumnTransform
implements ISingleNewAndOldValueColumnTransform,
IBuiltInExtensionPoint {
    public static final String NAME = "clarionDateTime";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.S";

    public String getName() {
        return NAME;
    }

    @Override
    public boolean isExtractColumnTransform() {
        return true;
    }

    @Override
    public boolean isLoadColumnTransform() {
        return true;
    }

    @Override
    public NewAndOldValue transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String clarionTimeStr = null;
        String columnName = column.getTransformExpression();
        if (columnName != null && !StringUtils.isEmpty((CharSequence)columnName)) {
            clarionTimeStr = sourceValues.get(columnName);
        }
        String value = this.convertClarionDate(newValue, clarionTimeStr);
        return new NewAndOldValue(column, data, value);
    }

    public String convertClarionDate(String clarionDate, String clarionTime) {
        if (clarionDate != null && !StringUtils.isEmpty((CharSequence)clarionDate)) {
            Integer time;
            Integer date = Integer.parseInt(clarionDate);
            Calendar cal = Calendar.getInstance();
            cal.set(1800, 11, 28, 0, 0, 0);
            cal.add(5, date);
            cal.set(14, 0);
            if (clarionTime != null && !StringUtils.isEmpty((CharSequence)clarionTime) && (time = Integer.valueOf(Integer.parseInt(clarionTime))) > 0) {
                cal.add(14, (time - 1) * 10);
            }
            return new SimpleDateFormat(DATE_FORMAT).format(cal.getTime());
        }
        return null;
    }
}

