/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.transform.IMultipleValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;

public class ColumnsToRowsKeyColumnTransform
implements IMultipleValueColumnTransform,
IBuiltInExtensionPoint {
    public static final String NAME = "columnsToRowsKey";
    public static final String CONTEXT_MAP = "Map";
    public static final String CONTEXT_PK_COLUMN = "PKColumn";

    public String getName() {
        return NAME;
    }

    public static String getContextBase(String transformId) {
        return "columnsToRowsKey:" + transformId + ":";
    }

    @Override
    public boolean isExtractColumnTransform() {
        return true;
    }

    @Override
    public boolean isLoadColumnTransform() {
        return true;
    }

    @Override
    public List<String> transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreRowException {
        if (StringUtils.trimToNull((String)column.getTransformExpression()) == null) {
            throw new RuntimeException("Transform configured incorrectly.  A map representing PK and column names must be defined as part of the transform expression");
        }
        String mapAsString = StringUtils.trimToEmpty((String)column.getTransformExpression());
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, String> reverseMap = new HashMap<String, String>();
        StringTokenizer tokens = new StringTokenizer(mapAsString);
        while (tokens.hasMoreElements()) {
            String keyValue = (String)tokens.nextElement();
            int equalIndex = keyValue.indexOf("=");
            if (equalIndex != -1) {
                reverseMap.put(keyValue.substring(equalIndex + 1), keyValue.substring(0, equalIndex));
                result.add(keyValue.substring(equalIndex + 1));
                continue;
            }
            throw new RuntimeException("Map string for " + column.getTransformExpression() + " is invalid format: " + mapAsString);
        }
        context.put(ColumnsToRowsKeyColumnTransform.getContextBase(column.getTransformId()) + CONTEXT_MAP, reverseMap);
        context.put(ColumnsToRowsKeyColumnTransform.getContextBase(column.getTransformId()) + CONTEXT_PK_COLUMN, column.getTargetColumnName());
        return result;
    }
}

