/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.ISingleNewAndOldValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;

public class LeftColumnTransform
implements ISingleNewAndOldValueColumnTransform,
IBuiltInExtensionPoint {
    public static final String NAME = "left";

    public String getName() {
        return NAME;
    }

    @Override
    public boolean isExtractColumnTransform() {
        return true;
    }

    @Override
    public boolean isLoadColumnTransform() {
        return true;
    }

    @Override
    public NewAndOldValue transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String expression;
        String value;
        String string = value = data.getSourceDmlType() == DataEventType.DELETE ? oldValue : newValue;
        if (StringUtils.isNotBlank((CharSequence)value) && StringUtils.isNotBlank((CharSequence)(expression = column.getTransformExpression()))) {
            expression = expression.trim();
            int index = Integer.parseInt(expression);
            if (value.length() > index) {
                value = value.substring(0, index);
            }
        }
        return new NewAndOldValue(column, data, value);
    }
}

