/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.text.DecimalFormat;
import java.util.Map;
import net.sourceforge.jeval.EvaluationException;
import net.sourceforge.jeval.Evaluator;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.transform.ISingleNewAndOldValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;

public class MathColumnTransform
implements ISingleNewAndOldValueColumnTransform,
IBuiltInExtensionPoint {
    public static final String NAME = "math";
    public static final String EVALUATOR = "evalutor";

    public String getName() {
        return NAME;
    }

    @Override
    public boolean isExtractColumnTransform() {
        return true;
    }

    @Override
    public boolean isLoadColumnTransform() {
        return true;
    }

    @Override
    public NewAndOldValue transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String transformExpression = column.getTransformExpression();
        try {
            Evaluator eval = (Evaluator)context.get(EVALUATOR);
            if (eval == null) {
                eval = new Evaluator();
                context.put(EVALUATOR, eval);
            }
            eval.clearVariables();
            eval.putVariable("currentValue", newValue);
            eval.putVariable("oldValue", oldValue);
            eval.putVariable("channelId", context.getBatch().getChannelId());
            for (String columnName : sourceValues.keySet()) {
                eval.putVariable(columnName.toUpperCase(), sourceValues.get(columnName));
                eval.putVariable(columnName, sourceValues.get(columnName));
            }
            String result = eval.evaluate(transformExpression);
            Double dblResult = Double.valueOf(result);
            if (result.contains("E")) {
                DecimalFormat format = new DecimalFormat("#");
                format.setMaximumFractionDigits(340);
                result = format.format(dblResult);
            } else if (dblResult == Math.floor(dblResult)) {
                result = result.substring(0, result.length() - 2);
            }
            return new NewAndOldValue(column, data, result);
        }
        catch (EvaluationException e) {
            throw new RuntimeException("Unable to evaluate transform expression: " + transformExpression, e);
        }
    }
}

