/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.writer.Conflict;

public class ConflictException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected CsvData data;
    protected Table table;
    protected boolean fallbackOperationFailed = false;
    protected Conflict conflict;

    public ConflictException(CsvData data, Table table, boolean fallbackOperationFailed, Conflict conflict, Exception originalCause) {
        super(ConflictException.message(data, table, fallbackOperationFailed, originalCause));
        this.data = data;
        this.table = table;
        this.fallbackOperationFailed = fallbackOperationFailed;
        this.conflict = conflict;
    }

    protected static String message(CsvData data, Table table, boolean fallbackOperationFailed, Exception originalCause) {
        Map<String, String> pks = data.toKeyColumnValuePairs(table);
        Object msg = String.format("Detected conflict while executing %s on %s.  The primary key data was: %s. %s", data.getDataEventType().toString(), table.getFullyQualifiedTableName(), pks, fallbackOperationFailed ? "Failed to fallback.  " : "  ");
        if (originalCause != null) {
            Throwable originalRoot = ExceptionUtils.getRootCause((Throwable)originalCause);
            if (originalRoot == null) {
                originalRoot = originalCause;
            }
            msg = (String)msg + String.format("The original error message was: %s", originalRoot.getMessage());
        }
        return msg;
    }

    public CsvData getData() {
        return this.data;
    }

    public Table getTable() {
        return this.table;
    }

    public Conflict getConflict() {
        return this.conflict;
    }

    public boolean isFallbackOperationFailed() {
        return this.fallbackOperationFailed;
    }
}

