/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.TransformedData;
import org.jumpmind.symmetric.io.data.writer.AbstractDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.DefaultDatabaseWriterConflictResolver;
import org.jumpmind.symmetric.io.data.writer.TransformWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransformWriterConflictResolver
extends DefaultDatabaseWriterConflictResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransformWriterConflictResolver.class);
    protected TransformWriter transformWriter;

    public DefaultTransformWriterConflictResolver(TransformWriter transformWriter) {
        this.transformWriter = transformWriter;
    }

    @Override
    protected void performFallbackToInsert(AbstractDatabaseWriter writer, CsvData data, Conflict conflict, boolean retransform) {
        TransformedData transformedData = (TransformedData)data.getAttribute(TransformedData.class.getName());
        if (transformedData != null && retransform) {
            List<TransformedData> newlyTransformedDatas = this.transformWriter.transform(DataEventType.INSERT, writer.getContext(), transformedData.getTransformation(), transformedData.getSourceKeyValues(), transformedData.getOldSourceValues(), transformedData.getSourceValues());
            if (newlyTransformedDatas.size() > 0) {
                boolean matchedTransform = false;
                for (TransformedData newlyTransformedData : newlyTransformedDatas) {
                    if (newlyTransformedDatas.size() != 1 && !newlyTransformedData.hasSameKeyValues(transformedData.getKeyValues()) && !newlyTransformedData.isGeneratedIdentityNeeded()) continue;
                    matchedTransform = true;
                    Table table = newlyTransformedData.buildTargetTable();
                    CsvData newData = newlyTransformedData.buildTargetCsvData(data.getAttributes());
                    if (newlyTransformedData.isGeneratedIdentityNeeded()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Enabling generation of identity for {}", (Object)newlyTransformedData.getTableName());
                        }
                        writer.allowInsertIntoAutoIncrementColumns(false, table);
                    } else if (table.hasAutoIncrementColumn()) {
                        writer.allowInsertIntoAutoIncrementColumns(true, table);
                    }
                    this.transformWriter.lastTransformedTable = table;
                    writer.start(table);
                    super.performFallbackToInsert(writer, newData, conflict, retransform);
                    writer.end(table);
                }
                if (!matchedTransform) {
                    log.warn("The attempt to retransform resulted in more than one transform.  We tried to choose one by matching on the ordered key values, but could not find a match.  Please check that the transformation is configured so that it will return keys in the same order regardless of DML type.  The original key values that we tried to match on were: {}" + ArrayUtils.toString((Object)transformedData.getKeyValues()));
                }
            }
        } else {
            super.performFallbackToInsert(writer, data, conflict, retransform);
        }
    }

    @Override
    protected void performFallbackToUpdate(AbstractDatabaseWriter writer, CsvData data, Conflict conflict, boolean retransform) {
        TransformedData transformedData = (TransformedData)data.getAttribute(TransformedData.class.getName());
        if (transformedData != null && retransform) {
            List<TransformedData> newlyTransformedDatas = this.transformWriter.transform(DataEventType.UPDATE, writer.getContext(), transformedData.getTransformation(), transformedData.getSourceKeyValues(), transformedData.getOldSourceValues(), transformedData.getSourceValues());
            for (TransformedData newlyTransformedData : newlyTransformedDatas) {
                Table table;
                if (!newlyTransformedData.hasSameKeyValues(transformedData.getKeyValues())) continue;
                this.transformWriter.lastTransformedTable = table = newlyTransformedData.buildTargetTable();
                writer.start(table);
                super.performFallbackToUpdate(writer, newlyTransformedData.buildTargetCsvData(data.getAttributes()), conflict, retransform);
                writer.end(table);
            }
        } else {
            super.performFallbackToUpdate(writer, data, conflict, retransform);
        }
    }
}

