/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.writer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.writer.AbstractProtocolDataWriter;
import org.jumpmind.symmetric.io.data.writer.IProtocolDataWriterListener;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.util.FormatUtils;

public class StagingDataWriter
extends AbstractProtocolDataWriter {
    private IStagingManager stagingManager;
    private String category;
    private Map<Batch, IStagedResource> stagedResources = new ConcurrentHashMap<Batch, IStagedResource>();
    private long memoryThresholdInBytes;
    private boolean acquireReference = false;

    public StagingDataWriter(long memoryThresholdInBytes, boolean acquireReference, String sourceNodeId, String category, IStagingManager stagingManager, boolean sendCaptureTime, boolean sendRowCaptureTime, IProtocolDataWriterListener ... listeners) {
        this(sourceNodeId, category, stagingManager, sendCaptureTime, sendRowCaptureTime, StagingDataWriter.toList(listeners));
        this.memoryThresholdInBytes = memoryThresholdInBytes;
        this.acquireReference = acquireReference;
    }

    public StagingDataWriter(String sourceNodeId, String category, IStagingManager stagingManager, boolean sendCaptureTime, boolean sendRowCaptureTime, List<IProtocolDataWriterListener> listeners) {
        super(sourceNodeId, listeners, false, sendCaptureTime, sendRowCaptureTime);
        this.category = category;
        this.stagingManager = stagingManager;
    }

    public static List<IProtocolDataWriterListener> toList(IProtocolDataWriterListener ... listeners) {
        if (listeners != null) {
            ArrayList<IProtocolDataWriterListener> list = new ArrayList<IProtocolDataWriterListener>(listeners.length);
            for (IProtocolDataWriterListener l : listeners) {
                list.add(l);
            }
            return list;
        }
        return new ArrayList<IProtocolDataWriterListener>(0);
    }

    @Override
    protected void notifyEndBatch(Batch batch, IProtocolDataWriterListener listener) {
        listener.end(this.context, batch, this.getStagedResource(batch));
        this.stagedResources.remove(batch);
    }

    protected IStagedResource getStagedResource(Batch batch) {
        IStagedResource resource = this.stagedResources.get(batch);
        if (resource == null) {
            String location = batch.getStagedLocation();
            resource = this.stagingManager.find(this.category, location, batch.getBatchId());
            if (resource == null || resource.getState() == IStagedResource.State.DONE) {
                this.log.debug("Creating staged resource for batch {}", (Object)batch.getNodeBatchId());
                resource = this.stagingManager.create(this.category, location, batch.getBatchId());
                if (this.acquireReference) {
                    resource.reference();
                }
            }
            this.stagedResources.put(batch, resource);
        }
        return resource;
    }

    @Override
    protected void endBatch(Batch batch) {
        super.endBatch(batch);
        IStagedResource resource = this.getStagedResource(batch);
        resource.close();
        this.flushNodeId = true;
        this.processedTables.clear();
        this.table = null;
    }

    @Override
    protected void print(Batch batch, String data) {
        if (this.log.isDebugEnabled() && data != null) {
            this.log.debug("Writing staging data: {}", (Object)FormatUtils.abbreviateForLogging((String)data));
        }
        IStagedResource resource = this.getStagedResource(batch);
        BufferedWriter writer = resource.getWriter(this.memoryThresholdInBytes);
        try {
            int size = data == null ? 0 : data.length();
            for (int i = 0; i < size; i += 1024) {
                int end = i + 1024;
                writer.append(data, i, end < size ? end : size);
            }
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
    }
}

