/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.stage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class ThresholdFileWriter
extends Writer {
    protected File file;
    protected BufferedWriter fileWriter;
    protected StringBuilder buffer;
    protected long threshhold;

    public ThresholdFileWriter(long threshold, StringBuilder buffer, File file) {
        this.file = file;
        this.buffer = buffer;
        this.threshhold = threshold;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void close() throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.close();
            this.fileWriter = null;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.flush();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.fileWriter != null) {
            this.fileWriter.write(cbuf, off, len);
        } else if (this.buffer == null || (long)(len + this.buffer.length()) > this.threshhold) {
            this.file.getParentFile().mkdirs();
            this.fileWriter = this.getWriter();
            if (this.buffer != null) {
                this.fileWriter.write(this.buffer.toString());
                this.buffer.setLength(0);
                this.buffer = null;
            }
            this.fileWriter.write(cbuf, off, len);
            this.fileWriter.flush();
        } else {
            this.buffer.append(new String(cbuf), off, len);
        }
    }

    protected BufferedWriter getWriter() throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8.name()));
    }

    public BufferedReader getReader() throws IOException {
        if (this.file != null && this.file.exists()) {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8.name()));
        }
        return new BufferedReader(new StringReader(this.buffer.toString()));
    }

    public void delete() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
        this.file = null;
        if (this.buffer != null) {
            this.buffer.setLength(0);
            this.buffer.trimToSize();
        }
    }
}

