/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.db2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class Db2DdlReader
extends AbstractJdbcDdlReader {
    private static final String[] KNOWN_SYSTEM_TABLES = new String[]{"STMG_DBSIZE_INFO", "HMON_ATM_INFO", "HMON_COLLECTION", "POLICY"};
    private Pattern db2TimePattern = Pattern.compile("'(\\d{2}).(\\d{2}).(\\d{2})'");
    private Pattern db2TimestampPattern = Pattern.compile("'(\\d{4}\\-\\d{2}\\-\\d{2})\\-(\\d{2}).(\\d{2}).(\\d{2})(\\.\\d{1,8})?'");

    public Db2DdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        String tableName = (String)values.get("TABLE_NAME");
        for (int idx = 0; idx < KNOWN_SYSTEM_TABLES.length; ++idx) {
            if (!KNOWN_SYSTEM_TABLES[idx].equals(tableName)) continue;
            return null;
        }
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            this.enhanceTableMetaData(connection, metaData, table);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enhanceTableMetaData(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
        this.log.debug("about to read additional column data");
        Object sql = "SELECT NAME, IDENTITY FROM SYSIBM.SYSCOLUMNS WHERE TBNAME=?";
        if (StringUtils.isNotBlank((CharSequence)metaData.getSchemaPattern())) {
            sql = (String)sql + " AND TBCREATOR=?";
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement((String)sql);
            pstmt.setString(1, table.getName());
            if (StringUtils.isNotBlank((CharSequence)metaData.getSchemaPattern())) {
                pstmt.setString(2, metaData.getSchemaPattern());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String isIdentity;
                String columnName = rs.getString(1);
                Column column = table.getColumnWithName(columnName);
                if (column == null || (isIdentity = rs.getString(2)) == null || !isIdentity.startsWith("Y")) continue;
                column.setAutoIncrement(true);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Found identity column {} on {}", (Object)columnName, (Object)table.getName());
            }
        }
        catch (Throwable throwable) {
            JdbcSqlTemplate.close(rs);
            JdbcSqlTemplate.close(pstmt);
            throw throwable;
        }
        JdbcSqlTemplate.close(rs);
        JdbcSqlTemplate.close(pstmt);
        this.log.debug("done reading additional column data");
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        if (column.getDefaultValue() != null) {
            if (column.getMappedTypeCode() == 92) {
                Matcher matcher = this.db2TimePattern.matcher(column.getDefaultValue());
                if (matcher.matches()) {
                    StringBuilder newDefault = new StringBuilder();
                    newDefault.append("'");
                    newDefault.append(matcher.group(1));
                    newDefault.append(":");
                    newDefault.append(matcher.group(2));
                    newDefault.append(":");
                    newDefault.append(matcher.group(3));
                    newDefault.append("'");
                    column.setDefaultValue(newDefault.toString());
                }
            } else if (column.getMappedTypeCode() == 93) {
                Matcher matcher = this.db2TimestampPattern.matcher(column.getDefaultValue());
                if (matcher.matches()) {
                    StringBuilder newDefault = new StringBuilder();
                    newDefault.append("'");
                    newDefault.append(matcher.group(1));
                    newDefault.append(" ");
                    newDefault.append(matcher.group(2));
                    newDefault.append(":");
                    newDefault.append(matcher.group(3));
                    newDefault.append(":");
                    newDefault.append(matcher.group(4));
                    if (matcher.groupCount() > 4 && matcher.group(4) != null) {
                        newDefault.append(matcher.group(5));
                    }
                    newDefault.append("'");
                    column.setDefaultValue(newDefault.toString());
                }
            } else if (TypeMap.isTextType((int)column.getMappedTypeCode())) {
                String defaultValue = column.getDefaultValue();
                if (defaultValue.length() >= 2 && defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                    defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                }
                column.setDefaultValue(this.unescape(defaultValue, "'", "''"));
            }
        }
        if (column.getJdbcTypeCode() == 93 || column.getJdbcTypeCode() == 92) {
            this.resetColumnSize(column, String.valueOf(column.getScale()));
        }
        if (column.getJdbcTypeCode() == 91) {
            this.removeColumnSize(column);
        }
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) throws SQLException {
        if (index.getName().startsWith("SQL")) {
            try {
                Long.parseLong(index.getName().substring(3));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        HashSet<String> pkNames = new HashSet<String>();
        try (ResultSet pkData = null;){
            this.log.debug("getting pk info");
            pkData = metaData.getPrimaryKeys(table.getName());
            this.log.debug("done getting pk info");
            while (pkData.next()) {
                Map<String, Object> values = this.readMetaData(pkData, this.getColumnsForPK());
                pkNames.add((String)values.get("PK_NAME"));
            }
        }
        return pkNames.contains(index.getName());
    }

    @Override
    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, IIndex index) throws SQLException {
        return fk.getName().equalsIgnoreCase(index.getName());
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT NAME as TRIGGER_NAME, SCHEMA, DEFINER, TBNAME as TABLE_NAME, TBCREATOR as TABLE_CREATOR, TRIGEVENT as TRIGGER_TYPE, TRIGTIME as TRIGGER_TIME, GRANULARITY, VALID, TEXT, ENABLED, CREATE_TIME, FUNC_PATH as FUNCTION_PATH, ALTER_TIME as LAST_ALTERED FROM SYSIBM.SYSTRIGGERS WHERE TBNAME=? and SCHEMA=?";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("TRIGGER_NAME"));
                trigger.setSchemaName(row.getString("SCHEMA"));
                trigger.setTableName(row.getString("TABLE_NAME"));
                trigger.setEnabled(row.getString("ENABLED").equals("Y"));
                trigger.setSource(row.getString("TEXT"));
                row.remove((Object)"TEXT");
                String trigEvent = row.getString("TRIGGER_TYPE");
                switch (trigEvent.charAt(0)) {
                    case 'I': {
                        trigEvent = "INSERT";
                        break;
                    }
                    case 'U': {
                        trigEvent = "UPDATE";
                        break;
                    }
                    case 'D': {
                        trigEvent = "DELETE";
                    }
                }
                trigger.setTriggerType(Trigger.TriggerType.valueOf((String)trigEvent));
                row.put("TRIGGER_TYPE", (Object)trigEvent);
                switch (row.getString("TRIGGER_TIME").charAt(0)) {
                    case 'A': {
                        row.put("TRIGGER_TIME", (Object)"AFTER");
                        break;
                    }
                    case 'B': {
                        row.put("TRIGGER_TIME", (Object)"BEFORE");
                        break;
                    }
                    case 'I': {
                        row.put("TRIGGER_TIME", (Object)"INSTEAD OF");
                    }
                }
                if (row.getString("GRANULARITY").equals("S")) {
                    row.put("GRANULARITY", (Object)"ONCE PER STATEMENT");
                } else if (row.getString("GRANULARITY").equals("R")) {
                    row.put("GRANULARITY", (Object)"ONCE PER ROW");
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName, schema});
        return triggers;
    }

    @Override
    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        if (typeName != null && typeName.startsWith("ROWID")) {
            return 12;
        }
        if (typeName != null && typeName.endsWith("CLOB")) {
            return -1;
        }
        if (typeName != null && typeName.endsWith("LONG VARCHAR")) {
            return 2005;
        }
        if (typeName != null && typeName.endsWith("XML")) {
            return 2009;
        }
        return super.mapUnknownJdbcTypeForColumn(values);
    }

    @Override
    protected void removeGeneratedColumns(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
        ArrayList<Column> tempColumns = new ArrayList<Column>();
        boolean found = false;
        Column[] columns = table.getColumns();
        for (int i = 0; columns != null && i < columns.length; ++i) {
            if (columns[i].getMappedTypeCode() == -8 || columns[i].getName().equals("DB2_GENERATED_ROWID_FOR_LOBS")) {
                found = true;
                this.log.info("Found generated and/or rowid column on table " + table.getFullyQualifiedTableName() + ", column " + columns[i].getName());
                continue;
            }
            tempColumns.add(columns[i]);
        }
        if (found) {
            table.removeAllColumns();
            table.addColumns(tempColumns);
        }
    }
}

