/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.db2;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;

public class Db2JdbcSqlTemplate
extends JdbcSqlTemplate {
    public Db2JdbcSqlTemplate(DataSource dataSource, SqlTemplateSettings settings, SymmetricLobHandler lobHandler, DatabaseInfo databaseInfo) {
        super(dataSource, settings, lobHandler, databaseInfo);
        this.primaryKeyViolationCodes = new int[]{-803};
        this.foreignKeyViolationCodes = new int[]{-530};
        this.foreignKeyChildExistsViolationCodes = new int[]{-531, -532};
        this.deadlockCodes = new int[]{-911};
    }

    @Override
    public String getSelectLastInsertIdSql(String sequenceName) {
        return "SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1";
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    @Override
    public String getUniqueKeyViolationIndexName(Throwable ex) {
        String indexName = null;
        SQLException sqlEx = this.findSQLException(ex);
        if (sqlEx != null && sqlEx.getMessage().contains("SQLSTATE=23505, SQLERRMC=2;")) {
            indexName = "%";
        }
        return indexName;
    }
}

