/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.generic;

import javax.sql.DataSource;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.DatabaseVersion;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.db.platform.JdbcDatabasePlatformFactory;
import org.jumpmind.db.platform.generic.GenericJdbcDdlBuilder;
import org.jumpmind.db.platform.generic.GenericJdbcSqlDdlReader;
import org.jumpmind.db.platform.generic.GenericJdbcSqlTemplate;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;

public class GenericJdbcDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    private String name;

    public GenericJdbcDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        try {
            DatabaseVersion nameVersion = JdbcDatabasePlatformFactory.getInstance().determineDatabaseNameVersionSubprotocol(dataSource);
            this.name = String.format("%s%s", nameVersion.getName(), nameVersion.getVersionAsString()).toLowerCase();
        }
        catch (Exception e) {
            this.name = "generic";
            this.log.info("Unable to determine database name and version, " + e.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultSchema() {
        return null;
    }

    public String getDefaultCatalog() {
        return null;
    }

    @Override
    protected IDdlBuilder createDdlBuilder() {
        return new GenericJdbcDdlBuilder(this.getName(), (IDatabasePlatform)this);
    }

    @Override
    protected IDdlReader createDdlReader() {
        return new GenericJdbcSqlDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected ISqlTemplate createSqlTemplate() {
        return new GenericJdbcSqlTemplate(this.dataSource, this.settings, new SymmetricLobHandler(), this.getDatabaseInfo());
    }
}

