/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.h2;

import javax.sql.DataSource;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.h2.H2JdbcSqlTransaction;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;

public class H2JdbcSqlTemplate
extends JdbcSqlTemplate {
    public H2JdbcSqlTemplate(DataSource dataSource, SqlTemplateSettings settings, SymmetricLobHandler lobHandler, DatabaseInfo databaseInfo) {
        super(dataSource, settings, lobHandler, databaseInfo);
        this.primaryKeyViolationSqlStates = new String[]{"23001", "23505"};
        this.uniqueKeyViolationNameRegex = new String[]{"key violation: \"(.*) ON .* VALUES .*"};
        this.foreignKeyViolationCodes = new int[]{23506};
        this.foreignKeyChildExistsViolationCodes = new int[]{23503};
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    @Override
    public String getSelectLastInsertIdSql(String sequenceName) {
        if (this.getDatabaseMajorVersion() == 2) {
            return "call CURRVAL('" + sequenceName + "_seq')";
        }
        return "call IDENTITY()";
    }

    @Override
    public ISqlTransaction startSqlTransaction(boolean autoCommit) {
        return new H2JdbcSqlTransaction(this, autoCommit);
    }

    @Override
    public ISqlTransaction startSqlTransaction() {
        return new H2JdbcSqlTransaction(this);
    }
}

