/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mariadb;

import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.mariadb.MariaDBDdlReader;
import org.jumpmind.db.platform.mysql.MySqlDatabasePlatform;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class MariaDBDatabasePlatform
extends MySqlDatabasePlatform {
    public static final String JDBC_DRIVER = "org.mariadb.jdbc.Driver";
    public static final String JDBC_SUBPROTOCOL = "mariadb";
    public static final String SQL_GET_MARIADB_NAME = "select variable_value from information_schema.global_variables where variable_name='VERSION'";
    private static int originalFetchSize;

    public MariaDBDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, MariaDBDatabasePlatform.overrideSettings(settings));
        settings.setFetchSize(originalFetchSize);
    }

    @Override
    protected MariaDBDdlReader createDdlReader() {
        return new MariaDBDdlReader((IDatabasePlatform)this);
    }

    @Override
    public PermissionResult getLogMinePermission() {
        PermissionResult result = new PermissionResult(PermissionType.LOG_MINE, "Use LogMiner");
        StringBuilder solution = new StringBuilder();
        Row row = this.getSqlTemplate().queryForRow("show variables like 'log_bin'", new Object[0]);
        if (row == null || !StringUtils.equalsIgnoreCase((CharSequence)row.getString("Value"), (CharSequence)"ON")) {
            solution.append("Use the --log-bin option at startup. ");
        }
        if ((row = this.getSqlTemplate().queryForRow("show variables like 'binlog_format'", new Object[0])) == null || !StringUtils.equalsIgnoreCase((CharSequence)row.getString("Value"), (CharSequence)"ROW")) {
            solution.append("Set the binlog_format system variable to \"ROW\". ");
        }
        if (solution.length() > 0) {
            result.setStatus(PermissionResult.Status.FAIL);
            result.setSolution(solution.toString());
        } else {
            result.setStatus(PermissionResult.Status.PASS);
        }
        return result;
    }

    @Override
    public String getCharSetName() {
        return (String)this.getSqlTemplate().queryForObject("SELECT CHARSET('a'), @@character_set_connection;", String.class, new Object[0]);
    }

    protected static SqlTemplateSettings overrideSettings(SqlTemplateSettings settings) {
        if (settings == null) {
            settings = new SqlTemplateSettings();
        }
        originalFetchSize = settings.getFetchSize();
        return settings;
    }
}

