/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mssql;

import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.mssql.MsSql2000DdlBuilder;
import org.jumpmind.db.platform.mssql.MsSqlDdlReader;
import org.jumpmind.db.platform.mssql.MsSqlJdbcSqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class MsSql2000DatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "net.sourceforge.jtds.jdbc.Driver";
    public static final String JDBC_SUBPROTOCOL = "jtds";
    int engineEdition = -1;

    public MsSql2000DatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        this.supportsTruncate = false;
    }

    @Override
    protected IDdlBuilder createDdlBuilder() {
        return new MsSql2000DdlBuilder();
    }

    @Override
    protected MsSqlDdlReader createDdlReader() {
        return new MsSqlDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected MsSqlJdbcSqlTemplate createSqlTemplate() {
        return new MsSqlJdbcSqlTemplate(this.dataSource, this.settings, this.getDatabaseInfo());
    }

    public String getName() {
        return "mssql2000";
    }

    public String getDefaultCatalog() {
        if (StringUtils.isBlank((CharSequence)this.defaultCatalog)) {
            this.defaultCatalog = (String)this.getSqlTemplate().queryForObject("select DB_NAME()", String.class, new Object[0]);
        }
        return this.defaultCatalog;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("select current_user", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public boolean allowsUniqueIndexDuplicatesWithNulls() {
        return false;
    }

    public boolean isClob(Column column) {
        if (this.isVarcharMax(column)) {
            return false;
        }
        return super.isClob(column) || this.isText(column);
    }

    public boolean isVarcharMax(Column column) {
        int mappedTypeCode = column.getMappedTypeCode();
        int size = column.getSizeAsInt();
        String jdbcTypeName = column.getJdbcTypeName();
        return mappedTypeCode == -1 && (jdbcTypeName.equalsIgnoreCase("NVARCHAR") && size > 4000 || jdbcTypeName.equalsIgnoreCase("VARCHAR") && size > 8000);
    }

    public boolean isText(Column column) {
        return column.getMappedTypeCode() == -10;
    }

    public boolean canColumnBeUsedInWhereClause(Column column) {
        if (column.getMappedTypeCode() == -3 && column.getSizeAsInt() > 8000) {
            return false;
        }
        return !this.isLob(column) && super.canColumnBeUsedInWhereClause(column);
    }

    protected Object parseFloat(String value) {
        return this.cleanNumber(value).replace(',', '.');
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE TRIGGER TEST_TRIGGER ON " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " AFTER UPDATE AS SELECT 1 GO";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public PermissionResult getCreateSymFunctionPermission() {
        PermissionResult result;
        block2: {
            String routineSql = "CREATE FUNCTION TEST_FUNC() RETURNS INTEGER BEGIN RETURN 1; END";
            String dropSql = "IF OBJECT_ID('TEST_FUNC') IS NOT NULL DROP FUNCTION TEST_FUNC";
            result = new PermissionResult(PermissionType.CREATE_FUNCTION, dropSql + "\r\n" + routineSql + "\r\n" + dropSql);
            try {
                this.getSqlTemplate().update(dropSql, new Object[0]);
                this.getSqlTemplate().update(routineSql, new Object[0]);
                this.getSqlTemplate().update(dropSql, new Object[0]);
                result.setStatus(PermissionResult.Status.PASS);
            }
            catch (SqlException e) {
                result.setException((Exception)((Object)e));
                if (result.getSolution() == null) break block2;
                result.setSolution("Grant CREATE FUNCTION Privilege");
            }
        }
        return result;
    }

    public PermissionResult getLogMinePermission() {
        PermissionResult result = new PermissionResult(PermissionType.LOG_MINE, "");
        result.setSolution("Change Tracking not available");
        result.setStatus(PermissionResult.Status.FAIL);
        return result;
    }

    public String massageForObjectAlreadyExists(String sql) {
        if (sql.toUpperCase().contains("CREATE TABLE")) {
            return sql;
        }
        return StringUtils.replaceOnceIgnoreCase((String)sql, (String)"create", (String)"alter");
    }

    public String massageForObjectDoesNotExist(String sql) {
        if (sql.toUpperCase().contains("ALTER TABLE") || sql.toUpperCase().contains(" OR ALTER ")) {
            return sql;
        }
        return StringUtils.replaceOnceIgnoreCase((String)sql, (String)"alter", (String)"create");
    }

    public int getEngineEdition() {
        if (this.engineEdition < 0) {
            try {
                this.engineEdition = this.sqlTemplate.queryForInt("SELECT CAST(SERVERPROPERTY('EngineEdition') AS INT)", new Object[0]);
            }
            catch (Exception e) {
                this.engineEdition = 0;
            }
        }
        return this.engineEdition;
    }
}

