/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.sybase;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SybaseJdbcSqlTemplate
extends JdbcSqlTemplate
implements ISqlTemplate {
    private static final Logger log = LoggerFactory.getLogger(SybaseJdbcSqlTemplate.class);
    protected static final String NATIVE_PREPARED_STATEMENT_NAME = "com.sybase.jdbc4.jdbc.SybPreparedStatement";
    protected int jdbcMajorVersion;
    protected boolean isUsingJtds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseJdbcSqlTemplate(DataSource dataSource, SqlTemplateSettings settings, SymmetricLobHandler lobHandler, DatabaseInfo databaseInfo) {
        super(dataSource, settings, lobHandler, databaseInfo);
        this.primaryKeyViolationCodes = new int[]{423, 511, 515, 530, 547, 2601, 2615, 2714};
        this.uniqueKeyViolationNameRegex = new String[]{"unique index '(.*)'"};
        this.foreignKeyViolationCodes = new int[]{546};
        this.foreignKeyChildExistsViolationCodes = new int[]{547};
        Connection c = null;
        try {
            c = dataSource.getConnection();
            this.jdbcMajorVersion = c.getMetaData().getJDBCMajorVersion();
            if (dataSource.getConnection().getMetaData().getURL().contains("jtds")) {
                this.isUsingJtds = true;
            }
        }
        catch (SQLException ex) {
            this.jdbcMajorVersion = -1;
        }
        finally {
            SybaseJdbcSqlTemplate.close(c);
        }
    }

    @Override
    protected boolean allowsNullForIdentityColumn() {
        return false;
    }

    @Override
    protected void setDecimalValue(PreparedStatement ps, int i, Object arg, int argType) throws SQLException {
        block17: {
            if ((argType == 3 || argType == 2) && arg != null && arg.equals("NaN")) {
                this.setNanOrNull(ps, i, arg, argType);
            } else {
                PreparedStatement nativeStatement = this.getNativeStmt(ps);
                if (nativeStatement != null && NATIVE_PREPARED_STATEMENT_NAME.equals(nativeStatement.getClass().getName())) {
                    Class<?> clazz = nativeStatement.getClass();
                    Class[] parameterTypes = new Class[]{Integer.TYPE, BigDecimal.class, Integer.TYPE, Integer.TYPE};
                    BigDecimal value = null;
                    if (arg instanceof BigDecimal) {
                        value = (BigDecimal)arg;
                    } else if (!(arg instanceof Boolean) && arg != null) {
                        value = new BigDecimal(arg.toString());
                    }
                    int precision = 1;
                    int scale = 0;
                    if (value != null) {
                        scale = value.scale();
                        precision = value.precision();
                        if (precision < scale) {
                            precision = scale + 1;
                        }
                        if (precision > 127) {
                            precision = 127;
                            if (scale > 127) {
                                scale = 126;
                            }
                        }
                    }
                    Object[] params = new Object[]{i, value, precision, scale};
                    try {
                        if (arg instanceof Long) {
                            params = new Object[]{i, Long.valueOf(arg.toString())};
                            parameterTypes = new Class[]{Integer.TYPE, Long.TYPE};
                            Method method = clazz.getMethod("setLong", parameterTypes);
                            method.invoke((Object)nativeStatement, params);
                            break block17;
                        }
                        if (arg instanceof Integer) {
                            params = new Object[]{i, Integer.valueOf(arg.toString())};
                            parameterTypes = new Class[]{Integer.TYPE, Integer.TYPE};
                            Method method = clazz.getMethod("setInt", parameterTypes);
                            method.invoke((Object)nativeStatement, params);
                            break block17;
                        }
                        if (arg instanceof Boolean) {
                            Integer intValue = (Boolean)arg != false ? Integer.valueOf(1) : Integer.valueOf(0);
                            params = new Object[]{i, intValue};
                            parameterTypes = new Class[]{Integer.TYPE, Integer.TYPE};
                            Method method = clazz.getMethod("setInt", parameterTypes);
                            method.invoke((Object)nativeStatement, params);
                            break block17;
                        }
                        Method method = clazz.getMethod("setBigDecimal", parameterTypes);
                        method.invoke((Object)nativeStatement, params);
                    }
                    catch (Throwable e) {
                        if (e instanceof InvocationTargetException) {
                            e = ((InvocationTargetException)e).getTargetException();
                        }
                        log.warn(String.format("Error calling the Sybase stmt.setBigDecimal(%s) method", Arrays.toString(params)), e);
                        super.setDecimalValue(ps, i, arg, argType);
                    }
                } else {
                    super.setDecimalValue(ps, i, arg, argType);
                }
            }
        }
    }

    @Override
    protected int getUpdateCount(Statement stmt) throws SQLException {
        int updateCount;
        do {
            updateCount = stmt.getUpdateCount();
        } while (stmt.getMoreResults());
        return updateCount;
    }

    private PreparedStatement getNativeStmt(PreparedStatement ps) {
        PreparedStatement stmt = ps;
        try {
            stmt = (PreparedStatement)ps.unwrap(Class.forName(NATIVE_PREPARED_STATEMENT_NAME));
        }
        catch (ClassNotFoundException ex) {
            log.debug("Cannot get native statement because missing class {}", (Object)NATIVE_PREPARED_STATEMENT_NAME);
        }
        catch (SQLException ex) {
            log.debug("Could not find a native preparedstatement using {}", (Object)ps.getClass().getName(), (Object)ex);
        }
        catch (AbstractMethodError e) {
            log.debug("Cannot get native statement because not implemented");
        }
        return stmt;
    }

    @Override
    public void setValues(PreparedStatement ps, Object[] args) throws SQLException {
        super.setValues(ps, args);
        if (args != null && args.length > 0) {
            int[] argTypes = new int[args.length];
            for (int i = 0; i < argTypes.length; ++i) {
                argTypes[i] = Integer.MIN_VALUE;
            }
            this.setValues(ps, args, argTypes, this.getLobHandler().getDefaultHandler());
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return this.jdbcMajorVersion >= 4 || this.isUsingJtds;
    }

    @Override
    protected String getSelectLastInsertIdSql(String sequenceName) {
        return "select @@identity";
    }
}

