/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.voltdb;

import java.io.InputStream;
import javax.sql.DataSource;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.voltdb.VoltDbDdlBuilder;
import org.jumpmind.db.platform.voltdb.VoltDbDdlReader;
import org.jumpmind.db.platform.voltdb.VoltDbJdbcSqlTemplate;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;
import org.jumpmind.db.util.BinaryEncoding;

public class VoltDbDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "org.voltdb.jdbc.Driver";
    public static final String JDBC_SUBPROTOCOL = "voltdb";

    public VoltDbDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        this.getDatabaseInfo().setRequiresAutoCommitForDdl(true);
        this.getDatabaseInfo().setDelimiterToken("");
        this.getDatabaseInfo().setDelimitedIdentifiersSupported(false);
        this.getDatabaseInfo().setTriggersSupported(false);
        this.getDatabaseInfo().setForeignKeysSupported(false);
        this.getDatabaseInfo().setHasPrecisionAndScale(3, false);
        this.getDatabaseInfo().setHasPrecisionAndScale(6, false);
    }

    public String getName() {
        return JDBC_SUBPROTOCOL;
    }

    public Database readDatabaseFromXml(InputStream is, boolean alterCaseToMatchDatabaseDefaultCase) {
        Database database = super.readDatabaseFromXml(is, alterCaseToMatchDatabaseDefaultCase);
        for (Table table : database.getTables()) {
            for (Column column : table.getColumns()) {
                column.setAutoIncrement(false);
            }
        }
        return database;
    }

    protected Object getObjectValue(String value, Column column, BinaryEncoding encoding, boolean useVariableDates, boolean fitToColumn) throws DecoderException {
        Object objectValue = super.getObjectValue(value, column, encoding, useVariableDates, fitToColumn);
        if (objectValue instanceof byte[] && (column.getJdbcTypeCode() == -3 || column.getJdbcTypeCode() == 2005)) {
            objectValue = new String(Hex.encodeHex((byte[])((byte[])objectValue)));
        }
        return objectValue;
    }

    public String getDefaultSchema() {
        return null;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @Override
    public <T> T getDataSource() {
        return (T)this.dataSource;
    }

    @Override
    public ISqlTemplate getSqlTemplate() {
        return this.sqlTemplate;
    }

    protected VoltDbDdlBuilder createDdlBuilder() {
        return new VoltDbDdlBuilder();
    }

    @Override
    protected VoltDbDdlReader createDdlReader() {
        return new VoltDbDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected VoltDbJdbcSqlTemplate createSqlTemplate() {
        return new VoltDbJdbcSqlTemplate(this.dataSource, this.settings, new SymmetricLobHandler(), this.getDatabaseInfo());
    }

    public PermissionResult getCreateSymTablePermission(Database database) {
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TABLE, "UNIMPLEMENTED");
        result.setStatus(PermissionResult.Status.UNIMPLEMENTED);
        return result;
    }

    public PermissionResult getDropSymTablePermission() {
        PermissionResult result = new PermissionResult(PermissionType.DROP_TABLE, "UNIMPLEMENTED");
        result.setStatus(PermissionResult.Status.UNIMPLEMENTED);
        return result;
    }

    public PermissionResult getAlterSymTablePermission(Database database) {
        PermissionResult result = new PermissionResult(PermissionType.ALTER_TABLE, "UNIMPLEMENTED");
        result.setStatus(PermissionResult.Status.UNIMPLEMENTED);
        return result;
    }

    public PermissionResult getDropSymTriggerPermission() {
        PermissionResult result = new PermissionResult(PermissionType.DROP_TRIGGER, "UNIMPLEMENTED");
        result.setStatus(PermissionResult.Status.UNIMPLEMENTED);
        return result;
    }

    @Override
    protected ISqlTemplate createSqlTemplateDirty() {
        return this.sqlTemplate;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql + " limit " + limit + " offset " + offset;
    }
}

