/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.IConnectionCallback;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.ISqlTransactionListener;
import org.jumpmind.db.sql.JdbcSqlReadCursor;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.LogSqlBuilder;
import org.jumpmind.db.sql.NamedParameterUtils;
import org.jumpmind.db.sql.ParsedSql;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlUtils;
import org.jumpmind.db.sql.mapper.RowMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class JdbcSqlTransaction
implements ISqlTransaction {
    private static final Logger log = LoggerFactory.getLogger(JdbcSqlTransaction.class);
    protected boolean inBatchMode = false;
    protected Connection connection;
    protected String psql;
    protected PreparedStatement pstmt;
    protected JdbcSqlTemplate jdbcSqlTemplate;
    protected boolean autoCommit = false;
    protected boolean oldAutoCommitValue;
    protected List<Object> markers = new ArrayList<Object>();
    protected LogSqlBuilder logSqlBuilder;
    protected List<ISqlTransactionListener> listeners = new ArrayList<ISqlTransactionListener>();
    protected int batchSize = 100;

    public JdbcSqlTransaction(JdbcSqlTemplate jdbcSqlTemplate) {
        this(jdbcSqlTemplate, false);
    }

    public JdbcSqlTransaction(JdbcSqlTemplate jdbcSqlTemplate, boolean autoCommit) {
        this.autoCommit = autoCommit;
        this.jdbcSqlTemplate = jdbcSqlTemplate;
        this.logSqlBuilder = jdbcSqlTemplate.logSqlBuilder;
        this.batchSize = jdbcSqlTemplate.getSettings().getBatchSize();
        this.init();
    }

    public void addSqlTransactionListener(ISqlTransactionListener listener) {
        this.listeners.add(listener);
    }

    protected final void init() {
        if (this.connection != null) {
            this.close();
        }
        try {
            this.connection = this.jdbcSqlTemplate.getDataSource().getConnection();
            this.oldAutoCommitValue = this.connection.getAutoCommit();
            this.connection.setAutoCommit(this.autoCommit);
            SqlUtils.addSqlTransaction((ISqlTransaction)this);
        }
        catch (SQLException ex) {
            this.close();
            throw this.jdbcSqlTemplate.translate(ex);
        }
    }

    public void setInBatchMode(boolean useBatching) {
        if (this.connection != null) {
            this.inBatchMode = useBatching;
        }
    }

    public boolean isInBatchMode() {
        return this.inBatchMode;
    }

    public void commit() {
        if (this.connection != null) {
            try {
                if (this.pstmt != null && this.inBatchMode) {
                    this.flush();
                }
                if (!this.autoCommit) {
                    this.connection.commit();
                    for (ISqlTransactionListener listener : this.listeners) {
                        listener.transactionCommitted();
                    }
                }
            }
            catch (SQLException ex) {
                throw this.jdbcSqlTemplate.translate(ex);
            }
        }
    }

    public void rollback() {
        this.rollback(true);
        this.init();
    }

    protected void rollback(boolean clearMarkers) {
        if (this.connection != null) {
            try {
                if (clearMarkers) {
                    this.markers.clear();
                }
                if (!this.autoCommit) {
                    this.connection.rollback();
                    for (ISqlTransactionListener listener : this.listeners) {
                        listener.transactionRolledBack();
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void close() {
        if (this.connection != null) {
            JdbcSqlTemplate.close(this.pstmt);
            try {
                this.connection.setAutoCommit(this.oldAutoCommitValue);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            JdbcSqlTemplate.close(this.connection);
            this.connection = null;
            SqlUtils.removeSqlTransaction((ISqlTransaction)this);
        }
    }

    public int flush() {
        int rowsUpdated = 0;
        if (this.markers.size() > 0 && this.pstmt != null) {
            try {
                int[] updates;
                for (int i : updates = this.pstmt.executeBatch()) {
                    rowsUpdated += this.normalizeUpdateCount(i);
                }
                this.markers.clear();
            }
            catch (BatchUpdateException ex) {
                this.removeMarkersThatWereSuccessful(ex);
                throw this.jdbcSqlTemplate.translate(ex);
            }
            catch (SQLException ex) {
                throw this.jdbcSqlTemplate.translate(ex);
            }
        }
        return rowsUpdated;
    }

    public Row queryForRow(String sql, Object ... args) {
        List rows = this.query(sql, (ISqlRowMapper)new RowMapper(), args, null);
        if (rows.size() > 0) {
            return (Row)rows.get(0);
        }
        return null;
    }

    public int queryForInt(String sql, Object ... args) {
        Integer val = this.queryForObject(sql, Integer.class, args);
        if (val == null) {
            val = Integer.MIN_VALUE;
        }
        return val;
    }

    public long queryForLong(String sql, Object ... args) {
        Long val = this.queryForObject(sql, Long.class, args);
        if (val == null) {
            val = Long.MIN_VALUE;
        }
        return val;
    }

    public <T> T queryForObject(final String sql, final Class<T> clazz, final Object ... args) {
        return this.executeCallback(new IConnectionCallback<T>(){

            @Override
            public T execute(Connection con) throws SQLException {
                Object result = null;
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    if (args != null && args.length > 0) {
                        PreparedStatement ps = con.prepareStatement(sql);
                        stmt = ps;
                        stmt.setQueryTimeout(JdbcSqlTransaction.this.jdbcSqlTemplate.getSettings().getQueryTimeout());
                        JdbcSqlTransaction.this.jdbcSqlTemplate.setValues(ps, args);
                        long startTime = System.currentTimeMillis();
                        rs = ps.executeQuery();
                        long endTime = System.currentTimeMillis();
                        JdbcSqlTransaction.this.logSqlBuilder.logSql(log, sql, args, null, endTime - startTime);
                    } else {
                        stmt = con.createStatement();
                        stmt.setQueryTimeout(JdbcSqlTransaction.this.jdbcSqlTemplate.getSettings().getQueryTimeout());
                        long startTime = System.currentTimeMillis();
                        rs = stmt.executeQuery(sql);
                        long endTime = System.currentTimeMillis();
                        JdbcSqlTransaction.this.logSqlBuilder.logSql(log, sql, args, null, endTime - startTime);
                    }
                    if (rs.next()) {
                        result = JdbcSqlTransaction.this.jdbcSqlTemplate.getObjectFromResultSet(rs, clazz);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw JdbcSqlTransaction.this.logSqlBuilder.logSqlAfterException(log, sql, args, e);
                    }
                    catch (Throwable throwable) {
                        JdbcSqlTemplate.close(rs);
                        JdbcSqlTemplate.close(stmt);
                        throw throwable;
                    }
                }
                JdbcSqlTemplate.close(rs);
                JdbcSqlTemplate.close(stmt);
                return result;
            }
        });
    }

    public <T> List<T> query(String sql, ISqlRowMapper<T> mapper, Map<String, Object> namedParams) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement((String)sql);
        String newSql = NamedParameterUtils.substituteNamedParameters((ParsedSql)parsedSql, namedParams);
        Object[] params = NamedParameterUtils.buildValueArray((ParsedSql)parsedSql, namedParams);
        return this.query(newSql, mapper, params, null);
    }

    public <T> List<T> query(final String sql, final ISqlRowMapper<T> mapper, final Object[] args, final int[] types) {
        return (List)this.executeCallback(new IConnectionCallback<List<T>>(){

            @Override
            public List<T> execute(Connection c) throws SQLException {
                ArrayList<Object> arrayList;
                PreparedStatement st = null;
                ResultSet rs = null;
                try {
                    st = c.prepareStatement(sql);
                    st.setQueryTimeout(JdbcSqlTransaction.this.jdbcSqlTemplate.getSettings().getQueryTimeout());
                    if (args != null) {
                        JdbcSqlTransaction.this.jdbcSqlTemplate.setValues(st, args, types, JdbcSqlTransaction.this.jdbcSqlTemplate.getLobHandler().getDefaultHandler());
                    }
                    st.setFetchSize(JdbcSqlTransaction.this.jdbcSqlTemplate.getSettings().getFetchSize());
                    long startTime = System.currentTimeMillis();
                    rs = st.executeQuery();
                    long endTime = System.currentTimeMillis();
                    JdbcSqlTransaction.this.logSqlBuilder.logSql(log, sql, args, types, endTime - startTime);
                    ArrayList<Object> list = new ArrayList<Object>();
                    ResultSetMetaData rsMetaData = rs.getMetaData();
                    int columnCount = rsMetaData.getColumnCount();
                    while (rs.next()) {
                        Row row = JdbcSqlReadCursor.getMapForRow(rs, rsMetaData, columnCount, JdbcSqlTransaction.this.jdbcSqlTemplate.getSettings().isReadStringsAsBytes(), false);
                        Object value = mapper.mapRow(row);
                        list.add(value);
                    }
                    arrayList = list;
                }
                catch (SQLException e) {
                    try {
                        throw JdbcSqlTransaction.this.logSqlBuilder.logSqlAfterException(log, sql, args, e);
                    }
                    catch (Throwable throwable) {
                        JdbcSqlTemplate.close(rs);
                        JdbcSqlTemplate.close(st);
                        throw throwable;
                    }
                }
                JdbcSqlTemplate.close(rs);
                JdbcSqlTemplate.close(st);
                return arrayList;
            }
        });
    }

    public int execute(final String sql) {
        return this.executeCallback(new IConnectionCallback<Integer>(){

            @Override
            public Integer execute(Connection con) throws SQLException {
                Integer n;
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = con.createStatement();
                    long startTime = System.currentTimeMillis();
                    boolean hasResults = stmt.execute(sql);
                    long endTime = System.currentTimeMillis();
                    JdbcSqlTransaction.this.logSqlBuilder.logSql(log, sql, null, null, endTime - startTime);
                    if (hasResults) {
                        rs = stmt.getResultSet();
                        while (rs.next()) {
                        }
                    }
                    n = stmt.getUpdateCount();
                }
                catch (SQLException e) {
                    try {
                        throw JdbcSqlTransaction.this.logSqlBuilder.logSqlAfterException(log, sql, null, e);
                    }
                    catch (Throwable throwable) {
                        JdbcSqlTemplate.close(rs);
                        JdbcSqlTemplate.close(stmt);
                        throw throwable;
                    }
                }
                JdbcSqlTemplate.close(rs);
                JdbcSqlTemplate.close(stmt);
                return n;
            }
        });
    }

    public int prepareAndExecute(final String sql, final Object[] args, final int[] types) {
        return this.executeCallback(new IConnectionCallback<Integer>(){

            @Override
            public Integer execute(Connection con) throws SQLException {
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = con.prepareStatement(sql);
                    JdbcSqlTransaction.this.jdbcSqlTemplate.setValues(stmt, args, types, JdbcSqlTransaction.this.jdbcSqlTemplate.getLobHandler().getDefaultHandler());
                    Integer n = JdbcSqlTransaction.this.executePreparedUpdate(stmt, sql, args, types);
                    return n;
                }
                catch (SQLException e) {
                    throw JdbcSqlTransaction.this.logSqlBuilder.logSqlAfterException(log, sql, args, e);
                }
                finally {
                    JdbcSqlTemplate.close(rs);
                    JdbcSqlTemplate.close(stmt);
                }
            }
        });
    }

    public int prepareAndExecute(final String sql, final Map<String, Object> args) {
        return this.executeCallback(new IConnectionCallback<Integer>(){

            @Override
            public Integer execute(Connection con) {
                Integer rowsUpdated = null;
                NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)new SingleConnectionDataSource(con, true));
                long startTime = System.currentTimeMillis();
                rowsUpdated = jdbcTemplate.update(sql, args);
                long endTime = System.currentTimeMillis();
                JdbcSqlTransaction.this.logSqlBuilder.logSql(log, sql, args.values().toArray(), null, endTime - startTime);
                return rowsUpdated;
            }
        });
    }

    public int prepareAndExecute(final String sql, final Object ... args) {
        return this.executeCallback(new IConnectionCallback<Integer>(){

            @Override
            public Integer execute(Connection con) throws SQLException {
                Integer n;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = con.prepareStatement(sql);
                    if (args != null && args.length > 0) {
                        JdbcSqlTransaction.this.jdbcSqlTemplate.setValues(stmt, args);
                    }
                    long startTime = System.currentTimeMillis();
                    boolean hasResults = stmt.execute();
                    long endTime = System.currentTimeMillis();
                    JdbcSqlTransaction.this.logSqlBuilder.logSql(log, sql, args, null, endTime - startTime);
                    if (hasResults) {
                        rs = stmt.getResultSet();
                        while (rs.next()) {
                        }
                    }
                    n = stmt.getUpdateCount();
                }
                catch (SQLException e) {
                    try {
                        throw JdbcSqlTransaction.this.logSqlBuilder.logSqlAfterException(log, sql, args, e);
                    }
                    catch (Throwable throwable) {
                        JdbcSqlTemplate.close(rs);
                        JdbcSqlTemplate.close(stmt);
                        throw throwable;
                    }
                }
                JdbcSqlTemplate.close(rs);
                JdbcSqlTemplate.close(stmt);
                return n;
            }
        });
    }

    public <T> T executeCallback(IConnectionCallback<T> callback) {
        try {
            return callback.execute(this.connection);
        }
        catch (SQLException ex) {
            throw this.jdbcSqlTemplate.translate(ex);
        }
    }

    protected final int normalizeUpdateCount(int value) {
        if (value == -2) {
            value = 1;
        }
        return value;
    }

    protected void removeMarkersThatWereSuccessful(BatchUpdateException ex) {
        int[] updateCounts = ex.getUpdateCounts();
        if (updateCounts != null) {
            Iterator<Object> it = this.markers.iterator();
            int index = 0;
            while (it.hasNext()) {
                it.next();
                if (updateCounts.length > index && this.normalizeUpdateCount(updateCounts[index]) > 0) {
                    it.remove();
                }
                ++index;
            }
        }
    }

    public void prepare(String sql) {
        try {
            if (this.markers.size() > 0) {
                throw new IllegalStateException("Cannot prepare a new batch before the last batch has been flushed.");
            }
            JdbcSqlTemplate.close(this.pstmt);
            this.pstmt = this.connection.prepareStatement(sql);
            this.psql = sql;
        }
        catch (SQLException ex) {
            throw this.jdbcSqlTemplate.translate(new SqlException("Exception while preparing sql [" + sql + "]", (Throwable)ex));
        }
    }

    public int addRow(Object marker, Object[] args, int[] argTypes) {
        int rowsUpdated = 0;
        try {
            if (args != null) {
                this.jdbcSqlTemplate.setValues(this.pstmt, args, argTypes, this.jdbcSqlTemplate.getLobHandler().getDefaultHandler());
            }
            if (this.inBatchMode) {
                if (marker == null) {
                    marker = this.markers.size() + 1;
                }
                this.markers.add(marker);
                long start = System.currentTimeMillis();
                this.pstmt.addBatch();
                long end = System.currentTimeMillis();
                this.logSqlBuilder.logSql(log, "addBatch()", this.psql, args, argTypes, end - start);
                if (this.markers.size() >= this.batchSize) {
                    rowsUpdated = this.flush();
                }
            } else {
                rowsUpdated = this.executePreparedUpdate(this.pstmt, this.psql, args, argTypes);
            }
        }
        catch (SQLException ex) {
            throw this.jdbcSqlTemplate.translate(ex);
        }
        return rowsUpdated;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    protected int executePreparedUpdate(PreparedStatement preparedStatement, String sql, Object[] args, int[] argTypes) throws SQLException {
        int rowsUpdated = 0;
        long start = System.currentTimeMillis();
        rowsUpdated = this.jdbcSqlTemplate.getSettings().isAllowUpdatesWithResults() ? this.executeAllowingResults(preparedStatement) : preparedStatement.executeUpdate();
        long end = System.currentTimeMillis();
        this.logSqlBuilder.logSql(log, sql, args, argTypes, end - start);
        return rowsUpdated;
    }

    protected int executeAllowingResults(PreparedStatement preparedStatement) throws SQLException {
        int rowsUpdated = 0;
        boolean hasResultsFlag = preparedStatement.execute();
        int currentUpdateCount = preparedStatement.getUpdateCount();
        if (currentUpdateCount != -1) {
            rowsUpdated = currentUpdateCount;
        }
        while (hasResultsFlag || currentUpdateCount != -1) {
            hasResultsFlag = preparedStatement.getMoreResults();
            currentUpdateCount = preparedStatement.getUpdateCount();
            if (currentUpdateCount == -1) continue;
            rowsUpdated = currentUpdateCount;
        }
        return rowsUpdated;
    }

    public List<Object> getUnflushedMarkers(boolean clear) {
        ArrayList<Object> ret = new ArrayList<Object>(this.markers);
        if (clear) {
            this.markers.clear();
        }
        return ret;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void allowInsertIntoAutoIncrementColumns(boolean value, Table table, String quote, String catalogSeparator, String schemaSepartor) {
    }

    public long insertWithGeneratedKey(String sql, String column, String sequenceName, Object[] args, int[] types) {
        try {
            return this.jdbcSqlTemplate.insertWithGeneratedKey(this.connection, sql, column, sequenceName, args, types);
        }
        catch (SQLException ex) {
            throw this.jdbcSqlTemplate.translate(ex);
        }
    }

    public LogSqlBuilder getLogSqlBuilder() {
        return this.logSqlBuilder;
    }

    public void setLogSqlBuilder(LogSqlBuilder logSqlBuilder) {
        this.logSqlBuilder = logSqlBuilder;
    }

    public void clearBatch() {
        if (this.inBatchMode && this.pstmt != null) {
            try {
                this.pstmt.clearBatch();
            }
            catch (SQLException e) {
                log.warn("Unable to clear batch mode for transaction. ", (Throwable)e);
            }
        }
    }

    public boolean isAllowInsertIntoAutoIncrement() {
        return false;
    }
}

