/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.driver;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.driver.InterceptResult;
import org.jumpmind.driver.PreparedStatementWrapper;
import org.jumpmind.driver.StatementInterceptor;
import org.jumpmind.properties.TypedProperties;

public class RandomErrorInterceptor
extends StatementInterceptor {
    private static AtomicInteger okCounter = new AtomicInteger(0);
    private static AtomicInteger errorCounter = new AtomicInteger(0);
    private static final int MIN = 1;
    private static final int MAX = 1000;
    private static final int ERROR_THRESHOLD = 10;
    private SecureRandom random = new SecureRandom();

    public RandomErrorInterceptor(Object wrapped, TypedProperties properties) {
        super(wrapped, properties);
    }

    @Override
    protected InterceptResult preparedStatementPreExecute(PreparedStatementWrapper ps, String methodName, Object[] parameters) {
        if (this.shouldThrowError()) {
            int errorCount = errorCounter.incrementAndGet();
            int okCount = okCounter.get();
            throw new SqlException("MOCK/RANDOM ERROR from RandomErrorInterceptor (" + okCount + " successful statements, " + errorCount + " error statements.)");
        }
        okCounter.incrementAndGet();
        return new InterceptResult();
    }

    @Override
    public void preparedStatementExecute(String methodName, long elapsed, String sql) {
    }

    protected boolean shouldThrowError() {
        int count = okCounter.get();
        if (count < 1000) {
            return false;
        }
        int randomValue = this.random.nextInt(1000) + 1;
        return randomValue <= 10;
    }
}

