/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityService
implements ISecurityService {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected static volatile SecretKey secretKey;
    protected static String keyStoreFileName;
    protected static URL keyStoreURL;
    protected static volatile boolean hasInitKeyStore;
    protected static String trustStoreFileName;
    protected static URL trustStoreURL;

    protected SecurityService() {
    }

    @Override
    public synchronized void init() {
    }

    @Override
    public KeyStore getTrustStore() {
        try {
            String keyStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            if (trustStoreFileName != null) {
                try (FileInputStream is = new FileInputStream(trustStoreFileName);){
                    ks.load(is, this.getTrustStorePassword().toCharArray());
                }
            }
            if (trustStoreURL != null) {
                try (InputStream is = trustStoreURL.openStream();){
                    ks.load(is, this.getTrustStorePassword().toCharArray());
                }
            }
            return ks;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public KeyStore getKeyStore() {
        try {
            this.checkThatKeystoreFileExists();
            String keyStoreType = this.getKeyStoreType();
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            if (keyStoreFileName != null) {
                this.log.debug("Loading keystore from file {}", (Object)keyStoreFileName);
                try (FileInputStream is = new FileInputStream(keyStoreFileName);){
                    ks.load(is, this.getKeyStorePassword().toCharArray());
                }
            } else if (keyStoreURL != null) {
                this.log.debug("Loading keystore from classpath {}", (Object)keyStoreURL);
                try (InputStream is = keyStoreURL.openStream();){
                    ks.load(is, this.getKeyStorePassword().toCharArray());
                }
            } else {
                this.log.debug("Loading keystore from memory");
                ks.load(null);
            }
            return ks;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getKeyStoreType() {
        String keyStoreType = System.getProperty("sym.keystore.type");
        if (keyStoreType == null) {
            byte[] buffer = new byte[2];
            if (keyStoreFileName != null) {
                try (FileInputStream is2 = new FileInputStream(keyStoreFileName);){
                    ((InputStream)is2).read(buffer, 0, 2);
                }
                catch (IOException is2) {}
            } else if (keyStoreURL != null) {
                try (InputStream is = keyStoreURL.openStream();){
                    is.read(buffer, 0, 2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (Byte.toUnsignedInt(buffer[0]) == 206 && Byte.toUnsignedInt(buffer[1]) == 206) {
                keyStoreType = "JCEKS";
            } else if (Byte.toUnsignedInt(buffer[0]) == 254 && Byte.toUnsignedInt(buffer[1]) == 237) {
                keyStoreType = "JKS";
            }
        }
        if (keyStoreType == null) {
            keyStoreType = "PKCS12";
        }
        return keyStoreType;
    }

    @Override
    public KeyManagerFactory getKeyManagerFactory() {
        KeyManagerFactory keyManagerFactory;
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(this.getKeyManagerFactoryAlgorithm());
            keyManagerFactory.init(this.getKeyStore(), this.getKeyStorePassword().toCharArray());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return keyManagerFactory;
    }

    @Override
    public void installTrustedCert(KeyStore.TrustedCertificateEntry entry) {
        try {
            KeyStore keyStore = this.getTrustStore();
            String alias = keyStore.getCertificateAlias(entry.getTrustedCertificate());
            if (alias == null) {
                alias = String.valueOf(entry.getTrustedCertificate().hashCode());
                keyStore.setEntry(alias, entry, null);
                this.log.info("Installing trusted certificate: {}", (Object)((X509Certificate)entry.getTrustedCertificate()).getSubjectX500Principal().getName());
                this.saveTrustStore(keyStore);
            } else {
                this.log.info("Trusted certificate already installed: {}", (Object)((X509Certificate)entry.getTrustedCertificate()).getSubjectX500Principal().getName());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public KeyStore.TrustedCertificateEntry createTrustedCert(byte[] content, String fileType, String alias, String password) {
        return null;
    }

    @Override
    public void installDefaultSslCert(String host) {
    }

    @Override
    public void installDefaultSamlSslCert(String host) {
    }

    @Override
    public void installSslCert(KeyStore.PrivateKeyEntry entry) {
        throw new NotImplementedException();
    }

    @Override
    public KeyStore.PrivateKeyEntry createDefaultSslCert(String host) {
        throw new NotImplementedException();
    }

    @Override
    public KeyStore.PrivateKeyEntry createSslCert(byte[] content, String fileType, String alias, String password) {
        throw new NotImplementedException();
    }

    @Override
    public X509Certificate getCurrentSslCert() {
        throw new NotImplementedException();
    }

    @Override
    public String exportCurrentSslCert(boolean includePrivateKey) {
        throw new NotImplementedException();
    }

    @Override
    public String exportTrustedCert(String alias) {
        throw new NotImplementedException();
    }

    @Override
    public boolean supportsExportCertificate() {
        return false;
    }

    @Override
    public boolean supportsImportCertificate() {
        return false;
    }

    @Override
    public boolean supportsBackupCertificate() {
        return false;
    }

    @Override
    public boolean supportsGenerateSelfSignedCertificate() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkThatKeystoreFileExists() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (hasInitKeyStore) return;
        Class<SecurityService> clazz = SecurityService.class;
        synchronized (SecurityService.class) {
            if (hasInitKeyStore || keyStoreFileName == null || new File(keyStoreFileName).exists()) return;
            String keyStoreType = System.getProperty("sym.keystore.type", "PKCS12");
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            ks.load(null, this.getKeyStorePassword().toCharArray());
            try (FileOutputStream os = new FileOutputStream(keyStoreFileName);){
                ks.store(os, this.getKeyStorePassword().toCharArray());
            }
            hasInitKeyStore = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String encrypt(String plainText) {
        try {
            this.checkThatKeystoreFileExists();
            byte[] bytes = plainText.getBytes("UTF8");
            byte[] enc = this.getCipher(1).doFinal(bytes);
            return new String(Base64.encodeBase64((byte[])enc), "UTF8");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String decrypt(String encText) {
        try {
            this.checkThatKeystoreFileExists();
            byte[] dec = Base64.decodeBase64((byte[])encText.getBytes(Charset.defaultCharset()));
            byte[] bytes = this.getCipher(2).doFinal(dec);
            return new String(bytes, "UTF8");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String obfuscate(String plainText) {
        return new String(Base64.encodeBase64((byte[])this.rot13(plainText).getBytes(Charset.defaultCharset())), Charset.defaultCharset());
    }

    @Override
    public String unobfuscate(String obfText) {
        return new String(this.rot13(new String(Base64.decodeBase64((byte[])obfText.getBytes(Charset.defaultCharset())), Charset.defaultCharset())));
    }

    @Override
    public String unobfuscateIfNeeded(String systemPropertyName) {
        String value = System.getProperty(systemPropertyName);
        if (value != null && value.startsWith("obf:")) {
            value = this.unobfuscate(value.substring("obf:".length()));
            System.setProperty(systemPropertyName, value);
        }
        return value;
    }

    private String rot13(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= 'a' && c <= 'm' || c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z' || c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public Cipher getCipher(int mode) throws Exception {
        this.initializeSecretKey();
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
        this.initializeCipher(cipher, mode);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Using {} algorithm {}-bit provided by {}.", new Object[]{cipher.getAlgorithm(), secretKey.getEncoded().length * 8, cipher.getProvider().getName()});
        }
        return cipher;
    }

    protected void initializeCipher(Cipher cipher, int mode) throws Exception {
        AlgorithmParameterSpec paramSpec = Cipher.getMaxAllowedParameterSpec(cipher.getAlgorithm());
        if (paramSpec instanceof PBEParameterSpec || cipher.getAlgorithm().startsWith("PBE")) {
            paramSpec = new PBEParameterSpec(SecurityConstants.SALT, 3);
            cipher.init(mode, (Key)secretKey, paramSpec);
        } else if (paramSpec instanceof IvParameterSpec) {
            paramSpec = new IvParameterSpec(SecurityConstants.SALT);
            cipher.init(mode, (Key)secretKey, paramSpec);
        } else {
            cipher.init(mode, secretKey);
        }
    }

    protected String getTrustStorePassword() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.unobfuscateIfNeeded("javax.net.ssl.trustStorePassword"), (CharSequence)"changeit");
    }

    protected String getKeyStorePassword() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.unobfuscateIfNeeded("javax.net.ssl.keyStorePassword"), (CharSequence)"changeit");
    }

    protected String getKeyManagerFactoryAlgorithm() {
        String algorithm = System.getProperty("sym.key.manager.factory.algorithm");
        if (algorithm == null) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        return algorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeSecretKey() throws Exception {
        if (secretKey != null) return;
        Class<SecurityService> clazz = SecurityService.class;
        synchronized (SecurityService.class) {
            if (secretKey != null) return;
            String password = this.getKeyStorePassword();
            KeyStore.PasswordProtection param = new KeyStore.PasswordProtection(password.toCharArray());
            KeyStore ks = this.getKeyStore();
            KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)ks.getEntry("sym.secret", param);
            if (entry == null) {
                this.log.info("Generating secret key");
                entry = new KeyStore.SecretKeyEntry(this.getDefaultSecretKey());
                ks.setEntry("sym.secret", entry, param);
                this.saveKeyStore(ks, password);
            } else {
                this.log.debug("Retrieving secret key");
            }
            secretKey = entry.getSecretKey();
            this.log.info("Initialized with {} {}-bit", (Object)entry.getSecretKey().getAlgorithm(), (Object)(entry.getSecretKey().getEncoded().length * 8));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getKeystoreEntry(String alias) throws Exception {
        String password = this.getKeyStorePassword();
        KeyStore ks = this.getKeyStore();
        Key entry = ks.getKey(alias, password.toCharArray());
        return entry == null ? null : new String(entry.getEncoded());
    }

    @Override
    public void setKeystoreEntry(String alias, String value) throws Exception {
        String password = this.getKeyStorePassword();
        SecretKeySpec mySecretKey = new SecretKeySpec(value.getBytes(), "AES");
        KeyStore ks = this.getKeyStore();
        ks.setKeyEntry(alias, mySecretKey, password.toCharArray(), null);
        this.saveKeyStore(ks, password);
    }

    @Override
    public void deleteKeystoreEntry(String alias) throws Exception {
        String password = this.getKeyStorePassword();
        KeyStore ks = this.getKeyStore();
        try {
            ks.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            this.log.info("Unable to delete keystore entry with name {}", (Object)alias);
        }
        this.saveKeyStore(ks, password);
    }

    @Override
    public String nextSecureHexString(int len) {
        if (len <= 0) {
            throw new IllegalArgumentException("length must be positive");
        }
        SecureRandom random = new SecureRandom();
        int maxInt = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".length();
        char[] password = new char[len];
        for (int i = 0; i < len; ++i) {
            password[i] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".charAt(random.nextInt(maxInt));
        }
        return new String(password);
    }

    protected SecretKey getDefaultSecretKey() throws Exception {
        for (int i = 0; i < SecurityConstants.CIPHERS.length; ++i) {
            try {
                if (SecurityConstants.CIPHERS[i].startsWith("DESede")) {
                    SecretKeyFactory kf = SecretKeyFactory.getInstance(SecurityConstants.KEYSPECS[i]);
                    secretKey = kf.generateSecret(new DESedeKeySpec(this.getBytes(SecurityConstants.BYTESIZES[i])));
                } else {
                    secretKey = new SecretKeySpec(this.getBytes(SecurityConstants.BYTESIZES[i]), SecurityConstants.KEYSPECS[i]);
                }
                this.initializeCipher(Cipher.getInstance(SecurityConstants.CIPHERS[i]), 1);
                this.log.info("Generated secret key using {} {}", (Object)SecurityConstants.CIPHERS[i], (Object)(SecurityConstants.BYTESIZES[i] * 8));
                break;
            }
            catch (Exception e) {
                this.log.debug("Cannot use {} {}-bit because: {}", new Object[]{SecurityConstants.CIPHERS[i], SecurityConstants.BYTESIZES[i] * 8, e.getMessage()});
                continue;
            }
        }
        return secretKey;
    }

    protected byte[] getBytes(int byteSize) {
        byte[] bytes = new byte[byteSize];
        if (keyStoreFileName != null) {
            this.log.info("Using random bytes for secret key");
            SecureRandom random = new SecureRandom();
            random.nextBytes(bytes);
        } else {
            this.log.info("Using keystore password as bytes for secret key");
            byte[] password = this.getKeyStorePassword().getBytes(Charset.defaultCharset());
            for (int i = 0; i < byteSize; ++i) {
                bytes[i] = password[i < password.length ? i : password.length - 1];
            }
        }
        return bytes;
    }

    @Override
    public void saveTrustStore(KeyStore ks) throws Exception {
        if (trustStoreFileName != null) {
            this.log.info("Saving truststore {}", (Object)trustStoreFileName);
            try (FileOutputStream os = new FileOutputStream(trustStoreFileName);){
                ks.store(os, this.getTrustStorePassword().toCharArray());
            }
        }
    }

    protected void saveKeyStore(KeyStore ks, String password) throws Exception {
        if (keyStoreFileName != null) {
            this.log.info("Saving keystore {}", (Object)keyStoreFileName);
            try {
                FileUtils.copyFile((File)new File(keyStoreFileName), (File)new File(keyStoreFileName + ".bak"));
            }
            catch (IOException e) {
                this.log.warn("Unable to backup keystore: ", (Object)e.getMessage());
            }
            try (FileOutputStream os = new FileOutputStream(keyStoreFileName);){
                ks.store(os, password.toCharArray());
            }
        }
    }

    static {
        keyStoreFileName = StringUtils.trimToNull((String)System.getProperty("sym.keystore.file"));
        if (keyStoreFileName == null) {
            keyStoreURL = SecurityService.class.getClassLoader().getResource("/keystore");
            hasInitKeyStore = true;
        }
        if ((trustStoreFileName = StringUtils.trimToNull((String)System.getProperty("javax.net.ssl.trustStore"))) == null && (trustStoreURL = SecurityService.class.getClassLoader().getResource("/cacerts")) == null) {
            trustStoreFileName = System.getProperty("java.home") + File.separatorChar + "lib" + File.separatorChar + "security" + File.separator + "cacerts";
        }
    }
}

