/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jumpmind.exception.ParseException;

public final class FormatUtils {
    public static final String[] TIMESTAMP_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "HH:mm:ss.S", "HH:mm:ss"};
    public static final String[] TIME_PATTERNS = new String[]{"HH:mm:ss.S", "HH:mm:ss", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss"};
    public static final String[] TIMESTAMP_WITH_TIMEZONE_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss.n xxx"};
    public static final FastDateFormat TIMESTAMP_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    public static final FastDateFormat DATE_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    public static final DateTimeFormatter TIMESTAMP9_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnnnnnn").withZone(ZoneId.systemDefault());
    public static final FastDateFormat TIME_FORMATTER = FastDateFormat.getInstance((String)"HH:mm:ss.SSS");
    public static final DateTimeFormatter TIME9_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.nnnnnnnnn").withZone(ZoneId.systemDefault());
    public static final String WILDCARD = "*";
    public static final String WILDCARD_SEPARATOR = ",";
    public static final String NEGATE_TOKEN = "!";
    public static final char WILDCARD_SEPARATOR_CHAR = ",".charAt(0);
    public static final char WILDCARD_CHAR = "*".charAt(0);
    public static final char NEGATE_TOKEN_CHAR = "!".charAt(0);
    public static final String WILDCARD_ESCAPED = "**";
    public static final String WILDCARD_SEPARATOR_ESCAPED = ",,";
    public static final String NEGATE_TOKEN_ESCAPED = "!!";
    public static final int MAX_CHARS_TO_LOG = 1000;
    private static Pattern pattern = Pattern.compile("\\$\\((.+?)\\)");
    private static boolean isInfamousTurkey = false;

    private FormatUtils() {
    }

    public static String replace(String prop, String replaceWith, String sourceString) {
        HashMap<String, String> replacements = new HashMap<String, String>(1);
        replacements.put(prop, replaceWith);
        return FormatUtils.replaceTokens(sourceString, replacements, true);
    }

    public static String replaceToken(String text, String tokenToReplace, String replaceWithText, boolean matchUsingPrefixSuffix) {
        HashMap<String, String> replacements = new HashMap<String, String>(1);
        replacements.put(tokenToReplace, replaceWithText);
        return FormatUtils.replaceTokens(text, replacements, matchUsingPrefixSuffix);
    }

    public static String replaceTokens(String text, Map<String, String> replacements, boolean matchUsingPrefixSuffix) {
        if (text != null && replacements != null && replacements.size() > 0) {
            if (matchUsingPrefixSuffix) {
                Matcher matcher = pattern.matcher(text);
                StringBuffer buffer = new StringBuffer();
                while (matcher.find()) {
                    String[] matchPipe = matcher.group(1).split("\\|");
                    String[] matchColon = matchPipe[0].split(":");
                    String replacement = replacements.get(matchColon[0]);
                    if (replacement == null) continue;
                    matcher.appendReplacement(buffer, "");
                    if (matchColon.length == 2) {
                        startIndex = Integer.parseInt(matchColon[1]);
                        if (startIndex <= replacement.length()) {
                            replacement = replacement.substring(Integer.parseInt(matchColon[1]));
                        }
                    } else if (matchColon.length == 3) {
                        startIndex = Integer.parseInt(matchColon[1]);
                        int endIndex = Integer.parseInt(matchColon[2]);
                        if (startIndex <= replacement.length() && endIndex <= replacement.length()) {
                            replacement = replacement.substring(startIndex, endIndex);
                        }
                    }
                    if (matchPipe.length == 2) {
                        replacement = FormatUtils.formatString(matchPipe[1], replacement);
                    }
                    buffer.append(replacement);
                }
                matcher.appendTail(buffer);
                text = buffer.toString();
            } else {
                for (String key : replacements.keySet()) {
                    text = text.replaceAll(key.toString(), replacements.get(key));
                }
            }
        }
        return text;
    }

    public static String formatString(String format, String arg) {
        if (format.indexOf("d") >= 0 || format.indexOf("u") >= 0 || format.indexOf("i") >= 0) {
            return String.format(format, Long.parseLong(arg));
        }
        if (format.indexOf("e") >= 0 || format.indexOf("f") >= 0) {
            return String.format(format, Double.valueOf(arg));
        }
        return String.format(format, arg);
    }

    public static boolean toBoolean(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            if (value.equals("1")) {
                return true;
            }
            if (value.equals("0")) {
                return false;
            }
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public static boolean isMixedCase(String text) {
        char[] chars = text.toCharArray();
        boolean upper = false;
        boolean lower = false;
        for (char ch : chars) {
            upper |= Character.isUpperCase(ch);
            lower |= Character.isLowerCase(ch);
        }
        return upper && lower;
    }

    public static boolean isWildCardMatch(String text, String pattern, boolean ignoreCase) {
        boolean match = FormatUtils.isWildCardMatch(text, pattern);
        if (ignoreCase && !match && !(match = FormatUtils.isWildCardMatch(text.toLowerCase(), pattern))) {
            match = FormatUtils.isWildCardMatch(text.toUpperCase(), pattern);
        }
        return match;
    }

    public static boolean isWildCardMatch(String text, String pattern) {
        boolean match = true;
        if (pattern.startsWith(NEGATE_TOKEN)) {
            pattern = pattern.substring(1);
        }
        String[] cards = pattern.split("\\*");
        for (int i = 0; i < cards.length; ++i) {
            String card = cards[i];
            boolean foundToken = false;
            if (!pattern.contains(WILDCARD)) {
                foundToken = text.equals(card);
            } else if (i == 0 && !pattern.startsWith(WILDCARD) && pattern.endsWith(WILDCARD)) {
                foundToken = text.startsWith(card);
            } else if (i == 0 && pattern.startsWith(WILDCARD)) {
                foundToken = text.startsWith(card);
            } else {
                boolean bl = foundToken = text.indexOf(card) != -1;
            }
            if (!foundToken) {
                return !match;
            }
            text = text.substring(text.indexOf(card) + card.length());
        }
        if (match && text.length() > 0 && !pattern.endsWith(WILDCARD)) {
            match = false;
        }
        return match;
    }

    public static String unescapeWildCards(String str) {
        return str == null ? null : str.replace(WILDCARD_ESCAPED, WILDCARD).replace(WILDCARD_SEPARATOR_ESCAPED, WILDCARD_SEPARATOR).replace(NEGATE_TOKEN_ESCAPED, NEGATE_TOKEN);
    }

    public static String escapeWildCards(String str) {
        return str == null ? null : str.replace(WILDCARD, WILDCARD_ESCAPED).replace(WILDCARD_SEPARATOR, WILDCARD_SEPARATOR_ESCAPED).replace(NEGATE_TOKEN, NEGATE_TOKEN_ESCAPED);
    }

    public static boolean isWildCarded(String str) {
        boolean hasWildCard = false;
        if (str != null) {
            int countWildCard = 0;
            int countCommas = 0;
            int countNegates = 0;
            for (int i = 0; i < str.length(); ++i) {
                char thisChar = str.charAt(i);
                if (thisChar == WILDCARD_CHAR) {
                    ++countWildCard;
                } else if (countWildCard > 0) {
                    if (countWildCard % 2 == 1) {
                        hasWildCard = true;
                        break;
                    }
                    countWildCard = 0;
                }
                if (thisChar == WILDCARD_SEPARATOR_CHAR) {
                    ++countCommas;
                } else if (countCommas > 0) {
                    if (countCommas % 2 == 1) {
                        hasWildCard = true;
                        break;
                    }
                    countCommas = 0;
                }
                if (thisChar == NEGATE_TOKEN_CHAR) {
                    ++countNegates;
                    continue;
                }
                if (countNegates <= 0) continue;
                if (countNegates % 2 == 1) {
                    hasWildCard = true;
                    break;
                }
                countNegates = 0;
            }
            if (countWildCard > 0 && countWildCard % 2 == 1 || countCommas > 0 && countCommas % 2 == 1 || countNegates > 0 && countNegates % 2 == 1) {
                hasWildCard = true;
            }
        }
        return hasWildCard;
    }

    public static String[] wordWrap(String str, int firstLineSize, int nonFirstLineSize) {
        Object[] lines = FormatUtils.wordWrap(str, firstLineSize);
        if (lines.length > 1 && firstLineSize != nonFirstLineSize) {
            String notFirstLinesString = StringUtils.join((Object[])lines, (String)" ", (int)1, (int)lines.length);
            String[] nonFirstLines = FormatUtils.wordWrap(notFirstLinesString, nonFirstLineSize);
            List<String> nonFirstLineCollection = Arrays.asList(nonFirstLines);
            ArrayList<Object> allLines = new ArrayList<Object>();
            allLines.add(lines[0]);
            allLines.addAll(nonFirstLineCollection);
            lines = (String[])allLines.toArray(lines);
        }
        return lines;
    }

    public static String[] wordWrap(String str, int lineSize) {
        if (str != null && str.length() > lineSize) {
            Pattern regex = Pattern.compile("(\\S\\S{" + lineSize + ",}|.{1," + lineSize + "})(\\s+|$)");
            ArrayList<String> list = new ArrayList<String>();
            Matcher m = regex.matcher(str);
            while (m.find()) {
                String[] lines;
                String group = m.group();
                for (String line : lines = StringUtils.splitPreserveAllTokens((String)group, (char)'\n')) {
                    line = StringUtils.removeEnd((String)line, (String)" ");
                    list.add(line);
                }
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[]{str};
    }

    public static String abbreviateForLogging(String value) {
        if (value != null) {
            value = value.trim();
        }
        return StringUtils.abbreviate((String)value, (int)1000);
    }

    public static String abbreviateForLogging(List list, int maxCharsToLog) {
        StringBuilder sb = new StringBuilder(maxCharsToLog);
        sb.append("[");
        boolean isFirst = true;
        for (Object obj : list) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(obj);
            if (sb.length() < maxCharsToLog) continue;
            sb.append("...");
            break;
        }
        sb.append("]");
        return sb.toString();
    }

    public static Date parseDate(String str, String[] parsePatterns) {
        return FormatUtils.parseDate(str, parsePatterns, null);
    }

    public static Date parseDate(String str, String[] parsePatterns, TimeZone timeZone) {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        for (int i = 0; i < parsePatterns.length; ++i) {
            if (i == 0) {
                parser = new SimpleDateFormat(parsePatterns[0]);
                if (timeZone != null) {
                    parser.setTimeZone(timeZone);
                }
            } else {
                parser.applyPattern(parsePatterns[i]);
            }
            pos.setIndex(0);
            Date date = parser.parse(str, pos);
            if (date == null || pos.getIndex() != str.length()) continue;
            return date;
        }
        try {
            Date date = new Date(Long.parseLong(str));
            return date;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Unable to parse the date: " + str);
        }
    }

    public static Timestamp parseTimestampWithTimezone(String str) {
        return FormatUtils.parseTimestampWithTimezone(str, TIMESTAMP_WITH_TIMEZONE_PATTERNS);
    }

    public static Timestamp parseTimestampWithTimezone(String str, String[] parsePatterns) {
        Timestamp ret = null;
        String dateTime = ((String)str).substring(0, ((String)str).indexOf("."));
        String fractionSeconds = ((String)str).substring(((String)str).indexOf(".") + 1, ((String)str).lastIndexOf(" "));
        String timeZone = ((String)str).substring(((String)str).lastIndexOf(" ") + 1);
        if (dateTime == null || dateTime.length() == 0 || fractionSeconds == null || fractionSeconds.length() == 0 || timeZone == null || timeZone.length() == 0) {
            throw new ParseException("Unable to parse the date: " + (String)str);
        }
        fractionSeconds = StringUtils.rightPad((String)fractionSeconds, (int)9, (char)'0');
        str = dateTime + "." + fractionSeconds + " " + timeZone;
        for (int i = 0; i < parsePatterns.length; ++i) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(parsePatterns[i]);
            ret = null;
            try {
                ret = Timestamp.from(ZonedDateTime.parse((CharSequence)str, formatter).toInstant());
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
            if (ret == null) continue;
            return ret;
        }
        throw new ParseException("Unable to parse the date: " + (String)str);
    }

    public static String[] splitOnSpacePreserveQuotedStrings(String source) {
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(source);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    public static String replaceCharsToShortenName(String name) {
        return name.replaceAll("[^a-zA-Z0-9_]|[a|e|i|o|u|A|E|I|O|U]", "");
    }

    public static String lower(String str) {
        if (isInfamousTurkey) {
            return str.toLowerCase(Locale.US);
        }
        return str.toLowerCase();
    }

    public static String upper(String str) {
        if (isInfamousTurkey) {
            return str.toUpperCase(Locale.US);
        }
        return str.toUpperCase();
    }

    public static boolean isInfamousTurkey() {
        return isInfamousTurkey;
    }

    public static String stripTurkeyDottedI(String str) {
        return str.replace("\u0130", "I").replace("\u0131", "i");
    }

    public static String formatDurationReadable(long duration) {
        String result = DurationFormatUtils.formatDurationWords((long)duration, (boolean)true, (boolean)true);
        result = result.replaceAll("hours", "hrs");
        result = result.replaceAll("hour", "hr");
        result = result.replaceAll("seconds", "sec.");
        result = result.replaceAll("second", "sec.");
        result = result.replaceAll("minutes", "mins");
        result = result.replaceAll("minute", "min");
        return result;
    }

    public static String formatDateTimeISO(Date date) {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return dateFormat.format(date);
        }
        return "null";
    }

    public static boolean isInteger(String s) {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String convertToPem(X509Certificate cert) throws CertificateEncodingException {
        Base64 encoder = new Base64(64);
        String cert_begin = "-----BEGIN CERTIFICATE-----\n";
        String end_cert = "-----END CERTIFICATE-----";
        byte[] derCert = cert.getEncoded();
        String pemCertPre = new String(encoder.encode(derCert));
        String pemCert = cert_begin + pemCertPre + end_cert;
        return pemCert;
    }

    static {
        isInfamousTurkey = Locale.getDefault().getCountry().equalsIgnoreCase("tr");
    }
}

